/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.math.DoubleRange;

public class HGMeshColor {
    private volatile double fRed;
    private volatile double fGreen;
    private volatile double fBlue;
    private final double alpha;
    public static final int COLOR = -1;
    public static final int NONE = 0;
    public static final int FLAT = 1;
    public static final int INTERP = 2;
    public static final int TEXTUREMAP = 3;
    public static final int AUTO = 4;
    private volatile int fStyle;
    public static final int NONE_FLAT_INTERP_TEXTURE = 0;
    public static final int NONE_AUTO = 1;
    public static final int NONE_AUTO_FLAT = 2;
    public static final int NONE_FLAT_INTERP = 3;
    public static final int NONE_ONLY = 4;
    private final int fAllowedStyles;
    private static final DoubleRange validRange = new DoubleRange(0.0, 1.0);
    private static final BidiMap styleMap = new DualHashBidiMap();
    private static final Map<Integer, List<String>> allowedStylesMap = new HashMap<Integer, List<String>>();

    private static boolean contains(int n) {
        return allowedStylesMap.keySet().contains(n);
    }

    public HGMeshColor(double d, double d2, double d3, int n) {
        this(d, d2, d3, 1.0, n);
    }

    public HGMeshColor(double d, double d2, double d3, double d4, int n) {
        this.fRed = d;
        this.fGreen = d2;
        this.fBlue = d3;
        this.alpha = d4;
        this.fStyle = -1;
        this.fAllowedStyles = n;
    }

    public HGMeshColor(int n, int n2) {
        this.fStyle = n;
        this.fAllowedStyles = n2;
        this.alpha = 0.0;
    }

    public HGMeshColor(HGMeshColor hGMeshColor) {
        if (hGMeshColor == null) {
            throw new IllegalArgumentException("Argument meshColor must not be null.");
        }
        this.fAllowedStyles = hGMeshColor.fAllowedStyles;
        this.fStyle = hGMeshColor.fStyle;
        this.fRed = hGMeshColor.fRed;
        this.fGreen = hGMeshColor.fGreen;
        this.fBlue = hGMeshColor.fBlue;
        this.alpha = hGMeshColor.alpha;
    }

    private void validateComponents(double d, double d2, double d3, double d4) {
        if (!validRange.containsDouble(d)) {
            throw new IllegalArgumentException("red is out of valid range [0,1]: " + d);
        }
        if (!validRange.containsDouble(d2)) {
            throw new IllegalArgumentException("green is out of valid range [0,1]: " + d2);
        }
        if (!validRange.containsDouble(d3)) {
            throw new IllegalArgumentException("blue is out of valid range [0,1]: " + d3);
        }
        if (!validRange.containsDouble(d4)) {
            throw new IllegalArgumentException("alpha is out of valid range [0,1]: " + d4);
        }
    }

    public static HGMeshColor valueOf(StyledColor styledColor, int n) {
        if (styledColor == null) {
            return null;
        }
        String string = styledColor.getStyleName();
        assert (allowedStylesMap.keySet().contains(n));
        assert (styleMap.keySet().contains(string));
        if (styledColor.isStyle()) {
            return new HGMeshColor((Integer)styleMap.get((Object)string), n);
        }
        float[] fArray = styledColor.getColorComponents(null);
        return new HGMeshColor(fArray[0], fArray[1], fArray[2], styledColor.getAlpha(), n);
    }

    public StyledColor colorValue() {
        String string = (String)styleMap.inverseBidiMap().get((Object)this.fStyle);
        List<String> list = allowedStylesMap.get(this.fAllowedStyles);
        if (this.fStyle == -1) {
            return new StyledColor(this.fRed, this.fGreen, this.fBlue, this.alpha, list);
        }
        return new StyledColor(string, list);
    }

    public double getRed() {
        return this.fRed;
    }

    public void setRed(double d) {
        this.fRed = d;
    }

    public double getGreen() {
        return this.fGreen;
    }

    public void setGreen(double d) {
        this.fGreen = d;
    }

    public double getBlue() {
        return this.fBlue;
    }

    public void setBlue(double d) {
        this.fBlue = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public int getStyle() {
        return this.fStyle;
    }

    private synchronized double[] getComponents() {
        return new double[]{this.fRed, this.fGreen, this.fBlue, this.alpha};
    }

    public void setStyle(int n) {
        this.fStyle = n;
    }

    public int getAllowedStyles() {
        return this.fAllowedStyles;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HGMeshColor)) {
            return false;
        }
        HGMeshColor hGMeshColor = (HGMeshColor)object;
        boolean bl = hGMeshColor.getStyle() == this.getStyle() && (this.getStyle() != -1 || hGMeshColor.fRed == this.fRed && hGMeshColor.fGreen == this.fGreen && hGMeshColor.fBlue == this.fBlue && hGMeshColor.alpha == this.alpha);
        return bl;
    }

    public static final Color getColor(HGMeshColor hGMeshColor) {
        Color color = null;
        if (hGMeshColor != null && hGMeshColor.getStyle() == -1) {
            int n = (int)(hGMeshColor.getRed() * 255.0);
            int n2 = (int)(hGMeshColor.getGreen() * 255.0);
            int n3 = (int)(hGMeshColor.getBlue() * 255.0);
            int n4 = (int)(hGMeshColor.alpha * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            color = new Color(n, n2, n3, n4);
        }
        return color;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("style", styleMap.inverseBidiMap().get((Object)this.fStyle));
        toStringBuilder.append("allowedStyles", (Object)allowedStylesMap.get(this.fAllowedStyles).toString());
        toStringBuilder.append("red", this.fRed).append("green", this.fGreen).append("blue", this.fBlue).append("alpha", this.alpha);
        return toStringBuilder.toString();
    }

    static {
        styleMap.put((Object)Style.COLOR.toString(), (Object)Style.COLOR.intValue());
        styleMap.put((Object)Style.NONE.toString(), (Object)Style.NONE.intValue());
        styleMap.put((Object)Style.FLAT.toString(), (Object)Style.FLAT.intValue());
        styleMap.put((Object)Style.INTERP.toString(), (Object)Style.INTERP.intValue());
        styleMap.put((Object)Style.TEXTUREMAP.toString(), (Object)Style.TEXTUREMAP.intValue());
        styleMap.put((Object)Style.AUTO.toString(), (Object)Style.AUTO.intValue());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Style.NONE.toString());
        arrayList.add(Style.FLAT.toString());
        arrayList.add(Style.INTERP.toString());
        arrayList.add(Style.TEXTUREMAP.toString());
        allowedStylesMap.put(0, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Style.NONE.toString());
        arrayList.add(Style.AUTO.toString());
        allowedStylesMap.put(1, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Style.NONE.toString());
        arrayList.add(Style.AUTO.toString());
        arrayList.add(Style.FLAT.toString());
        allowedStylesMap.put(2, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Style.NONE.toString());
        arrayList.add(Style.FLAT.toString());
        arrayList.add(Style.INTERP.toString());
        allowedStylesMap.put(3, arrayList);
        arrayList = new ArrayList();
        arrayList.add(Style.NONE.toString());
        allowedStylesMap.put(4, arrayList);
    }

    private static enum Style {
        COLOR("color", -1),
        NONE("none", 0),
        FLAT("flat", 1),
        INTERP("interp", 2),
        TEXTUREMAP("texturemap", 3),
        AUTO("auto", 4);

        private final String name;
        private final int intValue;

        private Style(String string2, int n2) {
            this.name = string2;
            this.intValue = n2;
        }

        public String toString() {
            return this.name;
        }

        public Integer intValue() {
            return this.intValue;
        }

        public static boolean contains(String string) {
            Style[] styleArray;
            for (Style style : styleArray = Style.values()) {
                if (!StringUtils.equalsIgnoreCase((String)string, (String)style.toString())) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(int n) {
            Style[] styleArray;
            for (Style style : styleArray = Style.values()) {
                if (style.intValue != n) continue;
                return true;
            }
            return false;
        }
    }
}

