/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.EditorCustomizer;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.hg.types.HGTypeEditorIcon;
import com.mathworks.hg.types.table.TableEditor;
import com.mathworks.hg.util.HGHelpers;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;

public class HGTablePropertyEditor
extends MWPropertyEditorSupport
implements EditorCustomizer {
    private static Image sIcon = null;
    private static ArrayList<String> sPropertyTable = new ArrayList();
    private Frame fHostFrame;
    private PropertyEditor fDefaultEditor;
    private JComponent fRenderer;
    private Object[] fEditObject;
    private String fPropertyName;

    public boolean supportsInPlaceEditing() {
        return false;
    }

    public Image getIcon() {
        if (sIcon == null) {
            sIcon = HGTypeEditorIcon.TABLE.getIcon().getImage();
        }
        return sIcon;
    }

    public boolean hasCustomDialog() {
        return this.isSingleSelection();
    }

    public void invokeDialog() {
        this.launchCallbackEditor();
    }

    public void updateComponentState() {
        if (this.fDefaultEditor != null && this.fDefaultEditor instanceof MWPropertyEditorSupport) {
            ((MWPropertyEditorSupport)this.fDefaultEditor).updateComponentState();
        }
        if (this.fRenderer == null) {
            this.getInspectorRenderer();
        }
        if (this.fRenderer != null) {
            this.fRenderer.setEnabled(this.isSingleSelection());
            if (this.fRenderer instanceof JTextComponent) {
                ((JTextComponent)this.fRenderer).setText(this.getAsText());
            } else if (this.fRenderer instanceof JLabel) {
                ((JLabel)this.fRenderer).setText(this.getAsText());
            }
            this.fRenderer.repaint();
        }
    }

    public JComponent getInspectorRenderer() {
        if (this.fRenderer == null) {
            if (this.fDefaultEditor != null && this.fDefaultEditor instanceof MWPropertyEditorSupport) {
                this.fRenderer = ((MWPropertyEditorSupport)this.fDefaultEditor).getInspectorRenderer();
            }
            if (this.fRenderer == null) {
                this.fRenderer = new MJLabel(this.getAsText());
                this.fRenderer.addMouseListener(new MouseInputAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        HGTablePropertyEditor.this.launchCallbackEditor();
                    }
                });
            } else {
                MJPanel mJPanel = new MJPanel();
                mJPanel.setLayout((LayoutManager)new OverlayLayout((Container)mJPanel));
                MJPanel mJPanel2 = new MJPanel();
                mJPanel.add((Component)mJPanel2);
                mJPanel2.setOpaque(false);
                mJPanel.add((Component)this.fRenderer);
                this.fRenderer.setBackground(UIManager.getColor("TextField.background"));
                mJPanel2.addMouseListener((MouseListener)new MouseInputAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        HGTablePropertyEditor.this.launchCallbackEditor();
                    }
                });
                this.fRenderer = mJPanel;
            }
            this.updateComponentState();
        }
        return this.fRenderer;
    }

    public void launchCallbackEditor() {
        if (this.hasCustomDialog() && this.fEditObject != null && this.fEditObject.length > 0) {
            TableEditor.showTableEditorDialog(this.fHostFrame, this.fEditObject[0], this.fPropertyName, true);
        }
    }

    public void setEditObject(Object[] objectArray) {
        this.fEditObject = objectArray;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getAsText() {
        if (this.isSingleSelection()) {
            if (this.fDefaultEditor != null) {
                return this.fDefaultEditor.getAsText();
            }
            return "";
        }
        return MLInspectorServices.getMixedValueDisplay();
    }

    public void setAsText(String string) {
        if (this.fDefaultEditor != null) {
            this.fDefaultEditor.setAsText(string);
        }
    }

    public void setValue(Object object) {
        if (this.fDefaultEditor != null) {
            this.fDefaultEditor.setValue(object);
        }
    }

    public Object getValue() {
        if (this.fDefaultEditor != null) {
            return this.fDefaultEditor.getValue();
        }
        return null;
    }

    public void setData(Object object) {
        super.setData(object);
        if (this.fDefaultEditor != null) {
            if (this.fDefaultEditor instanceof MWPropertyEditorSupport) {
                ((MWPropertyEditorSupport)this.fDefaultEditor).setData(object);
            } else if (this.fDefaultEditor instanceof EnhancedPropertyEditor) {
                ((EnhancedPropertyEditor)this.fDefaultEditor).setData(object);
            }
        }
    }

    public String getDataKey() {
        String string = super.getDataKey();
        if (this.fDefaultEditor != null) {
            if (this.fDefaultEditor instanceof MWPropertyEditorSupport) {
                string = ((MWPropertyEditorSupport)this.fDefaultEditor).getDataKey();
            } else if (this.fDefaultEditor instanceof EnhancedPropertyEditor) {
                string = ((EnhancedPropertyEditor)this.fDefaultEditor).getDataKey();
            }
        }
        return string;
    }

    public boolean hasAttachedData() {
        boolean bl = super.hasAttachedData();
        if (this.fDefaultEditor != null) {
            if (this.fDefaultEditor instanceof MWPropertyEditorSupport) {
                bl = ((MWPropertyEditorSupport)this.fDefaultEditor).hasAttachedData();
            } else if (this.fDefaultEditor instanceof EnhancedPropertyEditor) {
                bl = ((EnhancedPropertyEditor)this.fDefaultEditor).hasAttachedData();
            }
        }
        return bl;
    }

    public void setFrame(Frame frame) {
        super.setFrame(frame);
        this.fHostFrame = frame;
        if (this.fDefaultEditor != null) {
            if (this.fDefaultEditor instanceof MWPropertyEditorSupport) {
                ((MWPropertyEditorSupport)this.fDefaultEditor).setFrame(frame);
            } else if (this.fDefaultEditor instanceof EnhancedPropertyEditor) {
                ((EnhancedPropertyEditor)this.fDefaultEditor).setFrame(frame);
            }
        }
    }

    public boolean isPaintable() {
        if (this.fDefaultEditor != null) {
            return this.fDefaultEditor.isPaintable();
        }
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (this.fDefaultEditor != null) {
            this.fDefaultEditor.paintValue(graphics, rectangle);
        }
    }

    private boolean isSingleSelection() {
        return this.fEditObject != null && this.fEditObject.length == 1;
    }

    public Object getTargetClassKey() {
        if (HGHelpers.isHGUsingMATLABClasses()) {
            return "matlab.ui.control.Table";
        }
        return "uitable";
    }

    public boolean hasCustomEditorForProperty(PropertyDescriptor propertyDescriptor) {
        return sPropertyTable.contains(propertyDescriptor.getName());
    }

    public PropertyEditor getCustomPropertyEditor(PropertyDescriptor propertyDescriptor, PropertyEditor propertyEditor) {
        HGTablePropertyEditor hGTablePropertyEditor = new HGTablePropertyEditor();
        hGTablePropertyEditor.fPropertyName = propertyDescriptor.getName();
        hGTablePropertyEditor.fDefaultEditor = propertyEditor;
        return hGTablePropertyEditor;
    }

    static {
        sPropertyTable.add("BackgroundColor");
        sPropertyTable.add("ColumnFormat");
        sPropertyTable.add("ColumnEditable");
        sPropertyTable.add("ColumnName");
        sPropertyTable.add("ColumnWidth");
        sPropertyTable.add("RowName");
        sPropertyTable.add("RowStriping");
        sPropertyTable.add("Data");
    }
}

