/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.format;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.hg.types.table.format.AbstractFormatPanel;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.hg.types.table.format.MultiColumnListCellRenderer;
import com.mathworks.hg.types.table.format.NumberTypeEnum;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NumberPanel
extends AbstractFormatPanel {
    private MJList listTypes;
    private MJTextField fieldWidth;
    private MJTextField fieldPrecision;
    private MJTextField fieldSprintf;
    private MJTextField fieldExample;
    private MJCheckBox flagSign;
    private MJCheckBox flagPadZeros;
    private MJLabel warnWidth;
    private MJLabel warnPrecision;

    public NumberPanel(FormatTypeEnum formatTypeEnum) {
        super(formatTypeEnum);
    }

    @Override
    protected JPanel buildFormatPanel() {
        FormLayout formLayout = new FormLayout("p, 12dlu, p, 0dlu:g(1.0)", "p, 12dlu, p, 0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildNumberTypePanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildOptionPanel(), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.buildSprintfPanel(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.buildExamplePanel(), cellConstraints.xy(3, 3));
        panelBuilder.setBorder(Borders.DLU7_BORDER);
        return panelBuilder.getPanel();
    }

    private JPanel buildNumberTypePanel() {
        NumberTypeEnum numberTypeEnum2;
        Vector<NumberTypeEnum> vector = new Vector<NumberTypeEnum>();
        for (NumberTypeEnum numberTypeEnum2 : NumberTypeEnum.values()) {
            vector.add(numberTypeEnum2);
        }
        MultiColumnListCellRenderer multiColumnListCellRenderer = new MultiColumnListCellRenderer(4);
        this.listTypes = new MJList(vector);
        this.listTypes.setSelectionMode(0);
        this.listTypes.setVisibleRowCount(vector.size());
        this.listTypes.setCellRenderer((ListCellRenderer)multiColumnListCellRenderer);
        this.listTypes.setBorder(Borders.createEmptyBorder((String)"1dlu, 1dlu, 1dlu, 1dlu"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.listTypes);
        this.listTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    NumberTypeEnum numberTypeEnum = (NumberTypeEnum)((Object)NumberPanel.this.listTypes.getSelectedValue());
                    if (numberTypeEnum != null) {
                        NumberPanel.this.updateSizeFields(numberTypeEnum);
                        NumberPanel.this.updateFlagFields(numberTypeEnum);
                        NumberPanel.this.updateSprintfFields(numberTypeEnum);
                    } else {
                        NumberPanel.this.showNoFormat();
                    }
                }
            }
        });
        FormLayout formLayout = new FormLayout("p", "p, 2dlu, p");
        numberTypeEnum2 = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        numberTypeEnum2.addLabel("Conversions:", cellConstraints.xy(1, 1));
        numberTypeEnum2.add((Component)mJScrollPane, cellConstraints.xy(1, 3));
        return numberTypeEnum2.getPanel();
    }

    private JPanel buildOptionPanel() {
        this.flagSign = new MJCheckBox("Always display + before positive numbers");
        this.flagSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberPanel.this.updateExamples();
            }
        });
        this.flagPadZeros = new MJCheckBox("Pad with zeros rather than spaces");
        this.flagPadZeros.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberPanel.this.updateExamples();
            }
        });
        this.warnWidth = new MJLabel();
        this.warnWidth.setIcon((Icon)DialogIcon.WARNING_12x12.getIcon());
        Font font = this.warnWidth.getFont();
        font = font.deriveFont((float)font.getSize() - 1.0f);
        this.warnWidth.setFont(font);
        this.warnWidth.setVisible(false);
        this.warnPrecision = new MJLabel();
        this.warnPrecision.setIcon((Icon)DialogIcon.WARNING_12x12.getIcon());
        this.warnPrecision.setFont(font);
        this.warnPrecision.setVisible(false);
        this.fieldWidth = new MJTextField(6);
        this.fieldWidth.setInputVerifier((InputVerifier)new WidthVerifier((JLabel)this.warnWidth, 1, Integer.MAX_VALUE));
        this.fieldPrecision = new MJTextField(6);
        this.fieldPrecision.setInputVerifier((InputVerifier)new WidthVerifier((JLabel)this.warnPrecision, 0, Integer.MAX_VALUE));
        FormLayout formLayout = new FormLayout("p, 4dlu, p, 6dlu, p, 0dlu:g(1.0)", "p, 4dlu, p, 8dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("Field Width:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldWidth, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.warnWidth, cellConstraints.xy(5, 1));
        panelBuilder.addLabel("Precision:", cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.fieldPrecision, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.warnPrecision, cellConstraints.xy(5, 3));
        panelBuilder.add((Component)this.flagSign, cellConstraints.xyw(1, 5, 6));
        panelBuilder.add((Component)this.flagPadZeros, cellConstraints.xyw(1, 7, 6));
        return panelBuilder.getPanel();
    }

    private JPanel buildSprintfPanel() {
        this.fieldSprintf = new MJTextField(16);
        FormLayout formLayout = new FormLayout("p, 4dlu, p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("sprintf Format:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldSprintf, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JPanel buildExamplePanel() {
        this.fieldExample = new MJTextField(16);
        FormLayout formLayout = new FormLayout("p, 4dlu, p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("Example:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldExample, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void updateExamples() {
        if (this.isValidFormat()) {
            NumberTypeEnum numberTypeEnum = (NumberTypeEnum)((Object)this.listTypes.getSelectedValue());
            this.updateSprintfFields(numberTypeEnum);
        } else {
            this.showInvalidFormat();
        }
    }

    private void updateSizeFields(NumberTypeEnum numberTypeEnum) {
        this.fieldWidth.setText(null);
        this.fieldPrecision.setText(null);
        if (numberTypeEnum.allowsPrecision()) {
            this.fieldPrecision.setEnabled(true);
            this.fieldPrecision.setEditable(true);
        } else {
            this.fieldPrecision.setEnabled(false);
            this.fieldPrecision.setEditable(false);
        }
    }

    private void updateFlagFields(NumberTypeEnum numberTypeEnum) {
        this.flagSign.setSelected(false);
        this.flagPadZeros.setSelected(false);
        switch (numberTypeEnum) {
            case DEC_UNSIGNED: {
                this.flagSign.setEnabled(false);
                this.flagPadZeros.setEnabled(true);
                break;
            }
            default: {
                this.flagSign.setEnabled(true);
                this.flagPadZeros.setEnabled(true);
            }
        }
    }

    private void updateSprintfFields(NumberTypeEnum numberTypeEnum) {
        String string;
        String string2 = numberTypeEnum.getSymbol();
        string2 = this.addSizeToFormat(string2);
        string2 = this.addFlagsToFormat(string2);
        switch (numberTypeEnum) {
            case DEC_SIGNED: 
            case OCTAL: 
            case HEX_LOWER: 
            case HEX_UPPER: {
                string = String.format(string2, 123456);
                break;
            }
            case EXP_LOWER: 
            case EXP_UPPER: 
            case FIXED: 
            case COMPACT_LOWER: 
            case COMPACT_UPPER: {
                string = String.format(string2, 1.23456789E8);
                break;
            }
            case DEC_UNSIGNED: {
                char c = NumberTypeEnum.DEC_SIGNED.getSymbol().charAt(1);
                String string3 = string2.replace('u', c);
                string = String.format(string3, 123456);
                break;
            }
            default: {
                string2 = null;
                string = null;
            }
        }
        this.fieldSprintf.setBackground((Color)SystemColor.text);
        this.fieldSprintf.setText(string2);
        this.fieldExample.setText(string);
    }

    private String addSizeToFormat(String string) {
        String string2 = string;
        if (this.fieldPrecision.isEnabled() && this.fieldPrecision.getText().trim().length() > 0) {
            string2 = "%." + this.fieldPrecision.getText().trim() + string2.substring(1);
        }
        if (this.fieldWidth.getText().trim().length() > 0) {
            string2 = "%" + this.fieldWidth.getText().trim() + string2.substring(1);
        }
        return string2;
    }

    private String addFlagsToFormat(String string) {
        String string2 = string;
        if (this.fieldWidth.getText().trim().length() > 0 && this.flagPadZeros.isEnabled() && this.flagPadZeros.isSelected()) {
            string2 = "%0" + string2.substring(1);
        }
        if (this.flagSign.isEnabled() && this.flagSign.isSelected()) {
            string2 = "%+" + string2.substring(1);
        }
        return string2;
    }

    private void showInvalidFormat() {
        this.fieldSprintf.setText("Invalid");
        this.fieldSprintf.setBackground(Color.CYAN);
        this.fieldExample.setText("Invalid");
    }

    private void showNoFormat() {
        this.fieldSprintf.setText(null);
        this.fieldSprintf.setBackground((Color)SystemColor.text);
        this.fieldExample.setText(null);
        this.fieldWidth.setText(null);
        this.fieldWidth.setBackground((Color)SystemColor.text);
        this.warnWidth.setVisible(false);
        this.fieldPrecision.setText(null);
        this.fieldPrecision.setBackground((Color)SystemColor.text);
        this.warnPrecision.setVisible(false);
        this.flagSign.setSelected(false);
        this.flagPadZeros.setSelected(false);
    }

    @Override
    protected boolean isValidFormat() {
        return this.listTypes.getSelectedIndex() >= 0 && !this.warnWidth.isVisible() && !this.warnPrecision.isVisible();
    }

    @Override
    protected String getFormat() {
        if (this.isValidFormat()) {
            return this.fieldSprintf.getText();
        }
        return null;
    }

    class WidthVerifier
    extends InputVerifier {
        private JLabel warnLabel;
        private int minValue;
        private int maxValue;

        public WidthVerifier(JLabel jLabel, int n, int n2) {
            this.warnLabel = jLabel;
            this.minValue = n;
            this.maxValue = n2;
        }

        public void setMaximumValue(int n) {
            this.maxValue = n;
        }

        @Override
        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            NumberPanel.this.updateExamples();
            return bl;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            String string = null;
            MJTextField mJTextField = (MJTextField)jComponent;
            String string2 = mJTextField.getText().trim();
            if (!string2.equals("")) {
                try {
                    int n = Integer.parseInt(string2);
                    mJTextField.setBackground((Color)SystemColor.text);
                    if (n < this.minValue) {
                        string = "Number must be >= " + this.minValue;
                    } else if (n > this.maxValue) {
                        string = "Number must be <= " + this.maxValue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = "Not a number";
                }
            }
            if (string == null) {
                mJTextField.setBackground((Color)SystemColor.text);
                this.warnLabel.setText(null);
                this.warnLabel.setVisible(false);
            } else {
                mJTextField.setBackground(Color.CYAN);
                this.warnLabel.setText(string);
                this.warnLabel.setVisible(true);
            }
            return true;
        }
    }
}

