/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import com.mathworks.hg.types.table.panel.MessagePanel;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.mlwidgets.graphics.ColorPicker;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class RowStripingPanel
extends AbstractEditorPanel {
    private static final String COLOR_TEXT = EDITOR_RESOURCES.getString("stripe.color");
    private static final String RGB_TEXT = EDITOR_RESOURCES.getString("stripe.rgb");
    private static final String TOOLTIP_FORMAT = EDITOR_RESOURCES.getString("stripe.tooltip");
    private static NumberFormat FORMATTER = new DecimalFormat("0.000");
    private static Color STRIPE_COLOR_1 = new Color(1.0f, 1.0f, 1.0f);
    private static Color STRIPE_COLOR_2 = new Color(0.9608f, 0.9608f, 0.9608f);
    private MJRadioButton radioNone;
    private MJRadioButton radioStriping;
    private ColorPicker pickerBackground;
    private ColorPicker pickerFirstBack;
    private ColorPicker pickerSecondBack;
    private ColorPicker pickerForeground;

    public RowStripingPanel(PropertyPanelEnum propertyPanelEnum, TablePropertyModel tablePropertyModel) {
        super(propertyPanelEnum, tablePropertyModel);
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected JPanel buildEditorPanel() {
        MessagePanel messagePanel = new MessagePanel(this.getResourceString("stripe.info"));
        messagePanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("stripe.info"));
        this.radioNone = new MJRadioButton(this.getResourceString("stripe.no_striping"));
        this.radioNone.setToolTipText(this.getResourceString("stripe.no_striping_tip"));
        this.radioStriping = new MJRadioButton(this.getResourceString("stripe.striping"));
        this.radioStriping.setToolTipText(this.getResourceString("stripe.striping_tip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.radioNone);
        buttonGroup.add((AbstractButton)this.radioStriping);
        MJLabel mJLabel = this.createLabel("stripe.all_rows", null);
        MJLabel mJLabel2 = this.createLabel("stripe.all_rows", null);
        MJLabel mJLabel3 = this.createLabel("stripe.background", "stripe.all_back_tip");
        MJLabel mJLabel4 = this.createLabel("stripe.foreground", "stripe.all_fore_tip");
        this.pickerBackground = this.createColorPicker(this.radioNone);
        this.pickerBackground.getAccessibleContext().setAccessibleName(this.getResourceString("acc.stripe.bgpicker"));
        this.pickerForeground = this.createColorPicker(null);
        this.pickerForeground.getAccessibleContext().setAccessibleName(this.getResourceString("acc.stripe.fgpicker"));
        MJLabel mJLabel5 = this.createLabel("stripe.odd_rows", null);
        MJLabel mJLabel6 = this.createLabel("stripe.background", "stripe.odd_back_tip");
        this.pickerFirstBack = this.createColorPicker(this.radioStriping);
        this.pickerFirstBack.getAccessibleContext().setAccessibleName(this.getResourceString("acc.stripe.oddrowpicker"));
        MJLabel mJLabel7 = this.createLabel("stripe.even_rows", null);
        MJLabel mJLabel8 = this.createLabel("stripe.background", "stripe.even_back_tip");
        this.pickerSecondBack = this.createColorPicker(this.radioStriping);
        this.pickerSecondBack.getAccessibleContext().setAccessibleName(this.getResourceString("acc.stripe.evenrowpicker"));
        FormLayout formLayout = new FormLayout("12dlu, p, 10dlu, p, 4dlu, p, 16dlu, 0dlu:g(1.0)", "p, 4dlu, p, 4dlu, p, 8dlu, p, 4dlu, p, 4dlu, p, 16dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator(this.getResourceString("stripe.back_sep"), cellConstraints.xyw(1, 1, 7));
        panelBuilder.add((Component)this.radioNone, cellConstraints.xyw(1, 3, 7));
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(2, 5));
        panelBuilder.add((Component)mJLabel3, cellConstraints.xy(4, 5));
        panelBuilder.add((Component)this.pickerBackground, cellConstraints.xy(6, 5));
        panelBuilder.add((Component)this.radioStriping, cellConstraints.xyw(1, 7, 7));
        panelBuilder.add((Component)mJLabel5, cellConstraints.xy(2, 9));
        panelBuilder.add((Component)mJLabel6, cellConstraints.xy(4, 9));
        panelBuilder.add((Component)this.pickerFirstBack, cellConstraints.xy(6, 9));
        panelBuilder.add((Component)mJLabel7, cellConstraints.xy(2, 11));
        panelBuilder.add((Component)mJLabel8, cellConstraints.xy(4, 11));
        panelBuilder.add((Component)this.pickerSecondBack, cellConstraints.xy(6, 11));
        panelBuilder.addSeparator(this.getResourceString("stripe.fore_sep"), cellConstraints.xyw(1, 13, 7));
        panelBuilder.add((Component)mJLabel2, cellConstraints.xy(2, 15));
        panelBuilder.add((Component)mJLabel4, cellConstraints.xy(4, 15));
        panelBuilder.add((Component)this.pickerForeground, cellConstraints.xy(6, 15));
        panelBuilder.setBorder(Borders.createEmptyBorder((String)"6dlu, 0dlu, 0dlu, 0dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)messagePanel), (Object)"North");
        mJPanel.add((Component)panelBuilder.getPanel(), (Object)"Center");
        mJPanel.setBorder(Borders.createEmptyBorder((String)"7dlu, 7dlu, 0dlu, 0dlu"));
        mJPanel.getAccessibleContext().setAccessibleName(this.getResourceString("acc.stripe.name"));
        return mJPanel;
    }

    @Override
    protected void initializePanel() {
        boolean bl = this.getBooleanValue("RowStriping");
        List<Color> list = this.getColorValues("BackgroundColor", "Table.background");
        List<Color> list2 = this.getColorValues("ForegroundColor", "Table.foreground");
        if (bl) {
            int n = list.size() > 1 ? 1 : 0;
            this.pickerFirstBack.setValueWithoutEvents((Object)list.get(0));
            this.pickerSecondBack.setValueWithoutEvents((Object)list.get(n));
            Color color = UIManager.getColor("Table.background");
            this.pickerBackground.setValueWithoutEvents((Object)color);
        } else {
            this.pickerBackground.setValueWithoutEvents((Object)list.get(0));
            this.pickerFirstBack.setValueWithoutEvents((Object)STRIPE_COLOR_1);
            this.pickerSecondBack.setValueWithoutEvents((Object)STRIPE_COLOR_2);
        }
        this.pickerForeground.setValueWithoutEvents((Object)list2.get(0));
        if (bl) {
            this.radioStriping.setSelected(true);
        } else {
            this.radioNone.setSelected(true);
        }
    }

    @Override
    public void commit() {
        this.setBooleanValue("RowStriping", this.radioStriping.isSelected());
        ArrayList<Color> arrayList = new ArrayList<Color>();
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        if (this.radioStriping.isSelected()) {
            arrayList.add((Color)this.pickerFirstBack.getValue());
            arrayList.add((Color)this.pickerSecondBack.getValue());
        } else {
            arrayList.add((Color)this.pickerBackground.getValue());
        }
        arrayList2.add((Color)this.pickerForeground.getValue());
        this.setColorValue("BackgroundColor", arrayList);
        this.setColorValue("ForegroundColor", arrayList2);
        this.setMetadataValue("BackgroundColorPropertyDimension", new double[]{arrayList.size(), 3.0});
    }

    private MJLabel createLabel(String string, String string2) {
        MJLabel mJLabel = new MJLabel(this.getResourceString(string));
        if (string2 != null) {
            mJLabel.setToolTipText(this.getResourceString(string2));
        }
        return mJLabel;
    }

    private ColorPicker createColorPicker(MJRadioButton mJRadioButton) {
        return new StripingColorPicker(mJRadioButton, ColorPicker.NO_OPTIONS, ColorPicker.NO_ICON, "Color");
    }

    private class StripingColorPicker
    extends ColorPicker {
        private MJRadioButton colorButton;

        public StripingColorPicker(MJRadioButton mJRadioButton, int n, int n2, String string) {
            super(n, n2, string);
            this.colorButton = mJRadioButton;
        }

        public void setValue(Object object) {
            super.setValue(object);
            this.updateControls(object);
        }

        public void setValueWithoutEvents(Object object) {
            super.setValueWithoutEvents(object);
            this.updateControls(object);
        }

        private void updateControls(Object object) {
            this.setToolTipText(this.getColorAsHTML((Color)object));
            if (this.colorButton != null && !this.colorButton.isSelected()) {
                this.colorButton.setSelected(true);
            }
        }

        private String getColorAsHTML(Color color) {
            Object[] objectArray = new Object[]{COLOR_TEXT, FORMATTER.format((double)color.getRed() / 255.0), FORMATTER.format((double)color.getGreen() / 255.0), FORMATTER.format((double)color.getBlue() / 255.0), RGB_TEXT, String.valueOf(color.getRed()), String.valueOf(color.getGreen()), String.valueOf(color.getBlue())};
            return MessageFormat.format(TOOLTIP_FORMAT, objectArray);
        }
    }
}

