/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.hg.util.PrintDialog;
import com.mathworks.hg.util.PrinterUtils;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.GraphicsDeviceUtilities;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;

public class HGPrintOutputHelper
extends OutputHelper {
    private Exception fException;
    protected MPrintJob fPrintJob;
    protected PrintServiceHelper fPrintServiceHelper;
    protected PrinterException fPrintException = null;

    public HGPrintOutputHelper(MPrintJob mPrintJob) throws OutputHelperInstantiationException {
        super(mPrintJob);
        this.fPrintJob = mPrintJob;
    }

    @Override
    public void open() throws OutputHelperProcessingException {
        this.fPrintServiceHelper = new PrintServiceHelper();
    }

    @Override
    public void generateOutput(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        this.fPrintServiceHelper.setContainer(figurePanelContainer);
        PrintRequestAttributeSet printRequestAttributeSet = this.setupPrintRequestAttributeSet();
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.fPrintServiceHelper);
        PrintService printService = null;
        PrintService[] printServiceArray = null;
        String string = this.fPrintJob.getPrinterName();
        if (string != null && string.length() > 0 && ((printServiceArray = PrinterUtils.getRequestedPrinter(string)) == null || printServiceArray.length == 0)) {
            HGPrintOutputHelper.throwRequestedPrinterNotFound(string);
        }
        if (printServiceArray == null || printServiceArray.length == 0) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)).length > 0) {
                printService = printServiceArray[0];
            }
        } else if (printServiceArray.length > 0) {
            printService = printServiceArray[0];
        }
        this.printTheContainer(printService, printerJob, printRequestAttributeSet);
    }

    protected static void throwRequestedPrinterNotFound(String string) throws OutputHelperProcessingException {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        throw new OutputHelperProcessingException("MATLAB:HG:Java:UnknownPrinter\nThe specified printer '" + string2 + "' was not found");
    }

    protected void printTheContainer(PrintService printService, PrinterJob printerJob, PrintRequestAttributeSet printRequestAttributeSet) throws OutputHelperProcessingException {
        if (printService == null) {
            throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintSetup\nNo printers are setup");
        }
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintAccess\nProblem using printer " + printerException);
        }
        boolean bl = true;
        if (this.fPrintJob.isShowDialog()) {
            try {
                bl = PrintDialog.show(printerJob, printRequestAttributeSet);
            }
            catch (Throwable throwable) {
                throw new OutputHelperProcessingException(throwable);
            }
        }
        if (bl) {
            final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
            final PrinterJob printerJob2 = printerJob;
            final Container container = this.fPrintServiceHelper.getContainer().getTargetContainer();
            this.fException = null;
            Throwable throwable = null;
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            assert (container.isDisplayable()) : "Expected the container to be displayable before generating output.";
                            printerJob2.print(printRequestAttributeSet2);
                        }
                        catch (PrinterException printerException) {
                            HGPrintOutputHelper.this.fPrintException = printerException;
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (this.fPrintException != null) {
                throw new OutputHelperProcessingException("MATLAB:HG:Java:PrintAccess\nProblem using printer " + this.fPrintException);
            }
            if (this.fException != null) {
                throw new OutputHelperProcessingException(this.fException);
            }
            if (throwable != null) {
                throw new OutputHelperProcessingException(throwable);
            }
        }
    }

    protected PrintRequestAttributeSet setupPrintRequestAttributeSet() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName("MATLAB", null));
        hashPrintRequestAttributeSet.add(new PageRanges(1, 1));
        String string = this.fPrintJob.getOutputOrientation().toLowerCase();
        if (string.equals("portrait")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        } else if (string.equals("landscape")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        } else if (string.equals("rotated")) {
            hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
        } else {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        }
        String string2 = this.fPrintJob.getPaperType().toLowerCase();
        if (string2.equals("usletter")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_LETTER);
        } else if (string2.equals("uslegal")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_LEGAL);
        } else if (string2.equals("a0")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A0);
        } else if (string2.equals("a1")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A1);
        } else if (string2.equals("a2")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A2);
        } else if (string2.equals("a3")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A3);
        } else if (string2.equals("a4")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        } else if (string2.equals("a5")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A5);
        } else if (string2.equals("b0")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B0);
        } else if (string2.equals("b1")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B1);
        } else if (string2.equals("b2")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B2);
        } else if (string2.equals("b3")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B3);
        } else if (string2.equals("b4")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B4);
        } else if (string2.equals("b5")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.JIS_B5);
        } else if (string2.equals("a")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.A);
        } else if (string2.equals("b")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.B);
        } else if (string2.equals("c")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.C);
        } else if (string2.equals("d")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.D);
        } else if (string2.equals("e")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.E);
        } else if (string2.equals("tabloid")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.TABLOID);
        } else if (string2.equals("arch-a")) {
            hashPrintRequestAttributeSet.add(MediaSizeName.NA_9X12_ENVELOPE);
        } else {
            MediaSizeName mediaSizeName = MediaSize.findMedia(this.fPrintJob.getPaperSize_Width(), this.fPrintJob.getPaperSize_Height(), 25400);
            if (mediaSizeName != null) {
                hashPrintRequestAttributeSet.add(mediaSizeName);
            }
        }
        float f7 = this.fPrintJob.getPaperSize_Width();
        float f8 = this.fPrintJob.getPaperSize_Height();
        if (this.fPrintJob.getOutputOrientation().equalsIgnoreCase("portrait")) {
            f6 = this.fPrintJob.getPaperPosition_Width();
            f5 = this.fPrintJob.getPaperPosition_Height();
            f4 = this.fPrintJob.getPaperPosition_X();
            f3 = this.fPrintJob.getPaperPosition_Y();
            f2 = f4;
            f = f8 - f3 - f5;
        } else {
            f6 = this.fPrintJob.getPaperPosition_Height();
            f5 = this.fPrintJob.getPaperPosition_Width();
            f4 = this.fPrintJob.getPaperPosition_Y();
            f3 = this.fPrintJob.getPaperPosition_X();
            f2 = f8 - f4 - f6;
            f = f7 - f3 - f5;
        }
        if ((double)f2 < 0.0) {
            f2 = 0.001f;
        }
        if ((double)f < 0.0) {
            f = 0.001f;
        }
        if (this.fPrintJob.isDebugMode()) {
            DebugUtilities.logMessage(8192, "new setupPrintRequestAttributeSet()\norigin X: " + f2 + " Y: " + f + " paper W: " + f7 + " H: " + f8 + "\npos.  W: " + f6 + " H: " + f5 + "\noffsetX: " + f4 + " Y: " + f3 + "\n  ", this);
        }
        hashPrintRequestAttributeSet.add(new MediaPrintableArea(f2, f, f6, f5, 25400));
        return hashPrintRequestAttributeSet;
    }

    @Override
    public void close() throws OutputHelperProcessingException {
    }

    @Override
    public boolean supportsMultiplePages() {
        return false;
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return false;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
    }

    protected class PrintServiceHelper
    implements Printable {
        private boolean fPrintDebugInfo = false;
        private FigurePanelContainer fContainer = null;

        protected PrintServiceHelper() {
            this.fPrintDebugInfo = HGPrintOutputHelper.this.fPrintJob.isDebugMode();
        }

        public FigurePanelContainer getContainer() {
            return this.fContainer;
        }

        public void setContainer(FigurePanelContainer figurePanelContainer) {
            this.fContainer = figurePanelContainer;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n == 0) {
                Object object;
                if (this.fPrintDebugInfo) {
                    switch (pageFormat.getOrientation()) {
                        case 0: {
                            object = "landscape";
                            break;
                        }
                        case 2: {
                            object = "reverse landscape";
                            break;
                        }
                        case 1: {
                            object = "portrait";
                            break;
                        }
                        default: {
                            object = "unknown";
                        }
                    }
                    DebugUtilities.logMessage(8192, "new print()\nImageable X: " + pageFormat.getImageableX() + " Y: " + pageFormat.getImageableY() + " W: " + pageFormat.getImageableWidth() + " H: " + pageFormat.getImageableHeight() + "\nPW: " + pageFormat.getWidth() + " PH: " + pageFormat.getHeight() + " Orientation: " + (String)object + "\n  ", this);
                }
                object = (Graphics2D)graphics;
                ((Graphics2D)object).translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
                double d = OutputHelper.getJAVA2D_DPI() / (double)GraphicsDeviceUtilities.getDefaultScreenResolution();
                double d2 = d * (pageFormat.getImageableWidth() / OutputHelper.getJAVA2D_DPI()) / (double)HGPrintOutputHelper.this.fPrintJob.getPaperPosition_Width();
                double d3 = d * (pageFormat.getImageableHeight() / OutputHelper.getJAVA2D_DPI()) / (double)HGPrintOutputHelper.this.fPrintJob.getPaperPosition_Height();
                ((Graphics2D)object).scale(d2, d3);
                HGPrintOutputHelper.this.fException = this.fContainer.printFigurePanel((Graphics)object, HGPrintOutputHelper.this.fPrintJob.isShowUI(), HGPrintOutputHelper.this.fPrintJob.isDebugMode());
                this.fPrintDebugInfo = false;
                return 0;
            }
            return 1;
        }
    }
}

