/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.GraphicsDeviceUtilities;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class HGRasterOutputHelper
extends OutputHelper {
    private Exception fException;
    protected MPrintJob fPrintJob;
    private BufferedImage fBufferedImage;
    private static ResourceBundle sRasterHelperInfo = ResourceBundle.getBundle("com.mathworks.hg.util.resources.RES_rasterhelper");
    private static String[] sRasterTypes = new String[]{"raster@toolbox"};

    public HGRasterOutputHelper(MPrintJob mPrintJob) throws OutputHelperInstantiationException {
        super(mPrintJob);
        String string = mPrintJob.getDriver();
        boolean bl = false;
        for (String string2 : sRasterTypes) {
            if (!string.equals(string2)) continue;
            bl = true;
        }
        if (!bl) {
            throw new OutputHelperInstantiationException(sRasterHelperInfo.getString("raster.unknownDriver") + " " + string);
        }
        this.fPrintJob = mPrintJob;
    }

    @Override
    public void open() throws OutputHelperProcessingException {
    }

    @Override
    public void generateOutput(final FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        double d = this.fPrintJob.getDPI();
        assert (d != 0.0);
        double d2 = HGRasterOutputHelper.getJAVA2D_DPI() / (double)GraphicsDeviceUtilities.getDefaultScreenResolution();
        final double d3 = d2 * (d / HGRasterOutputHelper.getJAVA2D_DPI());
        this.fException = null;
        Throwable throwable = null;
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    assert (figurePanelContainer.getTargetContainer().isDisplayable()) : "Expected the container to be displayable before generating output.";
                    double d = (double)figurePanelContainer.getTargetContainer().getWidth() * d3;
                    double d2 = (double)figurePanelContainer.getTargetContainer().getHeight() * d3;
                    HGRasterOutputHelper.this.fBufferedImage = (BufferedImage)figurePanelContainer.getTargetContainer().createImage((int)Math.round(d), (int)Math.round(d2));
                    assert (HGRasterOutputHelper.this.fBufferedImage != null) : "Unable to create a buffered image of size " + d + " x " + d2 + " from Component " + figurePanelContainer.getTargetContainer();
                    Graphics2D graphics2D = HGRasterOutputHelper.this.fBufferedImage.createGraphics();
                    graphics2D.scale(d3, d3);
                    HGRasterOutputHelper.this.fException = figurePanelContainer.printFigurePanel(graphics2D, HGRasterOutputHelper.this.fPrintJob.isShowUI(), HGRasterOutputHelper.this.fPrintJob.isDebugMode());
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (this.fException != null) {
            throw new OutputHelperProcessingException(this.fException);
        }
        if (throwable != null) {
            throw new OutputHelperProcessingException(throwable);
        }
    }

    @Override
    public void close() throws OutputHelperProcessingException {
    }

    @Override
    public boolean supportsGettingCDataFromBufferedImage() {
        return true;
    }

    @Override
    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return this.fBufferedImage;
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return this.supportsGettingCDataFromBufferedImage();
    }

    @Override
    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.fBufferedImage != null && this.fBufferedImage.getWidth() > 0 && this.fBufferedImage.getHeight() > 0) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                String[] stringArray = new String[]{"png", "jpg", "gif", "bmp"};
                String string = "";
                int n = 0;
                do {
                    Iterator<ImageWriter> iterator;
                    if (!(iterator = ImageIO.getImageWritersByFormatName(stringArray[n])).hasNext()) continue;
                    string = stringArray[n];
                } while (string.isEmpty() && n < stringArray.length);
                if (string.isEmpty()) {
                    throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.insufficientImageSupportForClipboard"));
                }
                ImageIO.write((RenderedImage)this.fBufferedImage, "png", byteArrayOutputStream);
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream = null;
            }
        }
        if (byteArrayOutputStream == null) {
            throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.errorRetrievingRasterDataForClipboard"));
        }
        return byteArrayOutputStream;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
        this.fBufferedImage = null;
    }
}

