/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class PrinterUtils {
    public static String getDefaultPrinterName() {
        PrintService[] printServiceArray;
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService == null && (printServiceArray = PrintServiceLookup.lookupPrintServices(null, null)).length > 0) {
            printService = printServiceArray[0];
        }
        String string = printService != null ? printService.getName() : "";
        return string;
    }

    public static String[] getAvailablePrinterNames() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        if (printServiceArray == null || printServiceArray.length <= 0) {
            return new String[0];
        }
        String[] stringArray = new String[printServiceArray.length];
        for (int i = 0; i < printServiceArray.length; ++i) {
            stringArray[i] = printServiceArray[i].getName();
        }
        return stringArray;
    }

    public static boolean isPrinterValid(String string) {
        PrintService[] printServiceArray = PrinterUtils.getRequestedPrinter(string);
        return printServiceArray != null && printServiceArray.length > 0;
    }

    public static PrintService[] getDefaultPrinter() {
        return PrinterUtils.getRequestedPrinter(PrinterUtils.getDefaultPrinterName());
    }

    public static PrintService[] getRequestedPrinter(String string) {
        PrintService[] printServiceArray = null;
        if (string != null && string.length() > 0) {
            PrinterName printerName = new PrinterName(string, null);
            HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
            hashPrintServiceAttributeSet.add(printerName);
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, hashPrintServiceAttributeSet);
            if (printServiceArray == null || printServiceArray.length == 0) {
                PrintService[] printServiceArray2 = PrintServiceLookup.lookupPrintServices(null, null);
                for (int i = 0; i < printServiceArray2.length; ++i) {
                    if (string.compareToIgnoreCase(printServiceArray2[i].getName()) != 0) continue;
                    printServiceArray = new PrintService[]{printServiceArray2[i]};
                    break;
                }
            }
        }
        return printServiceArray;
    }
}

