/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.util.PlatformInfo;
import java.awt.Font;

public class UnicodeTextTranslator {
    private UnicodeTextTranslator() {
        throw new Error("UnicodeTextTranslator is just a host for static methods");
    }

    static String[] deriveUnicodeFromSymbol(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                stringArray2[i] = null;
                continue;
            }
            if (string == "") {
                stringArray2[i] = "";
                continue;
            }
            char[] cArray = new char[string.length()];
            for (int j = 0; j < cArray.length; ++j) {
                cArray[j] = UnicodeTextTranslator.deriveUnicodeFromSymbol(string.charAt(j));
            }
            stringArray2[i] = String.valueOf(cArray);
        }
        return stringArray2;
    }

    static String[] deriveUnicodeFromMarlett(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null) {
                stringArray2[i] = null;
                continue;
            }
            if (string == "") {
                stringArray2[i] = "";
                continue;
            }
            char[] cArray = new char[string.length()];
            for (int j = 0; j < cArray.length; ++j) {
                cArray[j] = UnicodeTextTranslator.deriveUnicodeFromMarlett(string.charAt(j));
            }
            stringArray2[i] = String.valueOf(cArray);
        }
        return stringArray2;
    }

    private static char deriveUnicodeFromSymbol(char n) {
        int n2 = n;
        switch (n) {
            case 34: {
                n2 = 8704;
                break;
            }
            case 36: {
                n2 = 8707;
                break;
            }
            case 39: {
                n2 = 8715;
                break;
            }
            case 64: {
                n2 = 8773;
                break;
            }
            case 65: {
                n2 = 913;
                break;
            }
            case 66: {
                n2 = 914;
                break;
            }
            case 67: {
                n2 = 935;
                break;
            }
            case 68: {
                n2 = 916;
                break;
            }
            case 69: {
                n2 = 917;
                break;
            }
            case 70: {
                n2 = 934;
                break;
            }
            case 71: {
                n2 = 915;
                break;
            }
            case 72: {
                n2 = 919;
                break;
            }
            case 73: {
                n2 = 921;
                break;
            }
            case 74: {
                n2 = 977;
                break;
            }
            case 75: {
                n2 = 922;
                break;
            }
            case 76: {
                n2 = 923;
                break;
            }
            case 77: {
                n2 = 924;
                break;
            }
            case 78: {
                n2 = 925;
                break;
            }
            case 79: {
                n2 = 927;
                break;
            }
            case 80: {
                n2 = 928;
                break;
            }
            case 81: {
                n2 = 920;
                break;
            }
            case 82: {
                n2 = 929;
                break;
            }
            case 83: {
                n2 = 931;
                break;
            }
            case 84: {
                n2 = 932;
                break;
            }
            case 85: {
                n2 = 933;
                break;
            }
            case 86: {
                n2 = 962;
                break;
            }
            case 87: {
                n2 = 937;
                break;
            }
            case 88: {
                n2 = 926;
                break;
            }
            case 89: {
                n2 = 936;
                break;
            }
            case 90: {
                n2 = 918;
                break;
            }
            case 92: {
                n2 = 8756;
                break;
            }
            case 94: {
                n2 = 8869;
                break;
            }
            case 96: {
                n2 = 773;
                break;
            }
            case 97: {
                n2 = 945;
                break;
            }
            case 98: {
                n2 = 946;
                break;
            }
            case 99: {
                n2 = 967;
                break;
            }
            case 100: {
                n2 = 948;
                break;
            }
            case 101: {
                n2 = 949;
                break;
            }
            case 102: {
                n2 = 981;
                break;
            }
            case 103: {
                n2 = 947;
                break;
            }
            case 104: {
                n2 = 951;
                break;
            }
            case 105: {
                n2 = 953;
                break;
            }
            case 106: {
                n2 = 981;
                break;
            }
            case 107: {
                n2 = 954;
                break;
            }
            case 108: {
                n2 = 955;
                break;
            }
            case 109: {
                n2 = 956;
                break;
            }
            case 110: {
                n2 = 957;
                break;
            }
            case 111: {
                n2 = 959;
                break;
            }
            case 112: {
                n2 = 960;
                break;
            }
            case 113: {
                n2 = 952;
                break;
            }
            case 114: {
                n2 = 961;
                break;
            }
            case 115: {
                n2 = 963;
                break;
            }
            case 116: {
                n2 = 964;
                break;
            }
            case 117: {
                n2 = 965;
                break;
            }
            case 118: {
                n2 = 982;
                break;
            }
            case 119: {
                n2 = 969;
                break;
            }
            case 120: {
                n2 = 958;
                break;
            }
            case 121: {
                n2 = 968;
                break;
            }
            case 122: {
                n2 = 950;
                break;
            }
            case 161: {
                n2 = 978;
                break;
            }
            case 162: {
                n2 = 697;
                break;
            }
            case 163: {
                n2 = 8804;
                break;
            }
            case 165: {
                n2 = 8734;
                break;
            }
            case 167: {
                n2 = 9827;
                break;
            }
            case 168: {
                n2 = 9830;
                break;
            }
            case 169: {
                n2 = 9829;
                break;
            }
            case 170: {
                n2 = 9824;
                break;
            }
            case 171: {
                n2 = 8596;
                break;
            }
            case 172: {
                n2 = 8592;
                break;
            }
            case 173: {
                n2 = 8593;
                break;
            }
            case 174: {
                n2 = 8594;
                break;
            }
            case 175: {
                n2 = 8595;
                break;
            }
            case 178: {
                n2 = 698;
                break;
            }
            case 179: {
                n2 = 8805;
                break;
            }
            case 180: {
                n2 = 215;
                break;
            }
            case 181: {
                n2 = 8733;
                break;
            }
            case 182: {
                n2 = 8706;
                break;
            }
            case 184: {
                n2 = 247;
                break;
            }
            case 185: {
                n2 = 8800;
                break;
            }
            case 186: {
                n2 = 8801;
                break;
            }
            case 187: {
                n2 = 8776;
                break;
            }
            case 188: {
                n2 = 8943;
                break;
            }
            case 189: {
                n2 = 124;
                break;
            }
            case 191: {
                n2 = 8629;
                break;
            }
            case 192: {
                n2 = 8501;
                break;
            }
            case 193: {
                n2 = 8465;
                break;
            }
            case 194: {
                n2 = 8475;
                break;
            }
            case 195: {
                n2 = 8472;
                break;
            }
            case 196: {
                n2 = 8855;
                break;
            }
            case 197: {
                n2 = 8853;
                break;
            }
            case 198: {
                n2 = 216;
                break;
            }
            case 199: {
                n2 = 8898;
                break;
            }
            case 200: {
                n2 = 8899;
                break;
            }
            case 201: {
                n2 = 8835;
                break;
            }
            case 202: {
                n2 = 8839;
                break;
            }
            case 203: {
                n2 = 8836;
                break;
            }
            case 204: {
                n2 = 8834;
                break;
            }
            case 205: {
                n2 = 8838;
                break;
            }
            case 206: {
                n2 = 8712;
                break;
            }
            case 207: {
                n2 = 8713;
                break;
            }
            case 208: {
                n2 = 8736;
                break;
            }
            case 209: {
                n2 = 8711;
                break;
            }
            case 210: {
                n2 = 174;
                break;
            }
            case 211: {
                n2 = 169;
                break;
            }
            case 212: {
                n2 = 8482;
                break;
            }
            case 213: {
                n2 = 8719;
                break;
            }
            case 214: {
                n2 = 8730;
                break;
            }
            case 215: {
                n2 = 183;
                break;
            }
            case 217: {
                n2 = 8896;
                break;
            }
            case 218: {
                n2 = 8897;
                break;
            }
            case 219: {
                n2 = 8660;
                break;
            }
            case 220: {
                n2 = 8656;
                break;
            }
            case 221: {
                n2 = 8657;
                break;
            }
            case 222: {
                n2 = 8658;
                break;
            }
            case 223: {
                n2 = 8659;
                break;
            }
            case 224: {
                n2 = 8900;
                break;
            }
            case 225: {
                n2 = 8901;
                break;
            }
            case 226: {
                n2 = 174;
                break;
            }
            case 227: {
                n2 = 169;
                break;
            }
            case 228: {
                n2 = 8482;
                break;
            }
            case 229: {
                n2 = 8721;
                break;
            }
            case 230: {
                n2 = 9127;
                break;
            }
            case 232: {
                n2 = 9129;
                break;
            }
            case 233: {
                n2 = 9121;
                break;
            }
            case 234: {
                n2 = 9125;
                break;
            }
            case 235: {
                n2 = 9123;
                break;
            }
            case 236: {
                n2 = 9127;
                break;
            }
            case 237: {
                n2 = 9128;
                break;
            }
            case 238: {
                n2 = 9129;
                break;
            }
            case 239: {
                n2 = 9130;
                break;
            }
            case 242: {
                n2 = 9136;
                break;
            }
            case 248: {
                n2 = 9120;
                break;
            }
            case 251: {
                n2 = 9126;
                break;
            }
            case 252: {
                n2 = 9131;
                break;
            }
            case 253: {
                n2 = 9132;
            }
        }
        return (char)n2;
    }

    private static char deriveUnicodeFromMarlett(char c) {
        if (PlatformInfo.isWindows() && c <= '\u0fff') {
            return (char)(c + 61440);
        }
        return c;
    }

    private static boolean translationToMarlettRequired(Font font) {
        return PlatformInfo.isWindows() && font.getName().equalsIgnoreCase("marlett");
    }

    private static boolean translationToSymbolRequired(Font font) {
        return font.getName().equalsIgnoreCase("symbol");
    }

    public static String[] deriveUnicodeFromFont(String[] stringArray, Font font) {
        if (!UnicodeTextTranslator.translationToSymbolRequired(font) && !UnicodeTextTranslator.translationToMarlettRequired(font)) {
            return stringArray;
        }
        String[] stringArray2 = UnicodeTextTranslator.translationToSymbolRequired(font) ? UnicodeTextTranslator.deriveUnicodeFromSymbol(stringArray) : UnicodeTextTranslator.deriveUnicodeFromMarlett(stringArray);
        return stringArray2;
    }

    public static Font deriveFont(Font font) {
        if (!UnicodeTextTranslator.translationToSymbolRequired(font)) {
            return font;
        }
        return new Font("serif", font.getStyle(), font.getSize());
    }
}

