/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQStaticContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xqj.SaxonXQItemType;

public class SaxonXQStaticContext
implements XQStaticContext {
    private int bindingMode = 0;
    private int holdability = 1;
    private int scrollability = 1;
    private StaticQueryContext sqc;

    public SaxonXQStaticContext(Configuration config) {
        this.sqc = new StaticQueryContext(config);
    }

    protected StaticQueryContext getSaxonStaticQueryContext() {
        return this.sqc;
    }

    public void declareNamespace(String prefix, String uri) throws XQException {
        this.sqc.declareNamespace(prefix, uri);
    }

    public String getBaseURI() {
        return this.sqc.getBaseURI();
    }

    public int getBindingMode() {
        return this.bindingMode;
    }

    public int getBoundarySpacePolicy() {
        return 2;
    }

    public int getConstructionMode() {
        return 2;
    }

    public XQItemType getContextItemStaticType() {
        ItemType type = this.sqc.getRequiredContextItemType();
        return new SaxonXQItemType(type, this.sqc.getConfiguration());
    }

    public int getCopyNamespacesModeInherit() {
        return 1;
    }

    public int getCopyNamespacesModePreserve() {
        return 1;
    }

    public String getDefaultCollation() {
        return this.sqc.getDefaultCollationName();
    }

    public String getDefaultElementTypeNamespace() {
        return this.sqc.getDefaultElementNamespace();
    }

    public String getDefaultFunctionNamespace() {
        return this.sqc.getDefaultFunctionNamespace();
    }

    public int getDefaultOrderForEmptySequences() {
        return this.sqc.isEmptyLeast() ? 2 : 1;
    }

    public String[] getNamespacePrefixes() {
        Iterator iter = this.sqc.iterateDeclaredPrefixes();
        ArrayList list = new ArrayList(20);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    public String getNamespaceURI(String prefix) throws XQException {
        if (prefix == null) {
            throw new XQException("prefix is null");
        }
        return this.sqc.getNamespaceForPrefix(prefix);
    }

    public int getOrderingMode() {
        return 1;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public int getQueryLanguageTypeAndVersion() {
        return 1;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public int getScrollability() {
        return this.scrollability;
    }

    public void setBaseURI(String baseUri) {
        this.sqc.setBaseURI(baseUri);
    }

    public void setBindingMode(int bindingMode) {
        this.bindingMode = bindingMode;
    }

    public void setBoundarySpacePolicy(int policy) throws XQException {
        switch (policy) {
            case 1: {
                this.sqc.setPreserveBoundarySpace(true);
            }
            case 2: {
                this.sqc.setPreserveBoundarySpace(false);
            }
        }
        throw new XQException("Invalid value for boundary space policy - " + policy);
    }

    public void setConstructionMode(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.sqc.setConstructionMode(3);
            }
            case 2: {
                this.sqc.setConstructionMode(4);
            }
        }
        throw new XQException("Invalid value for construction mode - " + mode);
    }

    public void setContextItemStaticType(XQItemType contextItemType) {
        this.sqc.setRequiredContextItemType(((SaxonXQItemType)contextItemType).getSaxonItemType());
    }

    public void setCopyNamespacesModeInherit(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.sqc.setInheritNamespaces(true);
            }
            case 2: {
                this.sqc.setInheritNamespaces(false);
            }
        }
        throw new XQException("Invalid value for namespaces inherit mode - " + mode);
    }

    public void setCopyNamespacesModePreserve(int mode) throws XQException {
        switch (mode) {
            case 1: {
                this.sqc.setPreserveNamespaces(true);
            }
            case 2: {
                this.sqc.setPreserveNamespaces(false);
            }
        }
        throw new XQException("Invalid value for namespaces preserve mode - " + mode);
    }

    public void setDefaultCollation(String uri) {
        this.sqc.declareDefaultCollation(uri);
    }

    public void setDefaultElementTypeNamespace(String uri) throws XQException {
        try {
            this.sqc.setDefaultElementNamespace(uri);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.sqc.setDefaultFunctionNamespace(uri);
    }

    public void setDefaultOrderForEmptySequences(int order) throws XQException {
        switch (order) {
            case 1: {
                this.sqc.setEmptyLeast(false);
            }
            case 2: {
                this.sqc.setEmptyLeast(true);
            }
        }
        throw new XQException("Invalid value for default order for empty sequences - " + order);
    }

    public void setOrderingMode(int mode) {
    }

    public void setQueryTimeout(int seconds) {
    }

    public void setHoldability(int holdability) throws XQException {
        switch (holdability) {
            case 1: 
            case 2: {
                this.holdability = holdability;
            }
        }
        throw new XQException("Invalid holdability value - " + holdability);
    }

    public void setQueryLanguageTypeAndVersion(int langtype) throws XQException {
        if (langtype != 1) {
            throw new XQException("XQueryX is not supported");
        }
    }

    public void setScrollability(int scrollability) throws XQException {
        switch (scrollability) {
            case 1: 
            case 2: {
                this.scrollability = scrollability;
            }
        }
        throw new XQException("Invalid scrollability value - " + scrollability);
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

