/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.intel.bluetooth.BlueCoveImpl;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.PlatformInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class BluetoothDiscovery
implements DiscoveryListener {
    private static Object lock = new Object();
    private static Vector<RemoteDevice> devices = new Vector();
    private static String connectionURL = null;
    private static DiscoveryAgent agent;
    private static PrintStream sysPrintStream;
    private static final String SPP = "1101";
    protected static final ResourceBundle sResources;
    protected static final ResourceBundle sInstrumentResources;

    private static void silencePrintStream() {
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void write(byte[] byArray) {
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
            }

            @Override
            public void write(int n) {
            }
        }));
    }

    private static void revivePrintStream() {
        System.setOut(sysPrintStream);
    }

    public BluetoothDiscovery() throws TMException, BluetoothStateException {
        if (agent == null) {
            BluetoothDiscovery.silencePrintStream();
            agent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            BluetoothDiscovery.revivePrintStream();
        }
    }

    public static Vector<RemoteDevice> getRemoteDevices(boolean bl) {
        if (!devices.isEmpty() && bl) {
            return devices;
        }
        BluetoothDiscovery bluetoothDiscovery = null;
        try {
            bluetoothDiscovery = new BluetoothDiscovery();
        }
        catch (TMException tMException) {
            return null;
        }
        catch (BluetoothStateException bluetoothStateException) {
            return null;
        }
        return bluetoothDiscovery.discoverDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getRemoteDevicesAndServices() {
        BluetoothDiscovery bluetoothDiscovery;
        if (PlatformInfo.isLinux()) {
            return null;
        }
        try {
            bluetoothDiscovery = new BluetoothDiscovery();
        }
        catch (TMException tMException) {
            return null;
        }
        catch (BluetoothStateException bluetoothStateException) {
            return null;
        }
        devices = bluetoothDiscovery.discoverDevices();
        if (devices == null) {
            return null;
        }
        int n = devices.size();
        if (n <= 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            Object object;
            RemoteDevice remoteDevice = devices.elementAt(i);
            UUID[] uUIDArray = new UUID[]{new UUID(SPP, true)};
            String string = null;
            String string2 = null;
            try {
                string = remoteDevice.getFriendlyName(true);
                string2 = remoteDevice.getBluetoothAddress();
            }
            catch (IOException iOException) {
                return null;
            }
            try {
                agent.searchServices(null, uUIDArray, remoteDevice, (DiscoveryListener)bluetoothDiscovery);
            }
            catch (BluetoothStateException bluetoothStateException) {
                return null;
            }
            try {
                object = lock;
                synchronized (object) {
                    lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            object = string.length() == 0 ? string2 : string;
            if (connectionURL == null) {
                vector.add((String)object + " [check device, rescan]");
            } else {
                String string3 = connectionURL.split(":")[2].split(";")[0];
                vector.add((String)object + " [Channel: " + string3 + "]");
            }
            vector.add("btspp://" + string2);
        }
        String[] stringArray = new String[vector.size()];
        stringArray = vector.toArray(stringArray);
        return stringArray;
    }

    public static Object[] hardwareInfo() throws TMException {
        if (PlatformInfo.isLinux()) {
            Instrument.displayError(sInstrumentResources.getString("Instrument.noBluetoothSupportInLinux"));
        }
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            Instrument.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        Object[] objectArray = new Object[4];
        objectArray[2] = "BlueCove-" + BlueCoveImpl.version;
        objectArray[3] = Instrument.jarVersion();
        BluetoothDiscovery bluetoothDiscovery = null;
        try {
            bluetoothDiscovery = new BluetoothDiscovery();
        }
        catch (BluetoothStateException bluetoothStateException) {
            return objectArray;
        }
        devices = bluetoothDiscovery.discoverDevices();
        if (devices == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < devices.size(); ++i) {
            vector.addElement("btspp://" + devices.elementAt(i).getBluetoothAddress());
            try {
                vector2.addElement(devices.elementAt(i).getFriendlyName(false));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        objectArray[1] = TMStringUtil.vector2StringArray(vector);
        objectArray[0] = TMStringUtil.vector2StringArray(vector2);
        return objectArray;
    }

    public static Object[] hardwareInfo(String string) throws TMException {
        if (PlatformInfo.isLinux()) {
            Instrument.displayError(sInstrumentResources.getString("Instrument.noBluetoothSupportInLinux"));
        }
        if (!Instrument.IS_TOOLBOX_INSTALLED) {
            Instrument.displayError("Undefined function or variable 'instrhwinfo'.");
        }
        Object[] objectArray = new Object[]{null, null, null, null};
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        if (string.equalsIgnoreCase("test") || string.equalsIgnoreCase("Emulator")) {
            objectArray[0] = string;
            objectArray[1] = "btspp://00000000000";
            stringArray[0] = "Bluetooth('Emulator', 0);";
            stringArray2[0] = "0";
            objectArray[2] = stringArray;
            objectArray[3] = stringArray2;
            return objectArray;
        }
        BluetoothDiscovery bluetoothDiscovery = null;
        try {
            bluetoothDiscovery = new BluetoothDiscovery();
        }
        catch (BluetoothStateException bluetoothStateException) {
            return objectArray;
        }
        RemoteDevice remoteDevice = bluetoothDiscovery.discoverServices(string);
        String string2 = null;
        if (remoteDevice == null) {
            return objectArray;
        }
        try {
            string2 = remoteDevice.getFriendlyName(false);
            objectArray[0] = string2;
        }
        catch (IOException iOException) {
            objectArray[0] = "";
        }
        objectArray[1] = "btspp://" + remoteDevice.getBluetoothAddress();
        if (connectionURL == null) {
            objectArray[2] = null;
            objectArray[3] = null;
            return objectArray;
        }
        stringArray2[0] = connectionURL.split(":")[2].split(";")[0];
        stringArray[0] = string.equalsIgnoreCase(string2) ? "Bluetooth('" + string2 + "', " + stringArray2[0] + ");" : (string.indexOf("btspp://") >= 0 ? "Bluetooth('" + string + "', " + stringArray2[0] + ");" : "Bluetooth('btspp://" + string + "', " + stringArray2[0] + ");");
        objectArray[2] = stringArray;
        objectArray[3] = stringArray2;
        return objectArray;
    }

    private RemoteDevice searchDevice(String string) {
        for (int i = 0; i < devices.size(); ++i) {
            RemoteDevice remoteDevice = devices.elementAt(i);
            try {
                if (!remoteDevice.getFriendlyName(false).equalsIgnoreCase(string) && !remoteDevice.getBluetoothAddress().equalsIgnoreCase(string) && !string.equalsIgnoreCase("btspp://" + remoteDevice.getBluetoothAddress())) continue;
                return remoteDevice;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteDevice discoverServices(String string) {
        devices = this.discoverDevices();
        RemoteDevice remoteDevice = this.searchDevice(string);
        if (remoteDevice == null) {
            return null;
        }
        try {
            remoteDevice.getFriendlyName(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UUID[] uUIDArray = new UUID[]{new UUID(SPP, true)};
        try {
            agent.searchServices(null, uUIDArray, remoteDevice, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bluetoothStateException) {
            // empty catch block
        }
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (connectionURL == null) {
            return null;
        }
        return remoteDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<RemoteDevice> discoverDevices() {
        try {
            agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (Exception exception) {
            return null;
        }
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (devices.size() == 0) {
            return null;
        }
        return devices;
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (!devices.contains(remoteDevice)) {
            devices.addElement(remoteDevice);
        }
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (serviceRecordArray != null && serviceRecordArray.length > 0) {
            connectionURL = serviceRecordArray[0].getConnectionURL(0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int n, int n2) {
        Object object = lock;
        synchronized (object) {
            if (n2 != 1) {
                connectionURL = null;
            }
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int n) {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    static {
        sysPrintStream = System.out;
        sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");
        sInstrumentResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.resources.RES_INSTRUMENT");
        System.setProperty("bluecove.debug", "false");
        System.setProperty("bluecove.debug.log4j", "false");
    }
}

