/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.VisaGeneral;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;

public class GenericVisa
extends VisaGeneral {
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "eosCharCode", "whileOpen", 0, 0), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "read&write", "never", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("Type", "string", "none", "", "visa-generic", "always", 0, 0)};

    public GenericVisa() {
        this.deleteInstrumentObject(this);
    }

    public GenericVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            GenericVisa.displayError("Undefined function or variable 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.rsrcName = this.visaName;
            this.info[0] = string + FILESEP + string2;
            this.info[1] = GenericVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-GENERIC-" + this.visaName;
            this.type = "visa-generic";
            this.displayName = "VISA-GENERIC";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.objectPolls = this.visa.VerifyAsyncVISARead();
            this.setEOSMode(3);
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    @Override
    public void parseName(String string) {
        this.rsrcName = this.visaName;
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-GENERIC-" + this.visaName);
    }

    @Override
    public void updateNameProperties() {
        this.rsrcName = this.visaName;
        if (this.nameStandardFormat) {
            this.setName("VISA-GENERIC-" + this.visaName);
        }
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            GenericVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"resource:", this.visaName};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.visaName;
    }

    @Override
    public boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof GenericVisa)) continue;
            GenericVisa genericVisa = (GenericVisa)e;
            if (!genericVisa.rsrcName.equals(this.rsrcName) || genericVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        super.updatePropsOnOpen();
    }

    @Override
    protected void setHardwareEOIMode(boolean bl) throws TMException {
        block2: {
            try {
                this.visa.setProperty(this.handle, 100, this.bool2int(bl));
            }
            catch (Exception exception) {
                if (!this.eoiMode) break block2;
                this.setEOIMode(false);
            }
        }
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        block2: {
            try {
                this.visa.setHardwareTimeout(this.handle, d, 104);
            }
            catch (Exception exception) {
                if (this.timeout == 0.0) break block2;
                this.setTimeout(0.0);
            }
        }
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (string.equals("Alias")) {
                iCPropArray[i].setDefaultValue(this.alias);
                continue;
            }
            if (!string.equals("Name")) continue;
            iCPropArray[i].setDefaultValue("VISA-GENERIC-" + this.visaName);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   VISA-Generic Object Using " + this.info[2] + " Adaptor : " + this.visaName + LINESEP + LINESEP + "   Communication Address " + LINESEP + "      Resource Address:   " + this.visaName + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-Generic specific properties:" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ none | read | write | {read&write} ]" + LINESEP + "    LANName" + LINESEP + "    RemoteHost" + LINESEP + " " + LINESEP;
    }
}

