/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.I2CAARDVARK;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentPrimativeReader;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.util.DefaultSyncICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;
import java.math.BigDecimal;
import java.util.Vector;

public abstract class I2C
extends InstrumentPrimativeReader {
    private static final int SUCCESS = 0;
    protected Object[] fConstructorArgs = new Object[3];
    protected int fRemoteAddress = 0;
    protected int fId = 0;
    protected int fBoardIndex = 0;
    protected int fBitRate = 100;
    protected double fBoardSerial = 0.0;
    protected int fPullupResistors = 1;
    protected int fTargetPower = 1;
    protected String fVendor;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    private static final String[] I2C_ADAPTORS = AdaptorInfo.I2C_ADAPTORS;
    private static final String[] I2C_NAME = AdaptorInfo.I2C_VENDORS;
    protected static final Object[] BOARDINDEXVALUES = new Object[]{new Double(0.0), new Double(8.0)};
    protected static final Object[] BOARDSERIALVALUES = new Object[]{new Double(0.0), new Double(2.147483647E9)};
    protected static final Object[] REMOTEADDRESSES = new Object[]{new Double(0.0), new Double(7.0)};
    protected static final Object[] BITRATES = new Object[]{new Double(0.0), new Double(Double.MAX_VALUE)};
    protected static final Object[] PULLUP_VALS = new Object[]{"none", "both"};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Type", "string", "none", "", "i2c", "always", 0, 0), new ICProp("BitRate", "double", "bounded", BITRATES, new Integer(100), "never", 1, 0), new ICProp("BoardIndex", "double", "none", BOARDINDEXVALUES, new Integer(0), "always", 1, 0), new ICProp("BoardSerial", "double", "bounded", BOARDSERIALVALUES, new Integer(0), "always", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("fPullupResistors", "string", "enum", PULLUP_VALS, "both", "never", 1, 0), new ICProp("RemoteAddress", "double", "bounded", REMOTEADDRESSES, new Integer(0), "never", 1, 0), new ICProp("fTargetPower", "string", "enum", PULLUP_VALS, "both", "never", 1, 0), new ICProp("Vendor", "string", "none", "", "", "always", 1, 0)};

    public I2C() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            I2C.displayError("Undefined function or variable 'i2c'.");
        }
        this.objectProps = DefaultSyncICProp.addObjectProps(objectICProps);
    }

    I2C(String string, String string2, int n, int n2) {
        if (!string2.equalsIgnoreCase("Test")) {
            try {
                System.load(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fConstructorArgs[0] = string2;
            this.fConstructorArgs[1] = new Integer(n);
            this.fConstructorArgs[2] = new Integer(n2);
        }
        this.fBoardIndex = n;
        this.fRemoteAddress = n2;
        this.fVendor = string2;
        this.type = "i2c";
        this.displayName = "I2C connection";
        this.objectProps = DefaultSyncICProp.addObjectProps(objectICProps);
        this.name = "I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h";
        try {
            this.openHardware();
            this.fBoardSerial = this.nativeGetBoardSerial(this.fId);
            this.fPullupResistors = this.nativeGetPullupResistors(this.fId);
            this.fTargetPower = this.nativeGetTargetPower(this.fId);
            this.closeHardware();
        }
        catch (Exception exception) {
            this.fBoardSerial = 0.0;
            this.fPullupResistors = 0;
            this.fTargetPower = 0;
        }
    }

    @Override
    public String getConstructor() {
        return new String("i2c('" + this.fVendor + "', " + this.fBoardIndex + ", " + this.fRemoteAddress + ");");
    }

    @Override
    public void dispose() throws TMException {
        super.dispose();
    }

    @Override
    protected void addToPoller() {
        Poller.addInstrument(this);
        if (this.timerFcn == ACTION) {
            return;
        }
        if (!this.wasTimerStarted) {
            this.createTimer();
        } else {
            this.timer.setDelay((int)(this.timerPeriod * 1000.0));
            this.timer.reset();
        }
    }

    @Override
    public void openHardware() throws Exception {
        this.fId = this.nativeOpen(this.fBoardIndex);
        if (this.fId < 0) {
            this.fId = 0;
            I2C.displayError(sInstrumentResources.getString("Instrument.general.openfailed"));
        }
    }

    @Override
    protected void updatePropsOnOpen() throws Exception {
        this.setBitRate(this.fBitRate);
        try {
            this.setTargetPower(this.fTargetPower);
        }
        catch (Exception exception) {
            this.fTargetPower = 0;
        }
        try {
            this.setPullupResistors(this.fPullupResistors);
        }
        catch (Exception exception) {
            this.fPullupResistors = 0;
        }
    }

    @Override
    public void closeHardware() throws Exception {
        this.nativeClose(this.fId);
    }

    public final Object[] hexread(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[3];
        if (this.status != 1) {
            I2C.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (DATASIZE[n2] * n > this.inputBufferSize) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.readtoomuch"));
        }
        try {
            Object[] objectArray2 = this.nativeReadImpl(this.fId, this.fRemoteAddress, n);
            int n4 = (Integer)objectArray2[1];
            if (n4 > 0) {
                this.valuesReceived += (long)n4;
                this.writeRawDataToFile(objectArray2[0], n4, n2, "<", "", n3);
                objectArray[0] = this.convertBinaryData((byte[])objectArray2[0], n2, n);
                objectArray[1] = new Integer(n / DATASIZE[n2]);
                objectArray[2] = null;
                return objectArray;
            }
            I2C.displayError(sInstrumentResources.getString("Instrument.general.openfailed"));
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
        }
        return objectArray;
    }

    public final void fwrite(Object object, int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray;
        Object object2;
        this.verifyObjectState();
        if (n == 0) {
            return;
        }
        if (DATASIZE[n2] * n > this.outputBufferSize - this.bytesToOutput) {
            throw new TMException("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (object instanceof Long[]) {
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = ((Long[])object)[i].intValue();
            }
            objectArray = this.writeBinary(object2, n, n2, n3);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object2, n, n2, ">", "", n4);
        } else {
            objectArray = this.writeBinarySync(object, n, n2);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object, n, n2, ">", "", n4);
        }
        object2 = (String)objectArray[1];
        if (!((String)object2).equals("")) {
            throw new TMException((String)object2);
        }
        objectArray = null;
    }

    protected Object[] writeBinarySync(Object object, int n, int n2) throws Exception {
        int n3 = this.writeBinaryToHardware(object, n, n2);
        Object[] objectArray = new Object[2];
        if (n3 < this.getSuccessValue()) {
            objectArray[0] = INTEGER_ZERO;
            objectArray[1] = this.getErrorMessageFromHardware(n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    protected Object[] writeBinary(Object object, int n, int n2, int n3) throws Exception {
        this.writeTransferMode = n3;
        switch (n3) {
            case 0: {
                return this.writeBinarySync(object, n, n2);
            }
        }
        throw new TMException("Invalid TransferMode specified.");
    }

    public static ICProp[] getProperties() {
        return DefaultSyncICProp.addObjectProps(objectICProps);
    }

    protected int writeBinaryToHardware(Object object, int n, int n2) throws Exception {
        byte[] byArray = BinarySwapBytes.getBinaryDataToWrite(object, n2, this.byteOrder);
        int n3 = this.nativeWriteImpl(this.fId, this.fRemoteAddress, byArray, byArray.length);
        return n3;
    }

    public String getVendor() {
        return this.fVendor;
    }

    public void setVendor(String string) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("Vendor"));
    }

    public int getBoardIndex() throws TMException {
        return this.fBoardIndex;
    }

    public void setBoardIndex(int n) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("BoardIndex"));
    }

    public void setBitRate(int n) {
        this.fBitRate = this.status == 1 ? this.nativeSetBitRate(this.fId, n) : n;
    }

    public int getBitRate() {
        return this.fBitRate;
    }

    public int getTargetPower() {
        if (this.status == 1) {
            return this.nativeGetTargetPower(this.fId);
        }
        return this.fTargetPower;
    }

    public void setTargetPower(int n) throws TMException {
        if (this.status == 1 && this.nativeSetTargetPower(this.fId, n) < 0) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.operationfailed"));
        } else {
            this.fTargetPower = n;
        }
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    public int getPullupResistors() {
        if (this.status == 1) {
            return this.nativeGetPullupResistors(this.fId);
        }
        return this.fPullupResistors;
    }

    public void setPullupResistors(int n) throws TMException {
        if (this.status == 1 && this.nativeSetPullupResistors(this.fId, n) < 0) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.operationfailed"));
        } else {
            this.fPullupResistors = n;
        }
    }

    public void setBoardSerial(double d) throws TMException {
        I2C.displayError(this.createReadOnlyPropertyError("BoardSerial"));
    }

    public double getBoardSerial() {
        if (this.status == 1) {
            Double d = this.nativeGetBoardSerial(this.fId);
            return d;
        }
        return this.fBoardSerial;
    }

    public String getRemoteDisplayAddress() {
        return Integer.toHexString(this.fRemoteAddress) + "h";
    }

    public int getRemoteAddress() {
        return this.fRemoteAddress;
    }

    public void setRemoteAddress(String string) {
        this.fRemoteAddress = Integer.parseInt(string);
        this.setName("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
    }

    public void setRemoteAddress(int n) {
        this.fRemoteAddress = n;
        this.setName("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
    }

    @Override
    public void setHardwareTimeout(double d) {
        this.timeout = (double)this.nativeSetHardwareTimeout(this.fBoardIndex, (int)d * 1000) / 1000.0;
    }

    @Override
    public double getHardwareTimeout() {
        int n = this.nativeGetHardwareTimeout(this.fId);
        if (n > 0) {
            return n;
        }
        return 0.0;
    }

    public Object[] hardwareInfo(String string, String string2, String string3) throws TMException {
        int n;
        if (!string2.equalsIgnoreCase(AdaptorInfo.I2C_VENDORS[0])) {
            I2C.displayError(sInstrumentResources.getString("Instrument.general.missingadaptor"));
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = string;
        objectArray[1] = I2C.jarVersion();
        objectArray[2] = string2;
        objectArray[5] = this.HwInfo(3);
        objectArray[6] = this.HwInfo(4);
        int[] nArray = this.nativeFindBoards();
        if (nArray == null) {
            return objectArray;
        }
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 32768) continue;
            ++n2;
        }
        if (n2 == 0) {
            return objectArray;
        }
        n = 0;
        int[] nArray2 = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 32768) continue;
            nArray2[n++] = nArray[i];
        }
        objectArray[3] = nArray2;
        objectArray[4] = "i2c('" + string2 + "', boardIndex, RemoteAddress);";
        return objectArray;
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector vector = new Vector();
        this.addPVPair(vector, "ByteOrder", BYTE_ORDER[this.byteOrder]);
        this.addPVPair(vector, "InputBufferSize", this.inputBufferSize);
        this.addPVPair(vector, "ObjectVisibility", this.bool2OnOff(this.objectVisibility));
        this.addPVPair(vector, "OutputBufferSize", this.outputBufferSize);
        this.addPVPair(vector, "RecordDetail", RECORD_DETAIL[this.recordDetail]);
        this.addPVPair(vector, "RecordMode", RECORD_MODE[this.recordMode]);
        this.addPVPair(vector, "RecordName", this.recordName);
        this.addPVPair(vector, "TargetPower", PULLUP_VALS[this.fTargetPower]);
        this.addPVPair(vector, "Tag", this.tag);
        this.addPVPair(vector, "Timeout", this.timeout);
        this.addPVPair(vector, "TimerPeriod", this.timerPeriod);
        return null;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("I2C-" + this.fBoardIndex + "-" + Integer.toHexString(this.fRemoteAddress) + "h");
                continue;
            }
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(this.fBoardIndex);
                continue;
            }
            if (string.equals("BoardSerial")) {
                iCPropArray[i].setDefaultValue(this.fBoardSerial);
                continue;
            }
            if (string.equals("RemoteAddress")) {
                iCPropArray[i].setDefaultValue(this.fRemoteAddress);
                continue;
            }
            if (string.equals("PullupResistors")) {
                iCPropArray[i].setDefaultValue(this.fPullupResistors);
                continue;
            }
            if (string.equals("TargetPower")) {
                iCPropArray[i].setDefaultValue(this.fTargetPower);
                continue;
            }
            if (!string.equals("Vendor")) continue;
            iCPropArray[i].setDefaultValue(this.fVendor);
        }
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   I2C Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      BoardIndex          " + this.fBoardIndex + LINESEP + "      BoardSerial         " + new BigDecimal(this.fBoardSerial).toPlainString() + LINESEP + "      BitRate:            " + this.fBitRate + LINESEP + "      RemoteAddress:      " + Integer.toHexString(this.fRemoteAddress) + 'h' + LINESEP + "      Vendor:             " + this.fVendor + LINESEP + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + LINESEP;
    }

    @Override
    public String setDisplay() {
        return "    ByteOrder: [ {littleEndian} | bigEndian ] " + LINESEP + "    InputBufferSize" + LINESEP + "    Name" + LINESEP + "    ObjectVisibility: [ {on} | off ] " + LINESEP + "    OutputBufferSize" + LINESEP + "    RecordDetail: [ {compact} | verbose ]" + LINESEP + "    RecordMode: [ {overwrite} | append | index ]" + LINESEP + "    RecordName" + LINESEP + "    Tag" + LINESEP + "    Timeout" + LINESEP + "    TimerFcn: string -or- function handle -or- cell array" + LINESEP + "    TimerPeriod" + LINESEP + "    UserData" + LINESEP + "    " + LINESEP + "    I2C specific properties:" + LINESEP + "    BitRate" + LINESEP + "    BoardIndex" + LINESEP + "    BoardSerial" + LINESEP + "    PullupResistors [ {both} | none ]" + LINESEP + "    RemoteAddress" + LINESEP + "    TargetPower [ {both} | none ]" + LINESEP + "    Vendor" + LINESEP + "       " + LINESEP;
    }

    public static String[] findValidAdaptors(String string) throws Exception {
        String[] stringArray = new String[1];
        int n = 0;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        String string2 = Instrument.extension();
        try {
            new I2CAARDVARK(string + Instrument.FILESEP + I2C_ADAPTORS[0] + string2, "aardvark", 0, 0);
            stringArray[n] = I2C_NAME[0];
            ++n;
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return this.nativeGetErrorMessageFromHardware(n);
    }

    @Override
    protected void disposeMLArrayRefs() {
    }

    protected abstract String HwInfo(int var1);

    protected abstract int nativeOpen(int var1);

    protected abstract int nativeClose(int var1);

    protected abstract Object[] nativeReadImpl(int var1, int var2, int var3) throws TMException;

    protected abstract int nativeWriteImpl(int var1, int var2, byte[] var3, int var4) throws TMException;

    protected abstract Object[] nativeQueryImpl(int var1, int var2, byte[] var3, int var4, int var5);

    protected abstract int[] nativeFindBoards();

    protected abstract double nativeGetBoardSerial(int var1);

    protected abstract int nativeGetBitRate();

    protected abstract int nativeSetBitRate(int var1, int var2);

    protected abstract int nativeGetPullupResistors(int var1);

    protected abstract int nativeSetPullupResistors(int var1, int var2);

    protected abstract int nativeGetTargetPower(int var1);

    protected abstract int nativeSetTargetPower(int var1, int var2);

    protected abstract int nativeSetHardwareTimeout(int var1, int var2);

    protected abstract int nativeGetHardwareTimeout(int var1);

    protected abstract String nativeGetErrorMessageFromHardware(int var1);
}

