/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InputBuffer;
import com.mathworks.toolbox.instrument.InstrumentAsyncContinuous;
import com.mathworks.toolbox.instrument.InstrumentWriter;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.testmeas.util.TMException;

public abstract class InstrumentReader
extends InstrumentWriter {
    protected static final int ASCII = 0;
    protected static final int BINARY = 1;
    private static Integer SIZE = new Integer(0);
    protected InputBuffer inputBuffer = null;
    protected int readAsyncCount = 0;
    protected long readAsyncStartTime = InstrumentReader.nanoBadTime();
    protected boolean performingRead = false;

    public InstrumentReader() {
        this.inputBuffer = new InputBuffer(this);
    }

    public final void setBytesAvailable(int n) throws TMException {
        InstrumentReader.displayError(this.createReadOnlyPropertyError("BytesAvailable"));
    }

    public final int getBytesAvailable() {
        return this.bytesAvailable;
    }

    public final void updateBytesAvailable(int n) {
        this.bytesAvailable = n;
    }

    @Override
    public final void setInputBufferSize(int n) throws TMException {
        if (this.status == 1) {
            InstrumentReader.displayError("InputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            InstrumentReader.displayError(sInstrumentResources.getString("Instrument.InputBuffer.InvalidSize"));
        }
        try {
            this.inputBuffer.setSize(n);
            this.bytesAvailable = 0;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.inputBuffer.setSize(this.inputBufferSize);
            InstrumentReader.displayError(sInstrumentResources.getString("Instrument.InputBuffer.OutOfMemory"));
            this.bytesAvailable = 0;
            return;
        }
        this.inputBufferSize = n;
    }

    @Override
    public final int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public final void setValuesReceived(int n) throws TMException {
        InstrumentReader.displayError(this.createReadOnlyPropertyError("ValuesReceived"));
    }

    public final long getValuesReceived() {
        return this.getWrappedValues(this.valuesReceived);
    }

    @Override
    public void flushinput() throws TMException {
        if (!this.isvalid()) {
            InstrumentReader.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.readAsyncCount < 0) {
            this.readAsyncCount = 0;
        }
        this.hardwareFlushInput();
        if (this.bytesAvailable > 0) {
            this.inputBuffer.flush();
            this.bytesAvailable = 0;
        }
    }

    public final Object[] fread(int n, int n2, int n3) throws TMException {
        Object[] objectArray;
        block5: {
            this.verifyObjectState();
            if (this.supportsAsynchronousOperations()) {
                Poller.wakeUpTimer();
            }
            if (this.readAsyncCount < 0) {
                this.readAsyncCount = 0;
            }
            if (DATASIZE[n2] * n > this.inputBufferSize) {
                InstrumentReader.displayError("SIZE * PRECISION must be less than or equal to InputBufferSize.");
            }
            objectArray = new Object[3];
            try {
                Object[] objectArray2 = this.readBinary(n, n2);
                Object object = objectArray2[0];
                int n4 = (Integer)objectArray2[1];
                this.valuesReceived += (long)n4;
                this.writeRawDataToFile(object, n4, n2, "<", "", n3);
                objectArray[0] = object;
                objectArray[1] = objectArray2[1];
                objectArray[2] = objectArray2[2];
                object = null;
                objectArray2 = null;
            }
            catch (Exception exception) {
                objectArray[0] = "";
                objectArray[1] = INTEGER_ZERO;
                objectArray[2] = exception.getMessage();
                if (exception.getMessage() != "Ctrl-C interrupted the read operation.") break block5;
                throw new TMException("Ctrl-C interrupted the read operation.");
            }
        }
        return this.addToBinaryOutput(objectArray);
    }

    public final Object[] binblockread(int n, int n2) throws TMException {
        this.verifyObjectState();
        this.updateObjectBinblockRead();
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
        int n3 = 0;
        Object[] objectArray = this.readData(1);
        String string = (String)objectArray[0];
        while (!string.equals("#")) {
            if (string.equals("")) {
                this.restoreObjectFromBinblockRead();
                return this.createBinBlockReadOutput("", "A binblock is not available to be read.");
            }
            objectArray = this.readData(1);
            string = (String)objectArray[0];
            ++n3;
        }
        ++n3;
        objectArray = this.readData(1);
        string = (String)objectArray[0];
        if (string.equals("")) {
            this.restoreObjectFromBinblockRead();
            return this.createBinBlockReadOutput("#", "A binblock is not available to be read.");
        }
        ++n3;
        int n4 = 0;
        try {
            n4 = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.restoreObjectFromBinblockRead();
            return this.createBinBlockReadOutput("#" + string, "A binblock is not available to be read.");
        }
        n3 += n4;
        if (n4 == 0) {
            this.restoreObjectFromBinblockRead();
            return this.createBinBlockReadOutput("#0", "A binblock is not available to be read.");
        }
        objectArray = this.readData(n4);
        string = (String)objectArray[0];
        if (string.equals("")) {
            this.restoreObjectFromBinblockRead();
            return this.createBinBlockReadOutput("#" + n4, "A binblock is not available to be read.");
        }
        int n5 = 1;
        try {
            n5 = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.restoreObjectFromBinblockRead();
            return this.createBinBlockReadOutput("#" + n4 + string, "A binblock is not available to be read.");
        }
        if (n5 > this.inputBufferSize) {
            InstrumentReader.displayError("The binblock contains " + n5 + " bytes and is greater than InputBufferSize." + LINESEP + "Use FREAD to read the data.");
        }
        Object[] objectArray2 = this.fread(n5 / DATASIZE[n], n, n2);
        int n6 = (Integer)objectArray2[1];
        int n7 = 0;
        if (n6 != n5 / DATASIZE[n]) {
            objectArray2[2] = "A timeout occurred before the binblock was read.";
        }
        objectArray2[1] = new Integer(n6 + n3 + n7);
        this.valuesReceived += (long)n3;
        this.restoreObjectFromBinblockRead();
        return objectArray2;
    }

    public final Object[] fscanf(int n) throws TMException {
        this.verifyObjectState();
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
        if (this.readAsyncCount < 0) {
            this.readAsyncCount = 0;
        }
        if (n > this.inputBufferSize) {
            throw new TMException("SIZE must be less than or equal to InputBufferSize.");
        }
        Object[] objectArray = new Object[3];
        this.performingRead = true;
        try {
            Object[] objectArray2 = this.readAscii(n);
            String string = (String)objectArray2[0];
            this.writeRawDataToFile(string, "<");
            this.valuesReceived += (long)string.length();
            objectArray[0] = string;
            objectArray[1] = new Integer(string.length());
            objectArray[2] = objectArray2[1];
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
            objectArray = this.addToASCIIOutput(objectArray);
        }
        this.performingRead = false;
        return this.addToASCIIOutput(objectArray);
    }

    public final Object[] fgets() throws TMException {
        return this.fscanf(0);
    }

    public final Object[] fgetl() throws TMException {
        Object[] objectArray = this.fgets();
        String string = (String)objectArray[2];
        if (string.equals("")) {
            objectArray[0] = this.removeTerminator((String)objectArray[0]);
            return objectArray;
        }
        return objectArray;
    }

    public final Object[] query(Object[] objectArray) throws Exception {
        this.verifyObjectState();
        this.fprintf(objectArray, 0);
        return this.fscanf(0);
    }

    public final Object[] query(String string) throws Exception {
        this.verifyObjectState();
        this.fprintf(string, 0);
        return this.fscanf(0);
    }

    @Override
    public void stopAsyncRead() {
        this.readAsyncCount = 0;
        this.readAsyncStartTime = InstrumentReader.nanoBadTime();
    }

    @Override
    public void disposeInputBuffer() {
        this.inputBuffer.dispose();
        this.inputBuffer = null;
    }

    public Object[] readAscii(int n) throws Exception {
        Object[] objectArray = null;
        String string = "";
        long l = InstrumentReader.currentNanoTicTime();
        int n2 = n;
        if (n == 0) {
            n2 = this.inputBufferSize;
        }
        if ((string = (String)(objectArray = this.getASCIIDataFromBuffer(n2))[0]).length() == n2 || this.okToTerminateASCIIRead((Integer)objectArray[1])) {
            return this.convertToASCIIOutput(objectArray, n, (Integer)objectArray[1]);
        }
        int n3 = n2 - string.length();
        double d = 0.0;
        while (!this.isReadAsyncOperationComplete(n3, 0) && !InstrumentReader.nanoTicTimeout(l, this.timeout)) {
            if (d < 10.0) {
                Thread.sleep(0L);
                d += 1.0;
                continue;
            }
            Thread.sleep(SLEEPTIME);
        }
        if (InstrumentReader.nanoTicTimeout(l, this.timeout)) {
            objectArray = this.getASCIIDataFromBuffer(n3);
            string = string + (String)objectArray[0];
            objectArray[0] = string;
            objectArray[1] = n2 != string.length() ? this.getTimeoutMessage(n, 0) : "";
            return objectArray;
        }
        if (ctrlc_flag) {
            objectArray = this.getASCIIDataFromBuffer(n3);
            string = string + (String)objectArray[0];
            objectArray[0] = string;
            objectArray[1] = n2 != string.length() ? "Ctrl-C interrupted the read operation." : "";
            return objectArray;
        }
        objectArray = this.getASCIIDataFromBuffer(n3);
        string = string + objectArray[0];
        objectArray[0] = string;
        if (this.okToTerminateASCIIRead((Integer)objectArray[1]) || string.length() == n2) {
            return this.convertToASCIIOutput(objectArray, n, (Integer)objectArray[1]);
        }
        n3 = n2 - string.length();
        objectArray = this.readAsciiFromHardware(n3, this.timeout);
        if (objectArray[0] instanceof String) {
            String string2 = string + (String)objectArray[0];
            objectArray[0] = string2;
            return this.convertToASCIIOutput(objectArray, n, (Integer)objectArray[1]);
        }
        int n4 = (Integer)objectArray[0];
        objectArray = new Object[]{string, this.getErrorMessageFromHardware(n4)};
        return objectArray;
    }

    protected boolean okToTerminateASCIIRead(int n) {
        return n != 0;
    }

    protected Object[] getASCIIDataFromBuffer(int n) {
        Object[] objectArray = this.inputBuffer.getDataWithInfo(n);
        if (objectArray == null) {
            objectArray = new Object[]{"", SIZE};
        } else {
            objectArray[0] = new String((byte[])objectArray[0]);
        }
        return objectArray;
    }

    private Object[] convertToASCIIOutput(Object[] objectArray, int n, int n2) {
        try {
            objectArray[1] = this.wasAsciiReadSuccessful((String)objectArray[0], n, n2);
        }
        catch (TMException tMException) {
            tMException.printStackTrace();
        }
        return objectArray;
    }

    protected String removeTerminator(String string, int n, int n2) {
        switch (n) {
            case 1: 
            case 3: {
                Character c = new Character((char)n2);
                if (string.endsWith(c.toString())) {
                    return string.substring(0, string.length() - 1);
                }
                return string;
            }
        }
        return string;
    }

    protected Object[] addToASCIIOutput(Object[] objectArray) {
        return objectArray;
    }

    public int getBinaryCountToReadFromBuffer(int n, int n2) {
        if (this.supportReadAsyncMode()) {
            if (this.getBytesAvailable() >= n) {
                return n;
            }
            return -1;
        }
        if (this.bytesAvailable == 0) {
            return -1;
        }
        int n3 = this.inputBuffer.getNextSize();
        int n4 = this.inputBuffer.getNextReason();
        if (n3 >= n) {
            return n;
        }
        if (n4 == 0) {
            return -1;
        }
        return n3 / DATASIZE[n2] * DATASIZE[n2];
    }

    public Object[] readBinary(int n, int n2) throws Exception {
        Object[] objectArray = null;
        long l = InstrumentReader.currentNanoTicTime();
        int n3 = n * DATASIZE[n2];
        int n4 = this.getBinaryCountToReadFromBuffer(n3, n2);
        if (n4 != -1) {
            objectArray = this.getBinaryDataFromBuffer(n4);
            return this.convertToBinaryOutput(objectArray, ((byte[])objectArray[0]).length, n, n2, "");
        }
        n4 = n3;
        double d = 0.0;
        while (!this.isReadAsyncOperationComplete(n4, 1) && !InstrumentReader.nanoTicTimeout(l, this.timeout)) {
            if (ctrlc_flag) {
                throw new TMException("Ctrl-C interrupted the read operation.");
            }
            if (d < 10.0) {
                Thread.sleep(0L);
                d += 1.0;
                continue;
            }
            Thread.sleep(SLEEPTIME);
        }
        if (InstrumentReader.nanoTicTimeout(l, this.timeout)) {
            return this.convertToBinaryOutputAfterError(n, n2, null);
        }
        n4 = this.getBinaryCountToReadFromBuffer(n3, n2);
        if (n4 != -1) {
            objectArray = this.getBinaryDataFromBuffer(n4);
            return this.convertToBinaryOutput(objectArray, ((byte[])objectArray[0]).length, n, n2, "");
        }
        n4 = this instanceof InstrumentAsyncContinuous ? n3 : n3 - this.getBytesAvailable();
        objectArray = this.readBinaryFromHardware(n4, this.timeout);
        if (objectArray.length == 1) {
            return this.convertToBinaryOutputAfterError(n, n2, (Integer)objectArray[0]);
        }
        int n5 = (Integer)objectArray[1];
        byte[] byArray = new byte[n5];
        System.arraycopy(objectArray[0], 0, byArray, 0, n5);
        this.inputBuffer.addData(byArray, 1);
        n4 = this.getBinaryCountToReadFromBuffer(n3, n2);
        objectArray = this.getBinaryDataFromBuffer(n4);
        return this.convertToBinaryOutput(objectArray, n4, n, n2, "");
    }

    protected Object[] getBinaryDataFromBuffer(int n) {
        Object[] objectArray = null;
        objectArray = this.supportReadAsyncMode() ? this.inputBuffer.getDataAcrossBlocks(n) : this.inputBuffer.getDataWithInfo(n);
        if (objectArray == null) {
            objectArray = new Object[]{new byte[0], SIZE};
        }
        return objectArray;
    }

    private Object[] convertToBinaryOutput(Object[] objectArray, int n, int n2, int n3, String string) throws Exception {
        Object[] objectArray2 = new Object[]{this.convertBinaryData((byte[])objectArray[0], n3, n), new Integer(n / DATASIZE[n3]), this.wasBinaryReadSuccessful(n / DATASIZE[n3], n2, string, (Integer)objectArray[1])};
        return objectArray2;
    }

    private Object[] convertToBinaryOutputAfterError(int n, int n2, Integer n3) throws Exception {
        Object[] objectArray = new Object[3];
        int n4 = Math.min(this.inputBuffer.getBytesAvailable() / DATASIZE[n2] * DATASIZE[n2], n * DATASIZE[n2]);
        String string = "";
        string = n3 == null ? this.getTimeoutMessage(n, 1) : this.getErrorMessageFromHardware(n3);
        if (n4 > 0) {
            Object[] objectArray2 = this.getBinaryDataFromBuffer(n4);
            int n5 = ((byte[])objectArray2[0]).length;
            objectArray[0] = this.convertBinaryData((byte[])objectArray2[0], n2, n5);
            objectArray[1] = new Integer(n5 / DATASIZE[n2]);
            objectArray[2] = string;
        } else {
            objectArray[0] = null;
            objectArray[1] = new Integer(0);
            objectArray[2] = string;
        }
        return objectArray;
    }

    @Override
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        if (n == 0 || n == 5) {
            return byArray;
        }
        if (platformByteOrder == this.byteOrder) {
            if (platformByteOrder == 0) {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            if (platformByteOrder == 1) {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        } else {
            if (platformByteOrder == 0) {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
            if (platformByteOrder == 1) {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
        }
        throw new TMException("Invalid ByteOrder specified.");
    }

    protected Object[] addToBinaryOutput(Object[] objectArray) {
        return objectArray;
    }

    private final Object[] readData(int n) {
        Object[] objectArray = new Object[3];
        try {
            return this.readAscii(n);
        }
        catch (Exception exception) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = exception.getMessage();
            return objectArray;
        }
    }

    private final Object[] createBinBlockReadOutput(Object object, Object object2) {
        int n = ((String)object).length();
        Object[] objectArray = new Object[]{object, new Integer(n), object2};
        this.valuesReceived += (long)n;
        return objectArray;
    }

    protected void updateObjectBinblockRead() {
    }

    protected void restoreObjectFromBinblockRead() {
    }

    protected abstract Object[] readAsciiFromHardware(int var1, double var2) throws Exception;

    protected abstract String removeTerminator(String var1) throws TMException;

    protected abstract Object[] readBinaryFromHardware(int var1, double var2) throws Exception;

    protected abstract void hardwareFlushInput();

    protected abstract boolean isReadAsyncOperationComplete(int var1, int var2) throws TMException;

    protected abstract String wasAsciiReadSuccessful(String var1, int var2, int var3) throws TMException;

    protected abstract String wasBinaryReadSuccessful(int var1, int var2, String var3, int var4) throws TMException;

    protected abstract String getTimeoutMessage(int var1, int var2) throws TMException;

    protected abstract boolean supportReadAsyncMode();
}

