/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.testmeas.util.TMException;

public abstract class Pxi
extends InstrumentAsync {
    protected static final int FIFO = 0;
    protected static final int BLOCK = 1;
    protected static final String[] MEMINC = new String[]{"FIFO", "block"};
    protected static final int PXICFG = 10;
    protected static final int BAR0 = 11;
    protected static final int BAR1 = 12;
    protected static final int BAR2 = 13;
    protected static final int BAR3 = 14;
    protected static final int BAR4 = 15;
    protected static final int BAR5 = 16;
    protected static final String[] ADDRESS_SPACE_DESC = new String[]{"PXICFG", "BAR0", "BAR1", "BAR2", "BAR3", "BAR4", "BAR5"};
    protected static final int INTERRUPTACTION = 202;
    protected static final int TRIGGERACTION = 204;
    protected static final int TRIGGERLINE = 205;
    protected static final int MEMORY_SIZE = 207;
    protected static final int MEMORY_SPACE = 208;
    protected static final int SLOT_NUMBER = 209;
    protected static final int MEMORY_INCREMENT = 213;
    protected static final int CHASSIS_NUMBER = 300;
    protected static final int BUS_NUMBER = 301;
    protected static final int DEVICE_NUMBER = 302;
    protected static final int FUNCTION_NUMBER = 303;
    protected static final int TRIGGER_BUS = 306;
    protected static final int SLOT_PATH = 309;
    protected static final int TIMEOUT = 310;
    protected static final int MODEL_NAME = 311;
    protected static final int TTL0 = 0;
    protected static final int TTL1 = 1;
    protected static final int TTL2 = 2;
    protected static final int TTL3 = 3;
    protected static final int TTL4 = 4;
    protected static final int TTL5 = 5;
    protected static final int TTL6 = 6;
    protected static final int TTL7 = 7;
    protected static final String[] TRIGGER_LINES = new String[]{"TTL0", "TTL1", "TTL2", "TTL3", "TTL4", "TTL5", "TTL6", "TTL7"};
    protected static final int HARDWARE = 0;
    protected static final int SOFTWARE = 10;
    protected static final String[] TRIGGER_TYPES = new String[]{"hardware", "software"};
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected static final int SUCCESS = 0;
    protected static final String UNSUPPORTED_OPERATION = "The given session or object reference does not support this operation.";
    protected String alias = "";
    protected int busNumber = 0;
    protected int chassisNumber = 0;
    protected int deviceNumber = 0;
    protected int functionNumber = 0;
    protected String mappedMemoryBase = "0H";
    protected int mappedMemorySize = 0;
    protected int memoryIncrement = 1;
    String rsrcName = "";
    protected int slotNumber = 0;
    protected String slotPath = "";
    protected int triggerBusNumber = 0;
    protected int triggerLine = 0;
    protected int triggerType = 0;
    protected String modelName = "";
    protected VISA visaobj;
    protected String visaName;
    protected boolean useAlias;
    protected long address = 0L;
    protected int mappedMemorySpace = 0;
    protected Object[] info = new Object[6];
    protected int readId = 0;
    protected int writeId = 0;
    protected int oldTransferStatus = 0;
    protected boolean objectPolls = false;
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    protected static final String[] MIncVals = new String[]{"block", "FIFO"};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write"};

    public void setAlias(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    public void setChassisNumber(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("ChassisNumber"));
    }

    public final int getChassisNumber() throws TMException {
        if (this.handle != 0) {
            this.chassisNumber = this.visaobj.getProperty(this.handle, 300);
        }
        if (this.chassisNumber < 0 || this.chassisNumber > 255) {
            this.chassisNumber = -1;
        }
        return this.chassisNumber;
    }

    public void setTriggerBusNumber(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("TriggerBusNumber"));
    }

    public final int getTriggerBusNumber() throws TMException {
        if (this.handle != 0) {
            this.triggerBusNumber = this.visaobj.getProperty(this.handle, 306);
        }
        return this.triggerBusNumber;
    }

    public void setSlotPath(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("SlotPath"));
    }

    public final String getSlotPath() throws TMException {
        if (this.handle != 0) {
            this.slotPath = this.visaobj.getStringProperty(this.handle, 309);
        }
        return this.slotPath;
    }

    public void setMappedMemoryBase(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("MappedMemoryBase"));
    }

    public String getMappedMemoryBase() {
        return this.mappedMemoryBase;
    }

    public void setMappedMemorySize(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("MappedMemorySize"));
    }

    public int getMappedMemorySize() {
        return this.mappedMemorySize;
    }

    public void setMemoryIncrement(int n) throws TMException {
        if (this.status == 0) {
            this.memoryIncrement = n;
            this.postPropertyChangedEvent("MemoryIncrement", MEMINC[this.memoryIncrement]);
            return;
        }
        try {
            this.setHardwareMemoryIncrement(n);
            this.memoryIncrement = n;
            this.postPropertyChangedEvent("MemoryIncrement", MEMINC[this.memoryIncrement]);
        }
        catch (Exception exception) {
            Pxi.displayError(exception.getMessage());
        }
    }

    public int getMemoryIncrement() {
        return this.memoryIncrement;
    }

    public void setRsrcName(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    public void setModelName(String string) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("ModelName"));
    }

    public String getModelName() throws TMException {
        if (this.handle != 0) {
            this.modelName = this.visaobj.getStringProperty(this.handle, 311);
        }
        return this.modelName;
    }

    public void setSlotNumber(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("SlotNumber"));
    }

    public int getSlotNumber() throws TMException {
        if (this.handle != 0) {
            this.slotNumber = this.visaobj.getProperty(this.handle, 209);
        }
        if (this.slotNumber < 0 || this.slotNumber > 255) {
            this.slotNumber = -1;
        }
        return this.slotNumber;
    }

    public int getBusNumber() throws TMException {
        if (this.handle != 0) {
            this.busNumber = this.visaobj.getProperty(this.handle, 301);
        }
        return this.busNumber;
    }

    public void setBusNumber(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("BusNumber"));
    }

    public int getDeviceNumber() throws TMException {
        if (this.handle != 0) {
            this.deviceNumber = this.visaobj.getProperty(this.handle, 302);
        }
        return this.deviceNumber;
    }

    public void setDeviceNumber(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("DeviceNumber"));
    }

    public int getFunctionNumber() throws TMException {
        if (this.handle != 0) {
            this.functionNumber = this.visaobj.getProperty(this.handle, 303);
        }
        return this.functionNumber;
    }

    public void setFunctionNumber(int n) throws TMException {
        Pxi.displayError(this.createReadOnlyPropertyError("FunctionNumber"));
    }

    protected void setHardwareMemoryIncrement(int n) throws TMException {
        this.visaobj.setProperty(this.handle, 213, n);
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visaobj.setHardwareTimeout(this.handle, d, 310);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visaobj.Get(this.handle, 310);
        return (double)n / 1000.0;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"VISA vendor:", (String)this.info[2], "Chassis Number:", Integer.toString(this.chassisNumber), "Bus Number:", Integer.toString(this.busNumber), "Device Number:", Integer.toString(this.deviceNumber)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.rsrcName;
    }

    @Override
    protected void hardwareStopAsync() {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 1: {
                this.visaobj.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return this.objectPolls;
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 0) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 0 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 0 : -1)));
        }
        return n;
    }

    @Override
    protected void updateWriteTransferStatus(boolean bl) {
        this.transferStatus = bl ? 2 : 0;
    }

    @Override
    protected int writeAsciiToHardware(String string) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    protected String constrctUpdatePropsOnOpenWarning(String[] stringArray) {
        String string = "An error occurred while configuring the following properties: " + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + ", " + stringArray[i];
        }
        string = string + "." + LINESEP + "The instrument may not support these properties or the values they " + "were configured to.";
        return string;
    }

    @Override
    protected void verifyObjectState() throws TMException {
        if (!this.isvalid()) {
            throw new TMException("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            throw new TMException("OBJ must be connected to the hardware with FOPEN.");
        }
    }

    private void verifyObjectStateForLowLevel() throws TMException {
        if (!this.isvalid()) {
            Pxi.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            Pxi.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.mappedMemorySize == 0) {
            Pxi.displayError("Memory must be mapped with the MEMMAP function.");
        }
    }

    public void memunmap() throws TMException {
        if (!this.isvalid()) {
            Pxi.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0 || this.mappedMemorySize == 0) {
            return;
        }
        int n = this.visaobj.UnMapAddress(this.handle);
        if (n < 0) {
            Pxi.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.mappedMemorySize = 0;
        this.mappedMemoryBase = "0H";
    }

    public void memmap(int n, long l, int n2) throws TMException {
        long l2;
        this.verifyObjectState();
        if (this.mappedMemorySize != 0) {
            Pxi.displayError("Memory has been mapped. Type 'instrhelp memmap' for more information.");
        }
        if ((l2 = this.visaobj.MapAddress(this.handle, n, l, n2)) == -1L) {
            Pxi.displayError("VISA: Unable to map the specified address space.");
        }
        this.address = l2;
        this.mappedMemorySpace = n - 10;
        this.mappedMemorySize = n2;
        this.mappedMemoryBase = this.isX86Arch() ? Integer.toHexString((int)this.address) + "H" : Long.toHexString(this.address) + "H";
    }

    public Object mempeek(int n, int n2) throws TMException {
        Object object;
        this.verifyObjectStateForLowLevel();
        ++this.valuesReceived;
        Object object2 = null;
        switch (n2) {
            case 3: {
                object = new byte[4];
                for (int i = 0; i < ((byte[])object).length; ++i) {
                    byte[] byArray = (byte[])this.visaobj.MemoryPeek(this.handle, 0, this.address, n + i);
                    object[i] = byArray[0];
                }
                try {
                    object2 = BinarySwapBytes.convertToLittlePrecision(object, 3, 4);
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while reading.");
                }
            }
            default: {
                object2 = this.visaobj.MemoryPeek(this.handle, n2, this.address, n);
            }
        }
        if (this.recordStatus) {
            try {
                object = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n + " offset";
                this.writeRawDataToFile(object2, 1, n2, "<", (String)object, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object2;
    }

    public void mempoke(Object object, int n, int n2) throws TMException {
        Object object2;
        this.verifyObjectStateForLowLevel();
        switch (n) {
            case 0: {
                object2 = (Byte)object;
                this.visaobj.MemoryPokeByte(this.handle, this.address, n2, (Byte)object2);
                break;
            }
            case 1: {
                Short s = (Short)object;
                this.visaobj.MemoryPokeShort(this.handle, this.address, n2, s);
                break;
            }
            case 2: {
                Integer n3 = (Integer)object;
                this.visaobj.MemoryPokeInt(this.handle, this.address, n2, n3);
                break;
            }
            case 3: {
                try {
                    byte[] byArray = BinarySwapBytes.breakdownToBytes(object, 3);
                    for (int i = 0; i < byArray.length; ++i) {
                        this.visaobj.MemoryPokeByte(this.handle, this.address, n2 + i, byArray[i]);
                    }
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while writing the data.");
                }
            }
        }
        if (this.recordStatus) {
            try {
                object2 = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n2 + " offset";
                this.writeRawDataToFile(object, 1, n, ">", (String)object2, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.valuesSent;
    }

    public Object memread(int n, int n2, int n3, int n4) throws TMException {
        Object[] objectArray;
        this.verifyObjectState();
        if (n4 * DATASIZE[n3] > this.inputBufferSize) {
            Pxi.displayError("SIZE*PRECISION must be less than or equal to InputBufferSize.");
        }
        int n5 = n4;
        int n6 = n3;
        if (n3 == 3) {
            n5 = n4 * 4;
            n6 = 0;
        }
        if ((objectArray = this.visaobj.MemRead(this.handle, n, n2, n5, n6))[0] instanceof String) {
            Integer n7 = (Integer)objectArray[1];
            String string = this.visaobj.TranslateErrorCode(this.handle, n7);
            if (string.indexOf("timeout") != -1) {
                string = "The specified data could not be read most likely due to a bus error.";
            }
            throw new TMException("VISA: " + string);
        }
        this.valuesReceived += (long)n4;
        if (n3 == 3) {
            try {
                objectArray[0] = BinarySwapBytes.convertToLittlePrecision((byte[])objectArray[0], 3, n5);
            }
            catch (Exception exception) {
                throw new TMException("An error occurred while reading.");
            }
        }
        if (this.recordStatus) {
            try {
                String string = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.writeRawDataToFile(objectArray[0], n4, n3, "<", string, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray[0];
    }

    public void memwrite(int n, Object object, int n2, int n3, int n4) throws TMException {
        Object object2;
        this.verifyObjectState();
        if (n4 * DATASIZE[n3] > this.outputBufferSize) {
            Pxi.displayError("The length(DATA)*PRECISION must be less than or equal to OutputBufferSize.");
        }
        int n5 = 0;
        switch (n3) {
            case 0: {
                if (object instanceof Byte) {
                    n5 = this.visaobj.MemWriteByte(this.handle, n, Pxi.object2byteArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteByte(this.handle, n, (byte[])object, n2);
                break;
            }
            case 1: {
                if (object instanceof Short) {
                    n5 = this.visaobj.MemWriteShort(this.handle, n, Pxi.object2shortArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteShort(this.handle, n, (short[])object, n2);
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    n5 = this.visaobj.MemWriteInt(this.handle, n, Pxi.object2intArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteInt(this.handle, n, (int[])object, n2);
                break;
            }
            case 3: {
                try {
                    object2 = BinarySwapBytes.breakdownToBytes(object, 3);
                    n5 = this.visaobj.MemWriteByte(this.handle, n, (byte[])object2, n2);
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while writing.");
                }
            }
        }
        if (n5 < 0) {
            Pxi.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n5));
        }
        if (this.recordStatus) {
            try {
                object2 = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.writeRawDataToFile(object, n4, n3, ">", (String)object2, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.valuesSent += (long)n4;
    }

    public Object ObjectHardwareInfo() {
        return this.visaobj.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    protected boolean isX86Arch() {
        String string = System.getProperty("os.arch");
        int n = string.indexOf("64");
        return n == -1;
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String getAsciiMessage(String string) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String removeTerminator(String string) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) throws TMException {
        throw new TMException(UNSUPPORTED_OPERATION);
    }
}

