/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.LineInputStream;
import com.mathworks.toolbox.instrument.Network;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.TCPIPBinder;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Vector;

public class TCPIP
extends Network
implements ActionListener {
    private static final int CLIENT = 0;
    private static final int SERVER = 1;
    public static final int DEFAULT_TCP_RPORT = 80;
    protected static final int ETHERNET_BLOCK_SIZE = 1408;
    private boolean transferDelay = true;
    private String errorString = null;
    private int networkRole = 0;
    private Socket socketTCPIP = null;
    private LineInputStream lineInputStream;
    private InputStream inputStream;
    private DataInputStream dataInputStream;
    private OutputStream outputStream;
    private OutputStreamWriter outputStreamWriter;
    private DataOutputStream dataOutputStream;
    private String initialRemoteHost = null;
    private boolean connected = false;
    protected static final String[] NETWORK_ROLES = new String[]{"client", "server"};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("ByteOrder", "string", "enum", byteOVals, "bigEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "terminator", "whileOpen", 0, 0), new ICProp("LocalHost", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("LocalPort", "double", "bounded", RPortVals, null, "whileOpen", 1, 0), new ICProp("LocalPortMode", "string", "enum", PModeVals, "auto", "whileOpen", 1, 0), new ICProp("ReadAsyncMode", "string", "enum", AsyncVals, "continuous", "never", 1, 0), new ICProp("RemoteHost", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("RemotePort", "double", "bounded", RPortVals, new Integer(80), "whileOpen", 1, 0), new ICProp("Terminator", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("TransferDelay", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("Type", "string", "none", "", "tcpip", "always", 0, 0), new ICProp("NetworkRole", "string", "enum", NETWORK_ROLES, "client", "whileOpen", 1, 0)};

    public TCPIP() {
        this.deleteInstrumentObject(this);
    }

    public TCPIP(String string, int n) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            TCPIP.displayError("Undefined function or variable 'tcpip'.");
        }
        if (!this.verifySetRange(n, 1, 65535)) {
            this.deleteInstrumentObject(this);
            throw new TMException("RemotePort must range between 1 and 65535.");
        }
        this.remotePort = n;
        if (string == null || string.length() == 0) {
            this.remoteHost = "127.0.0.1";
        }
        this.remoteHost = string;
        this.type = "tcpip";
        this.name = "TCPIP-" + this.remoteHost;
        this.displayName = "tcpip";
        this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        this.byteOrder = 1;
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "LocalHost", this.localHost);
        this.addPVPair(vector, "LocalPortMode", LPORT_MODE[this.localPortMode]);
        this.addPVPair(vector, "ReadAsyncMode", RA_MODES[this.readAsyncMode]);
        this.addPVPair(vector, "TransferDelay", this.bool2OnOff(this.transferDelay));
        this.addPVPair(vector, "NetworkRole", NETWORK_ROLES[this.networkRole]);
        if (this.localPort != 0) {
            vector.addElement((Comparable<?>)((Object)"LocalPort"));
            vector.addElement(new Integer(this.localPort));
        }
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.terminator != 10) {
            vector.addElement((Comparable<?>)((Object)"Terminator"));
            vector.addElement(new Integer(this.terminator));
        }
        if (this.networkRole == 1) {
            vector.addElement((Comparable<?>)((Object)"NetworkRole"));
            vector.addElement((Comparable<?>)((Object)"server"));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setTransferDelay(boolean bl) throws TMException {
        if (this.socketTCPIP == null) {
            this.transferDelay = bl;
            this.postPropertyChangedEvent("TransferDelay", this.bool2OnOff(this.transferDelay));
            return;
        }
        try {
            this.setHardwareTcpNoDelay(bl);
            this.transferDelay = bl;
            this.postPropertyChangedEvent("TransferDelay", this.bool2OnOff(this.transferDelay));
        }
        catch (SocketException socketException) {
            TCPIP.displayError("TransferDelay could not be set.");
        }
    }

    private void setHardwareTcpNoDelay(boolean bl) throws SocketException {
        this.socketTCPIP.setTcpNoDelay(!bl);
    }

    public boolean getTransferDelay() {
        return this.transferDelay;
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("TCPIP-" + this.remoteHost);
    }

    @Override
    protected void updateNameProperty() {
        if (this.nameStandardFormat) {
            this.setName("TCPIP-" + this.remoteHost);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Connection")) {
            this.connected = true;
        }
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", TCPIP.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "TCPIPTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    public void setSendBufferSize(int n) {
        try {
            this.socketTCPIP.setSendBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getSendBufferSize() {
        int n = 0;
        try {
            n = this.socketTCPIP.getSendBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void setReceiveBufferSize(int n) {
        try {
            this.socketTCPIP.setReceiveBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getReceiveBufferSize() {
        int n = 0;
        try {
            n = this.socketTCPIP.getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void openHardware() throws IOException, ConnectException, TMException {
        try {
            if (this.getLocalPortMode() == 1 && this.localPort == 0) {
                TCPIP.displayError("LocalPort must be an integer ranging from 1 to 65535.");
            }
            this.initialRemoteHost = this.getRemoteHost();
            this.verifyIPAddress(this.initialRemoteHost);
            InetAddress inetAddress = InetAddress.getByName(this.initialRemoteHost);
            if (this.networkRole == 1) {
                this.errorString = null;
                this.connected = false;
                TCPIPBinder tCPIPBinder = new TCPIPBinder(this, this.remotePort, inetAddress);
                Thread thread = new Thread((Runnable)tCPIPBinder, "TCPIP Binder");
                thread.start();
                while (!this.connected) {
                    if (this.checkForCtrlC() || this.errorString != null) {
                        tCPIPBinder.stopServer();
                        if (this.errorString != null) {
                            throw new TMException(this.errorString);
                        }
                        throw new IOException("Connection Failed");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                InetAddress inetAddress2 = this.socketTCPIP.getInetAddress();
                this.setRemoteHost(inetAddress2.getHostAddress());
            } else {
                this.socketTCPIP = this.localHost.equals("") && this.localPortMode == 0 ? new Socket(inetAddress, this.remotePort) : (this.localHost.equals("") && this.localPortMode == 1 ? new Socket(inetAddress, this.remotePort, InetAddress.getLocalHost(), this.localPort) : new Socket(inetAddress, this.remotePort, InetAddress.getByName(this.getLocalHost()), this.localPort));
            }
            this.enableOSBuffer(1);
            this.enableOSBuffer(0);
            this.localPort = this.socketTCPIP.getLocalPort();
            this.createStreams(this.socketTCPIP);
        }
        catch (UnknownHostException unknownHostException) {
            try {
                InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException2) {
                throw new IOException("Unknown RemoteHost: " + this.remoteHost + ".");
            }
            try {
                InetAddress.getByName(this.getLocalHost());
            }
            catch (UnknownHostException unknownHostException3) {
                throw new IOException("Unknown LocalHost: " + this.getLocalHost() + ".");
            }
        }
    }

    public void setError(String string) {
        this.errorString = string;
    }

    public void serverConnectEvent(Socket socket) {
        this.socketTCPIP = socket;
        this.connected = true;
    }

    private void createStreams(Socket socket) throws IOException {
        this.inputStream = socket.getInputStream();
        if (this.inputStream == null) {
            throw new IOException("Input Stream could not be opened.");
        }
        this.lineInputStream = new LineInputStream(this.inputStream);
        this.dataInputStream = new DataInputStream(this.inputStream);
        this.outputStream = socket.getOutputStream();
        if (this.outputStream == null) {
            throw new IOException("Output Stream could not be opened.");
        }
        this.outputStreamWriter = new OutputStreamWriter(this.outputStream);
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    @Override
    public void closeHardware() throws Exception {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        this.socketTCPIP.close();
        this.socketTCPIP = null;
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.lineInputStream != null) {
            this.lineInputStream.close();
            this.lineInputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        try {
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (this.outputStreamWriter != null) {
                this.outputStreamWriter.close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setRemoteHost(this.initialRemoteHost);
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        this.terminatorObject.dispose();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
    }

    @Override
    public void updatePropsOnOpen() throws Exception {
        this.setHardwareTcpNoDelay(this.transferDelay);
    }

    @Override
    protected void hardwareFlushInput() {
        if (this.lineInputStream != null) {
            this.lineInputStream.flush();
        }
    }

    @Override
    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.getRemoteHost(), new Integer(this.getRemotePort())};
        return objectArray;
    }

    private String addNetworkRole(String string) {
        if (this.networkRole == 1) {
            string = string + ", 'NetworkRole', '" + NETWORK_ROLES[this.networkRole] + "'";
        }
        return string;
    }

    @Override
    public final String getConstructor() {
        String string = "tcpip('" + this.getRemoteHost() + "', " + this.getRemotePort();
        string = this.addNetworkRole(string);
        string = string + ");";
        return string;
    }

    @Override
    public String getConstructorDescription() {
        String string = "Remote Host - " + this.getRemoteHost() + ", Remote Port - " + this.remotePort;
        return string;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RemoteHost', '" + this.remoteHost + "', 'RemotePort', " + this.remotePort + ", 'Tag', '" + this.tag + "');";
    }

    @Override
    protected int getBlockSizeForWrite() {
        return 1408;
    }

    @Override
    protected void writeData(String string, int n, int n2) throws Exception {
        byte[] byArray = string.substring(n, n2).getBytes();
        this.writeData(byArray, 0, byArray.length);
    }

    @Override
    protected void writeData(byte[] byArray, int n, int n2) throws Exception {
        block2: {
            try {
                this.dataOutputStream.write(byArray, n, n2);
            }
            catch (SocketException socketException) {
                if (!socketException.getMessage().equals("Broken pipe") && !socketException.getMessage().equals("Socket closed")) break block2;
                this.cleanupInterface();
                return;
            }
        }
        this.dataOutputStream.flush();
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        try {
            return this.writeAsciiToNetwork(string);
        }
        catch (IOException iOException) {
            this.updateWriteTransferStatus(false);
            try {
                this.fclose();
                return this.returnWriteErrorCode(-5);
            }
            catch (TMException tMException) {
                return this.returnWriteErrorCode(-6);
            }
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(-1);
        }
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        try {
            return this.writeBinaryToNetwork(object, n, n2);
        }
        catch (IOException iOException) {
            this.updateWriteTransferStatus(false);
            try {
                this.fclose();
                return this.returnWriteErrorCode(-5);
            }
            catch (TMException tMException) {
                return this.returnWriteErrorCode(-6);
            }
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(-1);
        }
    }

    @Override
    protected int writeAsyncDataToHardware(int n, int n2) {
        try {
            this.writeData(this.dataToWriteAsync, n, n2);
        }
        catch (Exception exception) {
            return -9;
        }
        return 0;
    }

    @Override
    protected void cleanupWriteAsync() {
        if (this.outputEmptyFcn != ACTION) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", TCPIP.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected int getBytesAvailableFromHardware() {
        try {
            return this.dataInputStream.available();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    protected byte[] readBytes(int n) {
        try {
            byte[] byArray = new byte[n];
            this.dataInputStream.readFully(byArray, 0, n);
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareFlushOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] resolveHost(String string, String string2) {
        String[] stringArray = new String[]{"", ""};
        String string3 = string2.toLowerCase();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (string3.equals("name") || string3.equals("")) {
                stringArray[0] = inetAddress.getHostName();
            } else if (string3.equals("address")) {
                stringArray[0] = inetAddress.getHostAddress();
            } else if (string3.equals("both")) {
                stringArray[0] = inetAddress.getHostName();
                stringArray[1] = inetAddress.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            stringArray[0] = "";
        }
        return stringArray;
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("TCPIP-" + this.remoteHost);
                continue;
            }
            if (string.equals("RemoteHost")) {
                iCPropArray[i].setDefaultValue(this.remoteHost);
                continue;
            }
            if (!string.equals("RemotePort") || this.remotePort == 0) continue;
            iCPropArray[i].setDefaultValue(new Integer(this.remotePort));
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    public void setNetworkRole(int n) throws TMException {
        if (this.status == 1) {
            TCPIP.displayError("networkRole cannot be set while OBJ is open.");
        }
        this.networkRole = n;
        this.postPropertyChangedEvent("NetworkRole", NETWORK_ROLES[this.networkRole]);
    }

    public int getNetworkRole() {
        return this.networkRole;
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   TCPIP Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      RemotePort:         " + this.getRemotePort() + LINESEP + "      RemoteHost:         " + this.getRemoteHost() + LINESEP + "      Terminator:         " + this.displayTerminator + LINESEP + "      NetworkRole:        " + NETWORK_ROLES[this.getNetworkRole()] + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay("terminator") + "    TCPIP specific properties:" + LINESEP + "    LocalHost" + LINESEP + "    LocalPort" + LINESEP + "    LocalPortMode: [ {auto} | manual ]" + LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + LINESEP + "    RemoteHost" + LINESEP + "    RemotePort" + LINESEP + "    Terminator" + LINESEP + "    TransferDelay: [ {on} | off ]" + LINESEP + "    NetworkRole:   [ {client} | server ]" + LINESEP + " " + LINESEP;
    }
}

