/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.instrument.VisaGeneral;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;

public class UsbVisa
extends VisaGeneral {
    protected int boardIndex = 0;
    protected int interfaceIndex = 0;
    protected String manufacturerID = "";
    protected String modelCode = "";
    protected String serialNumber = "";
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("Alias", "string", "none", "", "", "always", 1, 0), new ICProp("BoardIndex", "double", "none", "", new Integer(0), "whileOpen", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "byte", "whileOpen", 0, 0), new ICProp("EOIMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("EOSCharCode", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("EOSMode", "string", "enum", EOSMVals, "none", "never", 1, 0), new ICProp("InterfaceIndex", "double", "none", "", new Integer(0), "whileOpen", 1, 0), new ICProp("ManufacturerID", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("ModelCode", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("RsrcName", "string", "none", "", "", "always", 1, 0), new ICProp("SerialNumber", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("Type", "string", "none", "", "visa-tcpip", "always", 0, 0)};

    public UsbVisa() {
        this.deleteInstrumentObject(this);
    }

    public UsbVisa(String string, String string2, String string3, String string4) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            UsbVisa.displayError("Undefined function or variable 'visa'.");
        }
        try {
            this.rsrcName = this.visaName = string3;
            try {
                this.parseName(this.visaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alias = string4;
            this.useAlias = !this.alias.equals("");
            this.rsrcName = this.visaName;
            this.info[0] = string + FILESEP + string2;
            this.info[1] = UsbVisa.jarVersion();
            this.info[2] = this.getVendorName(string2);
            this.visa = VISA.createVisaObject((String)this.info[2], (String)this.info[0]);
            this.name = "VISA-USB-" + this.boardIndex + "-" + this.manufacturerID + "-" + this.modelCode + "-" + this.serialNumber + "-" + this.interfaceIndex;
            this.type = "visa-usb";
            this.displayName = "VISA-USB";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
            this.objectPolls = this.visa.VerifyAsyncVISARead();
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    @Override
    public void parseName(String string) {
        int n = string.indexOf("::");
        if (n == -1) {
            return;
        }
        this.boardIndex = n == 3 ? 0 : this.str2num(string.substring(3, n));
        if (this.boardIndex < 0) {
            return;
        }
        String string2 = string.substring(n + 2, string.length());
        if ((n = string2.indexOf("::")) == -1) {
            return;
        }
        this.manufacturerID = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            return;
        }
        this.modelCode = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            return;
        }
        this.serialNumber = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 2, string2.length())).indexOf("::")) == -1) {
            this.interfaceIndex = 0;
        } else {
            this.interfaceIndex = this.str2num(string2.substring(0, n));
            string2 = string2.substring(n + 2, string2.length());
        }
        if (!string2.toUpperCase().equals("INSTR")) {
            return;
        }
        this.rsrcName = "USB" + this.boardIndex + "::" + this.manufacturerID + "::" + this.modelCode + "::" + this.serialNumber + "::" + this.interfaceIndex + "::INSTR";
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("VISA-USB-" + this.boardIndex + "-" + this.manufacturerID + "-" + this.modelCode + "-" + this.serialNumber + "-" + this.interfaceIndex);
    }

    @Override
    public void updateNameProperties() {
        this.rsrcName = "USB" + this.boardIndex + "::" + this.manufacturerID + "::" + this.modelCode + "::" + this.serialNumber + "::" + this.interfaceIndex + "::INSTR";
        if (this.nameStandardFormat) {
            this.setName("VISA-USB-" + this.boardIndex + "-" + this.manufacturerID + "-" + this.modelCode + "-" + this.serialNumber + "-" + this.interfaceIndex);
        }
    }

    public final void setBoardIndex(int n) throws TMException {
        if (this.useAlias) {
            UsbVisa.displayError("BoardIndex cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            UsbVisa.displayError("BoardIndex cannot be set while OBJ is open.");
        }
        this.boardIndex = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("BoardIndex", new Integer(this.boardIndex));
    }

    public final int getBoardIndex() {
        return this.boardIndex;
    }

    public final void setInterfaceIndex(int n) throws TMException {
        if (this.useAlias) {
            UsbVisa.displayError("InterfaceIndex cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            UsbVisa.displayError("InterfaceIndex cannot be set while OBJ is open.");
        }
        this.interfaceIndex = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("InterfaceIndex", new Integer(this.interfaceIndex));
    }

    public final int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public final void setManufacturerID(String string) throws TMException {
        if (this.useAlias) {
            UsbVisa.displayError("ManufacturerID cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            UsbVisa.displayError("ManufacturerID cannot be set while OBJ is open.");
        }
        this.manufacturerID = string;
        this.updateNameProperties();
        this.postPropertyChangedEvent("ManufacturerID", this.manufacturerID);
    }

    public final String getManufacturerID() {
        return this.manufacturerID;
    }

    public final void setModelCode(String string) throws TMException {
        if (this.useAlias) {
            UsbVisa.displayError("ModelCode cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            UsbVisa.displayError("ModelCode cannot be set while OBJ is open.");
        }
        this.modelCode = string;
        this.updateNameProperties();
        this.postPropertyChangedEvent("ModelCode", this.modelCode);
    }

    public final String getModelCode() {
        return this.modelCode;
    }

    public final void setSerialNumber(String string) throws TMException {
        if (this.useAlias) {
            UsbVisa.displayError("SerialNumber cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            UsbVisa.displayError("SerialNumber cannot be set while OBJ is open.");
        }
        this.serialNumber = string;
        this.updateNameProperties();
        this.postPropertyChangedEvent("SerialNumber", this.serialNumber);
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Manufactuer ID:", this.manufacturerID, "Model code:", this.modelCode, "Serial number", this.serialNumber};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return "usb manufacturer id " + this.manufacturerID + " (model code " + this.modelCode + ")";
    }

    @Override
    public boolean isInUse() {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof UsbVisa)) continue;
            UsbVisa usbVisa = (UsbVisa)e;
            if (!usbVisa.rsrcName.equals(this.rsrcName) || usbVisa.status != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        super.updatePropsOnOpen();
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Clear(this.handle);
        if (n < 0) {
            UsbVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    public void trigger() throws TMException {
        this.verifyObjectState();
        int n = this.visa.Trigger(this.handle);
        if (n < 0) {
            UsbVisa.displayError("VISA: " + this.visa.TranslateErrorCode(this.handle, n));
        }
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("BoardIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.boardIndex));
                continue;
            }
            if (string.equals("InterfaceIndex")) {
                iCPropArray[i].setDefaultValue(new Integer(this.interfaceIndex));
                continue;
            }
            if (string.equals("ManufacturerID")) {
                iCPropArray[i].setDefaultValue(this.manufacturerID);
                continue;
            }
            if (string.equals("ModelCode")) {
                iCPropArray[i].setDefaultValue(this.modelCode);
                continue;
            }
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("VISA-USB-" + this.boardIndex + "-" + this.manufacturerID + "-" + this.modelCode + "-" + this.serialNumber + "-" + this.interfaceIndex);
                continue;
            }
            if (string.equals("RsrcName")) {
                iCPropArray[i].setDefaultValue(this.rsrcName);
                continue;
            }
            if (string.equals("Alias")) {
                iCPropArray[i].setDefaultValue(this.alias);
                continue;
            }
            if (!string.equals("SerialNumber")) continue;
            iCPropArray[i].setDefaultValue(this.serialNumber);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public String display() {
        if (!this.isvalid()) {
            return Displays.invalidDisplay();
        }
        return LINESEP + "   VISA-USB Object Using " + this.info[2] + " Adaptor : " + this.name + LINESEP + LINESEP + "   Communication Address  " + LINESEP + "      ManufacturerID:     " + this.manufacturerID + LINESEP + "      ModelCode:          " + this.modelCode + LINESEP + "      SerialNumber:       " + this.serialNumber + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay() + "    VISA-USB specific properties:" + LINESEP + "    BoardIndex" + LINESEP + "    EOIMode: [ {on} | off ]" + LINESEP + "    EOSCharCode" + LINESEP + "    EOSMode: [ {none} | read | write | read&write ]" + LINESEP + "    InterfaceIndex" + LINESEP + "    ManufacturerID" + LINESEP + "    ModelCode" + LINESEP + "    SerialNumber" + LINESEP + " " + LINESEP;
    }
}

