/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.toolbox.instrument.browser.HelpPanel;
import com.mathworks.toolbox.instrument.browser.ICTBrowserDesktop;
import com.mathworks.toolbox.instrument.browser.ICTDetailviewPanel;
import com.mathworks.toolbox.instrument.browser.ICTTreeView;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserDecoration;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.toolbox.testmeas.browser.TreeViewListener;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;

public class ICTBrowserTreeDetail
implements TreeViewEditorListener {
    private final int HARDWARENODE_ROW = 1;
    private int VISANODE_ROW = 7;
    private BrowserClient client = null;
    private ICTTreeView treeView = null;
    private BrowserTreeNode rootNode = null;
    private BrowserTreeNode currentNode = null;
    private boolean showRootNode = true;
    private boolean okToHilite = true;
    private BrowserDecoration browserDecorationDP = null;
    private BrowserDecoration browserDecorationTV = null;
    private boolean okToUpdateDecorationDP = true;

    public ICTBrowserTreeDetail(BrowserClient browserClient, BrowserTreeNode browserTreeNode) {
        this.client = browserClient;
        this.rootNode = browserTreeNode;
        if (this.rootNode == null) {
            this.showRootNode = false;
            this.rootNode = new BrowserTreeNode("temp", null);
        }
        this.treeView = new ICTTreeView(this, this.rootNode);
        this.treeView.setRootVisible(this.showRootNode);
    }

    public void init(BrowserConfigFileReader browserConfigFileReader) {
        this.client.addTreeViewListener((TreeViewListener)this.treeView);
        this.treeView.addParentandChildNodes(this.client.getRootNode(), this.client.getLevelOneNodes());
        this.treeView.addTreeViewEditorListener(this);
        this.client.init();
        if (browserConfigFileReader != null) {
            this.client.load(browserConfigFileReader, browserConfigFileReader.getToolboxNode(TMStringUtil.strrep((String)this.client.getToolboxName(), (String)" ", (String)"")));
        }
        try {
            this.currentNode = this.treeView.selectFirstNode();
            this.treeView.expandRow(1);
            if (PlatformInfo.isLinux() || !InstrumentControlBrowser.bluetoothSupportInTMTOOL) {
                this.VISANODE_ROW = 6;
            }
            this.treeView.expandRow(this.VISANODE_ROW);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.client.removeTreeViewListener((TreeViewListener)this.treeView);
        BrowserConfigFileWriter browserConfigFileWriter = new BrowserConfigFileWriter("tmtool.cfg");
        if (browserConfigFileWriter != null) {
            this.client.save(browserConfigFileWriter, browserConfigFileWriter.addToolboxNode(TMStringUtil.strrep((String)this.client.getToolboxName(), (String)" ", (String)"")));
            browserConfigFileWriter.saveToFile();
        }
        this.client.cleanup();
        this.client = null;
        this.treeView.cleanup();
        this.treeView = null;
    }

    public void update(BrowserTreeNode browserTreeNode) {
        if (this.currentNode == browserTreeNode) {
            return;
        }
        BrowserTreeNode browserTreeNode2 = this.currentNode;
        this.currentNode = browserTreeNode;
        BrowserClient browserClient = browserTreeNode.getClient();
        BrowserTreeNode[] browserTreeNodeArray = this.treeView.getAllNodesSelected();
        this.updateDetailViewAndHelp(browserClient, this.currentNode, browserTreeNode2, browserTreeNodeArray);
        if (browserClient != null) {
            if (!ICTBrowserDesktop.getInstance().getMainFrame().isVisible()) {
                return;
            }
            if (!browserTreeNode.isMenuUpdated()) {
                return;
            }
            ICTBrowserDesktop iCTBrowserDesktop = ICTBrowserDesktop.getInstance();
            iCTBrowserDesktop.updateMenubar();
        }
    }

    private void updateDetailViewAndHelp(BrowserClient browserClient, BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        HelpPanel helpPanel;
        if (browserClient == null) {
            return;
        }
        if (this.browserDecorationDP != null && this.okToUpdateDecorationDP) {
            this.browserDecorationDP.setText(browserTreeNode.getName().replace("&&", "&"), browserTreeNode.getIcon());
        }
        if (browserTreeNode2 != null && browserTreeNode2.getClient() != null) {
            browserTreeNode2.getClient().cleanupNode(browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        }
        JPanel jPanel = browserClient.getPanel(browserTreeNode, browserTreeNode2, browserTreeNodeArray);
        if (browserTreeNode != null && ICTDetailviewPanel.getInstance() != null) {
            ICTDetailviewPanel.getInstance().updateTitle(browserTreeNode.getName());
        }
        if ((helpPanel = HelpPanel.getInstance()) != null) {
            helpPanel.displayTopic(browserTreeNode.getHelpMapFile(), browserTreeNode.getAnchorTag());
        }
        ICTDetailviewPanel iCTDetailviewPanel = ICTDetailviewPanel.getInstance();
        if (browserTreeNode.isPanelUpdated()) {
            if (jPanel != null) {
                ICTBrowserDesktop.getInstance().showClient((Component)((Object)iCTDetailviewPanel), null, false);
                iCTDetailviewPanel.updateView(jPanel, browserTreeNode);
            } else {
                ICTBrowserDesktop.getInstance().hideClient((Component)((Object)iCTDetailviewPanel));
                iCTDetailviewPanel.clearView();
            }
        }
    }

    public BrowserTreeNode getSelectedNode() {
        return this.currentNode;
    }

    public void selectTreeView(boolean bl) {
        if (this.okToHilite) {
            this.browserDecorationTV.selectDecoration(bl);
        }
    }

    public void refresh() {
        this.client.refresh();
    }

    public void collapseAll() {
        this.treeView.collapseAll();
    }

    public void expandAll() {
        this.treeView.expandAll();
    }

    public void showRootNode(boolean bl) {
        this.showRootNode = bl;
        if (this.treeView != null) {
            this.treeView.setRootVisible(this.showRootNode);
        }
    }

    public BrowserClient getBrowserClients() {
        return this.client;
    }

    public BrowserTreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public JComponent getTreeViewComponent() {
        return new JScrollPane((Component)((Object)this.treeView));
    }

    public BrowserDecoration getTreeViewBrowserDecoration() {
        return this.browserDecorationTV;
    }

    public void nodeEditingCanceled(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
    }

    public void nodeEditingStopped(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        if (!IviCInstrumentObjectStore.isNameChanged(browserTreeNode)) {
            return;
        }
        if (IviCInstrumentObjectStore.isNameDup(browserTreeNode)) {
            JOptionPane.showMessageDialog(null, "The name has existed, please use another name");
            browserTreeNode.setName(IviCInstrumentObjectStore.getSelectedIviInstrumentObject().getName());
            return;
        }
        IviCInstrumentObjectStore.updateIviInstrumentObject(browserTreeNode);
    }
}

