/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.driver.IVIListSelector;
import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import com.mathworks.toolbox.instrument.browser.driver.IVITabListener;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class IVILogicalNameTab
extends IVITab
implements KeyListener,
FocusListener,
IVITabListener {
    private static final long serialVersionUID = 1L;
    private static final int DESCRIPTION = 0;
    private static final int DRIVER_SESSION = 1;
    private IVIListSelector listSelector;
    private JTextField name;
    private JTextArea description;
    private JComboBox driverSession;
    private Hashtable<String, String[]> logicalNames;
    private String selectedItem = "";
    private String originalName = "";
    private boolean isDirty = false;

    public IVILogicalNameTab() {
        this.layoutPanel();
    }

    protected void setup(String[] stringArray) {
        String[] stringArray2;
        this.driverSession.removeAllItems();
        this.driverSession.addItem("<unset>");
        for (int i = 0; i < stringArray.length; ++i) {
            this.driverSession.addItem(stringArray[i]);
        }
        if (this.logicalNames != null && (stringArray2 = this.logicalNames.get(this.selectedItem)) != null) {
            this.driverSession.setSelectedItem(stringArray2[1]);
        }
        this.selectSessionForLogicalName(this.listSelector.getSelectedItem());
    }

    protected void updateTable() {
        this.updateSelectedItem();
    }

    public void updateSelectedItem() {
        this.updateSelectedItem(this.selectedItem);
    }

    private void selectSessionForLogicalName(String string) {
        if (string == null || string.equals("") || !this.logicalNames.containsKey(string)) {
            this.driverSession.setSelectedItem("<unset>");
            return;
        }
        String[] stringArray = this.logicalNames.get(string);
        this.driverSession.setSelectedItem(stringArray[1]);
    }

    private void updateSelectedItem(String string) {
        if (!this.isVisible() || string == null || string.equals("")) {
            return;
        }
        if (!this.logicalNames.containsKey(string)) {
            this.addToTable(string);
            return;
        }
        String[] stringArray = this.logicalNames.get(string);
        if (!stringArray[0].equals(this.description.getText())) {
            this.isDirty = true;
        } else if (this.driverSession.getItemCount() > 0 && !stringArray[1].equals(this.driverSession.getSelectedItem())) {
            this.isDirty = true;
        }
        stringArray[0] = this.description.getText();
        stringArray[1] = this.driverSession.getItemCount() == 1 ? "" : (String)this.driverSession.getSelectedItem();
        this.logicalNames.put(string, stringArray);
    }

    private void addToTable(String string) {
        String[] stringArray = new String[]{this.description.getText(), this.driverSession.getItemCount() == 1 ? "" : (String)this.driverSession.getSelectedItem()};
        this.logicalNames.put(string, stringArray);
        this.isDirty = true;
    }

    private void removeFromTable(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.logicalNames.remove(string);
        this.isDirty = true;
    }

    public boolean isTabDirty() {
        return this.isDirty;
    }

    public void resetIsDirtyFlag() {
        this.isDirty = false;
    }

    private void layoutPanel() {
        this.name = new JTextField();
        this.name.addKeyListener(this);
        this.description = new JTextArea();
        this.description.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IVILogicalNameTab.this.updateSelectedItem();
            }
        });
        this.driverSession = new JComboBox();
        JScrollPane jScrollPane = this.configureTextArea(this.description);
        this.description.setFont(this.name.getFont());
        this.name.addFocusListener(this);
        this.name.setEnabled(false);
        JPanel jPanel = this.add(new JLabel("Name:"), this.name, 2);
        JPanel jPanel2 = this.add(new JLabel("Description:"), jScrollPane, 2);
        JPanel jPanel3 = this.add(new JLabel("Driver session:"), this.driverSession, 2);
        JPanel jPanel4 = this.add(jPanel, jPanel2, 4);
        JPanel jPanel5 = this.add(jPanel4, jPanel3, 4);
        JPanel jPanel6 = new JPanel(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, "North");
        this.listSelector = new IVIListSelector(this);
        this.add((Component)this.listSelector, "West");
        this.add((Component)jPanel6, "Center");
        this.setComponentsEnabled(false);
    }

    @Override
    public void itemChangedEvent(String string) {
        this.updateSelectedItem();
        this.name.setText(string);
        if (this.logicalNames == null || !this.logicalNames.containsKey(string)) {
            this.description.setText("");
            if (this.driverSession.getItemCount() > 0) {
                this.driverSession.setSelectedIndex(0);
            }
        } else {
            String[] stringArray = this.logicalNames.get(string);
            this.description.setText(stringArray[0]);
            try {
                if (stringArray[1].length() == 0) {
                    this.driverSession.setSelectedItem("<unset>");
                } else {
                    this.driverSession.setSelectedItem(stringArray[1]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.selectedItem = string;
        this.originalName = string;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.listSelector.getItemCount() == 0) {
            return;
        }
        if (this.listSelector.containsDuplicate(this.name.getText())) {
            TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"Duplicate names are not allowed.");
            this.name.setText(this.originalName);
            this.listSelector.updateSelectedItemText(this.name.getText());
            this.selectedItem = this.name.getText();
            return;
        }
        if (!this.name.getText().equals("")) {
            return;
        }
        TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"The Name field cannot be empty.");
        this.name.setText(this.originalName);
        this.keyReleased(null);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.isDirty = true;
        String string = this.name.getText();
        this.listSelector.updateSelectedItemText(string);
        this.removeFromTable(this.selectedItem);
        this.selectedItem = string;
    }

    public void setComponentsEnabled(boolean bl) {
        this.name.setEnabled(bl);
        this.description.setEnabled(bl);
        this.driverSession.setEnabled(bl);
    }

    @Override
    public void addItem(String string) {
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(true);
        }
    }

    @Override
    public void removeItem(String string) {
        this.removeFromTable(string);
        this.selectedItem = "";
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(false);
        }
    }

    @Override
    public void nameChanged(String string, String string2, String string3) {
        if (!string.equals("DriverSession")) {
            return;
        }
        Enumeration<String> enumeration = this.logicalNames.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement();
            String[] stringArray = this.logicalNames.get(string4);
            if (!stringArray[1].equals(string2)) continue;
            stringArray[1] = string3;
        }
    }

    public void removeAllElements() {
        this.listSelector.removeAllElements();
        this.setComponentsEnabled(false);
        this.listSelector.enableButtons(false);
    }

    public void updateForNewDriver(Object[] objectArray) {
        this.parse(objectArray);
        this.isDirty = false;
    }

    private void parse(Object[] objectArray) {
        this.logicalNames = new Hashtable();
        this.listSelector.enableButtons(true);
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = (String[])objectArray[i];
            String string = stringArray[0];
            String[] stringArray2 = new String[]{stringArray[1], stringArray[2]};
            this.logicalNames.put(string, stringArray2);
            this.listSelector.addElement(string);
        }
        if (objectArray.length > 0) {
            this.listSelector.setSelectedIndex(0);
            this.setComponentsEnabled(true);
        }
    }

    public Hashtable<String, String[]> getInfo() {
        return this.logicalNames;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    public class IVILogicalItem {
        private String name;
        private String description;
        private String driverSession;
        private int hashKey;

        public IVILogicalItem() {
            this("<unset>", "", "<unset>");
        }

        public IVILogicalItem(String string, String string2, String string3) {
            this.setName(string);
            this.setDescription(string2);
            this.setDriverSession(string3);
            this.setHashKey(10);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDriverSession() {
            return this.driverSession;
        }

        public void setDriverSession(String string) {
            this.driverSession = string;
        }

        public int getHashKey() {
            return this.hashKey;
        }

        private void setHashKey(int n) {
            this.hashKey = n;
        }
    }
}

