/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.interfaceobj;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.toolbox.instrument.GpibVisa;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.SerialComm;
import com.mathworks.toolbox.instrument.SerialVisa;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.instrcomm.CommunicationLabel;
import com.mathworks.toolbox.instrument.instrcomm.CommunicationPanel;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import java.util.ResourceBundle;

public class BrowserCommunicationLabel
extends CommunicationLabel {
    private static final long serialVersionUID = 1L;
    protected static final transient ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");
    private BrowserObject browserObject;
    private Object[] matlabArgs = new Object[3];
    private CommunicationPanel commPanel;
    private InstrumentControlBrowser browser;
    private CommunicationPage communicationPage;
    private ObjectRunnable objectRunnable = null;

    public BrowserCommunicationLabel(HistoryTable historyTable, int n, Instrument instrument, InstrumentControlBrowser instrumentControlBrowser) {
        super(historyTable, n, instrument);
        this.browser = instrumentControlBrowser;
        this.setComponentsEnabled(true);
    }

    @Override
    public void setHistoryTable(HistoryTable historyTable) {
        super.setHistoryTable(historyTable);
    }

    public void setCommunicationPage(CommunicationPage communicationPage) {
        this.communicationPage = communicationPage;
    }

    @Override
    public boolean showLabel() {
        return false;
    }

    @Override
    public boolean enableInstrumentObjectEvents() {
        return false;
    }

    public void setPanel(CommunicationPanel communicationPanel) {
        this.commPanel = communicationPanel;
    }

    public void setBrowserObject(BrowserObject browserObject) {
        this.browserObject = browserObject;
    }

    @Override
    public void addConnectRow() {
    }

    @Override
    public void callMATLABToConnect() {
        if (this.currentObject == null || !this.currentObject.isvalid()) {
            this.createObject();
        } else if (this.currentObject instanceof SerialComm || this.isaGpibDll()) {
            if (this.browserObject.createVISAObject()) {
                this.createObject();
            } else {
                this.connect();
            }
        } else if (this.currentObject instanceof SerialVisa || this.currentObject instanceof GpibVisa) {
            if (!this.browserObject.createVISAObject()) {
                this.createObject();
            } else {
                this.connect();
            }
        } else {
            this.connect();
        }
    }

    private boolean isaGpibDll() {
        String string = this.currentObject.getClass().getName();
        return string.startsWith("com.mathworks.toolbox.instrument.Gpib") && !string.equals("com.mathworks.toolbox.instrument.GpibVisa");
    }

    private void connect() {
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "fopen";
        this.matlabArgs[2] = this.currentObject;
        this.callIntoMATLAB();
    }

    private void createObject() {
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "create";
        this.matlabArgs[2] = this.browserObject;
        this.callIntoMATLAB();
    }

    @Override
    public void callMATLABToDisconnect() {
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "fclose";
        this.matlabArgs[2] = this.currentObject;
        this.callIntoMATLAB();
    }

    public void callIntoMATLAB() {
        if (this.matlabArgs[1].equals("fclose")) {
            this.browser.postStatusBarUpdateEvent(sResources.getString("StatusBarMessage.InstrumentDisconnect"));
        } else {
            this.browser.postStatusBarUpdateEvent(sResources.getString("StatusBarMessage.InstrumentConnect"));
        }
        if (this.objectRunnable == null) {
            this.objectRunnable = new ObjectRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.objectRunnable);
    }

    public void updateGUIAfterCallIntoMATLAB(Object object) {
        if (object == null) {
            if (this.matlabArgs[1].equals("fopen")) {
                this.setStateOpen(true);
            }
        } else if (object instanceof Instrument) {
            this.currentObject = (Instrument)object;
            this.commPanel.setObject(this.currentObject);
            this.browserObject.setInstrumentObject(this.currentObject);
            this.selectedObjectUpdated(this.currentObject);
            this.matlabActionComplete(0, "open", null);
            super.addConnectRow();
        } else {
            if (object instanceof double[]) {
                this.setStateOpen(false);
                return;
            }
            if (this.matlabArgs[1].equals("fopen")) {
                this.matlabActionComplete(0, object, null);
                super.addConnectRow();
            } else {
                this.matlabActionComplete(1, object, null);
            }
        }
        this.communicationPage.stateChanged(null);
    }

    @Override
    public void selectedObjectUpdated(Instrument instrument) {
        if (instrument == this.currentObject) {
            super.selectedObjectUpdated(instrument);
        }
    }

    @Override
    public void setCurrentObject(Instrument instrument) {
        this.currentObject = instrument;
    }

    @Override
    public void updateStateButton(int n) {
        super.updateStateButton(n);
    }

    public class ObjectRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", BrowserCommunicationLabel.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() == 0) {
                Object object = matlabEvent.getResult();
                BrowserCommunicationLabel.this.updateGUIAfterCallIntoMATLAB(object);
            } else {
                BrowserCommunicationLabel.this.updateGUIAfterCallIntoMATLAB(null);
            }
            BrowserCommunicationLabel.this.blockEvents(false);
            BrowserCommunicationLabel.this.browser.postStatusBarUpdateEvent("");
        }
    }
}

