/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.browser.ICTBrowserDesktop;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.instrument.util.ICUtil;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class CreateInstrumentObjDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    MJTextField fTextField;
    private static final String ACTION = "ACTION";
    private static final int OK = 0;
    private static final int CANCEL = 1;

    public CreateInstrumentObjDialog() {
        super((Frame)ICTBrowserDesktop.getInstance().getMainFrame(), "Create IVI Instrument object", true);
        this.setLayout(new GridBagLayout());
        this.layoutPanel();
        this.pack();
        this.setResizable(false);
        DTFrame dTFrame = ICTBrowserDesktop.getInstance().getMainFrame();
        ICUtil.centerWindow((Window)dTFrame, this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.setVisible(true);
    }

    private void layoutPanel() {
        ICUtil.addComponent(this, (Component)this.createObjNamePanel(), 0, 0, 1.0, 0.0, 1, 1, 2, new Insets(4, 4, 4, 4), 17);
        ICUtil.addComponent(this, (Component)this.createButtonPanel(), 0, 2, 1.0, 1.0, 1, 1, 1, new Insets(4, 4, 4, 4), 15);
    }

    private MJPanel createObjNamePanel() {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 3));
        MJLabel mJLabel = new MJLabel("Please provide an instrument object name");
        mJPanel.add((Component)mJLabel);
        this.fTextField = new MJTextField();
        this.fTextField.putClientProperty((Object)ACTION, (Object)new Integer(0));
        this.fTextField.addActionListener((ActionListener)this);
        mJPanel.add((Component)this.fTextField);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                CreateInstrumentObjDialog.this.fTextField.requestFocusInWindow();
            }
        });
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return mJPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(1, 0, 0));
        MJButton mJButton = new MJButton("OK");
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        mJButton.addActionListener((ActionListener)this);
        MJButton mJButton2 = new MJButton("Cancel");
        mJButton2.putClientProperty((Object)ACTION, (Object)new Integer(1));
        mJButton2.addActionListener((ActionListener)this);
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)mJButton2);
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return mJPanel;
    }

    public String getInstrumentObjName() {
        return this.fTextField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = Integer.parseInt(jComponent.getClientProperty(ACTION).toString());
        switch (n) {
            case 0: {
                String string = this.fTextField.getText();
                if (string.length() == 0) {
                    JOptionPane.showMessageDialog(null, "The instrument object name can't be empty");
                    this.fTextField.requestFocusInWindow();
                    return;
                }
                if (string.contains(" ")) {
                    JOptionPane.showMessageDialog(null, "The instrument object name can't contain empty space");
                    this.fTextField.setText(null);
                    this.fTextField.requestFocusInWindow();
                    return;
                }
                if (IviCInstrumentObjectStore.getIviCInstrumentObject(string) != null) {
                    JOptionPane.showMessageDialog(null, "The instrument object name has existed, please use other name", "Try again", 0);
                    this.fTextField.setText(null);
                    this.fTextField.requestFocusInWindow();
                    return;
                }
                this.setVisible(false);
                break;
            }
            case 1: {
                this.fTextField.setText(null);
                this.setVisible(false);
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

