/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.Bluetooth;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.math.BigInteger;

public class BluetoothObject
extends BrowserObject
implements Runnable {
    private String fRemoteName;
    private String fRemoteID;
    private int fChannel;
    private MLArrayRef fTerminator = null;

    public BluetoothObject(String string, String string2, String string3) {
        super(string2, string3);
        String[] stringArray = new String[]{"", "0]"};
        if (!string.contains("[check device, rescan]")) {
            try {
                stringArray = string.split(" \\[Channel: ");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            String[] stringArray2 = string.split(" \\[check device, rescan\\]");
            stringArray[0] = stringArray2[0];
            stringArray[1] = "0]";
        }
        if (stringArray[0].length() > 11) {
            try {
                new BigInteger(stringArray[0], 16);
                this.fRemoteID = stringArray[0];
            }
            catch (Exception exception) {
                this.fRemoteName = stringArray[0];
            }
        } else {
            this.fRemoteName = stringArray[0];
        }
        this.fChannel = Integer.parseInt(stringArray[1].substring(0, 1));
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            Object[] objectArray = new Object[]{new Integer(45), "LF"};
            this.fTerminator = (MLArrayRef)Matlab.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"Device: ", this.fRemoteName, " ", " ", " ", " "};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return this.fRemoteName;
    }

    @Override
    public String getType() {
        return "Bluetooth";
    }

    public String getDevice() {
        if (this.fRemoteName != null) {
            return "'" + this.fRemoteName + "', " + this.fChannel;
        }
        return "'btspp://" + this.fRemoteID + "', " + this.fChannel;
    }

    public void setRemoteName(String string) {
        this.fRemoteName = string;
    }

    public String getRemoteName() {
        return this.fRemoteName;
    }

    public void setRemoteID(String string) {
        this.fRemoteID = string;
    }

    public String getRemoteID() {
        return this.fRemoteID;
    }

    public void setChannel(int n) {
        this.fChannel = n;
    }

    public int getChannel() {
        return this.fChannel;
    }

    public MLArrayRef getTerminator() {
        return this.fTerminator;
    }

    public void setTerminator(MLArrayRef mLArrayRef) {
        if (this.fTerminator != mLArrayRef) {
            this.fTerminator.dispose();
        }
        this.fTerminator = mLArrayRef;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Bluetooth)this.instrumentObject).setTerminator(this.fTerminator);
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting Terminator", (String)exception.getMessage());
        }
    }
}

