/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.PxiVisa;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class PXIObject
extends BrowserObject {
    private static final String[] MEMORY_INCREMENT = new String[]{"block", "FIFO"};
    protected String vendor;
    protected String chassisNumber;
    protected String slotNumber;
    protected String modelName;
    protected String memoryIncrement = "block";

    public PXIObject(String string, String string2, String string3, String string4, String string5) {
        super(string4, string5);
        this.vendor = string;
        this.chassisNumber = string2;
        this.slotNumber = string3;
        this.modelName = string4;
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"VISA vendor:", this.vendor, "Chassis Number:", this.chassisNumber, "Slot Number:", this.slotNumber};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return "chassis " + this.chassisNumber + ", slot number " + this.slotNumber;
    }

    @Override
    public String getType() {
        return "PXI";
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getchassisNumber() {
        return this.chassisNumber;
    }

    public String getSlotNumber() {
        return this.slotNumber;
    }

    public void setMemoryIncrement(String string) {
        this.memoryIncrement = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((PxiVisa)this.instrumentObject).setMemoryIncrement(this.getIndex(MEMORY_INCREMENT, this.memoryIncrement));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting MemoryIncrement", (String)tMException.getMessage());
        }
    }

    public String getMemoryIncrement() {
        return this.memoryIncrement;
    }

    public String getModelName() {
        return this.modelName;
    }
}

