/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.CallbackQueue;
import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.DeviceObjectListener;
import com.mathworks.toolbox.instrument.device.HardwareInfoStruct;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.PropertyChangedListener;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.event.Event;
import com.mathworks.toolbox.instrument.device.util.Displays;
import com.mathworks.toolbox.instrument.device.util.ErrorMessages;
import com.mathworks.toolbox.instrument.device.util.MLNotifier;
import com.mathworks.toolbox.instrument.device.util.PropertyHelp;
import com.mathworks.toolbox.instrument.device.util.PropertyUtil;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Calendar;
import java.util.Random;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class Device
implements DeviceClient {
    protected static final String TYPE = "parent";
    private static Random randomGenerator = new Random();
    private static Vector<Double> allTimes = new Vector();
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    protected static final int EVAL = 0;
    protected static final int FEVAL = 1;
    public static final MLArrayRef CALLBACK = new MLArrayRef(4);
    public static final MLArrayRef USERDATA = new MLArrayRef(6);
    protected static final int TOTAL_CALLBACKS = 5;
    public static final int TOTAL_CB_DISABLE = 2;
    protected static final int CONFIRMATION_FCN = 0;
    protected static final int INSTRUMENT_ERROR_FCN = 1;
    protected static final int PROPERTY_CHANGED = 2;
    protected static final int OBJECT_CREATED = 3;
    protected static final int OBJECT_DELETED = 4;
    protected static final String[] CALLBACK_NAMES = new String[]{"ConfirmationFcn", "InstrumentErrorFcn"};
    protected static final MLNotifier mlNotifier = new MLNotifier();
    protected static Vector<DeviceClient> allObjects = new Vector();
    public static final int INTERFACE_OBJECT = 0;
    public static final int VXIPNP = 1;
    public static final int IVI_C = 2;
    public static final int IVI_COM = 3;
    public static final int GENERIC = 4;
    public static final int COM = 5;
    public static final int SHARED_LIBRAY = 6;
    public static final int IVI_C_CLASS = 7;
    public static final int LAST_DRIVER_TYPE = 4;
    public static final String[] DRIVER_TYPE_NAMES = new String[]{"MATLAB interface object", "MATLAB VXIplug&play", "MATLAB IVI-C", "MATLAB IVI-COM", "MATLAB generic", "MATLAB COM", "MATLAB shared library", "MATLAB IVI-CClass", ""};
    public static final String[] DRIVER_TYPE_DISPLAY_NAMES = new String[]{"MATLAB interface object", "MATLAB VXIplug&play", "MATLAB IVI", "MATLAB IVI", "MATLAB generic", "MATLAB COM", "MATLAB shared library", "MATLAB IVI-CClass", ""};
    protected static final int OVERWRITE = 0;
    protected static final int APPEND = 1;
    protected static final int INDEX = 2;
    public static final int CLOSED = 0;
    public static final int OPEN = 1;
    public static final String[] STATUS_TYPES = new String[]{"closed", "open"};
    protected static Vector<DeviceObjectListener> listeners;
    private static Vector<PropertyChangedListener> propertyChangedListeners;
    protected static final String[] boolVals;
    protected static final String[] RModeVals;
    protected static final String[] StatVals;
    protected MLArrayRef confirmationFcn = CALLBACK;
    protected double creationTime = 0.0;
    protected MLArrayRef driverData = USERDATA;
    protected String driverName = "";
    protected int driverType = 0;
    protected String instrumentModel = "";
    protected String optionString = "";
    protected MLArrayRef interfaceObj = USERDATA;
    protected String logicalName = "";
    protected String name = "";
    protected boolean objectVisibility = true;
    protected String rsrcName = "";
    protected boolean simulationMode = false;
    protected int status = 0;
    protected String tag = "";
    protected double timeout = 10.0;
    protected String type = null;
    protected MLArrayRef userData = USERDATA;
    protected String repCapIdentifier = "";
    public String displayName = null;
    protected HardwareInfoStruct hwInfoStruct = new HardwareInfoStruct();
    private Object[] info = null;
    protected boolean[] enabledCallbacks = new boolean[5];
    protected PropertyInfo[] objectProps = null;
    protected MLArrayRef MATLABObject = null;
    protected InstrumentDriver driver;
    private static final int DRIVER_DATA_HIDDEN = 0;
    private int driverDataIsVisibleFlag = 0;
    private boolean interfaceIsReadOnly = true;
    private boolean instrumentModelIsReadOnly = true;
    public int[] callbackType = new int[5];
    public String[] evalString = new String[5];
    public MLArrayRef[] callbackData = new MLArrayRef[5];
    protected MatlabMCR matlabMCR = MatlabMCRFactory.getForCurrentMCR();
    static PropertyInfo[] baseProperties;

    public Device() {
        allObjects.addElement(this);
        this.creationTime = this.findUniqueCreationTime();
    }

    private double findUniqueCreationTime() {
        double d = randomGenerator.nextDouble();
        while (allTimes.contains(new Double(d))) {
            d = randomGenerator.nextDouble();
        }
        allTimes.addElement(new Double(d));
        return d;
    }

    public void setMATLABObject(MLArrayRef mLArrayRef) {
        if (this.MATLABObject != null) {
            this.MATLABObject.dispose();
        } else {
            this.postDeviceObjectAddedEvent();
        }
        this.MATLABObject = mLArrayRef;
        this.driver.setDeviceObject(this.MATLABObject);
    }

    @Override
    public MLArrayRef getMATLABObject() {
        return this.MATLABObject;
    }

    public void cleanup() {
        if (this.MATLABObject != null) {
            this.MATLABObject.dispose();
        }
    }

    public static MLNotifier getMATLABNotifier() {
        return mlNotifier;
    }

    public void willExecuteDriverCreateCode() {
        ++this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = false;
        this.instrumentModelIsReadOnly = false;
    }

    public void willExecuteDriverConnectCode() {
        ++this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = false;
        this.instrumentModelIsReadOnly = false;
    }

    public void willExecuteDriverDisconnectCode() {
        ++this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = false;
        this.instrumentModelIsReadOnly = false;
    }

    public void willExecuteDriverPropertyCode() {
        ++this.driverDataIsVisibleFlag;
    }

    public void willExecuteDriverMethodCode() {
        ++this.driverDataIsVisibleFlag;
    }

    public void didExecuteDriverCreateCode() {
        --this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = true;
        this.instrumentModelIsReadOnly = true;
    }

    public void didExecuteDriverConnectCode() {
        --this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = true;
        this.instrumentModelIsReadOnly = true;
    }

    public void didExecuteDriverDisconnectCode() {
        --this.driverDataIsVisibleFlag;
        if (this.driverType != 4) {
            return;
        }
        this.interfaceIsReadOnly = true;
        this.instrumentModelIsReadOnly = true;
    }

    public void didExecuteDriverPropertyCode() {
        --this.driverDataIsVisibleFlag;
    }

    public void didExecuteDriverMethodCode() {
        --this.driverDataIsVisibleFlag;
    }

    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        System.out.println("");
        System.out.println("   Instrument object: " + this.getType());
        System.out.println("");
    }

    @Override
    public String getDisplayName() {
        return "device";
    }

    public void setConfirmationFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyCallbackValue("ConfirmationFcn", 0, mLArrayRef);
        if (this.confirmationFcn != CALLBACK) {
            this.confirmationFcn.dispose();
        }
        this.confirmationFcn = mLArrayRef2;
        this.enabledCallbacks[0] = true;
        this.postPropertyChangedEvent("ConfirmationFcn", this.confirmationFcn);
    }

    public MLArrayRef getConfirmationFcn() {
        return this.confirmationFcn;
    }

    public final void setCreationTime(double d) {
        this.creationTime = d;
    }

    public final double getCreationTime() {
        return this.creationTime;
    }

    public void setDriverData(MLArrayRef mLArrayRef) throws TMException {
        if (this.driverIsHidden()) {
            TMStringUtil.error((String)"There is no 'DriverData' property of device objects.");
        }
        if (this.driverData != USERDATA) {
            this.driverData.dispose();
        }
        this.driverData = mLArrayRef;
    }

    public MLArrayRef getDriverData() throws TMException {
        if (this.driverIsHidden()) {
            TMStringUtil.error((String)"There is no 'DriverData' property of device objects.");
        }
        return this.driverData;
    }

    protected boolean driverIsHidden() {
        return this.driverDataIsVisibleFlag == 0;
    }

    public void setDriverName(String string) throws TMException {
        if (this.getDriverType() == 2) {
            this.driverName = string;
            this.driver.setDriverName(string);
        } else {
            TMStringUtil.throwReadOnlyPropertyError((String)"DriverName");
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setRepCapIdentifier(String string) throws TMException {
        if (this.getDriverType() == 2 || this.getDriverType() == 7 || this.getDriverType() == 1) {
            this.repCapIdentifier = string;
        } else {
            TMStringUtil.error((String)"RepCapIdentifier is only available to IVI-C, IVI-C CLASS or VXIPNP driver");
        }
    }

    public String getRepCapIdentifier() {
        return this.repCapIdentifier;
    }

    public void setDriverType(int n) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"DriverType");
    }

    public int getDriverType() {
        return this.driverType;
    }

    public String getDriverTypeDisplayName() {
        return DRIVER_TYPE_DISPLAY_NAMES[this.driverType];
    }

    public void setInstrumentModel(String string) throws TMException {
        if (this.instrumentModelIsReadOnly) {
            TMStringUtil.error((String)"Changing the 'InstrumentModel' property of device objects is not allowed.");
        }
        this.instrumentModel = string;
        this.driver.setInstrumentModel(string);
        this.postPropertyChangedEvent("InstrumentModel", this.instrumentModel);
    }

    public String getInstrumentModel() {
        if (this.status == 1) {
            this.instrumentModel = this.driver.getInstrumentModel();
        }
        return this.instrumentModel;
    }

    public void setOptionString(String string) throws TMException {
        this.optionString = string;
        this.driver.setOptionString(this.optionString);
    }

    public String getOptionString() {
        return this.optionString;
    }

    public void setInterface(MLArrayRef mLArrayRef) throws TMException {
        if (this.interfaceIsReadOnly) {
            TMStringUtil.error((String)"Changing the 'Interface' property of device objects is not allowed.");
        }
        if (this.interfaceObj != USERDATA) {
            this.interfaceObj.dispose();
        }
        this.interfaceObj = mLArrayRef;
    }

    public MLArrayRef getInterface() {
        return this.interfaceObj;
    }

    public void setJInterface(MLArrayRef mLArrayRef) {
        if (this.interfaceObj != USERDATA) {
            this.interfaceObj.dispose();
        }
        this.interfaceObj = mLArrayRef;
    }

    public void setLogicalName(String string) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"LogicalName");
    }

    public String getLogicalName() {
        if (this.logicalName.equals("")) {
            this.logicalName = this.driver.getLogicalName();
        }
        return this.logicalName;
    }

    public void setName(String string) throws TMException {
        this.name = string;
        this.postPropertyChangedEvent("Name", this.name);
    }

    public String getName() {
        return this.name;
    }

    public final void setObjectVisibility(boolean bl) {
        this.objectVisibility = bl;
        this.postPropertyChangedEvent("ObjectVisibility", this.bool2OnOff(this.objectVisibility));
    }

    public final boolean getObjectVisibility() {
        return this.objectVisibility;
    }

    public final void setRsrcName(String string) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"RsrcName");
    }

    public String getRsrcName() {
        if (this.rsrcName.equals("")) {
            this.rsrcName = this.driver.getRsrcName();
        }
        return this.rsrcName;
    }

    public void setSimulationMode(boolean bl) {
        this.simulationMode = bl;
        this.postPropertyChangedEvent("SimulationMode", this.bool2OnOff(this.simulationMode));
    }

    public boolean getSimulationMode() {
        return this.simulationMode;
    }

    public void setStatus(int n) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"Status");
    }

    public int getStatus() {
        return this.status;
    }

    public void setTag(String string) {
        this.tag = string;
        this.postPropertyChangedEvent("Tag", this.tag);
    }

    public String getTag() {
        return this.tag;
    }

    public void setType(String string) throws TMException {
        TMStringUtil.throwReadOnlyPropertyError((String)"Type");
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = this.driver.getInstrumentType();
        }
        return this.type;
    }

    public void setTimeout(double d) throws TMException {
        this.driver.setTimeout(d);
        this.timeout = d;
        this.postPropertyChangedEvent("Timeout", new Double(this.timeout));
    }

    public double getTimeout() {
        this.timeout = this.driver.getTimeout();
        return this.timeout;
    }

    public void setUserData(MLArrayRef mLArrayRef) {
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
        this.userData = mLArrayRef;
        this.postPropertyChangedEvent("UserData", this.userData);
    }

    public MLArrayRef getUserData() {
        return this.userData;
    }

    public String getDriverVersion() {
        return this.driver.getDriverVersion();
    }

    public String getInstrumentType() {
        return this.driver.getInstrumentType();
    }

    public String getInstrumentManufacturer() {
        return this.driver.getInstrumentManufacturer();
    }

    public void open(String string) throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.status == 1) {
            TMStringUtil.error((String)"OBJ has already been opened.");
        }
        this.instrumentOpen(string.toLowerCase());
        this.status = 1;
        this.postPropertyChangedEvent("Status", "open");
    }

    public void close() throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        this.instrumentClose();
        this.status = 0;
        this.postPropertyChangedEvent("Status", "closed");
    }

    public void dispose() throws TMException {
        if (!this.isvalid()) {
            return;
        }
        this.instrumentClose();
        this.status = 0;
        mlNotifier.cleanupDestroyCallbacks();
        allObjects.removeElement(this);
        if (this.userData != USERDATA) {
            this.userData.dispose();
        }
        if (this.confirmationFcn != CALLBACK) {
            this.confirmationFcn.dispose();
        }
        if (this.interfaceObj != USERDATA) {
            this.interfaceObj.dispose();
        }
        for (int i = 0; i < this.callbackData.length; ++i) {
            if (this.callbackData[i] == null) continue;
            this.callbackData[i].dispose();
        }
        mlNotifier.cleanup();
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(){

            public Object runOnMatlabThread() throws Exception {
                Device.this.instrumentDispose();
                Device.this.postDeviceObjectDeletedEvent();
                Device.this.driver = null;
                Device.this.hwInfoStruct = null;
                Device.access$002(Device.this, null);
                Device.this.callbackData = null;
                Device.this.interfaceObj = null;
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }

    @Override
    public boolean isvalid() {
        return allObjects.contains(this);
    }

    @Override
    public String getInstrumentPropertyHelp(String string) throws TMException {
        return this.driver.getPropertyHelp(this.findPropertyCompleteName(string), TYPE);
    }

    public String getPropertyHelp(String string) throws TMException {
        return PropertyHelp.getHelp(this, string);
    }

    @Override
    public String getInstrumentGroupHelp(String string) throws TMException {
        return this.driver.getGroupHelp(this.findPropertyCompleteName(string));
    }

    public String getError() throws TMException {
        this.verifyObjectState();
        return TMStringUtil.removeTrailingCRLF((String)this.driver.getError());
    }

    public void hwreset() throws TMException {
        this.verifyObjectState();
        this.driver.hwreset();
    }

    public String selftest() throws TMException {
        this.verifyObjectState();
        return this.driver.selftest();
    }

    public void verifyObjectState() throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            TMStringUtil.error((String)"OBJ must be connected to the hardware with CONNECT.");
        }
    }

    public HardwareInfoStruct hwinfo() throws TMException {
        this.hwInfoStruct.setInstrumentManufacturer(this.driver.getInstrumentManufacturer());
        this.hwInfoStruct.setInstrumentModel(this.driver.getHwInstrumentModel());
        this.hwInfoStruct.setInstrumentType(this.driver.getInstrumentType());
        this.hwInfoStruct.setDriverName(this.getPathToDriverName());
        return this.hwInfoStruct;
    }

    public Object[] ObjectHardwareInfo() throws TMException {
        if (this.info != null) {
            return this.info;
        }
        this.hwinfo();
        this.info = new Object[4];
        this.info[0] = this.hwInfoStruct.getInstrumentManufacturer();
        this.info[1] = this.hwInfoStruct.getInstrumentModel();
        this.info[2] = this.hwInfoStruct.getInstrumentType();
        this.info[3] = this.hwInfoStruct.getDriverName();
        return this.info;
    }

    public Object[] ObjectHardwareInfo(String[] stringArray) throws TMException {
        if (this.info == null) {
            this.ObjectHardwareInfo();
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            try {
                n = TMStringUtil.findPropertyCompleteName((String)stringArray[i], (String[])HardwareInfoStruct.HWINFO_FIELDS);
            }
            catch (TMException tMException) {
                throw new TMException("Invalid FieldName: '" + stringArray[i] + "' specified.");
            }
            objectArray[i] = this.info[n];
        }
        return objectArray;
    }

    public Object[] executeMethod(String string) throws TMException {
        return this.executeMethod(string, null);
    }

    public String[] getMethodNames() {
        try {
            return this.driver.getMethods(TYPE);
        }
        catch (TMException tMException) {
            return null;
        }
    }

    @Override
    public boolean isMethod(String string) {
        String[] stringArray = this.getMethodNames();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isDeviceMethod(String string) {
        return this.isMethod(string);
    }

    @Override
    public String getInstrumentMethodHelp(String string) throws TMException {
        return this.driver.getMethodHelp(string, TYPE);
    }

    public String getMethodSignature(String string) throws TMException {
        return this.driver.getMethodSignature(string, TYPE);
    }

    public PropertyInfo[] getPropertyInfo() throws TMException {
        Vector<String> vector = this.getAllProperties();
        PropertyInfo[] propertyInfoArray = new PropertyInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            propertyInfoArray[i] = this.getPropertyInfo(vector.elementAt(i));
        }
        return propertyInfoArray;
    }

    public final Object[] propinfo() throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.objectProps == null) {
            this.objectProps = this.getPropertyInfo();
        }
        this.updateObjectSpecificProperties(this.objectProps);
        return PropertyUtil.propinfo(this, this.objectProps);
    }

    public final Object[] propinfo(String[] stringArray) throws TMException {
        if (!this.isvalid()) {
            TMStringUtil.error((String)"Device object OBJ is an invalid object.");
        }
        if (this.objectProps == null) {
            this.objectProps = this.getPropertyInfo();
        }
        this.updateObjectSpecificProperties(this.objectProps);
        PropertyInfo[] propertyInfoArray = new PropertyInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.findPropertyCompleteName(stringArray[i]);
            propertyInfoArray[i] = this.getPropertyInfoForName(string);
        }
        return PropertyUtil.propinfoWithoutName(this, propertyInfoArray);
    }

    public PropertyInfo getPropertyInfoForName(String string) throws TMException {
        for (int i = 0; i < this.objectProps.length; ++i) {
            if (!this.objectProps[i].getName().equals(string)) continue;
            return this.objectProps[i];
        }
        return null;
    }

    @Override
    public PropertyInfo getPropertyInfo(String string) throws TMException {
        int n = this.getBasePropertyIndex(string);
        if (n != -1) {
            return baseProperties[n];
        }
        return this.getDeviceSpecificPropertyInfo(this.findPropertyCompleteName(string));
    }

    public String findPropertyCompleteName(String string) throws TMException {
        try {
            String[] stringArray = TMStringUtil.vector2StringArray(this.getAllPropertiesPlusHidden());
            int n = TMStringUtil.findPropertyCompleteName((String)string, (String[])stringArray);
            return stringArray[n];
        }
        catch (TMException tMException) {
            if (tMException.getMessage().endsWith("unique")) {
                throw new TMException("The '" + string + "' property name is ambiguous for device objects.");
            }
            throw new TMException("There is no '" + string + "' property for device objects.");
        }
    }

    public static PropertyInfo[] getBasePropertyInfo() {
        return baseProperties;
    }

    @Override
    public Vector<String> getProperties() {
        return this.getDeviceSpecificProperties();
    }

    @Override
    public Vector<String> getAllProperties() throws TMException {
        Vector<String> vector = this.getBasePropertyNames();
        Vector<String> vector2 = this.getProperties();
        if (vector2 == null) {
            return vector;
        }
        return TMStringUtil.sort(vector2, vector);
    }

    public Vector<String> getAllPropertiesPlusHidden() throws TMException {
        Vector<String> vector = this.getAllBasePropertyNames();
        Vector<String> vector2 = this.getProperties();
        return TMStringUtil.sort(vector2, vector);
    }

    @Override
    public Vector<String> getBasePropertyNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < baseProperties.length; ++i) {
            if (Device.baseProperties[i].hidden != 0 || this.getDriverType() != 7 && this.getDriverType() != 2 && this.getDriverType() != 1 && Device.baseProperties[i].name.equalsIgnoreCase("RepCapIdentifier")) continue;
            vector.addElement(Device.baseProperties[i].name);
        }
        return vector;
    }

    public Vector<String> getAllBasePropertyNames() {
        return this.getAllBasePropertyNames(false);
    }

    public Vector<String> getAllBasePropertyNames(boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < baseProperties.length; ++i) {
            if (bl) {
                vector.addElement(Device.baseProperties[i].name.toLowerCase());
                continue;
            }
            vector.addElement(Device.baseProperties[i].name);
        }
        return vector;
    }

    @Override
    public boolean isBaseProperty(String string) {
        try {
            string = this.findPropertyCompleteName(string);
            return this.getAllBasePropertyNames().indexOf(string) != -1;
        }
        catch (TMException tMException) {
            return false;
        }
    }

    public int getBasePropertyIndex(String string) {
        try {
            string = this.findPropertyCompleteName(string);
            return this.getAllBasePropertyNames(true).indexOf(string.toLowerCase());
        }
        catch (TMException tMException) {
            return -1;
        }
    }

    @Override
    public boolean isGroupProperty(String string) {
        Vector<String> vector = this.getPropertyGroups();
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).toLowerCase().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String[] getPropertyNames() throws TMException {
        return PropertyUtil.getPropertyNames(this);
    }

    public final int[] isInterfaceSpecific() throws TMException {
        return PropertyUtil.isInterfaceSpecific(this);
    }

    public final String setDisplay() throws TMException {
        return Displays.setDisplay(this);
    }

    public final Object createPropSetArray(String string) throws TMException {
        return PropertyUtil.createPropSetArray(this, string);
    }

    public final String createPropSetDisplay(String[] stringArray) throws TMException {
        return PropertyUtil.createPropSetDisplay(this, stringArray);
    }

    @Override
    public Object[] getValidRange(String string) {
        return this.driver.getValidRange(string, TYPE);
    }

    @Override
    public int getNumberOfEnums(String string) {
        return this.driver.getNumberOfEnums(string, TYPE);
    }

    @Override
    public String getSetList(String string) {
        return this.driver.getSetList(string, TYPE);
    }

    public void executeEvent(int n, Object object) {
        this.executeEvent(this, n, object);
    }

    public void executeEvent(Object object, int n, Object object2) {
        if (!this.enabledCallbacks[n]) {
            return;
        }
        if (this.callbackType[n] == 0) {
            this.matlabMCR.whenMatlabReady((Runnable)new CallbackQueue(object, n, this.evalString[n], object2));
        } else {
            this.matlabMCR.whenMatlabReady((Runnable)new CallbackQueue(object, n, this.callbackData[n], object2));
        }
    }

    public void executeConfirmationEvent(Calendar calendar, String string, Object object, Object object2) {
        this.executeConfirmationEvent(this, calendar, string, object, object2);
    }

    public void executeConfirmationEvent(Object object, Calendar calendar, String string, Object object2, Object object3) {
        if (!this.confirmationFcn.equals(CALLBACK)) {
            this.executeEvent(0, new Event("Confirmation", MLNotifier.constructClockVector(calendar), string, object2, object3));
        }
    }

    public static void addDeviceObjectListener(DeviceObjectListener deviceObjectListener) {
        if (listeners == null) {
            listeners = new Vector();
        }
        if (!listeners.contains(deviceObjectListener)) {
            listeners.addElement(deviceObjectListener);
        }
    }

    public static Vector<DeviceObjectListener> getListeners() {
        return listeners;
    }

    public static void addPropertyChangedListener(PropertyChangedListener propertyChangedListener) {
        if (propertyChangedListeners == null) {
            propertyChangedListeners = new Vector();
        }
        if (!propertyChangedListeners.contains(propertyChangedListener)) {
            propertyChangedListeners.addElement(propertyChangedListener);
        }
    }

    public static Vector<PropertyChangedListener> getPropertyListeners() {
        return propertyChangedListeners;
    }

    public static void removeDeviceObjectListener(DeviceObjectListener deviceObjectListener) {
        if (listeners == null) {
            return;
        }
        listeners.removeElement(deviceObjectListener);
        deviceObjectListener = null;
    }

    public static void removePropertyChangedListener(PropertyChangedListener propertyChangedListener) {
        if (propertyChangedListeners == null) {
            return;
        }
        propertyChangedListeners.removeElement(propertyChangedListener);
        propertyChangedListener = null;
    }

    public void postDeviceObjectAddedEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    DeviceObjectListener deviceObjectListener = listeners.elementAt(i);
                    deviceObjectListener.deviceObjectAdded(this, this.getType());
                }
            }
            this.objectCreatedNotification();
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Device.this.postDeviceObjectAddedEvent();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void postDeviceObjectDeletedEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    DeviceObjectListener deviceObjectListener = listeners.elementAt(i);
                    deviceObjectListener.deviceObjectDeleted(this, this.getType());
                }
            }
            this.objectDeletedNotification();
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Device.this.postDeviceObjectDeletedEvent();
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void postPropertyChangedEvent(String string, Object object) {
        this.postPropertyChangedEvent(this, string, object);
    }

    public void postPropertyChangedEvent(final Object object, final String string, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (propertyChangedListeners != null) {
                for (int i = 0; i < propertyChangedListeners.size(); ++i) {
                    PropertyChangedListener propertyChangedListener = propertyChangedListeners.elementAt(i);
                    propertyChangedListener.propertyChanged(object, string, object2);
                }
            }
            this.propertyChangedNotification(object, string, object2);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Device.this.postPropertyChangedEvent(object, string, object2);
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void objectCreatedNotification() {
        this.enabledCallbacks[3] = true;
        mlNotifier.objectCreatedNotification(this, 3, Calendar.getInstance(), this.matlabMCR);
    }

    private void objectDeletedNotification() {
        this.enabledCallbacks[4] = true;
        mlNotifier.objectDeletedNotification(this, 4, Calendar.getInstance(), this.matlabMCR);
    }

    private void propertyChangedNotification(Object object, String string, Object object2) {
        this.enabledCallbacks[2] = true;
        mlNotifier.propertyChangedNotification(object, 2, string, object2, Calendar.getInstance(), this.matlabMCR);
    }

    public static Vector<DeviceClient> jinstrfind() {
        return allObjects;
    }

    public static final Vector<DeviceClient> getNonLockedObjects() {
        Vector<DeviceClient> vector = new Vector<DeviceClient>();
        for (int i = 0; i < allObjects.size(); ++i) {
            if (!((Device)Device.allObjects.elementAt((int)i)).objectVisibility) continue;
            vector.addElement(allObjects.elementAt(i));
        }
        return vector;
    }

    public static final Vector<DeviceClient> jinstrfindall() {
        return allObjects;
    }

    protected String removeExtension(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    protected final MLArrayRef verifyCallbackValue(String string, int n, MLArrayRef mLArrayRef) throws TMException {
        int n2 = mLArrayRef.getType();
        if (n2 != 1 && n2 != 4 && n2 != 16) {
            TMStringUtil.error((String)(string + ErrorMessages.INVALIDCALLBACK));
        }
        if (mLArrayRef.getM() == 0 && mLArrayRef.getN() == 0) {
            if (n2 == 1) {
                TMStringUtil.error((String)(string + ErrorMessages.INVALIDCALLBACK));
            }
            return CALLBACK;
        }
        if (mLArrayRef.getM() != 1) {
            TMStringUtil.error((String)(string + ErrorMessages.INVALIDCALLBACK));
        }
        if (n2 == 1) {
            MLArrayRef mLArrayRef2 = mLArrayRef.cellInfoAt(0);
            if (mLArrayRef2.getType() != 4 && mLArrayRef2.getType() != 16) {
                mLArrayRef2.dispose();
                TMStringUtil.error((String)(string + ErrorMessages.INVALIDCALLBACK));
            }
            if (mLArrayRef2.getM() == 0 && mLArrayRef2.getN() == 0) {
                mLArrayRef2.dispose();
                TMStringUtil.error((String)(string + ErrorMessages.INVALIDCALLBACK));
            }
            mLArrayRef2.dispose();
        }
        if (n2 == 4) {
            this.callbackType[n] = 0;
            this.evalString[n] = (String)mLArrayRef.getData();
        } else {
            this.callbackType[n] = 1;
            this.callbackData[n] = mLArrayRef;
        }
        return mLArrayRef;
    }

    protected final String bool2OnOff(boolean bl) {
        if (bl) {
            return "on";
        }
        return "off";
    }

    public abstract void instrumentOpen(String var1) throws TMException;

    public abstract void instrumentClose() throws TMException;

    public abstract void instrumentDispose() throws TMException;

    public abstract String getConstructor();

    public abstract String getPathToDriverName();

    public abstract void updateObjectSpecificProperties(PropertyInfo[] var1);

    public abstract Vector<String> getDeviceSpecificProperties();

    public abstract PropertyInfo getDeviceSpecificPropertyInfo(String var1);

    public abstract Object[] executeMethod(String var1, Object[] var2) throws TMException;

    public abstract Vector<String> getPropertyGroups();

    static /* synthetic */ Object[] access$002(Device device, Object[] objectArray) {
        device.info = objectArray;
        return objectArray;
    }

    static {
        boolVals = new String[]{"on", "off"};
        RModeVals = new String[]{"overwrite", "append", "index"};
        StatVals = new String[]{"open", "closed"};
        baseProperties = new PropertyInfo[]{new PropertyInfo("ConfirmationFcn", "callback", "callback", "", "", "never", 0, 0), new PropertyInfo("DriverData", "any", "none", "", null, "always", 0, 1), new PropertyInfo("CreationTime", "double", "double", "", "", "never", 0, 1), new PropertyInfo("DriverType", "string", "none", "", "", "always", 0, 0), new PropertyInfo("InstrumentModel", "string", "none", "", "", "always", 0, 0), new PropertyInfo("Interface", "object", "object", "", null, "always", 0, 0), new PropertyInfo("DriverName", "string", "none", "", "", "always", 0, 0), new PropertyInfo("LogicalName", "string", "none", "", "", "always", 0, 0), new PropertyInfo("Name", "string", "none", "", "", "never", 0, 0), new PropertyInfo("ObjectVisibility", "string", "enum", boolVals, "on", "never", 0, 0), new PropertyInfo("RsrcName", "string", "none", "", "", "always", 0, 0), new PropertyInfo("Status", "string", "enum", StatVals, "closed", "always", 0, 0), new PropertyInfo("Tag", "string", "none", "", "", "never", 0, 0), new PropertyInfo("Timeout", "double", "none", null, new Integer(10), "never", 0, 0), new PropertyInfo("Type", "string", "none", "", "", "always", 0, 0), new PropertyInfo("UserData", "any", "none", null, null, "never", 0, 0), new PropertyInfo("RepCapIdentifier", "string", "none", "", "", "always", 0, 0)};
    }
}

