/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers;

import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.drivers.ExternalDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.testmeas.util.TMException;

public class COMDriver
extends ExternalDriver {
    protected UDDObject comMLObject = null;
    protected MLArrayRef comMLArrayRef = null;
    protected boolean isOpen = false;

    public COMDriver(Parser parser, String string, UDDObject uDDObject) throws TMException {
        super(parser, string);
        this.comMLObject = uDDObject;
        this.comMLObject.acquireReference();
        this.comMLArrayRef = this.initRefWithObject(this.comMLObject);
        this.itrArgs[2] = this.comMLArrayRef;
    }

    @Override
    protected void validateDriverType() throws TMException {
        if (this.xmlParser.getDriverTypeId() != 5) {
            throw new TMException("The driver must be a MATLAB COM instrument driver.");
        }
    }

    @Override
    public Object[] defineConstructorArgs() {
        Object[] objectArray = new Object[]{this.driverName};
        return objectArray;
    }

    @Override
    public String defineConstructor() {
        return "icdevice('" + this.driverName + "');";
    }

    @Override
    public String defineConstructorDescription() {
        return "ProgID - " + this.driverName;
    }

    @Override
    public int defineDriverType() {
        return 3;
    }

    @Override
    public void setDeviceObject(MLArrayRef mLArrayRef) {
        super.setDeviceObject(mLArrayRef);
        this.itrArgs[2] = this.comMLArrayRef;
    }

    @Override
    public int getStatusBasedOnInterface() {
        if (this.isOpen) {
            return 1;
        }
        return 0;
    }

    @Override
    public void open() throws TMException {
        this.isOpen = true;
    }

    @Override
    public void close() throws TMException {
        this.isOpen = false;
    }

    @Override
    public void dispose() throws TMException {
        this.deviceMLObject.dispose();
        this.comMLObject.releaseReference();
        if (this.comMLArrayRef != Device.USERDATA) {
            this.comMLArrayRef.dispose();
        }
    }

    public MLArrayRef getInterfaceObject() {
        return this.comMLArrayRef;
    }

    @Override
    public String getInterfaceConstructor() {
        return "actxserver(" + this.driverName + ")";
    }
}

