/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.mwid;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.MethodDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.XMLDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class MWIDDriver
extends XMLDriver
implements InstrumentDriver,
Runnable {
    protected InstrumentAsync instrumentObject;
    protected MLArrayRef MATLABObject;
    protected MLArrayRef deviceMLObject = null;
    protected ICDevice deviceObject;
    private String logicalName = "";
    private Object[] getArgs = new Object[]{"privateEvaluateGetCode", "", "", "", "", ""};
    private Object[] setArgs = new Object[]{"privateEvaluateSetCode", "", "", "", "", "", ""};

    public MWIDDriver(String string) throws TMException {
        this.xmlParser = new Parser(string);
        this.xmlParser.setWarnState(false);
        this.xmlParser.parse();
        this.xmlParser.setWarnState(true);
        this.driverNameWithPath = string;
        this.driverName = this.parseDriverName(string);
        if (!this.xmlParser.getDriverType().equals(Device.DRIVER_TYPE_NAMES[0])) {
            throw new TMException("The driver must be a MATLAB interface instrument driver.");
        }
    }

    public MWIDDriver(String string, Instrument instrument, MLArrayRef mLArrayRef) throws TMException {
        this(string);
        this.instrumentObject = (InstrumentAsync)instrument;
        this.MATLABObject = mLArrayRef;
    }

    @Override
    public void setJDeviceObject(Device device) {
        this.deviceObject = (ICDevice)device;
        this.instrumentObject.setDeviceObject(this.deviceObject);
    }

    @Override
    public void setDeviceObject(MLArrayRef mLArrayRef) {
        if (this.deviceMLObject != null) {
            this.deviceMLObject.dispose();
        }
        this.deviceMLObject = mLArrayRef;
        if (this.getArgs[1] instanceof MLArrayRef) {
            ((MLArrayRef)this.getArgs[1]).dispose();
            this.getArgs[1] = null;
        }
        if (this.setArgs[1] instanceof MLArrayRef) {
            ((MLArrayRef)this.setArgs[1]).dispose();
            this.setArgs[1] = null;
        }
        this.getArgs[1] = this.deviceMLObject;
        this.setArgs[1] = this.deviceMLObject;
    }

    @Override
    public Object[] defineConstructorArgs() {
        Object[] objectArray = new Object[]{this.driverNameWithPath, this.MATLABObject};
        return objectArray;
    }

    @Override
    public String defineConstructor() {
        return "icdevice('" + this.driverName + "', HWOBJ);";
    }

    @Override
    public String defineConstructorDescription() {
        return "Driver - " + this.driverName + ", " + this.getInterfaceObject().getConstructorDescription();
    }

    @Override
    public int getStatusBasedOnInterface() {
        return this.instrumentObject.getStatus();
    }

    @Override
    public int defineDriverType() {
        return 0;
    }

    @Override
    public void open() throws TMException {
        this.instrumentObject.fopen();
        Vector<String> vector = this.xmlParser.getConnectInitVector();
        for (int i = 0; i < vector.size(); ++i) {
            this.write(vector.elementAt(i));
        }
    }

    @Override
    public void close() throws TMException {
        Vector<String> vector = this.xmlParser.getCleanupVector();
        for (int i = 0; i < vector.size(); ++i) {
            this.write(vector.elementAt(i));
        }
        this.instrumentObject.fclose();
    }

    @Override
    public void dispose() throws TMException {
        int n;
        this.instrumentObject.removeDeviceObject(this.deviceObject);
        if (this.MATLABObject != null) {
            this.MATLABObject.dispose();
        }
        if (this.deviceMLObject != null) {
            this.deviceMLObject.dispose();
        }
        this.xmlParser.dispose();
        if (this.getArgs[1] instanceof MLArrayRef) {
            ((MLArrayRef)this.getArgs[1]).dispose();
        }
        if (this.setArgs[1] instanceof MLArrayRef) {
            ((MLArrayRef)this.setArgs[1]).dispose();
        }
        for (n = 0; n < this.getArgs.length; ++n) {
            this.getArgs[n] = null;
        }
        for (n = 0; n < this.setArgs.length; ++n) {
            this.setArgs[n] = null;
        }
        this.instrumentObject = null;
        this.deviceObject = null;
        this.xmlParser = null;
        this.getArgs = null;
        this.setArgs = null;
    }

    @Override
    public void setTimeout(double d) throws TMException {
        this.instrumentObject.setTimeout(d);
    }

    @Override
    public double getTimeout() {
        return this.instrumentObject.getTimeout();
    }

    @Override
    public String getInterfaceConstructor() {
        return this.instrumentObject.getConstructor();
    }

    public Instrument getInterfaceObject() {
        return this.instrumentObject;
    }

    @Override
    public String getError() throws TMException {
        String string = this.xmlParser.getErrorCommand();
        if (string.equals("")) {
            TMStringUtil.error((String)"The error command is not defined.");
            return "";
        }
        return this.query(string);
    }

    @Override
    public void hwreset() throws TMException {
        String string = this.xmlParser.getResetCommand();
        if (string.equals("")) {
            TMStringUtil.error((String)"The reset command is not defined.");
        }
        this.write(string);
    }

    @Override
    public String selftest() throws TMException {
        String string = this.xmlParser.getSelfTestCommand();
        if (string.equals("")) {
            TMStringUtil.error((String)"The selftest command is not defined.");
            return "";
        }
        return this.query(string);
    }

    @Override
    public String getInstrumentModel() {
        String string = this.xmlParser.getIdentifyCommand();
        if (string.equals("")) {
            return "";
        }
        try {
            return TMStringUtil.removeTrailingCRLF((String)this.query(string));
        }
        catch (TMException tMException) {
            return "";
        }
    }

    @Override
    public void setInstrumentModel(String string) throws TMException {
        TMStringUtil.error((String)"Changing the 'InstrumentModel' property of device objects is not allowed.");
    }

    @Override
    public String getLogicalName() {
        if (!this.logicalName.equals("")) {
            return this.logicalName;
        }
        try {
            String[] stringArray = new String[]{"Name"};
            Object[] objectArray = this.instrumentObject.propinfo(stringArray);
            Object[] objectArray2 = (Object[])objectArray[0];
            this.logicalName = (String)objectArray2[3];
            return this.logicalName;
        }
        catch (TMException tMException) {
            return "";
        }
    }

    @Override
    public String getRsrcName() {
        return "";
    }

    @Override
    public Object[] executeMethod(String string, String string2, Object[] objectArray) throws TMException {
        this.currentChannelIndex = -1;
        MethodDefinition methodDefinition = this.getMethodDefinition(string, string2);
        this.verifyMethodInputs(methodDefinition, objectArray);
        return this.executeMethod(methodDefinition, objectArray);
    }

    @Override
    public Object[] executeMethod(String string, String string2, Object[] objectArray, int n) throws TMException {
        String string3;
        this.currentChannelIndex = n;
        MethodDefinition methodDefinition = this.getMethodDefinition(string, string2);
        this.verifyMethodInputs(methodDefinition, objectArray);
        String string4 = methodDefinition.getLocation();
        if (this.xmlParser.isPropertyGroup(string4) && !(string3 = this.xmlParser.getGroupConfigureCommand(string4, n)).equals("")) {
            this.write(string3);
        }
        return this.executeMethod(methodDefinition, objectArray);
    }

    private Object[] executeMethod(MethodDefinition methodDefinition, Object[] objectArray) throws TMException {
        Object[] objectArray2 = new Object[methodDefinition.getNumberOfOutputCommands()];
        int n = 0;
        for (int i = 0; i < methodDefinition.getNumberOfCommands(); ++i) {
            String string = methodDefinition.getCommand(i, objectArray);
            if (this.currentChannelIndex != -1) {
                string = this.xmlParser.substituteMappingInCommand(methodDefinition.getLocation(), string, this.currentChannelIndex);
            }
            if (methodDefinition.hasOutput(i)) {
                this.write(string);
                String string2 = methodDefinition.getTypeOfOutputRead(i).toLowerCase();
                String string3 = methodDefinition.getOutputFormat(i).toLowerCase();
                if (string2.equals("ascii")) {
                    objectArray2[n++] = this.readAscii(string3);
                    continue;
                }
                if (string2.equals("binary")) {
                    objectArray2[n++] = this.readBinary(string3);
                    continue;
                }
                if (!string2.equals("binblock")) continue;
                objectArray2[n++] = this.readBinblock(string3);
                continue;
            }
            this.write(string);
        }
        return objectArray2;
    }

    /*
     * Loose catch block
     */
    private Object readAscii(String string) throws TMException {
        String string2;
        block5: {
            Object[] objectArray = this.instrumentObject.fgetl();
            string2 = (String)objectArray[0];
            if (!string.equals("text")) break block5;
            return TMStringUtil.removeTrailingCRLF((String)string2);
            {
                catch (Exception exception) {
                    throw new TMException(exception.getMessage());
                }
            }
        }
        try {
            return new Double(TMStringUtil.str2double((String)string2));
        }
        catch (Exception exception) {
            return TMStringUtil.removeTrailingCRLF((String)string2);
        }
    }

    private Object readBinary(String string) throws TMException {
        Object[] objectArray = this.convertFormatToType(string);
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        Object[] objectArray2 = new Object[2];
        try {
            Object[] objectArray3 = this.instrumentObject.fread(this.instrumentObject.getInputBufferSize() - this.instrumentObject.getBytesAvailable(), n, n2);
            objectArray2[0] = objectArray3[0];
            objectArray2[1] = string;
            return objectArray2;
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
    }

    private Object readBinblock(String string) throws TMException {
        Object[] objectArray = this.convertFormatToType(string);
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        Object[] objectArray2 = new Object[2];
        try {
            Object[] objectArray3 = this.instrumentObject.binblockread(n, n2);
            objectArray2[0] = objectArray3[0];
            objectArray2[1] = string;
            return objectArray2;
        }
        catch (Exception exception) {
            throw new TMException(exception.getMessage());
        }
    }

    private Object[] convertFormatToType(String string) {
        int n = 0;
        int n2 = 0;
        if (string.equals("uchar") || string.equals("char")) {
            n = 5;
            n2 = 0;
        } else if (string.equals("schar")) {
            n = 5;
            n2 = 1;
        } else if (string.equals("int8")) {
            n = 0;
            n2 = 1;
        } else if (string.equals("short") || string.equals("int16")) {
            n = 1;
            n2 = 1;
        } else if (string.equals("int32") || string.equals("int") || string.equals("long")) {
            n = 2;
            n2 = 1;
        } else if (string.equals("uint8")) {
            n = 0;
            n2 = 0;
        } else if (string.equals("uint16") || string.equals("ushort")) {
            n = 1;
            n2 = 0;
        } else if (string.equals("uint32") || string.equals("uint") || string.equals("ulong")) {
            n = 2;
            n2 = 0;
        } else if (string.equals("single") || string.equals("float32") || string.equals("float")) {
            n = 3;
            n2 = 1;
        } else if (string.equals("double") || string.equals("float64")) {
            n = 4;
            n2 = 1;
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return objectArray;
    }

    private void verifyMethodInputs(MethodDefinition methodDefinition, Object[] objectArray) throws TMException {
        int n = 0;
        if (objectArray != null) {
            n = objectArray.length;
        }
        if (n > methodDefinition.getNumberOfInputs()) {
            TMStringUtil.error((String)"Too many input arguments.");
        } else if (n < methodDefinition.getNumberOfInputs()) {
            Vector<String> vector = methodDefinition.getRawInputs();
            String string = "";
            for (int i = n; i < vector.size(); ++i) {
                string = string + vector.elementAt(i).toUpperCase() + ", ";
            }
            TMStringUtil.error((String)(string.substring(0, string.length() - 2) + " must be specified."));
        }
    }

    @Override
    public void setProperty(String string, String string2, Object object, int n) throws TMException {
        this.currentChannelIndex = n;
        this.setPropertyValue(string, string2, object);
    }

    @Override
    public void setProperty(String string, String string2, Object object) throws TMException {
        this.currentChannelIndex = -1;
        this.setPropertyValue(string, string2, object);
    }

    @Override
    public Object getProperty(String string, String string2, int n) throws TMException {
        this.currentChannelIndex = n;
        return this.getPropertyValue(string, string2);
    }

    @Override
    public Object getProperty(String string, String string2) throws TMException {
        this.currentChannelIndex = -1;
        return this.getPropertyValue(string, string2);
    }

    public void setPropertyValue(String string, String string2, Object object) throws TMException {
        String string3;
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        if (!propertyDefinition.isValidValue(object, string2, this)) {
            TMStringUtil.error((String)propertyDefinition.getErrorMessage(this));
        }
        object = propertyDefinition.getValidValue(object);
        if (this.currentChannelIndex == -1) {
            propertyDefinition.setCurrentValue(object);
        } else {
            propertyDefinition.setCurrentValue(object, this.currentChannelIndex);
        }
        String string4 = propertyDefinition.getLocation();
        if (this.xmlParser.isPropertyGroup(string4) && !(string3 = this.xmlParser.getGroupConfigureCommand(string4, this.currentChannelIndex)).equals("")) {
            this.write(string3);
        }
        if (propertyDefinition.isPropertyTypeMCode()) {
            this.setPropertyValueFromMCode(propertyDefinition, object, string4);
            return;
        }
        string3 = this.getCommandToConfigureHardware(string, string2);
        if (string3.indexOf("%s") == -1) {
            this.write(string3 + " " + object);
        } else {
            this.write(TMStringUtil.strrep((String)string3, (String)"%s", (String)((String)object)));
        }
    }

    private void setPropertyValueFromMCode(PropertyDefinition propertyDefinition, Object object, String string) throws TMException {
        this.setArgs[2] = propertyDefinition.getName();
        this.setArgs[3] = object;
        this.setArgs[4] = propertyDefinition.getSetMCodeToEvaluate();
        this.setArgs[5] = new Integer(this.currentChannelIndex);
        this.setArgs[6] = string;
        this.deviceObject.willExecuteDriverPropertyCode();
        if (!NativeMatlab.nativeIsMatlabThread()) {
            this.matlabMCR.whenMatlabReady((Runnable)this);
            return;
        }
        try {
            MatlabMCR.mtFeval((String)"instrgate", (Object[])this.setArgs, (int)0);
        }
        catch (Exception exception) {
            this.deviceObject.didExecuteDriverPropertyCode();
            throw new TMException(exception.getMessage());
        }
        this.deviceObject.didExecuteDriverPropertyCode();
    }

    @Override
    public void run() {
        try {
            MatlabMCR.mtFeval((String)"instrgate", (Object[])this.setArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public Object getPropertyValue(String string, String string2) throws TMException {
        Object object;
        Object object2;
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        String string3 = propertyDefinition.getLocation();
        if (this.xmlParser.isPropertyGroup(string3) && !((String)(object2 = this.xmlParser.getGroupConfigureCommand(string3, this.currentChannelIndex))).equals("")) {
            this.write((String)object2);
        }
        if (propertyDefinition.isPropertyTypeMCode()) {
            object = this.getPropertyValueFromMCode(propertyDefinition, string3);
        } else {
            object2 = this.getCommandToQueryHardware(string, string2);
            object = this.query((String)object2);
        }
        if (object instanceof double[]) {
            object2 = (double[])object;
            if (object2 == null || ((Object)object2).length == 0) {
                return new Double(0.0);
            }
            object = new Double((double)object2[0]);
        } else if (object instanceof boolean[]) {
            object2 = (boolean[])object;
            object = ((Boolean)(object = new Boolean((boolean)object2[0]))).booleanValue() ? "on" : "off";
        } else if (object instanceof String && (object2 = propertyDefinition.getOutputValue((String)object)) != null) {
            object = object2;
        }
        if (this.currentChannelIndex == -1) {
            propertyDefinition.setCurrentValue(object);
        } else {
            propertyDefinition.setCurrentValue(object, this.currentChannelIndex);
        }
        return object;
    }

    private Object getPropertyValueFromMCode(PropertyDefinition propertyDefinition, String string) throws TMException {
        this.getArgs[2] = propertyDefinition.getName();
        this.getArgs[3] = propertyDefinition.getGetMCodeToEvaluate();
        this.getArgs[4] = new Integer(this.currentChannelIndex);
        this.getArgs[5] = string;
        Object object = null;
        this.deviceObject.willExecuteDriverPropertyCode();
        try {
            object = MatlabMCR.mtFeval((String)"instrgate", (Object[])this.getArgs, (int)1);
        }
        catch (Exception exception) {
            this.deviceObject.didExecuteDriverPropertyCode();
            throw new TMException(exception.getMessage());
        }
        this.deviceObject.didExecuteDriverPropertyCode();
        return object;
    }

    @Override
    public boolean isValidConstraint(String string, String string2, String string3) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        if (this.instrumentObject.getStatus() == 0) {
            return propertyDefinition.getCurrentValue().equals(propertyDefinition.getOutputValue(string3));
        }
        try {
            Object object = this.getPropertyValue(string, string2);
            Object object2 = propertyDefinition.getOutputValue(string3);
            return object.equals(object2);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (TMException tMException) {
            return false;
        }
    }

    public void write(String string) throws TMException {
        try {
            Object[] objectArray = new Object[]{string, new Integer(-1)};
            this.instrumentObject.fprintf(objectArray, 0);
        }
        catch (Exception exception) {
            TMStringUtil.error((String)exception.getMessage());
        }
    }

    public String query(String string) throws TMException {
        try {
            Object[] objectArray = new Object[]{string, new Integer(-1)};
            Object[] objectArray2 = this.instrumentObject.query(objectArray);
            String string2 = (String)objectArray2[0];
            string2 = string2.replace("\r", "").replace("\n", "");
            return string2;
        }
        catch (Exception exception) {
            TMStringUtil.error((String)exception.getMessage());
            return null;
        }
    }
}

