/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp;

import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;

public class VXIPnPHeaderParser {
    private Hashtable<String, Integer> attrbuteIDTable = null;
    private String fileName = "";
    private FileReader fr = null;
    private BufferedReader br = null;
    private String line = null;
    private String[] tokens = null;

    public VXIPnPHeaderParser(String string) {
        this.fileName = string;
        this.attrbuteIDTable = new Hashtable();
        this.buildIVIClassCompliantIDAttribute();
        this.buildVendorIDAttributes();
    }

    public void parse() throws TMException {
        try {
            this.fr = new FileReader(this.fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TMException("File not found");
        }
        this.br = new BufferedReader(this.fr);
        try {
            while ((this.line = this.br.readLine()) != null) {
                this.processLine(this.line);
            }
        }
        catch (Exception exception) {
            throw new TMException("Failed to parse driver header file");
        }
    }

    private void processLine(String string) throws TMException {
        if (!this.isAttributeLine(string)) {
            return;
        }
        if (!this.getAttributeID()) {
            this.calculateAttributeID();
        }
    }

    public void calculateAttributeID() throws TMException {
        String string = "";
        int n = 0;
        String string2 = "";
        string2 = this.tokens[1];
        if (this.tokens.length == 3 && this.tokens[2].length() > 0 || this.tokens.length >= 3 && this.tokens[3].equals("//")) {
            string = this.tokens[2];
            string = string.replace('(', ' ');
            string = string.replace(')', ' ');
            n = this.getAtttributeID(string = string.trim());
            if (n == 0) {
                TMStringUtil.warning((String)("Can not retrieve attribute : " + string2 + "'s ID value"));
            }
            this.attrbuteIDTable.put(string2, n);
            return;
        }
        if (this.tokens.length >= 4 && this.tokens[3].equals("+")) {
            int n2;
            string = this.tokens[2];
            string = string.replace('(', ' ');
            n = this.getAtttributeID(string = string.trim());
            if (n == 0) {
                TMStringUtil.warning((String)("Can not retrieve attribute : " + string2 + "'s ID value"));
            }
            if (n < 0) {
                TMStringUtil.warning((String)("Can't find the attribute ID value for " + string2.toUpperCase() + " because " + string + " ID is not available"));
                this.attrbuteIDTable.put(string2, 0);
                return;
            }
            String string3 = "";
            for (n2 = 0; n2 < this.tokens[4].length(); ++n2) {
                if (!Character.isDigit(this.tokens[4].charAt(n2))) continue;
                string3 = string3 + this.tokens[4].charAt(n2);
            }
            try {
                n2 = Integer.parseInt(string3) + n;
                this.attrbuteIDTable.put(string2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TMException("failed to parse attribute " + string2 + " 's ID");
            }
        } else {
            TMStringUtil.warning((String)("Can not retrieve attribute : " + string2 + "'s ID value"));
        }
    }

    public boolean getAttributeID() {
        int n = 0;
        try {
            n = this.tokens[2].indexOf("0x") >= 0 ? Integer.parseInt(this.tokens[2].substring(2), 16) : Integer.parseInt(this.tokens[2]);
            this.attrbuteIDTable.put(this.tokens[1], n);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean isAttributeLine(String string) {
        if (string.length() <= 7) {
            return false;
        }
        if (!string.substring(0, 7).equals("#define")) {
            return false;
        }
        int n = string.indexOf("/*");
        if (n > 0) {
            string = string.substring(0, n - 1);
        }
        this.tokens = string.trim().split("\\s+");
        if (this.tokens.length < 3) {
            return false;
        }
        if (this.tokens[1].indexOf("_ATTR_") > 0) {
            String[] stringArray = null;
            stringArray = this.tokens[1].split("_");
            if (stringArray[1].equals("ATTR")) {
                return true;
            }
        }
        return false;
    }

    public int getAtttributeID(String string) {
        int n = 0;
        try {
            n = this.attrbuteIDTable.get(string.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private void buildVendorIDAttributes() {
        this.buildRSAttributes();
    }

    private void buildIVIClassCompliantIDAttribute() {
        this.buildIVIIDAttribute();
        this.buildIVIScopeIDAttribute();
        this.buildIVISwtchIDAttribute();
        this.buildIVIDmmIDAttribute();
        this.buildIVIDCPwrIDAttribute();
        this.buildIVIFgenIDAttribute();
        this.buildIVIRFSigGenIDAttribute();
        this.buildIVISpecAnIDAttribute();
        this.buildIVILxiSyncIDAttribute();
        this.buildIVIPwrMeterIDAttribute();
    }

    private void buildIVIIDAttribute() {
        this.attrbuteIDTable.put("IVI_ATTR_BASE", 1000000);
        this.attrbuteIDTable.put("IVI_ENGINE_PRIVATE_ATTR_BASE", 1000000);
        this.attrbuteIDTable.put("IVI_ENGINE_PUBLIC_ATTR_BASE", 1050000);
        this.attrbuteIDTable.put("IVI_INHERENT_ATTR_BASE", 1050000);
        this.attrbuteIDTable.put("IVI_SPECIFIC_PRIVATE_ATTR_BASE", 1100000);
        this.attrbuteIDTable.put("IVI_SPECIFIC_PUBLIC_ATTR_BASE", 1150000);
        this.attrbuteIDTable.put("IVI_SPECIFIC_ATTR_BASE", 1150000);
        this.attrbuteIDTable.put("IVI_CLASS_PRIVATE_ATTR_BASE", 1200000);
        this.attrbuteIDTable.put("IVI_CLASS_PUBLIC_ATTR_BASE", 1250000);
        this.attrbuteIDTable.put("IVI_CLASS_ATTR_BASE", 1250000);
        this.attrbuteIDTable.put("IVI_LXISYNC_ATTR_BASE", 1950000);
        this.attrbuteIDTable.put("IVI_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVI_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVI_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVI_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVI_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVI_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVI_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVI_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVI_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVI_ATTR_DEFER_UPDATE", 1050051);
        this.attrbuteIDTable.put("IVI_ATTR_RETURN_DEFERRED_VALUES", 1050052);
        this.attrbuteIDTable.put("IVI_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVI_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVI_ATTR_ERROR_ELABORATION", 1050103);
        this.attrbuteIDTable.put("IVI_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVI_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVI_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVI_ATTR_VISA_RM_SESSION", 1050321);
        this.attrbuteIDTable.put("IVI_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVI_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVI_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVI_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVI_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVI_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("IVI_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVI_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVI_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVI_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVI_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("IVI_ATTR_BUFFERED_IO_CALLBACK", 1050601);
        this.attrbuteIDTable.put("IVI_ATTR_OPC_CALLBACK", 1050602);
        this.attrbuteIDTable.put("IVI_ATTR_CHECK_STATUS_CALLBACK", 1050603);
        this.attrbuteIDTable.put("IVI_ATTR_SUPPORTS_WR_BUF_OPER_MODE", 1050704);
        this.attrbuteIDTable.put("IVI_ATTR_UPDATING_VALUES", 1050708);
        this.attrbuteIDTable.put("IVI_ATTR_USER_INTERCHANGE_CHECK_CALLBACK", 1050801);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVI_ATTR_SPECIFIC_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVI_ATTR_MODULE_PATHNAME", 1050303);
        this.attrbuteIDTable.put("IVI_ATTR_DRIVER_MAJOR_VEviRSION", 1050503);
        this.attrbuteIDTable.put("IVI_ATTR_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVI_ATTR_CLASS_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVI_ATTR_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVI_ATTR_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVI_ATTR_SUPPORTED_CLASSES", 1050323);
        this.attrbuteIDTable.put("IVI_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVI_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVI_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVI_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
    }

    private void buildIVIScopeIDAttribute() {
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_VERTICAL_RANGE", 1250001);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_VERTICAL_OFFSET", 1250002);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_VERTICAL_COUPLING", 1250003);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_PROBE_ATTENUATION", 1250004);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CHANNEL_ENABLED", 1250005);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_MAX_INPUT_FREQUENCY", 1250006);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INPUT_IMPEDANCE", 0x131337);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ACQUISITION_TYPE", 0x131335);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ACQUISITION_START_TIME", 0x13133D);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_HORZ_TIME_PER_RECORD", 1250007);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_HORZ_RECORD_LENGTH", 1250008);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_HORZ_MIN_NUM_PTS", 1250009);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_HORZ_SAMPLE_RATE", 1250010);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_TYPE", 1250012);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_SOURCE", 1250013);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_COUPLING", 1250014);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_HOLDOFF", 1250016);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_LEVEL", 1250017);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_SLOPE", 1250018);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_SIGNAL_FORMAT", 0x131399);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_EVENT", 1250205);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_LINE_NUMBER", 1250206);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_POLARITY", 1250204);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RUNT_HIGH_THRESHOLD", 1250301);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RUNT_LOW_THRESHOLD", 1250302);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RUNT_POLARITY", 0x1313FF);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_GLITCH_WIDTH", 1250401);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_GLITCH_POLARITY", 1250402);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_GLITCH_CONDITION", 1250403);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_WIDTH_LOW_THRESHOLD", 1250501);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_WIDTH_HIGH_THRESHOLD", 1250502);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_WIDTH_POLARITY", 1250503);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_WIDTH_CONDITION", 1250504);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_AC_LINE_TRIGGER_SLOPE", 1250701);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_NUM_ENVELOPES", 0x131339);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_MEAS_HIGH_REF", 1250607);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_MEAS_LOW_REF", 1250608);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_MEAS_MID_REF", 0x131531);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_MODIFIER", 0x131336);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_NUM_AVERAGES", 0x131338);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SAMPLE_MODE", 0x13133A);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INITIATE_CONTINUOUS", 0x13133B);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_PROBE_SENSE_VALUE", 0x13133C);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_INTERPOLATION", 1250019);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_REVISION", 1050552);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_MODULE_PATHNAME", 1050303);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_ERROR_ELABORATION", 1050103);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_BANDWIDTH", 1250006);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_HORZ_RECORD_REF_POSITION", 1250011);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TRIGGER_DELAY_TIME", 1250015);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_SIGNAL_TYPE", 0x131399);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_FIELD", 1250202);
        this.attrbuteIDTable.put("IVISCOPE_ATTR_TV_TRIGGER_LINE", 1250203);
    }

    private void buildIVISwtchIDAttribute() {
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IS_SOURCE_CHANNEL", 1250001);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IS_DEBOUNCED", 1250002);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IS_CONFIGURATION_CHANNEL", 1250003);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SETTLING_TIME", 1250004);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_BANDWIDTH", 1250005);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_DC_VOLTAGE", 1250006);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_AC_VOLTAGE", 1250007);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_SWITCHING_DC_CURRENT", 1250008);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_SWITCHING_AC_CURRENT", 1250009);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_CARRY_DC_CURRENT", 1250010);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_CARRY_AC_CURRENT", 1250011);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_SWITCHING_DC_POWER", 1250012);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_SWITCHING_AC_POWER", 1250013);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_CARRY_DC_POWER", 1250014);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MAX_CARRY_AC_POWER", 1250015);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CHARACTERISTIC_IMPEDANCE", 1250016);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_WIRE_MODE", 1250017);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_NUM_OF_ROWS", 1250018);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_NUM_OF_COLUMNS", 1250019);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SCAN_LIST", 1250020);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SCAN_MODE", 1250021);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_TRIGGER_INPUT", 1250022);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SCAN_ADVANCED_OUTPUT", 1250023);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IS_SCANNING", 1250024);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SCAN_DELAY", 1250025);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CONTINUOUS_SCAN", 1250026);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_REVISION", 1050552);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_MODULE_PATHNAME", 1050303);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVISWTCH_ATTR_ERROR_ELABORATION", 1050103);
    }

    private void buildIVIDmmIDAttribute() {
        this.attrbuteIDTable.put("IVIDMM_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVIDMM_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVIDMM_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVIDMM_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVIDMM_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVIDMM_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVIDMM_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIDMM_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVIDMM_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVIDMM_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVIDMM_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIDMM_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVIDMM_ATTR_FUNCTION", 1250001);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RANGE", 1250002);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RESOLUTION_ABSOLUTE", 1250008);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TRIGGER_SOURCE", 1250004);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TRIGGER_DELAY", 1250005);
        this.attrbuteIDTable.put("IVIDMM_ATTR_AC_MIN_FREQ", 1250006);
        this.attrbuteIDTable.put("IVIDMM_ATTR_AC_MAX_FREQ", 1250007);
        this.attrbuteIDTable.put("IVIDMM_ATTR_FREQ_VOLTAGE_RANGE", 0x131335);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_TRANSDUCER_TYPE", 0x131399);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_TC_TYPE", 1250231);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_TC_REF_JUNC_TYPE", 1250232);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_TC_FIXED_REF_JUNC", 1250233);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_RTD_ALPHA", 0x1313C1);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_RTD_RES", 1250242);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TEMP_THERMISTOR_RES", 1250251);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SAMPLE_COUNT", 1250301);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SAMPLE_TRIGGER", 1250302);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SAMPLE_INTERVAL", 0x1313FF);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TRIGGER_COUNT", 1250304);
        this.attrbuteIDTable.put("IVIDMM_ATTR_MEAS_COMPLETE_DEST", 1250305);
        this.attrbuteIDTable.put("IVIDMM_ATTR_TRIGGER_SLOPE", 1250334);
        this.attrbuteIDTable.put("IVIDMM_ATTR_APERTURE_TIME", 0x131411);
        this.attrbuteIDTable.put("IVIDMM_ATTR_APERTURE_TIME_UNITS", 1250322);
        this.attrbuteIDTable.put("IVIDMM_ATTR_AUTO_RANGE_VALUE", 1250331);
        this.attrbuteIDTable.put("IVIDMM_ATTR_AUTO_ZERO", 1250332);
        this.attrbuteIDTable.put("IVIDMM_ATTR_POWERLINE_FREQ", 1250333);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIDMM_ATTR_MODULE_PATHNAME", 1050303);
        this.attrbuteIDTable.put("IVIDMM_ATTR_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVIDMM_ATTR_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVIDMM_ATTR_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIDMM_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("IVIDMM_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("IVIDMM_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("IVIDMM_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVIDMM_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIDMM_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVIDMM_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVIDMM_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVIDMM_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
        this.attrbuteIDTable.put("IVIDMM_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVIDMM_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVIDMM_ATTR_ERROR_ELABORATION", 1050103);
        this.attrbuteIDTable.put("IVIDMM_ATTR_RESOLUTION", 1250003);
    }

    private void buildIVIDCPwrIDAttribute() {
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_AVERAGING_AUTO_ENABLED", 1250003);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CORRECTION_FREQUENCY", 1250004);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_OFFSET", 1250005);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_RANGE_AUTO_ENABLED", 1250002);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_UNITS", 1250001);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_CHANNEL_ENABLED", 0x131303);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_RANGE_LOWER", 0x131335);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_RANGE_UPPER", 0x131336);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_TRIGGER_SOURCE", 0x131399);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INTERNAL_TRIGGER_EVENT_SOURCE", 1250251);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INTERNAL_TRIGGER_LEVEL", 0x1313CC);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_INTERNAL_TRIGGER_SLOPE", 1250253);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_AVERAGING_COUNT", 1250301);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_DUTY_CYCLE_CORRECTION", 1250402);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_DUTY_CYCLE_CORRECTION_ENABLED", 1250401);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_REF_OSCILLATOR_ENABLED", 1250501);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_REF_OSCILLATOR_FREQUENCY", 1250502);
        this.attrbuteIDTable.put("IVIPWRMETER_ATTR_REF_OSCILLATOR_LEVEL", 1250503);
    }

    private void buildIVIFgenIDAttribute() {
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_OUTPUT_MODE", 1250001);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_REF_CLOCK_SOURCE", 1250002);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_OUTPUT_ENABLED", 1250003);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_OUTPUT_IMPEDANCE", 1250004);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_OPERATION_MODE", 1250005);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_WAVEFORM", 0x131335);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_AMPLITUDE", 0x131336);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_DC_OFFSET", 0x131337);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_FREQUENCY", 0x131338);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_START_PHASE", 0x131339);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FUNC_DUTY_CYCLE_HIGH", 0x13133A);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_WAVEFORM_HANDLE", 0x131399);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_GAIN", 1250202);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_OFFSET", 1250203);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_SAMPLE_RATE", 1250204);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MAX_NUM_WAVEFORMS", 1250205);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_WAVEFORM_QUANTUM", 1250206);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MIN_WAVEFORM_SIZE", 1250207);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MAX_WAVEFORM_SIZE", 1250208);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_FREQUENCY", 0x1313A1);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ARB_SEQUENCE_HANDLE", 0x1313A3);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MAX_NUM_SEQUENCES", 1250212);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MIN_SEQUENCE_LENGTH", 1250213);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MAX_SEQUENCE_LENGTH", 1250214);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MAX_LOOP_COUNT", 1250215);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_TRIGGER_SOURCE", 1250302);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_INTERNAL_TRIGGER_RATE", 1250310);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_BURST_COUNT", 1250350);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_AM_ENABLED", 1250401);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_AM_SOURCE", 1250402);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_AM_INTERNAL_DEPTH", 1250403);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_AM_INTERNAL_WAVEFORM", 1250404);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_AM_INTERNAL_FREQUENCY", 1250405);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FM_ENABLED", 1250501);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FM_SOURCE", 1250502);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FM_INTERNAL_DEVIATION", 1250503);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FM_INTERNAL_WAVEFORM", 1250504);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_FM_INTERNAL_FREQUENCY", 1250505);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_MODULE_PATHNAME", 1050303);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_ERROR_ELABORATION", 1050103);
        this.attrbuteIDTable.put("IVIFGEN_ATTR_CYCLE_COUNT", 1250301);
    }

    private void buildIVIRFSigGenIDAttribute() {
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY", 1250001);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_LEVEL", 1250002);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ALC_ENABLED", 1250003);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_OUTPUT_ENABLED", 1250004);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_ENABLED", 1250011);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_SOURCE", 1250012);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_SCALING", 1250013);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_EXTERNAL_COUPLING", 1250014);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_NOMINAL_VOLTAGE", 1250015);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_AM_DEPTH", 1250016);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FM_ENABLED", 1250021);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FM_SOURCE", 1250022);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FM_EXTERNAL_COUPLING", 1250023);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FM_NOMINAL_VOLTAGE", 1250024);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FM_DEVIATION", 1250025);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PM_ENABLED", 1250031);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PM_SOURCE", 1250032);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PM_EXTERNAL_COUPLING", 1250033);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PM_NOMINAL_VOLTAGE", 1250034);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PM_DEVIATION", 1250035);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ANALOG_MODULATION_SOURCE_COUNT", 1250041);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_MODULATION_ENABLED", 0x131303);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_MODULATION_SOURCE", 1250052);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_MODULATION_EXTERNAL_POLARITY", 1250053);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ACTIVE_LF_GENERATOR", 0x131335);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LF_GENERATOR_COUNT", 0x131338);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LF_GENERATOR_FREQUENCY", 0x131336);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LF_GENERATOR_WAVEFORM", 0x131337);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LF_GENERATOR_OUTPUT_AMPLITUDE", 0x13133F);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LF_GENERATOR_OUTPUT_ENABLED", 1250112);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_INTERNAL_TRIGGER_PERIOD", 1250121);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_WIDTH", 1250122);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_GATING_ENABLED", 1250123);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_TRIGGER_SOURCE", 1250124);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_EXTERNAL_TRIGGER_SLOPE", 1250125);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_EXTERNAL_TRIGGER_DELAY", 1250126);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_DOUBLE_ENABLED", 0x131353);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_DOUBLE_DELAY", 1250132);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_OUTPUT_POLARITY", 1250141);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_PULSE_OUTPUT_ENABLED", 1250142);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SWEEP_MODE", 0x131399);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_SWEEP_TRIGGER_SOURCE", 1250202);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_SWEEP_START", 0x1313A3);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_SWEEP_STOP", 1250212);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_SWEEP_TIME", 1250213);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_SWEEP_START", 1250221);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_SWEEP_STOP", 1250222);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_SWEEP_TIME", 1250223);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_START", 0x1313C1);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_STOP", 1250242);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_SCALING", 0x1313C3);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_SIZE", 1250244);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_SINGLE_STEP_ENABLED", 1250245);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_FREQUENCY_STEP_DWELL", 1250246);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_STEP_START", 1250261);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_STEP_STOP", 1250262);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_STEP_SIZE", 1250263);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_STEP_SINGLE_STEP_ENABLED", 1250264);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_POWER_STEP_DWELL", 1250265);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LIST_SELECTED_NAME", 1250281);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LIST_SINGLE_STEP_ENABLED", 1250282);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_LIST_DWELL", 1250283);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ALC_SOURCE", 1250301);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ALC_BANDWIDTH", 1250302);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_REFERENCE_OSCILLATOR_SOURCE", 0x131411);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_REFERENCE_OSCILLATOR_EXTERNAL_FREQUENCY", 1250322);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_ENABLED", 1250401);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_NOMINAL_VOLTAGE", 1250402);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_SOURCE", 1250403);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_SWAP_ENABLED", 1250404);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_IMPAIRMENT_ENABLED", 1250421);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_I_OFFSET", 1250422);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_Q_OFFSET", 1250423);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_RATIO", 1250424);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_IQ_SKEW", 1250425);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_SELECTED_WAVEFORM", 1250451);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_CLOCK_FREQUENCY", 1250452);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_FILTER_FREQUENCY", 1250453);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_MAX_NUMBER_WAVEFORMS", 1250454);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_WAVEFORM_QUANTUM", 1250455);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_WAVEFORM_SIZE_MIN", 1250456);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_WAVEFORM_SIZE_MAX", 1250457);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_TRIGGER_SOURCE", 1250458);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_ARB_EXTERNAL_TRIGGER_SLOPE", 1250459);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_STANDARD_COUNT", 1250501);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_SELECTED_STANDARD", 1250502);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_DATA_SOURCE", 1250503);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_PRBS_TYPE", 1250504);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_SELECTED_BIT_SEQUENCE", 1250505);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_CLOCK_SOURCE", 1250506);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_DIGITAL_MODULATION_BASE_EXTERNAL_CLOCK_TYPE", 1250507);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_STANDARD_COUNT", 1250601);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_SELECTED_STANDARD", 1250602);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_TRIGGER_SOURCE", 1250603);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_EXTERNAL_TRIGGER_SLOPE", 1250604);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_TEST_MODEL_COUNT", 1250605);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_SELECTED_TEST_MODEL", 1250606);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_CDMA_CLOCK_SOURCE", 1250607);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_STANDARD_COUNT", 1250701);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_SELECTED_STANDARD", 1250702);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_TRIGGER_SOURCE", 1250703);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_EXTERNAL_TRIGGER_SLOPE", 1250704);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_FRAME_COUNT", 1250705);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_SELECTED_FRAME", 1250706);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_CLOCK_SOURCE", 1250707);
        this.attrbuteIDTable.put("IVIRFSIGGEN_ATTR_TDMA_EXTERNAL_CLOCK_TYPE", 1250708);
    }

    private void buildIVISpecAnIDAttribute() {
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_AMPLITUDE_UNITS", 1250001);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_ATTENUATION", 1250002);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_ATTENUATION_AUTO", 1250003);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_DETECTOR_TYPE", 1250004);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_DETECTOR_TYPE_AUTO", 1250005);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_FREQUENCY_START", 1250006);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_FREQUENCY_STOP", 1250007);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_FREQUENCY_OFFSET", 1250008);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_INPUT_IMPEDANCE", 1250009);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_NUMBER_OF_SWEEPS", 1250010);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_REFERENCE_LEVEL", 1250011);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_REFERENCE_LEVEL_OFFSET", 1250012);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_RESOLUTION_BANDWIDTH", 1250013);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_RESOLUTION_BANDWIDTH_AUTO", 1250014);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SWEEP_MODE_CONTINUOUS", 1250015);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SWEEP_TIME", 1250016);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SWEEP_TIME_AUTO", 1250017);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_TRACE_COUNT", 1250018);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_TRACE_SIZE", 1250019);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_TRACE_TYPE", 1250020);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_VERTICAL_SCALE", 1250021);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_VIDEO_BANDWIDTH", 1250022);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_VIDEO_BANDWIDTH_AUTO", 1250023);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_ACTIVE_MARKER", 0x131399);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_AMPLITUDE", 1250202);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_COUNT", 1250203);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_ENABLED", 1250204);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_FREQUENCY_COUNTER_ENABLED", 1250205);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_FREQUENCY_COUNTER_RESOLUTION", 1250206);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_POSITION", 1250207);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_THRESHOLD", 1250208);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_TRACE", 0x1313A1);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_PEAK_EXCURSION", 1250210);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_SIGNAL_TRACK_ENABLED", 0x1313A3);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_TRIGGER_SOURCE", 1250301);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_TRIGGER_LEVEL", 1250401);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_TRIGGER_SLOPE", 1250402);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_VIDEO_TRIGGER_LEVEL", 1250501);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_VIDEO_TRIGGER_SLOPE", 1250502);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_NUMBER_OF_DIVISIONS", 1250602);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_UNITS_PER_DIVISION", 1250601);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_MARKER_TYPE", 1250701);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_REFERENCE_MARKER_AMPLITUDE", 1250801);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_REFERENCE_MARKER_POSITION", 1250802);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_AVERAGE_CONVERSION_LOSS", 1250901);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_BIAS", 1250902);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_BIAS_ENABLED", 1250903);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_BIAS_LIMIT", 1250904);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_CONVERSION_LOSS_TABLE_ENABLED", 1250905);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_ENABLED", 1250906);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_HARMONIC", 1250907);
        this.attrbuteIDTable.put("IVISPECAN_ATTR_EXTERNAL_MIXER_NUMBER_OF_PORTS", 1250908);
    }

    private void buildIVILxiSyncIDAttribute() {
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_BASE", 950000);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_COUNT", 950001);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_ENABLED", 950002);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_PERIOD", 950003);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_REPEAT_COUNT", 950004);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_TIME_FRACTION", 950005);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_ALARM_TIME_SECONDS", 950006);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_COUNT", 950007);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_DELAY", 950008);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_COUNT", 950009);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_DETECTION", 950010);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_ENABLED", 950011);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_EVENTID", 950012);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_FILTER", 950013);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_ARM_SOURCE_OR_ENABLED", 950014);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_COUNT", 950015);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_ENABLED", 950016);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_PERIOD", 950017);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_REPEAT_COUNT", 950018);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_TIME_FRACTION", 950019);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_ALARM_TIME_SECONDS", 950020);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_COUNT", 950021);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE", 950022);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE_COUNT", 950023);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE_DELAY", 950024);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE_DETECTION", 950025);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE_EVENTID", 950026);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_TRIGGER_SOURCE_FILTER", 950027);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_COUNT", 950028);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_DESTINATION_PATH", 950029);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_DRIVE_MODE", 950030);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_SLOPE", 950031);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_SOURCE", 950032);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_WIRED_OR_BIAS_MODE", 950033);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_LOG_ENABLED", 950034);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_EVENT_LOG_ENTRY_COUNT", 950035);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_IS_TIME_MASTER", 950036);
        this.attrbuteIDTable.put("IVILXISYNC_ATTR_IS_TIME_SYNCHRONIZED", 950037);
    }

    private void buildIVIPwrMeterIDAttribute() {
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_VOLTAGE_LEVEL", 1250001);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_OVP_ENABLED", 1250002);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_OVP_LIMIT", 1250003);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CURRENT_LIMIT_BEHAVIOR", 1250004);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CURRENT_LIMIT", 1250005);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_OUTPUT_ENABLED", 1250006);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_TRIGGER_SOURCE", 0x131335);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_TRIGGERED_CURRENT_LIMIT", 0x131336);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_TRIGGERED_VOLTAGE_LEVEL", 0x131337);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_QUERY_INSTR_STATUS", 1050003);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_NUM_CHANNELS", 1050203);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_ATTRIBUTE_CAPABILITIES", 1050403);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("IVIDCPWR_ATTR_ERROR_ELABORATION", 1050103);
    }

    private void buildRSAttributes() {
        this.attrbuteIDTable.put("RS_ATTR_BASE", 1000000);
        this.attrbuteIDTable.put("RS_ENGINE_PRIVATE_ATTR_BASE", 1000000);
        this.attrbuteIDTable.put("RS_ENGINE_PUBLIC_ATTR_BASE", 1050000);
        this.attrbuteIDTable.put("RS_SPECIFIC_PRIVATE_ATTR_BASE", 1100000);
        this.attrbuteIDTable.put("RS_SPECIFIC_PUBLIC_ATTR_BASE", 1150000);
        this.attrbuteIDTable.put("RS_CLASS_PRIVATE_ATTR_BASE", 1200000);
        this.attrbuteIDTable.put("RS_CLASS_PUBLIC_ATTR_BASE", 1250000);
        this.attrbuteIDTable.put("RS_ATTR_RANGE_CHECK", 1050002);
        this.attrbuteIDTable.put("RS_ATTR_QUERY_INSTRUMENT_STATUS", 1050003);
        this.attrbuteIDTable.put("RS_ATTR_CACHE", 1050004);
        this.attrbuteIDTable.put("RS_ATTR_SIMULATE", 1050005);
        this.attrbuteIDTable.put("RS_ATTR_RECORD_COERCIONS", 1050006);
        this.attrbuteIDTable.put("RS_ATTR_INTERCHANGE_CHECK", 1050021);
        this.attrbuteIDTable.put("RS_ATTR_SPY", 1050022);
        this.attrbuteIDTable.put("RS_ATTR_USE_SPECIFIC_SIMULATION", 1050023);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_DESCRIPTION", 1050518);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_PREFIX", 1050301);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_VENDOR", 1050517);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_REVISION", 1050552);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050519);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050520);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_DESCRIPTION", 1050514);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_PREFIX", 1050302);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_LOCATOR", 1050303);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_VENDOR", 1050513);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_REVISION", 1050551);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MAJOR_VERSION", 1050515);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_CLASS_SPEC_MINOR_VERSION", 1050516);
        this.attrbuteIDTable.put("RS_ATTR_SUPPORTED_INSTRUMENT_MODELS", 1050327);
        this.attrbuteIDTable.put("RS_ATTR_GROUP_CAPABILITIES", 1050401);
        this.attrbuteIDTable.put("RS_ATTR_FUNCTION_CAPABILITIES", 1050402);
        this.attrbuteIDTable.put("RS_ATTR_CHANNEL_COUNT", 1050203);
        this.attrbuteIDTable.put("RS_ATTR_DRIVER_SETUP", 1050007);
        this.attrbuteIDTable.put("RS_ATTR_INSTRUMENT_MANUFACTURER", 1050511);
        this.attrbuteIDTable.put("RS_ATTR_INSTRUMENT_MODEL", 1050512);
        this.attrbuteIDTable.put("RS_ATTR_INSTRUMENT_FIRMWARE_REVISION", 1050510);
        this.attrbuteIDTable.put("RS_ATTR_OPTIONS_LIST", 1050591);
        this.attrbuteIDTable.put("RS_ATTR_IO_RESOURCE_DESCRIPTOR", 1050304);
        this.attrbuteIDTable.put("RS_ATTR_LOGICAL_NAME", 1050305);
        this.attrbuteIDTable.put("RS_ATTR_PRIMARY_ERROR", 1050101);
        this.attrbuteIDTable.put("RS_ATTR_SECONDARY_ERROR", 1050102);
        this.attrbuteIDTable.put("RS_ATTR_ERROR_ELABORATION", 1050103);
        this.attrbuteIDTable.put("RS_ATTR_VISA_RM_SESSION", 1050321);
        this.attrbuteIDTable.put("RS_ATTR_IO_SESSION", 1050322);
        this.attrbuteIDTable.put("RS_ATTR_IO_SESSION_TYPE", 1050324);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_MAJOR_VERSION", 1050503);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_MINOR_VERSION", 1050504);
        this.attrbuteIDTable.put("RS_ATTR_SPECIFIC_DRIVER_MINOR_MINOR_VERSION", 1050590);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_MAJOR_VERSION", 1050505);
        this.attrbuteIDTable.put("RS_ATTR_CLASS_DRIVER_MINOR_VERSION", 1050506);
        this.attrbuteIDTable.put("RS_ATTR_ENGINE_MAJOR_VERSION", 1050501);
        this.attrbuteIDTable.put("RS_ATTR_ENGINE_MINOR_VERSION", 1050502);
        this.attrbuteIDTable.put("RS_ATTR_ENGINE_REVISION", 1050553);
        this.attrbuteIDTable.put("RS_ATTR_OPC_CALLBACK", 1050602);
        this.attrbuteIDTable.put("RS_ATTR_CHECK_STATUS_CALLBACK", 1050603);
        this.attrbuteIDTable.put("RS_ATTR_OPC_TIMEOUT", 1051001);
    }
}

