/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyGetPanel
extends PropertyPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    protected JLabel outputArgumentLabel;
    protected JTextField outputArgument;
    protected String outputStr = "";
    protected JTextField stepPassesTextField;
    protected JCheckBox noErrorStepPass;
    protected JCheckBox argsStepPass;
    protected JButton helpButton;

    public PropertyGetPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.setStepType(1);
        this.layoutPanel();
        this.setName("Get Property Step Panel");
    }

    @Override
    public void update(StepInfo stepInfo) {
        super.update(stepInfo);
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        if (!propertyInfo.getNeedsToUpdate()) {
            this.outputArgument.setText(propertyInfo.getOutputArgument());
            this.stepPassesTextField.setText(propertyInfo.getStepPassesValue());
            this.noErrorStepPass.setSelected(propertyInfo.getNoErrorStepPass());
            this.argsStepPass.setSelected(propertyInfo.getArgsStepPass());
            return;
        }
        boolean bl = this.updateAfterDriverReload(propertyInfo);
        if (!bl) {
            this.outputArgument.setText("");
            this.stepPassesTextField.setText("");
            this.noErrorStepPass.setSelected(true);
            this.argsStepPass.setSelected(false);
        }
        this.outputStr = this.outputArgument.getText();
        propertyInfo.setNeedsToUpdate(false);
    }

    public void updatePanelAfterDriverReload() {
        this.updatePropertiesInListBox();
    }

    private boolean updateAfterDriverReload(PropertyInfo propertyInfo) {
        this.updatePropertiesInListBox();
        if (propertyInfo.getProperty().equals("")) {
            this.propertyToTest.setSelectedIndex(0);
            return false;
        }
        String string = propertyInfo.getGroup();
        String string2 = propertyInfo.getProperty();
        int n = this.getPropertyIndex(string2, string);
        if (n == -1) {
            this.propertyToTest.setSelectedIndex(0);
            return false;
        }
        this.propertyToTest.setSelectedIndex(n);
        this.outputArgument.setText(propertyInfo.getOutputArgument());
        this.stepPassesTextField.setText(propertyInfo.getStepPassesValue());
        this.noErrorStepPass.setSelected(propertyInfo.getNoErrorStepPass());
        this.argsStepPass.setSelected(propertyInfo.getArgsStepPass());
        this.objectToTest.setSelectedItem(propertyInfo.getObject());
        this.outputStr = this.outputArgument.getText();
        return true;
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        super.cleanup(stepInfo);
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        propertyInfo.setOutputArgument(this.outputArgument.getText());
        propertyInfo.setStepPassesValue(this.stepPassesTextField.getText());
        propertyInfo.setNoErrorStepPass(this.noErrorStepPass.isSelected());
        propertyInfo.setArgsStepPass(this.argsStepPass.isSelected());
        int n = this.propertyToTest.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        propertyInfo.setProperty(this.getProperty(n));
        propertyInfo.setGroup(this.getSelectedPropertyGroup(n));
        propertyInfo.setObject((String)this.objectToTest.getSelectedItem());
    }

    @Override
    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        mIDTestToolFileWriter.addNode(element, "Name", propertyInfo.getName());
        mIDTestToolFileWriter.addNode(element, "Property", propertyInfo.getProperty());
        mIDTestToolFileWriter.addNode(element, "Group", propertyInfo.getGroup());
        mIDTestToolFileWriter.addNode(element, "Object", propertyInfo.getObject());
        mIDTestToolFileWriter.addNode(element, "PropertyIndex", propertyInfo.getPropertyToTest());
        mIDTestToolFileWriter.addNode(element, "ObjectIndex", propertyInfo.getObjectToTest());
        mIDTestToolFileWriter.addNode(element, "OutputArgument", propertyInfo.getOutputArgument());
        mIDTestToolFileWriter.addNode(element, "NoErrorStepPass", propertyInfo.getNoErrorStepPass());
        mIDTestToolFileWriter.addNode(element, "ArgsStepPass", propertyInfo.getArgsStepPass());
        mIDTestToolFileWriter.addNode(element, "StepPassesValue", propertyInfo.getStepPassesValue());
    }

    @Override
    public void load(Node node, StepInfo stepInfo) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        propertyInfo.setNeedsToUpdate(true);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (nodeList2.getLength() == 0) continue;
            if (string.equals("Name")) {
                propertyInfo.setName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Property")) {
                propertyInfo.setProperty(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Group")) {
                propertyInfo.setGroup(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("Object")) {
                propertyInfo.setObject(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("PropertyIndex")) {
                propertyInfo.setPropertyToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ObjectIndex")) {
                propertyInfo.setObjectToTest(new Integer(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("OutputArgument")) {
                propertyInfo.setOutputArgument(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("NoErrorStepPass")) {
                propertyInfo.setNoErrorStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ArgsStepPass")) {
                propertyInfo.setArgsStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (!string.equals("StepPassesValue")) continue;
            propertyInfo.setStepPassesValue(nodeList2.item(0).getNodeValue());
        }
        propertyInfo.setIsNodeDirty(false);
        this.outputStr = this.outputArgument.getText();
    }

    @Override
    public void duplicate(StepInfo stepInfo, StepInfo stepInfo2) {
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        PropertyInfo propertyInfo2 = (PropertyInfo)stepInfo2;
        propertyInfo.setOutputArgument(propertyInfo2.getOutputArgument());
        propertyInfo.setNoErrorStepPass(propertyInfo2.getNoErrorStepPass());
        propertyInfo.setArgsStepPass(propertyInfo2.getArgsStepPass());
        propertyInfo.setStepPassesValue(propertyInfo2.getStepPassesValue());
        propertyInfo.setProperty(propertyInfo2.getProperty());
        propertyInfo.setGroup(propertyInfo2.getGroup());
        propertyInfo.setObject(propertyInfo2.getObject());
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.add(this.createPropertyToTestPanel(), this.createObjectToTestPanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createOutputArgumentPanel(), 5);
        JPanel jPanel3 = this.add(jPanel2, this.createStepPassesPanel(), 5);
        this.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 0, 0));
        this.helpButton = new JButton("Show Help on Property...");
        this.helpButton.setName("Show Help on Property Button");
        this.helpButton.addActionListener(this);
        jPanel4.add(this.helpButton);
        this.add((Component)jPanel4, "South");
    }

    protected JPanel createOutputArgumentPanel() {
        this.outputArgumentLabel = new JLabel("Output argument:");
        this.outputArgumentLabel.setVerticalAlignment(1);
        this.outputArgument = new JTextField();
        this.outputArgument.setName("Output Argument Text Field");
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.outputArgumentLabel, "North");
        jPanel.add((Component)this.outputArgument, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.outputArgument.addFocusListener(this);
        return jPanel;
    }

    protected JPanel createStepPassesPanel() {
        this.stepPassesTextField = new JTextField();
        this.noErrorStepPass = new JCheckBox("If no MATLAB or instrument error occurs", true);
        this.argsStepPass = new JCheckBox("If property value is: ", false);
        this.stepPassesTextField.setName("Step Passes Text Field");
        this.noErrorStepPass.setName("No error Checkbox");
        this.argsStepPass.setName("Matches CheckBox");
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select when this step passes"));
        jPanel.add(this.noErrorStepPass);
        jPanel.add(this.addTextFieldToComponent(this.argsStepPass, this.stepPassesTextField, 96));
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.showHelp();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.outputArgument.getText().equals("")) {
            this.outputStr = "";
            return;
        }
        if (!TMStringUtil.isvarname((String)this.outputArgument.getText())) {
            TMStringUtil.warn((MJFrame)((MJFrame)SwingUtilities.windowForComponent(this)), (String)"Invalid variable name", (String)("Invalid variable name specified. A valid variable name is a character string of letters," + TMStringUtil.LINESEP + "digits and underscores, with length <= namelengthmax and the first character a letter."));
            this.outputArgument.setText(this.outputStr);
        } else {
            this.outputStr = this.outputArgument.getText();
        }
    }

    @Override
    public void setComponentsEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.objectToTestLabel.setEnabled(bl);
        this.objectToTest.setEnabled(bl);
        this.outputArgumentLabel.setEnabled(bl);
        this.outputArgument.setEnabled(bl);
        this.stepPassesTextField.setEnabled(bl);
        this.noErrorStepPass.setEnabled(bl);
        this.argsStepPass.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        if (!bl) {
            this.objectToTest.removeAllItems();
            this.stepPassesTextField.setText("");
            this.outputArgument.setText("");
        }
        this.isEnabled = bl;
    }

    @Override
    public String generateCode(StepInfo stepInfo, boolean bl, boolean bl2, int n) {
        String string;
        String string2;
        PropertyInfo propertyInfo = (PropertyInfo)stepInfo;
        boolean bl3 = false;
        if (this.isHeader(propertyInfo.getPropertyToTest())) {
            if (bl) {
                this.client.assignVariableInformation(new Integer(0));
            }
            return "";
        }
        String string3 = this.getDisplayFunction(bl);
        String string4 = this.getDisplayInsert(bl);
        String string5 = this.addLine("\n", "errorcode = false;");
        string5 = this.addLine(string5, "try");
        string5 = this.addTabbedLine(string5, "% Query the property.");
        String string6 = propertyInfo.getOutputArgument();
        int n2 = 1;
        if (string6.equals("")) {
            n2 = 0;
            string6 = "temp";
        }
        if (propertyInfo.getGroup().equals("parent")) {
            string5 = this.addTabbedLine(string5, string6 + " = get(deviceObj, '" + propertyInfo.getProperty() + "');");
        } else {
            string5 = this.addTabbedLine(string5, "groupObj = get(deviceObj, '" + propertyInfo.getGroup() + "');");
            string2 = propertyInfo.getObject();
            if (!string2.equals(string = "All " + propertyInfo.getGroup() + " group objects")) {
                string5 = this.addTabbedLine(string5, "groupObj = groupObj(" + (propertyInfo.getObjectToTest() + 1) + ");");
                string5 = this.addTabbedLine(string5, string6 + " = get(groupObj, '" + propertyInfo.getProperty() + "');");
            } else {
                bl3 = true;
                string5 = this.addTabbedLine(string5, string6 + " = get(groupObj, {'" + propertyInfo.getProperty() + "'});");
            }
        }
        if (n2 == 1) {
            string5 = this.addTabbedLine(string5, " ");
            string5 = this.addTabbedLine(string5, "% Store the result so that it can be returned.");
            string5 = this.addTabbedLine(string5, "varargout = {varargout{:}, " + string6 + "};");
        }
        string5 = this.addLine(string5, " ");
        string5 = this.addTabbedLine(string5, "% Check if instrument error occurred.");
        string5 = this.addTabbedLine(string5, "result = geterror(deviceObj);");
        if (propertyInfo.getNoErrorStepPass()) {
            string5 = this.addTabbedLine(string5, "errorcode = ~strcmpi(result, noErrorMsg);");
            string5 = this.addTabbedLine(string5, "");
            string5 = this.addTabbedLine(string5, this.postMessage(bl, "An instrument error occurred while getting the property value.", "result", true, "    "));
        }
        string5 = this.addLine(string5, "catch aException");
        string5 = this.addTabbedLine(string5, "% A MATLAB error occurred.");
        if (propertyInfo.getNoErrorStepPass()) {
            string5 = this.addTabbedLine(string5, "errorcode = true;");
            string5 = this.addLine(string5, "");
            string5 = this.addTabbedLine(string5, "% Post information about error.");
            string5 = this.addTabbedLine(string5, string3 + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the property.") + string4 + "');");
            string5 = this.addTabbedLine(string5, string3 + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string5 = this.addLine(string5, "end");
        if (propertyInfo.getArgsStepPass()) {
            string5 = this.addLine(string5, " ");
            string5 = this.addLine(string5, "% Verify that the queried value matches the expected value.");
            string5 = this.addLine(string5, "if (errorcode == false)");
            string2 = this.formatPropertyValue(propertyInfo.getStepPassesValue());
            if (bl3) {
                string5 = this.addTabbedLine(string5, "% Compare to the expected value.");
                string5 = this.addTabbedLine(string5, "expectedValue = cell(size(groupObj))';");
                string5 = this.addTabbedLine(string5, "[expectedValue{:}] = deal(" + string2 + ");");
                string5 = this.addTabbedLine(string5, "errorcode = ~isequal(" + string6 + ", expectedValue);");
            } else {
                string5 = this.addTabbedLine(string5, "% Compare to the expected value.");
                string5 = this.addTabbedLine(string5, "errorcode = ~isequal(" + string6 + ", " + string2 + ");");
            }
            string5 = this.addTabbedLine(string5, "");
            string5 = this.addTabbedLine(string5, "% Post information about test step failure.");
            string5 = this.addTabbedLine(string5, "if (errorcode == true)");
            string5 = this.addTabbedLine(string5, "    " + string3 + "('The property is not configured to the expected value." + string4 + "');");
            if (!bl3) {
                string5 = this.addTabbedLine(string5, "");
                string5 = this.addTabbedLine(string5, "    % Post actual value.");
                string5 = this.addTabbedLine(string5, "    if isnumeric(" + string6 + ")");
                string5 = this.addTabbedLine(string5, "        " + string3 + "(['Actual value: ' num2str(" + string6 + ") '" + string4 + "']);");
                string5 = this.addTabbedLine(string5, "    else");
                string5 = this.addTabbedLine(string5, "        " + string3 + "(['Actual value: ' " + string6 + " '" + string4 + "']);");
                string5 = this.addTabbedLine(string5, "    end");
                string5 = this.addTabbedLine(string5, "");
                string5 = this.addTabbedLine(string5, "    % Post expected value.");
                string5 = this.addTabbedLine(string5, "    " + string3 + "('Expected value: " + this.formatPropertyValueForStringConcat(propertyInfo.getStepPassesValue()) + string4 + "');");
                string5 = this.addTabbedLine(string5, "end");
            } else {
                string5 = this.addTabbedLine(string5, "");
                string5 = this.addTabbedLine(string5, "    % Post actual value.");
                string5 = this.addTabbedLine(string5, "    for i=1:length(" + string6 + ")");
                string5 = this.addTabbedLine(string5, "        c = " + string6 + "{i};");
                string5 = this.addTabbedLine(string5, "        if isnumeric(c)");
                string5 = this.addTabbedLine(string5, "            " + string3 + "(['Actual value(' num2str(i) '): ' num2str(c) '" + string4 + "']);");
                string5 = this.addTabbedLine(string5, "        else");
                string5 = this.addTabbedLine(string5, "            " + string3 + "(['Actual value(' num2str(i) '): ' c '" + string4 + "']);");
                string5 = this.addTabbedLine(string5, "        end");
                string5 = this.addTabbedLine(string5, "    end");
                string5 = this.addTabbedLine(string5, "");
                string5 = this.addTabbedLine(string5, "    % Post expected value.");
                string5 = this.addTabbedLine(string5, "    " + string3 + "('Expected value: " + this.formatPropertyValueForStringConcat(propertyInfo.getStepPassesValue()) + string4 + "');");
                string5 = this.addTabbedLine(string5, "end");
            }
            string5 = this.addLine(string5, "end");
        }
        if (bl) {
            this.client.assignVariableInformation(new Integer(n2));
            for (int i = 0; i < n2; ++i) {
                this.client.assignVariable(string6);
            }
        }
        if (!bl2) {
            return string5;
        }
        int n3 = propertyInfo.getPropertyToTest();
        string = propertyInfo.getGroup();
        String string7 = propertyInfo.getProperty();
        boolean bl4 = true;
        if (!this.isPropertyHelpDefined(string, n3)) {
            bl4 = false;
            string5 = this.addLine(string5, "");
            string5 = this.addLine(string5, "% Post warnings.");
            string5 = this.addLine(string5, "warningOccurred = true;");
            string5 = this.addLine(string5, "stepWarningOccurred = true;");
            string5 = this.addLine(string5, string3 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No help is defined for the " + string7 + " property in the " + string + " group.") + string4 + "');");
        }
        if (!this.isDefaultValueDefined(string, n3)) {
            if (bl4) {
                string5 = this.addLine(string5, "");
                string5 = this.addLine(string5, "% Post warnings.");
                string5 = this.addLine(string5, "warningOccurred = true;");
                string5 = this.addLine(string5, "stepWarningOccurred = true;");
            }
            string5 = this.addLine(string5, string3 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No default value is defined for the " + string7 + " property in the " + string + " group.") + string4 + "');");
        }
        return string5;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

