/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DriverFileWriter {
    private DriverModel fData;
    String driverName;

    public DriverFileWriter(DriverModel driverModel) {
        this.fData = driverModel;
    }

    public void writeXML(String string) throws TMException {
        try {
            File file = new File(string);
            this.driverName = file.getCanonicalFile().toString();
            if (this.fData.isStandaloneDriver() && this.fData.getDriverName().length() == 0) {
                this.fData.setDriverName(string);
            }
            Document document = this.createDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult("file:/" + file.getAbsolutePath());
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException transformerException) {
            if (transformerException.getException() instanceof FileNotFoundException) {
                throw new TMException("The driver file could not be written.  Verify that you have write permissions in the output file or directory.");
            }
            throw new TMException("An unknown error occurred writing the driver.");
        }
        catch (IOException iOException) {
            throw new TMException("An unknown error occurred writing the driver.");
        }
    }

    public void writeXML(String string, String string2) throws TMException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(string2 + File.separator + string);
        }
        if (file.exists() && !file.canWrite()) {
            throw new TMException("The output file is not writable.");
        }
        if (!file.exists() && !file.getParentFile().canWrite()) {
            throw new TMException("The output file is not writable.");
        }
        this.writeXML(file.getAbsolutePath());
    }

    public Document createDocument() {
        return this.createDocumentv11();
    }

    public Document createDocument(String string) {
        try {
            return this.createDocumentv11();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public Document createDocumentv11() {
        Document document = null;
        try {
            int n;
            Vector<Object> vector;
            Element element;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.getDOMImplementation().createDocument("", "MATLABInstrumentDriver", null);
            Element element2 = document.getDocumentElement();
            this.write(document, element2, "FileVersion", this.fData.getFileVersion());
            this.write(document, element2, "DriverName", this.fData.getDriverName());
            this.write(document, element2, "DriverType", Device.DRIVER_TYPE_NAMES[this.fData.getDriverType()]);
            this.write(document, element2, "InstrumentType", this.fData.getInstrumentType());
            this.write(document, element2, "InstrumentManufacturer", this.fData.getInstrumentManufacturer());
            this.write(document, element2, "InstrumentModel", this.fData.getInstrumentModel());
            this.write(document, element2, "InstrumentVersion", this.fData.getInstrumentVersion());
            this.write(document, element2, "Identify", this.fData.getIdentifyCommand());
            this.write(document, element2, "Reset", this.fData.getResetCommand());
            this.write(document, element2, "Selftest", this.fData.getSelfTestCommand());
            this.write(document, element2, "Error", this.fData.getErrorCommand());
            String string = this.fData.getCreateInitMCode();
            if (string != null && string.length() > 0) {
                element = this.write(document, element2, "CreateInitCode", "");
                this.write(document, element, "Code", string);
            }
            element = this.write(document, element2, "ConnectInitCode", "");
            if (this.fData.getConnectInitType() == 0) {
                vector = this.fData.getConnectInitCode();
                if (vector != null) {
                    this.write(document, element, "Type", "InstrumentCommand");
                    for (n = 0; n < vector.size(); ++n) {
                        this.write(document, element, "Code", vector.get(n));
                    }
                }
            } else {
                string = this.fData.getConnectInitMCode();
                this.write(document, element, "Type", "MCode");
                this.write(document, element, "Code", string);
            }
            element = this.write(document, element2, "CleanupCode", "");
            if (this.fData.getDisconnectType() == 0) {
                vector = this.fData.getDisconnectCode();
                if (vector != null) {
                    this.write(document, element, "Type", "InstrumentCommand");
                    for (n = 0; n < vector.size(); ++n) {
                        this.write(document, element, "Code", vector.get(n));
                    }
                }
            } else {
                string = this.fData.getDisconnectMCode();
                this.write(document, element, "Type", "MCode");
                this.write(document, element, "Code", string);
            }
            Element element3 = document.createElement("GroupInfo");
            element2.appendChild(element3);
            DriverGroup[] driverGroupArray = this.fData.getGroups();
            for (int i = 0; i < driverGroupArray.length; ++i) {
                Element element4 = this.write(document, (Node)element3, driverGroupArray[i]);
                Element element5 = document.createElement("PropertyInfo");
                element4.appendChild(element5);
                vector = driverGroupArray[i].getProperties();
                for (int j = 0; j < vector.size(); ++j) {
                    this.write(document, (Node)element5, (DriverProperty)vector.get(j));
                }
                Element element6 = document.createElement("MethodInfo");
                element4.appendChild(element6);
                vector = driverGroupArray[i].getFunctions();
                for (int j = 0; j < vector.size(); ++j) {
                    this.write(document, (Node)element6, (DriverFunction)vector.get(j));
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return document;
    }

    public Document createDocumentv10() {
        Document document = null;
        try {
            int n;
            Vector<Object> vector;
            Element element;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.getDOMImplementation().createDocument("", "MATLABInstrumentDriver", null);
            Element element2 = document.getDocumentElement();
            this.write(document, element2, "FileVersion", "1.0");
            this.write(document, element2, "DriverName", this.fData.getDriverName());
            this.write(document, element2, "DriverType", Device.DRIVER_TYPE_NAMES[this.fData.getDriverType()]);
            this.write(document, element2, "InstrumentType", this.fData.getInstrumentType());
            this.write(document, element2, "InstrumentManufacturer", this.fData.getInstrumentManufacturer());
            this.write(document, element2, "InstrumentModel", this.fData.getInstrumentModel());
            this.write(document, element2, "InstrumentVersion", this.fData.getInstrumentVersion());
            this.write(document, element2, "Identify", this.fData.getIdentifyCommand());
            this.write(document, element2, "Reset", this.fData.getResetCommand());
            this.write(document, element2, "Selftest", this.fData.getSelfTestCommand());
            this.write(document, element2, "Error", this.fData.getErrorCommand());
            String string = this.fData.getCreateInitMCode();
            if (string != null && string.length() > 0) {
                element = this.write(document, element2, "CreateInitCode", "");
                this.write(document, element, "Code", string);
            }
            element = this.write(document, element2, "ConnectInitCode", "");
            if (this.fData.getConnectInitType() == 0) {
                vector = this.fData.getConnectInitCode();
                if (vector != null) {
                    this.write(document, element, "Type", "InstrumentCommand");
                    for (n = 0; n < vector.size(); ++n) {
                        this.write(document, element, "Code", vector.get(n));
                    }
                }
            } else {
                string = this.fData.getConnectInitMCode();
                this.write(document, element, "Type", "MCode");
                this.write(document, element, "Code", string);
            }
            element = this.write(document, element2, "CleanupCode", "");
            if (this.fData.getDisconnectType() == 0) {
                vector = this.fData.getDisconnectCode();
                if (vector != null) {
                    this.write(document, element, "Type", "InstrumentCommand");
                    for (n = 0; n < vector.size(); ++n) {
                        this.write(document, element, "Code", vector.get(n));
                    }
                }
            } else {
                string = this.fData.getDisconnectMCode();
                this.write(document, element, "Type", "MCode");
                this.write(document, element, "Code", string);
            }
            Element element3 = document.createElement("GroupInfo");
            Element element4 = document.createElement("PropertyInfo");
            Element element5 = document.createElement("MethodInfo");
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            DriverGroup[] driverGroupArray = this.fData.getGroups();
            for (int i = 0; i < driverGroupArray.length; ++i) {
                int n2;
                if (!driverGroupArray[i].isParentGroup()) {
                    this.write(document, (Node)element3, driverGroupArray[i]);
                }
                vector = driverGroupArray[i].getProperties();
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    this.write(document, (Node)element4, (DriverProperty)vector.get(n2));
                }
                vector = driverGroupArray[i].getFunctions();
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    this.write(document, (Node)element5, (DriverFunction)vector.get(n2));
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return document;
    }

    private Element write(Document document, Node node, String string, String string2) {
        Element element = document.createElement(string);
        element.appendChild(document.createTextNode(string2));
        node.appendChild(element);
        return element;
    }

    private void write(Document document, Node node, DriverDataType driverDataType) {
        Element element = document.createElement("PermissibleType");
        int n = driverDataType.getDataType();
        switch (n) {
            case 2: {
                this.write(document, element, "Type", "Boolean");
                break;
            }
            case 0: {
                this.write(document, element, "Type", "Double");
                break;
            }
            case 1: {
                this.write(document, element, "Type", "String");
                break;
            }
            case 3: {
                this.write(document, element, "Type", "Object");
            }
        }
        if (driverDataType.getDependentPropertyName().length() > 0) {
            this.write(document, element, "DependentProperty", driverDataType.getDependentPropertyName());
            this.write(document, element, "DependentPropertyValue", driverDataType.getDependentPropertyValue());
        }
        int n2 = driverDataType.getConstraintType();
        switch (n2) {
            case 2: {
                this.write(document, element, "Constraint", "none");
                break;
            }
            case 0: {
                this.write(document, element, "Constraint", "bounded");
                Element element2 = document.createElement("ConstraintValue");
                Element element3 = document.createElement("Range");
                element3.setAttribute("Min", Double.toString(driverDataType.getRangeMin()));
                element3.setAttribute("Max", Double.toString(driverDataType.getRangeMax()));
                element2.appendChild(element3);
                element.appendChild(element2);
                break;
            }
            case 1: {
                this.write(document, element, "Constraint", "enum");
                Element element4 = document.createElement("ConstraintValue");
                if (n == 0) {
                    for (int i = 0; i < driverDataType.getDoubleEnumCount(); ++i) {
                        this.write(document, element4, "Value", driverDataType.getDoubleEnum(i).toString());
                    }
                } else {
                    for (int i = 0; i < driverDataType.getStringEnumKeyCount(); ++i) {
                        Element element5 = document.createElement("Enum");
                        element5.setAttribute("Name", driverDataType.getStringEnumKey(i));
                        element5.setAttribute("Value", driverDataType.getStringEnumVal(i));
                        element4.appendChild(element5);
                    }
                }
                element.appendChild(element4);
            }
        }
        node.appendChild(element);
    }

    private void write(Document document, Node node, DriverProperty driverProperty) {
        Object object;
        Element element = document.createElement("Property");
        this.write(document, element, "Name", driverProperty.getName());
        this.write(document, element, "Location", driverProperty.getGroup().getName());
        this.write(document, element, "CapabilityGroup", "Base");
        if (driverProperty.getCodeType() == 0) {
            this.write(document, element, "Type", "InstrumentCommand");
        } else {
            this.write(document, element, "Type", "MCode");
        }
        Element element2 = document.createElement("Code");
        if (driverProperty.getCodeType() == 0) {
            object = document.createElement("Commands");
            if (driverProperty.getConfigureCommand() != null) {
                this.write(document, (Node)object, "ConfigureCommand", driverProperty.getConfigureCommand());
            }
            if (driverProperty.getQueryCommand() != null) {
                this.write(document, (Node)object, "QueryCommand", driverProperty.getQueryCommand());
            }
            element2.appendChild((Node)object);
        } else {
            if (driverProperty.getGetCodeToEvaluate() != null) {
                this.write(document, element2, "GetMCode", driverProperty.getGetCodeToEvaluate());
            }
            if (driverProperty.getSetCodeToEvaluate() != null) {
                this.write(document, element2, "SetMCode", driverProperty.getSetCodeToEvaluate());
            }
        }
        element.appendChild(element2);
        object = driverProperty.getPropertyTypes();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this.write(document, (Node)element, (DriverDataType)((Vector)object).get(i));
        }
        this.write(document, element, "DefaultValue", driverProperty.getDefaultValue().toString());
        this.write(document, element, "ReadOnly", driverProperty.getReadOnly());
        if (driverProperty.getDescription() != null) {
            this.write(document, element, "Description", driverProperty.getDescription());
        }
        node.appendChild(element);
    }

    private void write(Document document, Node node, DriverFunction driverFunction) {
        Element element = document.createElement("Method");
        this.write(document, element, "Name", driverFunction.getName());
        this.write(document, element, "Location", driverFunction.getGroup().getName());
        this.write(document, element, "CapabilityGroup", "Base");
        int n = driverFunction.getCodeType();
        if (n == 0) {
            this.write(document, element, "Type", "InstrumentCommand");
        } else {
            this.write(document, element, "Type", "MCode");
        }
        Element element2 = document.createElement("Code");
        element.appendChild(element2);
        if (n == 1) {
            this.write(document, element2, "MCode", driverFunction.getMCodeToEvaluate());
        } else {
            int n2;
            Element element3 = document.createElement("Commands");
            element2.appendChild(element3);
            for (n2 = 0; n2 < driverFunction.getCommandCount(); ++n2) {
                Element element4 = document.createElement("Line");
                element4.setAttribute("Command", driverFunction.getCommand(n2));
                element4.setAttribute("Output", driverFunction.hasOutput(n2) ? "true" : "false");
                if (driverFunction.hasOutput(n2)) {
                    element4.setAttribute("ReadOutputAs", driverFunction.getOutputType(n2));
                    element4.setAttribute("Format", driverFunction.getOutputFormat(n2));
                }
                element3.appendChild(element4);
            }
            if (driverFunction.getInputs() != null) {
                for (n2 = 0; n2 < driverFunction.getInputs().size(); ++n2) {
                    String string = driverFunction.getInputs().get(n2);
                    this.write(document, element3, "Input", string);
                }
            }
        }
        this.write(document, element, "Description", driverFunction.getDescription());
        node.appendChild(element);
    }

    private Element write(Document document, Node node, DriverGroup driverGroup) {
        Element element = document.createElement("Group");
        this.write(document, element, "Name", driverGroup.getName());
        this.write(document, element, "Description", driverGroup.getHelpText());
        this.write(document, element, "Command", driverGroup.getCommand());
        this.write(document, element, "Size", Integer.toString(driverGroup.getSize()));
        Element element2 = document.createElement("Mappings");
        element.appendChild(element2);
        Hashtable<Integer, String> hashtable = driverGroup.getIdMappings();
        Enumeration<Integer> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = enumeration.nextElement();
            String string = hashtable.get(n);
            Element element3 = this.write(document, element2, "ChannelMap", "");
            element3.setAttribute("Index", n.toString());
            element3.setAttribute("Command", string);
        }
        node.appendChild(element);
        return element;
    }
}

