/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.VXIPnPLoader;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DefaultDriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.ImportDialog;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDToolbarButton;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeDetail;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.toolbox.testmeas.guiutil.AboutWindow;
import com.mathworks.toolbox.testmeas.util.PreferenceFile;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.FileUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class MIDTool
implements WindowListener,
TreeSelectionListener,
DriverModelListener,
MatlabListener {
    private static MIDTool sInstance = null;
    private Action fActionNewInterfaceObjectDriver;
    private Action fActionNewGenericDriver;
    private Action fActionOpenRecentDocument;
    private Action fActionOpenDocument;
    private Action fActionImport;
    private Action fActionSaveDocument;
    private Action fActionSaveAsDocument;
    private Action fActionQuitApplication;
    private Action fActionAboutApplication;
    private Action fActionHelp;
    protected Action fActionAddGroup;
    protected Action fActionAddProperty;
    protected Action fActionAddFunction;
    protected Action fActionRenameNode;
    protected Action fActionDuplicateNode;
    protected Action fActionDeleteNode;
    protected Action fActionAddGroupContext;
    protected Action fActionAddPropertyContext;
    protected Action fActionAddFunctionContext;
    protected Action fActionRenameNodeContext;
    protected Action fActionDuplicateNodeContext;
    protected Action fActionDeleteNodeContext;
    protected String fMatlabFunction;
    protected Object[] fMatlabArgs;
    private DefaultDriverModel fDocument;
    private String fAppName;
    private File currentOpenDir;
    private File currentSaveDir;
    private File currentImportDir;
    private MJMenu[] fMenus;
    private MJToolBar fToolBar;
    private DriverClient fClient;
    private Browser fBrowser;
    private TreeView fTreeView;
    private MJButton fCloseStatusBarButton;
    private MJButton fSaveStatusBarButton;
    private Vector<String> fRecentDocuments;
    private MJMenuItem[] fRecentMenuItems;
    private static final int kRecentDocumentOffset = 7;
    private static final int kMaxRecentDocuments = 4;
    private static Object[] sMatlabArgs;
    private static Color sMCommentColor;
    private static boolean sShowButtonsInStatusBar;
    private IviImportRunnable fImportRunnable;
    private FileExtensionFilter fileExtensionFilter = null;

    public MIDTool(String string) {
        this.setApplicationName("MATLAB Instrument Driver Editor");
        this.initialize();
        this.setDocument(this.createDocument(string));
    }

    public MIDTool(DefaultDriverModel defaultDriverModel) {
        this.setApplicationName("MATLAB Instrument Driver Editor");
        this.initialize();
        this.setDocument(defaultDriverModel);
    }

    private void initialize() {
        this.loadPreferences();
        this.createActions();
        this.layoutPanel();
        this.setTitle(this.fAppName);
        this.setStateHaveDocument(false);
        this.fBrowser.getFrame().addWindowListener((WindowListener)this);
        this.fBrowser.getFrame().removeWindowListener((WindowListener)this.fBrowser);
        Matlab.addListener((MatlabListener)this);
        sInstance = this;
    }

    public String getApplicationName() {
        return this.fAppName;
    }

    public void setApplicationName(String string) {
        this.fAppName = string;
    }

    public DefaultDriverModel getDocument() {
        return this.fDocument;
    }

    public boolean hasDocument() {
        return this.fDocument != null;
    }

    protected void setDocument(DefaultDriverModel defaultDriverModel) {
        this.fDocument = defaultDriverModel;
        if (this.fDocument != null) {
            this.setStateHaveDocument(true);
            this.fDocument.addDriverModelListener(this);
        } else {
            this.setStateHaveDocument(false);
        }
        this.refresh();
        this.fBrowser.getCurrentDetailView().clearView();
        this.fTreeView.setModel(this.fClient.setDocument(defaultDriverModel));
        if (defaultDriverModel != null) {
            TreePath treePath = new TreePath(this.fTreeView.getModel().getRoot());
            this.fTreeView.setSelectionPath(treePath);
        }
    }

    public void setDefaultOpenDirectory(String string) {
        this.currentOpenDir = new File(string);
    }

    public File getDefaultOpenDirectory() {
        return this.currentOpenDir;
    }

    public void setDefaultSaveDirectory(String string) {
        this.currentSaveDir = new File(string);
    }

    public File getDefaultSaveDirectory() {
        return this.currentSaveDir;
    }

    public void setDefaultImportDirectory(String string) {
        this.currentImportDir = new File(string);
    }

    public File getDefaultImportDirectory() {
        return this.currentImportDir;
    }

    public Hashtable<String, Action> getActions() {
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        hashtable.put("New", this.fActionNewInterfaceObjectDriver);
        hashtable.put("Open", this.fActionOpenDocument);
        hashtable.put("OpenRecent", this.fActionOpenRecentDocument);
        hashtable.put("ImportVXIPnP", this.fActionImport);
        hashtable.put("Save", this.fActionSaveDocument);
        hashtable.put("SaveAs", this.fActionSaveAsDocument);
        hashtable.put("Quit", this.fActionQuitApplication);
        hashtable.put("About", this.fActionAboutApplication);
        hashtable.put("Help", this.fActionHelp);
        hashtable.put("AddGroup", this.fActionAddGroup);
        hashtable.put("AddProperty", this.fActionAddProperty);
        hashtable.put("AddFunction", this.fActionAddFunction);
        hashtable.put("Duplicate", this.fActionDuplicateNode);
        hashtable.put("Delete", this.fActionDeleteNode);
        hashtable.put("Rename", this.fActionRenameNode);
        hashtable.put("AddGroupContext", this.fActionAddGroupContext);
        hashtable.put("AddPropertyContext", this.fActionAddPropertyContext);
        hashtable.put("AddFunctionContext", this.fActionAddFunctionContext);
        hashtable.put("DuplicateContext", this.fActionDuplicateNodeContext);
        hashtable.put("DeleteContext", this.fActionDeleteNodeContext);
        hashtable.put("RenameContext", this.fActionRenameNodeContext);
        return hashtable;
    }

    public void refresh() {
        if (this.hasDocument()) {
            this.setStatusText(this.getDocument().getFileName());
        } else {
            this.setTitle(this.getApplicationName());
            this.setStatusText("");
        }
    }

    @Override
    public void driverStateChanged(DriverModelEvent driverModelEvent) {
        if (driverModelEvent.getType() == 0) {
            this.refresh();
            return;
        }
        if (driverModelEvent.getType() == 15 && this.attemptCloseDocument(false)) {
            File file = (File)driverModelEvent.getTarget();
            this.setDocument(this.createDocument(file.getAbsolutePath()));
            this.addRecentDocumentToList(file.getAbsolutePath());
        }
    }

    private void layoutPanel() {
        this.createMenus();
        this.createBrowser();
        MJStatusBar mJStatusBar = this.fBrowser.getStatusbar();
        mJStatusBar.getParent().getParent().remove(mJStatusBar.getParent());
        mJStatusBar.getParent().remove((Component)mJStatusBar);
        mJStatusBar.add((Component)new JPanel(), (Object)"West");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)mJStatusBar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.createButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 14;
        jPanel.add((Component)new MJCornerGrip(), gridBagConstraints);
        if (!sShowButtonsInStatusBar) {
            mJStatusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.fBrowser.addToSouthPanel((JComponent)jPanel, "Center");
    }

    public void addToolbarButtons(MJToolBar mJToolBar) {
        this.fToolBar = mJToolBar;
        MIDToolbarButton mIDToolbarButton = new MIDToolbarButton();
        mIDToolbarButton.setAction(this.fActionNewInterfaceObjectDriver);
        mIDToolbarButton.setText("");
        this.fToolBar.add((Component)((Object)mIDToolbarButton));
        mIDToolbarButton = new MIDToolbarButton();
        mIDToolbarButton.setAction(this.fActionOpenDocument);
        mIDToolbarButton.setText("");
        this.fToolBar.add((Component)((Object)mIDToolbarButton));
        mIDToolbarButton = new MIDToolbarButton();
        mIDToolbarButton.setAction(this.fActionSaveDocument);
        mIDToolbarButton.setText("");
        this.fToolBar.add((Component)((Object)mIDToolbarButton));
    }

    private void createMenus() {
        this.fMenus = new MJMenu[3];
        MJMenu mJMenu = new MJMenu("File");
        mJMenu.setMnemonic('F');
        MJMenu mJMenu2 = new MJMenu("New");
        MJMenuItem mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        mJMenuItem.setAction(this.fActionNewInterfaceObjectDriver);
        mJMenuItem.setIcon(null);
        mJMenu2.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionNewGenericDriver);
        mJMenuItem.setIcon(null);
        mJMenu2.add((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenu2);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mJMenuItem.setAction(this.fActionOpenDocument);
        mJMenuItem.setIcon(null);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        mJMenuItem.setAction(this.fActionImport);
        mJMenuItem.setIcon(null);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.addSeparator();
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mJMenuItem.setAction(this.fActionSaveDocument);
        mJMenuItem.setIcon(null);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionSaveAsDocument);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.addSeparator();
        this.fRecentMenuItems = new MJMenuItem[4];
        for (int i = 0; i < 4; ++i) {
            this.fRecentMenuItems[i] = mJMenuItem = new MJMenuItem();
            mJMenuItem.setAction(this.fActionOpenRecentDocument);
            mJMenuItem.setIcon(null);
            if (i >= this.fRecentDocuments.size()) continue;
            mJMenuItem.setText(i + 1 + " " + FileUtils.truncatePathname((String)this.fRecentDocuments.get(i), (int)32, (int)0));
            mJMenuItem.putClientProperty((Object)"FullFileName", (Object)this.fRecentDocuments.get(i));
            mJMenu.add((JMenuItem)mJMenuItem);
        }
        if (this.fRecentDocuments.size() > 0) {
            mJMenu.addSeparator();
        }
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        mJMenuItem.setAction(this.fActionQuitApplication);
        mJMenu.add((JMenuItem)mJMenuItem);
        this.fMenus[0] = mJMenu;
        mJMenu = new MJMenu("Edit");
        mJMenu.setMnemonic('E');
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionAddGroup);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionAddProperty);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionAddFunction);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.addSeparator();
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        mJMenuItem.setAction(this.fActionRenameNode);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        mJMenuItem.setAction(this.fActionDuplicateNode);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.addSeparator();
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionDeleteNode);
        mJMenu.add((JMenuItem)mJMenuItem);
        this.fMenus[1] = mJMenu;
        mJMenu = new MJMenu("Help");
        mJMenu.setMnemonic('H');
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionHelp);
        mJMenu.add((JMenuItem)mJMenuItem);
        mJMenu.addSeparator();
        mJMenuItem = new MJMenuItem();
        mJMenuItem.setAction(this.fActionAboutApplication);
        mJMenu.add((JMenuItem)mJMenuItem);
        this.fMenus[2] = mJMenu;
    }

    public MJMenu[] getMenus() {
        return this.fMenus;
    }

    private JPanel createBrowser() {
        this.fBrowser = new Browser("MATLAB Instrument Driver");
        this.fBrowser.setBrowserLayout(1);
        this.fBrowser.setConfigurationFileName("midtool.cfg");
        this.fClient = new DriverClient(this);
        BrowserTreeDetail browserTreeDetail = this.fBrowser.addClients((BrowserClient)this.fClient, "MATLAB Instrument Driver", Browser.matlabImage, 1, null, false);
        browserTreeDetail.okToHiliteTreeView(false);
        this.fBrowser.addToolbar(true);
        this.fBrowser.addToolbarAndButtons(false);
        this.fBrowser.addMenubar(true);
        this.fBrowser.addMenubarAndMenus(false);
        this.fBrowser.addStatusbar(true);
        this.fBrowser.layoutBrowser();
        this.fBrowser.addToFrame();
        this.fBrowser.getCurrentDetailView().clearView();
        this.fBrowser.addTreeViewEditorListener((TreeViewEditorListener)this.fClient);
        this.fTreeView = this.fBrowser.getCurrentTreeView();
        this.fTreeView.setModel(null);
        this.fTreeView.setRootVisible(true);
        this.fTreeView.addTreeSelectionListener((TreeSelectionListener)this);
        return this.fBrowser;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 5, 0));
        Hashtable<String, Action> hashtable = this.getActions();
        if (sShowButtonsInStatusBar) {
            this.fSaveStatusBarButton = new MJButton("Save");
            this.fSaveStatusBarButton.setAction(hashtable.get("Save"));
            this.fSaveStatusBarButton.setIcon(null);
            this.fSaveStatusBarButton.setToolTipText(null);
            this.fSaveStatusBarButton.setVisible(sShowButtonsInStatusBar);
            jPanel2.add((Component)this.fSaveStatusBarButton);
        }
        if (sShowButtonsInStatusBar) {
            this.fCloseStatusBarButton = new MJButton("Close");
            this.fCloseStatusBarButton.setAction(hashtable.get("Quit"));
            this.fCloseStatusBarButton.setText("Close");
            this.fCloseStatusBarButton.setIcon(null);
            this.fCloseStatusBarButton.setToolTipText(null);
            jPanel2.add((Component)this.fCloseStatusBarButton);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void setStatusText(String string) {
        this.fBrowser.getStatusbar().setText(string);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.setActionStateForNode((JTree)this.fTreeView);
    }

    protected DefaultDriverModel createDocument(String string) {
        return this.createDocument(string, 0);
    }

    protected DefaultDriverModel createDocument(String string, int n) {
        if (string == null || string.length() == 0) {
            return new DefaultDriverModel(n);
        }
        try {
            return new DefaultDriverModel(string, n);
        }
        catch (Exception exception) {
            MJOptionPane.showMessageDialog((Component)this.fBrowser.getFrame(), (Object)("Error loading " + string), (String)"Driver Editor", (int)0);
            return new DefaultDriverModel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doSaveAsDialog() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)this.getFileExtensionFilter());
        mJFileChooserPerPlatform.setSelectedFile(new File(this.getDefaultSaveDirectory().getAbsolutePath(), this.fDocument.getDocumentName(true)));
        mJFileChooserPerPlatform.showSaveDialog((Component)this.fBrowser.getFrame());
        this.setDefaultSaveDirectory(mJFileChooserPerPlatform.getCurrentDirectory().getAbsolutePath());
        if (mJFileChooserPerPlatform.getState() != 0 || mJFileChooserPerPlatform.getSelectedFile() == null) {
            return false;
        }
        File file = mJFileChooserPerPlatform.getSelectedFile();
        if (!this.getDocument().verifyExtension(file.getName()).equals(file.getName())) {
            File file2 = new File(file.getParent(), this.getDocument().verifyExtension(file.getName()));
            if (file2.exists()) {
                int n = MJOptionPane.showConfirmDialog((Component)this.fBrowser.getFrame(), (Object)("The file " + file.getName() + ".mdd" + " already exists.  Do you want to replace the existing file"), (String)this.getApplicationName(), (int)1, (int)2);
                if (n != 0) return false;
                this.getDocument().setFile(file2);
                this.addRecentDocumentToList(file.getAbsolutePath());
                this.refresh();
                return true;
            }
            this.getDocument().setFile(file2);
            this.addRecentDocumentToList(file.getAbsolutePath());
            this.refresh();
            return true;
        }
        this.getDocument().setFile(file);
        this.addRecentDocumentToList(file.getAbsolutePath());
        this.refresh();
        return true;
    }

    protected boolean saveDocument() {
        this.fClient.prepareToSave();
        File file = this.fDocument.getFile();
        if (file.exists() && !file.canWrite()) {
            String string = file.getAbsolutePath() + "\n\nThis file is read-only on disk.";
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.add((Component)new MJMultilineLabel(string), (Object)"North");
            int n = MJOptionPane.showOptionDialog((Component)MJFrame.getFrame((Component)this.fToolBar), (Object)mJPanel, (String)"MATLAB Instrument Driver Editor", (int)1, (int)2, null, (Object[])new Object[]{"Save As...", "Overwrite", MJOptionPane.CANCEL_STRING}, (Object)"Save As...");
            if (n == 0) {
                if (this.doSaveAsDialog()) {
                    return this.saveDocument();
                }
                return false;
            }
            if (n == 1) {
                NativeJava.changeFileAttribute((String)file.getAbsolutePath(), (String)"w");
                if (file.exists() && file.canWrite()) {
                    return this.saveDocument();
                }
                MJOptionPane.showMessageDialog((Component)this.fBrowser.getFrame(), (Object)"Unable to overwrite file.\nCheck if directory is read-only");
                return false;
            }
            return false;
        }
        this.fDocument.save();
        return true;
    }

    protected void setStateHaveDocument(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fActionSaveDocument.setEnabled(bl);
            this.fActionSaveAsDocument.setEnabled(bl);
            this.setActionStateForNode((JTree)this.fTreeView);
        } else {
            try {
                AWTUtilities.invokeAndWait((Runnable)new SetStateRunnable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setActionStateForNode(JTree jTree) {
        MIDNode mIDNode = (MIDNode)((Object)jTree.getLastSelectedPathComponent());
        this.fActionAddGroup.setEnabled(false);
        this.fActionAddProperty.setEnabled(false);
        this.fActionAddFunction.setEnabled(false);
        this.fActionRenameNode.setEnabled(false);
        this.fActionDuplicateNode.setEnabled(false);
        this.fActionDeleteNode.setEnabled(false);
        if (mIDNode == null) {
            return;
        }
        switch (mIDNode.getType()) {
            case 0: {
                this.fActionAddGroup.setEnabled(true);
                this.fActionAddProperty.setEnabled(true);
                this.fActionAddFunction.setEnabled(true);
                break;
            }
            case 3: {
                this.fActionAddGroup.setEnabled(true);
                break;
            }
            case 4: {
                this.fActionAddProperty.setEnabled(true);
                this.fActionAddFunction.setEnabled(true);
                break;
            }
            case 9: {
                this.fActionAddProperty.setEnabled(true);
                break;
            }
            case 10: {
                this.fActionAddFunction.setEnabled(true);
                break;
            }
            case 7: {
                this.fActionAddProperty.setEnabled(true);
                break;
            }
            case 8: {
                this.fActionAddFunction.setEnabled(true);
                break;
            }
            case 5: {
                this.fActionDuplicateNode.setEnabled(true);
                break;
            }
            case 6: {
                this.fActionDuplicateNode.setEnabled(true);
            }
        }
        this.fActionRenameNode.setEnabled(mIDNode.isEditable());
        this.fActionDeleteNode.setEnabled(mIDNode.isRemoveable());
    }

    private void createActions() {
        ImageIcon imageIcon = CommonIcon.NEW.getIcon();
        this.fActionNewInterfaceObjectDriver = new NewInterfaceObjectDriverAction("Interface object driver", imageIcon);
        this.fActionNewInterfaceObjectDriver.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        this.fActionNewInterfaceObjectDriver.putValue("MnemonicKey", new Integer(78));
        this.fActionNewInterfaceObjectDriver.putValue("ShortDescription", "Create new interface object driver");
        this.fActionNewGenericDriver = new NewGenericDriverAction("Generic driver", imageIcon);
        this.fActionNewGenericDriver.putValue("ShortDescription", "Create new generic driver");
        imageIcon = CommonIcon.OPEN.getIcon();
        this.fActionOpenDocument = new OpenAction("Open...", imageIcon);
        this.fActionOpenDocument.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.fActionOpenDocument.putValue("MnemonicKey", new Integer(79));
        this.fActionOpenDocument.putValue("ShortDescription", "Open driver");
        this.fActionOpenRecentDocument = new OpenRecentAction("", null);
        this.fActionOpenRecentDocument.putValue("ShortDescription", "Open driver");
        this.fActionImport = new ImportVXIPnPAction("Import...", null);
        this.fActionImport.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
        this.fActionImport.putValue("MnemonicKey", new Integer(86));
        this.fActionImport.putValue("ShortDescription", "Import driver");
        imageIcon = CommonIcon.SAVE.getIcon();
        this.fActionSaveDocument = new SaveAction("Save", imageIcon);
        this.fActionSaveDocument.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.fActionSaveDocument.putValue("MnemonicKey", new Integer(83));
        this.fActionSaveDocument.putValue("ShortDescription", "Save driver");
        this.fActionSaveAsDocument = new SaveAsAction("Save As...", null);
        this.fActionSaveAsDocument.putValue("MnemonicKey", new Integer(65));
        this.fActionSaveAsDocument.putValue("ShortDescription", "Save document to a new file");
        this.fActionQuitApplication = new QuitAction("Close", null);
        this.fActionQuitApplication.putValue("ShortDescription", "Close Editor");
        this.fActionQuitApplication.putValue("MnemonicKey", new Integer(67));
        this.fActionAboutApplication = new AboutAction("About TMApplication", null);
        this.fActionAboutApplication.putValue("MnemonicKey", new Integer(65));
        this.fActionAboutApplication.putValue("Name", "About Instrument Control Toolbox");
        this.fActionHelp = new HelpAction("Instrument Control Toolbox", null);
        this.fActionHelp.putValue("MnemonicKey", new Integer(73));
        this.fActionAddGroup = new AddGroupAction("Add Group", null);
        this.fActionAddGroup.putValue("MnemonicKey", new Integer(71));
        this.fActionAddGroup.putValue("ShortDescription", "Add new instrument group");
        this.fActionAddProperty = new AddPropertyAction("Add Property", null);
        this.fActionAddProperty.putValue("MnemonicKey", new Integer(80));
        this.fActionAddProperty.putValue("ShortDescription", "Add new instrument property");
        this.fActionAddFunction = new AddFunctionAction("Add Function", null);
        this.fActionAddFunction.putValue("MnemonicKey", new Integer(70));
        this.fActionAddFunction.putValue("ShortDescription", "Add new instrument function");
        this.fActionDuplicateNode = new DuplicateNodeAction("Duplicate", null);
        this.fActionDuplicateNode.putValue("MnemonicKey", new Integer(76));
        this.fActionDuplicateNode.putValue("ShortDescription", "Duplicate the selected node");
        this.fActionRenameNode = new RenameNodeAction("Rename", null);
        this.fActionRenameNode.putValue("MnemonicKey", new Integer(82));
        this.fActionRenameNode.putValue("ShortDescription", "Rename the selected node");
        this.fActionDeleteNode = new DeleteNodeAction("Delete", null);
        this.fActionDeleteNode.putValue("MnemonicKey", new Integer(68));
        this.fActionDeleteNode.putValue("ShortDescription", "Delete the selected node");
        this.fActionAddGroupContext = new AddGroupAction("Add Group", null);
        this.fActionAddGroupContext.putValue("MnemonicKey", new Integer(71));
        this.fActionAddGroupContext.putValue("ShortDescription", "Add new instrument group");
        this.fActionAddPropertyContext = new AddPropertyAction("Add Property", null);
        this.fActionAddPropertyContext.putValue("MnemonicKey", new Integer(80));
        this.fActionAddPropertyContext.putValue("ShortDescription", "Add new instrument property");
        this.fActionAddFunctionContext = new AddFunctionAction("Add Function", null);
        this.fActionAddFunctionContext.putValue("MnemonicKey", new Integer(70));
        this.fActionAddFunctionContext.putValue("ShortDescription", "Add new instrument function");
        this.fActionDuplicateNodeContext = new DuplicateNodeAction("Duplicate", null);
        this.fActionDuplicateNodeContext.putValue("MnemonicKey", new Integer(76));
        this.fActionDuplicateNodeContext.putValue("ShortDescription", "Duplicate the selected node");
        this.fActionRenameNodeContext = new RenameNodeAction("Rename", null);
        this.fActionRenameNodeContext.putValue("MnemonicKey", new Integer(82));
        this.fActionRenameNodeContext.putValue("ShortDescription", "Rename the selected node");
        this.fActionDeleteNodeContext = new DeleteNodeAction("Delete", null);
        this.fActionDeleteNodeContext.putValue("MnemonicKey", new Integer(68));
        this.fActionDeleteNodeContext.putValue("ShortDescription", "Delete the selected node");
    }

    protected void handleAboutCommand(ActionEvent actionEvent) {
        if (Matlab.isMatlabAvailable()) {
            new AboutWindow(1, this.fBrowser.getFrame());
        } else {
            MJOptionPane.showMessageDialog((Component)this.fBrowser.getFrame(), (Object)"MATLAB Instrument Driver Editor.", (String)"About MATLAB Instrument Driver Editor", (int)-1);
        }
    }

    protected void handleNewInterfaceObjectDriverCommand(ActionEvent actionEvent) {
        if (this.attemptCloseDocument(false)) {
            this.setDocument(this.createDocument(null));
        }
    }

    protected void handleNewGenericDriverCommand(ActionEvent actionEvent) {
        if (this.attemptCloseDocument(false)) {
            this.setDocument(this.createDocument(null, 4));
        }
    }

    protected void handleOpenCommand(ActionEvent actionEvent) {
        if (!this.attemptCloseDocument(false)) {
            return;
        }
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)this.getFileExtensionFilter());
        mJFileChooserPerPlatform.setCurrentDirectory(this.getDefaultOpenDirectory());
        mJFileChooserPerPlatform.showOpenDialog((Component)this.fBrowser.getFrame());
        this.setDefaultOpenDirectory(mJFileChooserPerPlatform.getCurrentDirectory().getAbsolutePath());
        if (mJFileChooserPerPlatform.getState() != 0 || mJFileChooserPerPlatform.getSelectedFile() == null) {
            return;
        }
        this.setDocument(this.createDocument(mJFileChooserPerPlatform.getSelectedFile().getAbsolutePath()));
        this.addRecentDocumentToList(mJFileChooserPerPlatform.getSelectedFile().getAbsolutePath());
    }

    protected void handleImportCommand(ActionEvent actionEvent) {
        if (!this.attemptCloseDocument(false)) {
            return;
        }
        ImportDialog importDialog = new ImportDialog();
        importDialog.showAsDialog(this.getBrowser().getFrame());
        if (!importDialog.okToImportDriver()) {
            return;
        }
        String string = importDialog.getSelectedDriver();
        int n = importDialog.getSelectedType();
        String string2 = importDialog.getPathForSelectedType();
        DefaultDriverModel defaultDriverModel = null;
        try {
            switch (n) {
                case 1: {
                    String string3 = string2 + "\\" + string + "\\" + string + ".fp";
                    defaultDriverModel = (DefaultDriverModel)VXIPnPLoader.toDriverModel(string3, false);
                    defaultDriverModel.setFile(new File(this.getDefaultSaveDirectory(), string + ".mdd"));
                    this.setDocument(defaultDriverModel);
                    break;
                }
                case 4: {
                    String string4 = string2 + "\\Drivers\\" + string + "\\" + string + ".fp";
                    defaultDriverModel = (DefaultDriverModel)VXIPnPLoader.toDriverModel(string4, true);
                    defaultDriverModel.setFile(new File(this.getDefaultSaveDirectory(), string + ".mdd"));
                    this.setDocument(defaultDriverModel);
                    break;
                }
                case 2: 
                case 3: {
                    this.setStatusText("Loading driver");
                    if (this.fImportRunnable == null) {
                        this.fImportRunnable = new IviImportRunnable();
                    }
                    this.fImportRunnable.setDriverName(string);
                    Matlab.whenMatlabReady((Runnable)this.fImportRunnable);
                }
            }
        }
        catch (Exception exception) {
            MJOptionPane.showMessageDialog((Component)this.getBrowser().getFrame(), (Object)"An error occurred while reading the file.", (String)"File Format Error", (int)0);
            return;
        }
    }

    protected void handleCloseCommand(ActionEvent actionEvent) {
        this.attemptCloseDocument(true);
    }

    protected void handleSaveCommand(ActionEvent actionEvent) {
        this.attemptSaveDocument();
    }

    protected void handleSaveAsCommand(ActionEvent actionEvent) {
        if (this.doSaveAsDialog()) {
            this.saveDocument();
        }
    }

    protected void handleQuitCommand(ActionEvent actionEvent) {
        if (this.attemptCloseDocument(true)) {
            this.fBrowser.getFrame().hide();
        }
    }

    protected FileExtensionFilter getFileExtensionFilter() {
        if (this.fileExtensionFilter == null) {
            this.fileExtensionFilter = new FileExtensionFilter("MATLAB Instrument Driver Files", "mdd", true);
        }
        return this.fileExtensionFilter;
    }

    protected boolean attemptSaveDocument() {
        if (this.fDocument == null) {
            return true;
        }
        if (this.fDocument.isValid() || this.doSaveAsDialog()) {
            return this.saveDocument();
        }
        return false;
    }

    protected boolean attemptCloseDocument(boolean bl) {
        if (this.fDocument == null) {
            return true;
        }
        this.fClient.prepareToSave();
        if (this.fDocument.isDirty()) {
            int n = MJOptionPane.showConfirmDialog((Component)this.fBrowser.getFrame(), (Object)("Do you want to save the changes you made to " + this.fDocument.getDocumentName(true) + "?"), (String)this.getApplicationName(), (int)1, (int)2);
            switch (n) {
                case 0: {
                    this.attemptSaveDocument();
                    break;
                }
                case 1: {
                    break;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
        }
        if (bl) {
            this.setDocument(null);
        }
        return true;
    }

    protected void addRecentDocumentToList(String string) {
        boolean bl = this.fRecentDocuments.contains(string);
        if (bl) {
            this.fRecentDocuments.removeElement(string);
        }
        this.fRecentDocuments.insertElementAt(string, 0);
        if (this.fRecentDocuments.size() > 4) {
            this.fRecentDocuments.removeElementAt(4);
        } else {
            this.fMenus[0].insert((JMenuItem)this.fRecentMenuItems[this.fRecentDocuments.size() - 1], 7 + this.fRecentDocuments.size() - 1);
        }
        if (!bl && this.fRecentDocuments.size() == 1) {
            this.fMenus[0].insertSeparator(8);
        }
        for (int i = 0; i < this.fRecentDocuments.size(); ++i) {
            this.fRecentMenuItems[i].setText(i + 1 + " " + FileUtils.truncatePathname((String)this.fRecentDocuments.get(i), (int)32, (int)0));
            this.fRecentMenuItems[i].putClientProperty((Object)"FullFileName", (Object)this.fRecentDocuments.get(i));
        }
    }

    protected void removeRecentDocumentFromList(String string) {
        this.fRecentDocuments.removeElement(string);
        this.fMenus[0].remove((JMenuItem)this.fRecentMenuItems[this.fRecentDocuments.size() - 1]);
        for (int i = 0; i < this.fRecentDocuments.size(); ++i) {
            this.fRecentMenuItems[i].setText(i + 1 + " " + FileUtils.truncatePathname((String)this.fRecentDocuments.get(i), (int)32, (int)0));
            this.fRecentMenuItems[i].putClientProperty((Object)"FullFileName", (Object)this.fRecentDocuments.get(i));
        }
    }

    public void setTitle(String string) {
        if (this.fBrowser != null) {
            this.fBrowser.setFrameTitle("MATLAB Instrument Driver Editor");
        }
    }

    public Browser getBrowser() {
        return this.fBrowser;
    }

    public JTree getTreeView() {
        return this.fTreeView;
    }

    public static Color getMCommentColor() {
        return sMCommentColor;
    }

    protected void loadPreferences() {
        PreferenceFile preferenceFile = Instrument.getPreferenceFile();
        this.currentOpenDir = null;
        this.currentSaveDir = null;
        this.setDefaultImportDirectory("C:\\VXIPNP\\WINNT");
        this.fRecentDocuments = new Vector();
        String string = preferenceFile.read("MIDToolRecentDocumentCount");
        if (string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    for (int i = 0; i < Math.min(4, n); ++i) {
                        string = preferenceFile.read("MIDToolRecentDocument" + i);
                        if (string.length() <= 0) continue;
                        this.fRecentDocuments.add(string);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = preferenceFile.read("MIDToolOpenDirectory")).length() != 0) {
            this.setDefaultOpenDirectory(string);
        }
        if ((string = preferenceFile.read("MIDToolSaveDirectory")).length() != 0) {
            this.setDefaultSaveDirectory(string);
        }
        if ((string = preferenceFile.read("MIDToolImportDirectory")).length() != 0) {
            this.setDefaultImportDirectory(string);
        }
        if ((string = preferenceFile.read("MIDToolShowButtonsInStatusBar")).length() != 0) {
            MIDTool.setShowButtonsInStatusBar(Boolean.valueOf(string));
        }
        sMCommentColor = ColorPrefs.MatlabColor.COMMENT.getPreferredColor();
    }

    protected void savePreferences() {
        PreferenceFile preferenceFile = Instrument.getPreferenceFile();
        preferenceFile.update("MIDToolRecentDocumentCount", Integer.toString(this.fRecentDocuments.size()));
        for (int i = 0; i < this.fRecentDocuments.size(); ++i) {
            preferenceFile.update("MIDToolRecentDocument" + i, this.fRecentDocuments.get(i));
        }
        if (this.currentOpenDir != null) {
            preferenceFile.update("MIDToolOpenDirectory", this.getDefaultOpenDirectory().getAbsolutePath());
        }
        if (this.currentSaveDir != null) {
            preferenceFile.update("MIDToolSaveDirectory", this.getDefaultSaveDirectory().getAbsolutePath());
        }
        if (this.currentImportDir != null) {
            preferenceFile.update("MIDToolImportDirectory", this.getDefaultImportDirectory().getAbsolutePath());
        }
        preferenceFile.update("MIDToolShowButtonsInStatusBar", Boolean.toString(sShowButtonsInStatusBar));
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        if (matlabEvent.getEventType() == 1) {
            this.savePreferences();
            this.fBrowser.cleanup(this.fBrowser.getFrame());
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.handleQuitCommand(null);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static void setShowButtonsInStatusBar(boolean bl) {
        sShowButtonsInStatusBar = bl;
    }

    public static void newDocument(String string) {
        sMatlabArgs = new String[1];
        MIDTool.sMatlabArgs[0] = string;
        try {
            EventQueue.invokeLater(new NewDocumentRunnable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean openDocument(String string, boolean bl) {
        String string2 = "File " + string + " does not exist.  Do you want to create it?";
        if (!bl) {
            MIDTool.openDocument(string);
            return true;
        }
        DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
        String string3 = "MATLAB Instrument Driver Editor";
        String string4 = Instrument.getPreferenceFile().read("EditorEditFilesDontExist");
        int n = Boolean.valueOf(string4) != false ? 0 : 1;
        boolean bl2 = 0 == Dialogs.showOptionalConfirmDialog((Component)dTFrame, (Object)string2, (String)string3, (int)0, (int)3, (String)"InstrumentControl_MIDEDIT_DNE_Prompt", (int)n, (boolean)true);
        Instrument.getPreferenceFile().update("EditorEditFilesDontExist", Boolean.valueOf(bl2).toString());
        if (bl2) {
            MIDTool.openDocument(string);
        }
        return bl2;
    }

    public static void openDocument(String string) {
        String string2 = string;
        sMatlabArgs = new String[1];
        MIDTool.sMatlabArgs[0] = string2;
        try {
            EventQueue.invokeLater(new OpenDocumentRunnable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openDocument(DefaultDriverModel defaultDriverModel) {
        sMatlabArgs = new Object[1];
        MIDTool.sMatlabArgs[0] = defaultDriverModel;
        try {
            EventQueue.invokeLater(new OpenDocumentRunnable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        sMCommentColor = Color.black;
        sShowButtonsInStatusBar = false;
    }

    private class HelpAction
    extends AbstractAction
    implements Runnable {
        public static final long serialVersionUID = 0L;

        public HelpAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Matlab.isMatlabAvailable()) {
                MIDTool.this.fMatlabFunction = "doc";
                MIDTool.this.fMatlabArgs = new Object[1];
                MIDTool.this.fMatlabArgs[0] = new String("instrument");
                Matlab.whenMatlabReady((Runnable)this);
            } else {
                MJOptionPane.showMessageDialog((Component)MIDTool.this.fBrowser.getFrame(), (Object)"This feature not available outside of MATLAB.", (String)"Instrument Control Toolbox Help", (int)2);
            }
        }

        @Override
        public void run() {
            try {
                Matlab.mtFeval((String)MIDTool.this.fMatlabFunction, (Object[])MIDTool.this.fMatlabArgs, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class AboutAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public AboutAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleAboutCommand(actionEvent);
        }
    }

    private class DuplicateNodeAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public DuplicateNodeAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fClient.duplicate(mIDNode);
        }
    }

    private class RenameNodeAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public RenameNodeAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fTreeView.startEditingAtPath(new TreePath(mIDNode.getPath()));
        }
    }

    private class DeleteNodeAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public DeleteNodeAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fClient.remove(mIDNode);
        }
    }

    private class AddFunctionAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public AddFunctionAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fClient.createFunction(mIDNode);
        }
    }

    private class AddGroupAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public AddGroupAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fClient.createGroup(mIDNode);
        }
    }

    private class AddPropertyAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public AddPropertyAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            MIDNode mIDNode = (MIDNode)((Object)jComponent.getClientProperty("ActualSelectedNode"));
            if (mIDNode == null) {
                mIDNode = (MIDNode)((Object)MIDTool.this.fTreeView.getLastSelectedPathComponent());
            }
            MIDTool.this.fClient.createProperty(mIDNode);
        }
    }

    private class QuitAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public QuitAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleQuitCommand(actionEvent);
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public SaveAsAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleSaveAsCommand(actionEvent);
        }
    }

    private class SaveAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public SaveAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleSaveCommand(actionEvent);
        }
    }

    private class ImportVXIPnPAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public ImportVXIPnPAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleImportCommand(actionEvent);
        }
    }

    private class OpenRecentAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public OpenRecentAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJMenuItem mJMenuItem = (MJMenuItem)actionEvent.getSource();
            String string = (String)mJMenuItem.getClientProperty((Object)"FullFileName");
            if (MIDTool.this.fDocument != null && string.equalsIgnoreCase(MIDTool.this.fDocument.getFileName()) && MIDTool.this.fDocument.isValid()) {
                int n;
                if (!MIDTool.this.fDocument.isDirty() || (n = MJOptionPane.showConfirmDialog((Component)MIDTool.this.fBrowser.getFrame(), (Object)("Reload last saved version of " + MIDTool.this.fDocument.getDocumentName(true) + "?"), (String)"Reload Driver", (int)0)) != 0) return;
                MIDTool.this.setDocument(MIDTool.this.createDocument(string));
                return;
            }
            File file = new File(string);
            if (!file.exists()) {
                MIDTool.this.removeRecentDocumentFromList(string);
                int n = MJOptionPane.showConfirmDialog((Component)MIDTool.this.fBrowser.getFrame(), (Object)"The file can not be found.  Would you like to search for it?", (String)"File Not Found", (int)0);
                if (n != 0) return;
                MIDTool.this.handleOpenCommand(actionEvent);
                return;
            } else {
                if (!MIDTool.this.attemptCloseDocument(false)) return;
                MIDTool.this.setDocument(MIDTool.this.createDocument(string));
                MIDTool.this.addRecentDocumentToList(string);
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public OpenAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleOpenCommand(actionEvent);
        }
    }

    private class NewGenericDriverAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public NewGenericDriverAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleNewGenericDriverCommand(actionEvent);
        }
    }

    private class NewInterfaceObjectDriverAction
    extends AbstractAction {
        public static final long serialVersionUID = 0L;

        public NewInterfaceObjectDriverAction(String string, ImageIcon imageIcon) {
            super(string, imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MIDTool.this.handleNewInterfaceObjectDriverCommand(actionEvent);
        }
    }

    private class IviImportRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();
        private String[] matlabArgs = new String[]{"privateDeviceConstructorHelper", "iviProgramIdFromUnknown", ""};

        private IviImportRunnable() {
        }

        public void setDriverName(String string) {
            this.matlabArgs[2] = string;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", (Object[])this.matlabArgs, 2, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() != 0) {
                this.LoadErrorDlg();
            } else {
                try {
                    Object[] objectArray = (Object[])matlabEvent.getResult();
                    DefaultDriverModel defaultDriverModel = (DefaultDriverModel)objectArray[1];
                    String string = defaultDriverModel.getDriverName();
                    string = string.replaceAll("[\\.]", "_");
                    defaultDriverModel.setFile(new File(MIDTool.this.getDefaultSaveDirectory(), string + ".mdd"));
                    MIDTool.this.setDocument(defaultDriverModel);
                }
                catch (Exception exception) {
                    this.LoadErrorDlg();
                }
            }
            MIDTool.this.setStatusText(MIDTool.this.getDocument().getFileName());
        }

        private void LoadErrorDlg() {
            MJOptionPane.showMessageDialog((Component)MIDTool.this.getBrowser().getFrame(), (Object)"An error occurred while loading the IVI Driver.", (String)"Driver Load Error", (int)0);
        }
    }

    private class SetStateRunnable
    implements Runnable {
        private SetStateRunnable() {
        }

        @Override
        public void run() {
            MIDTool.this.setStateHaveDocument(true);
        }
    }

    private static class OpenDocumentRunnable
    implements Runnable {
        MIDTool app = MIDTool.access$400();
        Object absoluteName = MIDTool.access$500()[0];

        private OpenDocumentRunnable() {
        }

        @Override
        public void run() {
            if (this.app == null) {
                this.app = new MIDTool((String)this.absoluteName);
                if (this.app.getDefaultOpenDirectory() == null) {
                    String string = "";
                    File file = new File((String)this.absoluteName);
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        string = file2.getAbsolutePath();
                    }
                    this.app.setDefaultOpenDirectory(string);
                    if (this.app.getDefaultSaveDirectory() == null) {
                        this.app.setDefaultSaveDirectory(string);
                    }
                }
                this.app.addRecentDocumentToList((String)this.absoluteName);
            } else {
                if (!this.app.attemptCloseDocument(false)) {
                    return;
                }
                if (sMatlabArgs[0] instanceof String) {
                    try {
                        this.app.setDocument(new DefaultDriverModel((String)sMatlabArgs[0], 0));
                    }
                    catch (TMException tMException) {
                        this.app.setDocument(new DefaultDriverModel());
                    }
                    if (this.app.getDefaultOpenDirectory() == null) {
                        String string = "";
                        File file = new File((String)sMatlabArgs[0]);
                        File file3 = file.getParentFile();
                        if (file3 != null) {
                            string = file3.getAbsolutePath();
                        }
                        this.app.setDefaultOpenDirectory(string);
                        if (this.app.getDefaultSaveDirectory() == null) {
                            this.app.setDefaultSaveDirectory(string);
                        }
                    }
                    this.app.addRecentDocumentToList((String)this.absoluteName);
                } else {
                    this.app.setDocument((DefaultDriverModel)sMatlabArgs[0]);
                }
                this.app.fBrowser.getFrame().show();
            }
        }
    }

    private static class NewDocumentRunnable
    implements Runnable {
        private NewDocumentRunnable() {
        }

        @Override
        public void run() {
            MIDTool mIDTool = sInstance;
            if (mIDTool == null) {
                mIDTool = new MIDTool((String)null);
                if (mIDTool.getDefaultOpenDirectory() == null) {
                    mIDTool.setDefaultOpenDirectory((String)sMatlabArgs[0]);
                }
                if (mIDTool.getDefaultSaveDirectory() == null) {
                    mIDTool.setDefaultSaveDirectory((String)sMatlabArgs[0]);
                }
            } else {
                mIDTool.handleNewInterfaceObjectDriverCommand(null);
            }
            mIDTool.getBrowser().getFrame().show();
        }
    }
}

