/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcreate;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.instrument.objectbrowser.InstrumentObjectBrowserClient;
import com.mathworks.toolbox.instrument.objectbrowser.InstrumentObjectBrowserPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;

public class ObjectBrowserPanel
extends MJPanel
implements Runnable,
FocusListener,
ActionListener,
InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.instrcreate.resources.RES_Instrcreate");
    private static final int NEW = 0;
    private static final int DELETE = 1;
    private static final String ACTION = "ACTION";
    private MJFrame frame;
    private InstrumentObjectBrowserPanel instrumentObjectBrowserPanel;
    private MJButton deleteButton;
    private int numOfObjects = 0;
    private Instrument currentObject = null;
    private Object[] matlabArgs = new Object[3];

    public ObjectBrowserPanel(int n, Instrument instrument) {
        this.numOfObjects = n;
        this.currentObject = instrument;
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
        Instrument.addInstrumentObjectListener(this);
        if (this.numOfObjects == 0) {
            this.deleteButton.setEnabled(false);
        }
        this.matlabArgs[0] = "privateInstrcreateHelper";
        this.matlabArgs[1] = "delete";
    }

    public void setup() {
        Instrument.addInstrumentObjectListener(this);
        this.instrumentObjectBrowserPanel.setup();
        this.numOfObjects = Instrument.getNonLockedObjects().size();
    }

    public void cleanup() {
        Instrument.removeInstrumentObjectListener(this);
        this.instrumentObjectBrowserPanel.cleanup();
    }

    private void layoutPanel() {
        this.instrumentObjectBrowserPanel = new InstrumentObjectBrowserPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add((Component)new MJScrollPane((Component)this.instrumentObjectBrowserPanel), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 3, 5, 0));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout());
        MJButton mJButton = new MJButton(RES.getString("button.new"));
        mJButton.setMnemonic(78);
        mJButton.addActionListener((ActionListener)this);
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        mJButton.setName("New Button");
        mJButton.addFocusListener((FocusListener)this);
        this.deleteButton = new MJButton(RES.getString("button.delete"));
        mJButton.setMnemonic(68);
        this.deleteButton.addActionListener((ActionListener)this);
        this.deleteButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.deleteButton.setName("Delete Button");
        this.deleteButton.addFocusListener((FocusListener)this);
        mJPanel3.add((Component)mJButton, (Object)"North");
        mJPanel2.add((Component)mJPanel3);
        mJPanel4.add((Component)this.deleteButton, (Object)"North");
        mJPanel2.add((Component)mJPanel4);
        mJPanel.add((Component)mJPanel2);
        return mJPanel;
    }

    protected void setFrame(MJFrame mJFrame) {
        this.frame = mJFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MJButton mJButton = (MJButton)actionEvent.getSource();
        int n = (Integer)mJButton.getClientProperty((Object)ACTION);
        switch (n) {
            case 0: {
                new NewObjectDialog(1).showAsDialog(this.frame, true);
                break;
            }
            case 1: {
                if (this.numOfObjects <= 0) break;
                this.matlabArgs[2] = this.currentObject;
                Matlab.whenMatlabReady((Runnable)this);
            }
        }
        this.frame.getRootPane().setDefaultButton(null);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.frame.getRootPane().setDefaultButton(null);
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.matlabArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println("ObjectBrowser Exception: " + exception.getMessage());
        }
    }

    public void selectedObjectUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        if (instrument == null) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
        this.currentObject = instrument;
    }

    public void objectVisibilityUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        ++this.numOfObjects;
    }

    public InstrumentObjectBrowserClient getBrowserClient() {
        return this.instrumentObjectBrowserPanel.getInstrumentObjectBrowserClient();
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        ++this.numOfObjects;
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        --this.numOfObjects;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }
}

