/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.objectbrowser;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.objectbrowser.InstrumentObjectBrowserListener;
import com.mathworks.toolbox.testmeas.browser.BaseBrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class InstrumentObjectBrowserClient
extends BaseBrowserClient
implements Runnable,
ActionListener,
PropertyChangedListener,
BrowserClient,
InstrumentObjectListener {
    private static ImageIcon objectImage = new ImageIcon(Instrument.class.getResource("/com/mathworks/toolbox/instrument/resources/instrument.gif"));
    private static ImageIcon groupImage = new ImageIcon(Instrument.class.getResource("/com/mathworks/toolbox/instrument/resources/instr_obj.gif"));
    private static Vector<InstrumentObjectBrowserListener> instrObjectBrowserListeners = null;
    private BrowserTreeNode rootNode = null;
    private BrowserTreeNode[] levelNodes = null;
    private Hashtable<Instrument, BrowserTreeNode> allNodes = new Hashtable();
    private Vector<Instrument> allObjects = new Vector();
    private JMenuItem deleteItem = new JMenuItem("Delete all serial objects");
    private JMenuItem editProperties = new JMenuItem("Edit Properties");
    private boolean okToDoubleClick = false;
    private boolean rightClickEditProperties = false;
    private Object[] matlabArgs = new Object[2];

    public InstrumentObjectBrowserClient() {
        Instrument.addInstrumentObjectListener(this);
        Instrument.addPropertyChangedListener(this);
        this.deleteItem.addActionListener(this);
        this.editProperties.addActionListener(this);
        this.matlabArgs[0] = "privateDisconnect";
    }

    public void setRightClickEditProperties(boolean bl) {
        this.rightClickEditProperties = bl;
    }

    public void setOkToDoubleClick(boolean bl) {
        this.okToDoubleClick = bl;
    }

    public void init() {
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        for (int i = 0; i < vector.size(); ++i) {
            Instrument instrument = vector.elementAt(i);
            this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
        }
    }

    public void setup() {
        Instrument instrument;
        int n;
        Instrument.addInstrumentObjectListener(this);
        Instrument.addPropertyChangedListener(this);
        this.deleteItem.addActionListener(this);
        this.editProperties.addActionListener(this);
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        Vector vector2 = (Vector)this.allObjects.clone();
        for (n = 0; n < vector.size(); ++n) {
            instrument = vector.elementAt(n);
            if (vector2.contains(instrument)) continue;
            this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
        }
        for (n = 0; n < vector2.size(); ++n) {
            instrument = (Instrument)vector2.elementAt(n);
            if (instrument.isvalid() && instrument.getObjectVisibility()) continue;
            this.instrumentObjectDeleted(instrument, instrument.getType(), instrument.getName());
        }
        if (vector.size() > 0) {
            this.postNodeSelectedEvent(this.allNodes.get(vector.elementAt(0)));
        }
    }

    public void cleanup() {
        Instrument.removeInstrumentObjectListener(this);
        Instrument.removePropertyChangedListener(this);
        this.deleteItem.removeActionListener(this);
        this.editProperties.removeActionListener(this);
    }

    public JMenu[] getMenus() {
        return null;
    }

    public JMenuItem getHelpMenuItem() {
        return null;
    }

    public JMenuItem getAboutMenuItem() {
        return null;
    }

    public boolean defineRightClickMenuItems(BrowserTreeNode browserTreeNode, JPopupMenu jPopupMenu) {
        if (browserTreeNode.getUserData() == null) {
            if (browserTreeNode.getName().equals("Instrument Objects")) {
                this.deleteItem.setText("Delete all instrument objects");
                if (this.allObjects.size() == 0) {
                    this.deleteItem.setEnabled(false);
                } else {
                    this.deleteItem.setEnabled(true);
                }
                this.deleteItem.putClientProperty("ACTION", "Delete_all");
            } else {
                this.deleteItem.setText("Delete all " + browserTreeNode.getName() + " objects");
                this.deleteItem.putClientProperty("ACTION", browserTreeNode);
            }
            jPopupMenu.add(this.deleteItem);
        } else {
            if (this.rightClickEditProperties) {
                jPopupMenu.add(this.editProperties);
                this.editProperties.putClientProperty("ACTION", browserTreeNode.getUserData());
                jPopupMenu.addSeparator();
            }
            this.deleteItem.setText("Delete object");
            Instrument instrument = (Instrument)browserTreeNode.getUserData();
            this.deleteItem.putClientProperty("ACTION", instrument);
            if (instrument.getStatus() == 0) {
                this.deleteItem.setEnabled(true);
            } else {
                this.deleteItem.setEnabled(false);
            }
            jPopupMenu.add(this.deleteItem);
        }
        return true;
    }

    public void doubleClickOnNode(BrowserTreeNode browserTreeNode) {
        Object object = browserTreeNode.getUserData();
        if (object == null || !this.okToDoubleClick) {
            return;
        }
        if (!(object instanceof Instrument)) {
            return;
        }
        MLInspectorServices.inspectObject((Object)object);
    }

    public BrowserTreeNode getRootNode() {
        return this.rootNode;
    }

    public BrowserTreeNode[] getLevelOneNodes() {
        return this.levelNodes;
    }

    public JPanel getPanel(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        Object object = browserTreeNode.getUserData();
        if (object != null) {
            this.postSelectedObjectUpdatedEvent((Instrument)object);
        } else {
            this.postSelectedObjectUpdatedEvent(null);
        }
        return null;
    }

    public String getToolTipString(BrowserTreeNode browserTreeNode) {
        return null;
    }

    public ImageIcon getNodeIcon(BrowserTreeNode browserTreeNode) {
        if (browserTreeNode.getIcon() == null) {
            browserTreeNode.setIcon(groupImage);
        }
        return browserTreeNode.getIcon();
    }

    public String getToolboxVersion() {
        return Instrument.jarVersion();
    }

    public String getToolboxName() {
        return "Instrument Control Toolbox";
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        String[] stringArray = new String[]{"Instrument Objects", instrument.getDisplayName()};
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string2, (BrowserClient)this, (Object)instrument);
        browserTreeNode.setIcon(objectImage);
        this.postNodeAddedEvent(string2, stringArray, browserTreeNode, 2, true);
        this.postSelectedObjectUpdatedEvent(instrument);
        this.allNodes.put(instrument, browserTreeNode);
        this.allObjects.addElement(instrument);
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        String[] stringArray = new String[]{"Instrument Objects", instrument.getDisplayName()};
        this.postNodeRemovedEvent(stringArray, instrument, 2);
        this.allNodes.remove(instrument);
        this.allObjects.removeElement(instrument);
    }

    public void selectInstrument(Instrument instrument) {
        BrowserTreeNode browserTreeNode = this.allNodes.get(instrument);
        if (browserTreeNode != null) {
            this.postNodeSelectedEvent(browserTreeNode);
            this.postSelectedObjectUpdatedEvent(instrument);
        }
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (string.equals("Name")) {
            BrowserTreeNode browserTreeNode = this.allNodes.get(instrument);
            if (browserTreeNode == null) {
                return;
            }
            browserTreeNode.setName((String)object);
            this.postNodeUpdatedEvent(browserTreeNode);
        } else if (string.equals("ObjectVisibility")) {
            if (object.equals("off")) {
                return;
            }
            BrowserTreeNode browserTreeNode = this.allNodes.get(instrument);
            if (browserTreeNode == null) {
                this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
                this.postObjectVisibilityUpdateEvent(instrument);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        Object object = jMenuItem.getClientProperty("ACTION");
        try {
            if (jMenuItem.getText().equals("Edit Properties")) {
                MLInspectorServices.inspectObject((Object)object);
            } else if (object instanceof Instrument) {
                this.matlabArgs[1] = object;
                ((Instrument)object).stopasync();
                ((Instrument)object).fclose();
                ((Instrument)object).dispose();
                Matlab.whenMatlabReady((Runnable)this);
            } else if (object instanceof String) {
                Instrument[] instrumentArray = new Instrument[this.allObjects.size()];
                boolean bl = false;
                for (int i = this.allObjects.size() - 1; i >= 0; --i) {
                    try {
                        Instrument instrument;
                        instrumentArray[i] = instrument = this.allObjects.elementAt(i);
                        instrument.stopasync();
                        instrument.fclose();
                        instrument.dispose();
                        continue;
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
                this.matlabArgs[1] = instrumentArray;
                Matlab.whenMatlabReady((Runnable)this);
                if (bl) {
                    TMStringUtil.error((String)"Object Deletion Error", (String)"An object(s) could not be deleted.");
                }
            } else {
                BrowserTreeNode browserTreeNode = (BrowserTreeNode)object;
                int n = browserTreeNode.getChildCount();
                boolean bl = false;
                Instrument[] instrumentArray = new Instrument[n];
                int n2 = 0;
                for (int i = n - 1; i >= 0; --i) {
                    BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getChildAt(i);
                    try {
                        Instrument instrument = (Instrument)browserTreeNode2.getUserData();
                        instrumentArray[n2++] = instrument;
                        instrument.stopasync();
                        instrument.fclose();
                        instrument.dispose();
                        continue;
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                }
                this.matlabArgs[1] = instrumentArray;
                Matlab.whenMatlabReady((Runnable)this);
                if (bl) {
                    TMStringUtil.error((String)"Object Deletion Error", (String)"An object(s) could not be deleted.");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("InstrumentObjectBrowserClient - actionPerformed: " + exception.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            Matlab.mtFeval((String)"instrgate", (Object[])this.matlabArgs, (int)0);
        }
        catch (Exception exception) {
            System.out.println("InstrumentObjectBrowserClient Exception: " + exception.getMessage());
        }
    }

    public static void addInstrumentObjectBrowserListener(InstrumentObjectBrowserListener instrumentObjectBrowserListener) {
        if (instrObjectBrowserListeners == null) {
            instrObjectBrowserListeners = new Vector();
        }
        if (!instrObjectBrowserListeners.contains(instrumentObjectBrowserListener)) {
            instrObjectBrowserListeners.addElement(instrumentObjectBrowserListener);
        }
    }

    public static void removeInstrumentObjectBrowserListener(InstrumentObjectBrowserListener instrumentObjectBrowserListener) {
        if (instrObjectBrowserListeners == null) {
            return;
        }
        instrObjectBrowserListeners.removeElement(instrumentObjectBrowserListener);
        instrumentObjectBrowserListener = null;
    }

    public void postSelectedObjectUpdatedEvent(Instrument instrument) {
        if (instrObjectBrowserListeners == null) {
            return;
        }
        for (int i = 0; i < instrObjectBrowserListeners.size(); ++i) {
            InstrumentObjectBrowserListener instrumentObjectBrowserListener = instrObjectBrowserListeners.elementAt(i);
            instrumentObjectBrowserListener.selectedObjectUpdated(instrument, this);
        }
    }

    public void postObjectVisibilityUpdateEvent(Instrument instrument) {
        if (instrObjectBrowserListeners == null) {
            return;
        }
        for (int i = 0; i < instrObjectBrowserListeners.size(); ++i) {
            InstrumentObjectBrowserListener instrumentObjectBrowserListener = instrObjectBrowserListeners.elementAt(i);
            instrumentObjectBrowserListener.objectVisibilityUpdated(instrument, this);
        }
    }
}

