/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.logging.Levels;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.security.Security;

class Item
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger;
    private static final boolean enableImplToStubReplacement;
    public ServiceID serviceID;
    public ServiceType serviceType;
    public String codebase;
    public MarshalledWrapper service;
    public EntryRep[] attributeSets;

    public Item(ServiceItem serviceItem) throws RemoteException {
        Object object = serviceItem.service;
        if (enableImplToStubReplacement && object instanceof Remote) {
            try {
                object = RemoteObject.toStub((Remote)object);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "replacing {0} with {1}", new Object[]{serviceItem.service, object});
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.serviceID = serviceItem.serviceID;
        ServiceTypeBase serviceTypeBase = ClassMapper.toServiceTypeBase(object.getClass());
        this.serviceType = serviceTypeBase.type;
        this.codebase = serviceTypeBase.codebase;
        try {
            this.service = new MarshalledWrapper(object);
        }
        catch (IOException iOException) {
            throw new MarshalException("error marshalling arguments", iOException);
        }
        this.attributeSets = EntryRep.toEntryRep(serviceItem.attributeSets, true);
    }

    public ServiceItem get() {
        Object object = null;
        try {
            object = this.service.get();
        }
        catch (Throwable throwable) {
            RegistrarProxy.handleException(throwable);
        }
        return new ServiceItem(this.serviceID, object, EntryRep.toEntry(this.attributeSets));
    }

    public Object clone() {
        try {
            Item item = (Item)super.clone();
            EntryRep[] entryRepArray = (EntryRep[])item.attributeSets.clone();
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryRepArray[n] = (EntryRep)entryRepArray[n].clone();
            }
            item.attributeSets = entryRepArray;
            return item;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static ServiceItem[] toServiceItem(ArrayList arrayList) {
        ServiceItem[] serviceItemArray = null;
        if (arrayList != null) {
            serviceItemArray = new ServiceItem[arrayList.size()];
            int n = serviceItemArray.length;
            while (--n >= 0) {
                serviceItemArray[n] = ((Item)arrayList.get(n)).get();
            }
        }
        return serviceItemArray;
    }

    static {
        Boolean bl;
        logger = Logger.getLogger("com.sun.jini.reggie");
        try {
            bl = (Boolean)Security.doPrivileged((PrivilegedAction)new GetBooleanAction("com.sun.jini.reggie.enableImplToStubReplacement"));
        }
        catch (SecurityException securityException) {
            logger.log(Levels.HANDLED, "failed to read system property", securityException);
            bl = Boolean.FALSE;
        }
        enableImplToStubReplacement = bl;
    }
}

