/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.constant.SysProperties;
import org.h2.message.Message;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static String toUpperEnglish(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerEnglish(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String quoteStringSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\'');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string)) + ")";
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    public static String javaEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                default: {
                    int n = c & 0xFFFF;
                    if (n >= 32 && n < 128) {
                        stringBuffer.append(c);
                        continue block8;
                    }
                    stringBuffer.append("\\u");
                    stringBuffer.append(Integer.toHexString(0x10000 | n).substring(1));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String addAsterisk(String string, int n) {
        if (string != null && n < string.length()) {
            string = string.substring(0, n) + "[*]" + string.substring(n);
        }
        return string;
    }

    private static SQLException getFormatException(String string, int n) {
        return Message.getSQLException(90095, StringUtils.addAsterisk(string, n));
    }

    public static String javaDecode(String string) throws SQLException {
        char c;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block17: for (int i = 0; i < string.length() && (c = string.charAt(i)) != '\"'; ++i) {
            if (c == '\\') {
                if (i >= string.length()) {
                    throw StringUtils.getFormatException(string, string.length() - 1);
                }
                c = string.charAt(++i);
                switch (c) {
                    case 't': {
                        stringBuffer.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuffer.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuffer.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuffer.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.getFormatException(string, i);
                        }
                        i += 4;
                        stringBuffer.append(c);
                        continue block17;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(string.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.getFormatException(string, i);
                            }
                            i += 2;
                            stringBuffer.append(c);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(string, i);
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String quoteJavaString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string) + "\"";
    }

    public static byte[] utf8Encode(String string) throws SQLException {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convert(unsupportedEncodingException);
        }
    }

    public static String utf8Decode(byte[] byArray) {
        try {
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    private static String utf8Decode(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Message.convertToInternal(unsupportedEncodingException);
        }
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(5 * stringArray.length);
        stringBuffer.append("new String[]{");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(StringUtils.quoteJavaString(stringArray[i]));
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(2 * nArray.length);
        stringBuffer.append("new int[]{");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String enclose(String string) {
        if (string.startsWith("(")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unEnclose(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public static String urlDecode(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                byArray[n++] = 32;
                continue;
            }
            if (c == '%') {
                byArray[n++] = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (SysProperties.CHECK && (c > '\u007f' || c < ' ')) {
                throw new IllegalArgumentException("unexpected char " + c + " decoding " + string);
            }
            byArray[n++] = (byte)c;
        }
        String string2 = StringUtils.utf8Decode(byArray, 0, n);
        return string2;
    }

    public static String[] arraySplit(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                String string2 = stringBuffer.toString();
                arrayList.add(bl ? string2.trim() : string2);
                stringBuffer.setLength(0);
                continue;
            }
            if (c2 == '\\' && i < string.length() - 1) {
                stringBuffer.append(string.charAt(++i));
                continue;
            }
            stringBuffer.append(c2);
        }
        String string3 = stringBuffer.toString();
        arrayList.add(bl ? string3.trim() : string3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String arrayCombine(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer(5 * stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (i > 0) {
                stringBuffer.append(c);
            }
            if ((string = stringArray[i]) == null) {
                string = "";
            }
            for (int j = 0; j < string.length(); ++j) {
                char c2 = string.charAt(j);
                if (c2 == '\\' || c2 == c) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) throws SQLException {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = StringUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) throws SQLException {
        SimpleDateFormat simpleDateFormat = StringUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw Message.getSQLException(90014, new String[]{string}, parseException);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) throws SQLException {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw Message.getSQLException(90014, new String[]{string + "/" + string2 + "/" + string3}, exception);
        }
    }

    public static String xmlAttr(String string, String string2) {
        return " " + string + "=\"" + StringUtils.xmlText(string2) + "\"";
    }

    public static String xmlNode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string2 == null ? string : string + string2;
        if (string3 == null) {
            return "<" + string4 + "/>\n";
        }
        if (string3.indexOf(10) >= 0) {
            string3 = "\n" + StringUtils.indent(string3);
        }
        return "<" + string4 + ">" + string3 + "</" + string + ">\n";
    }

    private static String indent(String string) {
        return StringUtils.indent(string, 4);
    }

    private static String indent(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + n);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append(' ');
            }
            n3 = string.indexOf(10, n2);
            n3 = n3 < 0 ? string.length() : n3 + 1;
            stringBuffer.append(string.substring(n2, n3));
            n2 = n3;
        }
        if (!string.endsWith("\n")) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String xmlComment(String string) {
        int n = 0;
        while ((n = string.indexOf("--", n)) >= 0) {
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(string) + "-->\n";
        }
        return "<!-- " + string + " -->\n";
    }

    public static String xmlCData(String string) {
        if (string.indexOf("]]>") >= 0) {
            return StringUtils.xmlText(string);
        }
        boolean bl = string.endsWith("\n");
        string = "<![CDATA[" + string + "]]>";
        return bl ? string + "\n" : string;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        stringBuffer.append("&#x");
                        stringBuffer.append(Integer.toHexString(c));
                        stringBuffer.append(';');
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) < 0) break;
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String quoteIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String quoteRemarkSQL(String string) {
        int n;
        while ((n = string.indexOf("*/")) >= 0) {
            string = string.substring(0, n) + "++/" + string.substring(n + 2);
        }
        while ((n = string.indexOf("/*")) >= 0) {
            string = string.substring(0, n) + "/++" + string.substring(n + 2);
        }
        return string;
    }

    public static String pad(String string, int n, String string2, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (n < string.length()) {
            return string.substring(0, n);
        }
        if (n == string.length()) {
            return string;
        }
        char c = string2 == null || string2.length() == 0 ? (char)' ' : (char)string2.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(n);
        n -= string.length();
        if (bl) {
            stringBuffer.append(string);
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        if (!bl) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

