/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryContentPanel;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryHeader;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryIconPanel;
import com.mathworks.toolstrip.components.gallery.popupview.CategoryListPanel;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class CategoryPanel {
    private final Category fCategory;
    private final GalleryModel fModel;
    private final PopupMenuCustomizer fMenuCustomizer;
    private final GallerySelectionModel fSelectionModel;
    private final int fPreferredWidth;
    private final Dimension fItemSize;
    private final int fLabelLineCount;
    private final int fCategoryIndex;
    private final boolean fEnableItemDrag;
    private final MJPanel fComponent;
    private CategoryContentPanel fContent;
    private CategoryHeader fHeader;
    private GalleryOptions.PopupViewType fViewType;
    private ActionListener fActionListener;
    private ActionListener fCloseListener;
    private Runnable fFavoritesAnimation;

    CategoryPanel(Category category, GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, PopupMenuCustomizer popupMenuCustomizer, Runnable runnable, GalleryOptions.PopupViewType popupViewType, Runnable runnable2, int n, Dimension dimension, int n2, int n3, boolean bl) {
        this.fCategory = category;
        this.fModel = galleryModel;
        this.fSelectionModel = gallerySelectionModel;
        this.fMenuCustomizer = popupMenuCustomizer;
        this.fPreferredWidth = n;
        this.fItemSize = dimension;
        this.fLabelLineCount = n2;
        this.fCategoryIndex = n3;
        this.fEnableItemDrag = bl;
        this.fFavoritesAnimation = runnable2;
        this.fComponent = new MJPanel((LayoutManager)new BorderLayout());
        this.fComponent.setName("Category_" + category.getName());
        this.fHeader = new CategoryHeader(category, runnable);
        this.fComponent.add((Component)this.fHeader.getComponent(), (Object)"North");
        this.setViewType(popupViewType);
    }

    CategoryPanel(CategoryPanel categoryPanel) {
        this(categoryPanel.fCategory, categoryPanel.fModel, categoryPanel.fSelectionModel, categoryPanel.fMenuCustomizer, null, categoryPanel.fViewType, categoryPanel.fFavoritesAnimation, categoryPanel.fPreferredWidth, categoryPanel.fItemSize, categoryPanel.fLabelLineCount, categoryPanel.fCategoryIndex, false);
    }

    void setViewType(GalleryOptions.PopupViewType popupViewType) {
        if (popupViewType != this.fViewType) {
            if (this.fContent != null) {
                this.fComponent.remove((Component)((Object)this.fContent));
                this.fContent.dispose();
                this.fContent = null;
            }
            if (popupViewType == GalleryOptions.PopupViewType.LIST) {
                this.fComponent.setBackground(ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor());
                this.fHeader.setMinimalAppearance(false);
                this.fContent = new CategoryListPanel(this.fCategory, this.fModel, this.fSelectionModel, this.fMenuCustomizer, this.fFavoritesAnimation);
            } else {
                this.fComponent.setBackground(this.fCategoryIndex % 2 == 0 ? ToolstripTheme.getInstance().getGalleryNonSelectedBackgroundColor() : ToolstripTheme.getInstance().getGalleryAlternateBackgroundColor());
                this.fHeader.setMinimalAppearance(true);
                this.fContent = new CategoryIconPanel(this.fCategory, this.fModel, this.fSelectionModel, this.fMenuCustomizer, this.fFavoritesAnimation, this.fPreferredWidth, this.fItemSize, this.fLabelLineCount);
            }
            if (this.fActionListener != null) {
                this.fContent.setActionListener(this.fActionListener);
            }
            if (this.fCloseListener != null) {
                this.fContent.setCloseListener(this.fCloseListener);
            }
            this.fContent.setDragEnabled(this.fEnableItemDrag);
            this.fContent.setOpaque(false);
            this.fComponent.add((Component)((Object)this.fContent), (Object)"Center");
            this.fViewType = popupViewType;
        }
    }

    void setActionListener(ActionListener actionListener) {
        this.fActionListener = actionListener;
        if (this.fContent != null) {
            this.fContent.setActionListener(actionListener);
        }
    }

    void setCloseListener(ActionListener actionListener) {
        this.fCloseListener = actionListener;
        if (this.fContent != null) {
            this.fContent.setCloseListener(actionListener);
        }
    }

    public void dispose() {
        if (this.fContent != null) {
            this.fContent.dispose();
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public JComponent getContentPanel() {
        return this.fContent;
    }

    public Item getItemAtPoint(Point point) {
        if (this.fContent != null) {
            Point point2 = SwingUtilities.convertPoint((Component)this.fComponent, point, (Component)((Object)this.fContent));
            return this.fContent.getItemAtPoint(point2);
        }
        return null;
    }
}

