/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.view;

import com.mathworks.mwswing.MJButton;
import com.mathworks.toolstrip.Previewer;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.Action;

class HintButton
extends MJButton {
    private static final int VERTICAL_MARGIN = 2;
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0, 64);
    private static final Color ROLLOVER_BACKGROUND = new Color(0, 0, 0, 96);
    private static final Color FOREGROUND_COLOR = Color.white;
    private Previewer fShowingPreviewer;

    HintButton() {
        this.setName("GalleryHintButton");
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusTraversable(false);
        this.setFont(ToolstripTheme.getInstance().getSectionTitleFont().deriveFont(1, 14.0f));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Previewer previewer = this.getPreviewer();
                if (previewer != null) {
                    HintButton.this.showPreview(previewer);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HintButton.this.hidePreview();
            }

            private Previewer getPreviewer() {
                Action action = HintButton.this.getAction();
                return action == null ? null : (Previewer)action.getValue("previewer");
            }
        });
    }

    private void showPreview(Previewer previewer) {
        this.fShowingPreviewer = previewer;
        previewer.showPreview();
    }

    private void hidePreview() {
        if (this.fShowingPreviewer != null) {
            this.fShowingPreviewer.hidePreview();
            this.fShowingPreviewer = null;
        }
    }

    public void setAction(Action action) {
        super.setAction(action);
        this.hidePreview();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Graphics graphics = this.getGraphics();
        Dimension dimension = fontMetrics.getStringBounds(this.getText(), graphics).getBounds().getSize();
        dimension.height += 4;
        dimension.width += dimension.height;
        graphics.dispose();
        return dimension;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getHeight();
        int n2 = this.getWidth();
        Area area = new Area(new Rectangle(n / 2, 0, n2 - n, n));
        area.add(new Area(new Ellipse2D.Float(0.0f, 0.0f, n, n)));
        area.add(new Area(new Ellipse2D.Float(n2 - n, 0.0f, n, n)));
        graphics2D.setColor(this.isEnabled() && this.model.isRollover() ? ROLLOVER_BACKGROUND : BACKGROUND_COLOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(area);
        String string = this.getText();
        graphics2D.setFont(this.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        graphics2D.setColor(FOREGROUND_COLOR);
        LAFUtil.drawString(graphics2D, string, (n2 - n3) / 2, 2 + fontMetrics.getAscent());
    }
}

