/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.Attributes;
import com.mathworks.desktop.client.Client;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.toolstrip.DefaultToolstripTab;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.Resources;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSCheckBox;
import com.mathworks.toolstrip.components.TSComboBox;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSRadioButton;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.TSToggleButton;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.DefaultGalleryModel;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.model.WrappedGalleryModel;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.toolstrip.factory.TargetedGalleryModel;
import com.mathworks.toolstrip.sections.FlowToolstripSection;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TSFactory {
    public static final Attribute<Action> ACTION_ATTRIBUTE = new Attribute("action");
    public static final String TOOL_PATH_PROPERTY_KEY = "tool path";
    public static final String TOOL_COMPONENT_PROPERTY_KEY = "tool component";
    public static final Attribute<TSToolPath> TOOL_PATH_ATTRIBUTE = new Attribute("tool path");
    public static final String INVOKER_PROPERTY_KEY = "invoker";
    public static final String CACHE_COMPONENT_KEY = "cash_ts_component";
    private static final Attribute<TSToolSet[]> TOOL_SETS_ATTRIBUTE = new Attribute("tool sets");
    private static final String ORIGINAL_TAB_PROPERTY_KEY = "original tab";
    private static final Attribute<Disposable> DISPOSABLE_ATTRIBUTE = new Attribute("disposable");
    private static final Map<String, GalleryModel> fSharedGalleryModelMap = new HashMap<String, GalleryModel>();

    private TSFactory() {
    }

    public static ToolstripTab createTab(TSTabConfiguration tSTabConfiguration, TSToolSet ... tSToolSetArray) {
        return TSFactory.createTab(tSTabConfiguration, false, tSToolSetArray);
    }

    public static ToolstripTab createTab(TSTabConfiguration tSTabConfiguration, boolean bl, TSToolSet ... tSToolSetArray) {
        return TSFactory.createTab(tSTabConfiguration, bl, null, null, tSToolSetArray);
    }

    @Deprecated
    public static ToolstripTab createTab(TSTabConfiguration tSTabConfiguration, ContextTargetingManager contextTargetingManager, boolean bl, TSToolSet ... tSToolSetArray) {
        return TSFactory.createTab(tSTabConfiguration, bl, contextTargetingManager, null, tSToolSetArray);
    }

    public static ToolstripTab createTab(TSTabConfiguration tSTabConfiguration, boolean bl, ContextTargetingManager contextTargetingManager, TSRegistry tSRegistry, TSToolSet ... tSToolSetArray) {
        Map<String, TSToolSet> map = TSFactory.createToolSetMap(tSToolSetArray);
        String string = tSTabConfiguration.getLabel();
        DefaultToolstripTab defaultToolstripTab = new DefaultToolstripTab(tSTabConfiguration.getName(), MJUtilities.exciseMnemonic((String)string));
        defaultToolstripTab.setAttribute(TOOL_SETS_ATTRIBUTE, tSToolSetArray);
        char c = MJUtilities.findMnemonic((String)string);
        if (c != '\u0000') {
            defaultToolstripTab.setAttribute((Attribute)ToolstripTab.MNEMONIC, "" + c);
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
            }
        };
        defaultToolstripTab.setAttribute(DISPOSABLE_ATTRIBUTE, disposable);
        for (TSTabConfiguration.Section section : tSTabConfiguration.getSections()) {
            Object object;
            Object object4;
            if (section.isEmpty() || !section.isVisible()) continue;
            TSToolPath tSToolPath = new TSToolPath(tSTabConfiguration.getContextName(), tSTabConfiguration.getName(), section.getName());
            if (section.getLayoutType() == TSTabConfiguration.SectionLayoutType.FLOW) {
                object4 = new FlowToolstripSection(section.getName(), section.getLabel(), section.getPriority());
                for (TSTabConfiguration.Tool tool : section.getTools()) {
                    Object object2;
                    if (!tool.isVisible() || !((object = TSFactory.createComponent((TSToolPath)(object2 = new TSToolPath(tSToolPath, tool.getName(), tool.getToolSetName())), map, tSRegistry, TSToolSet.ToolLocation.TOOLSTRIP_TAB, contextTargetingManager, bl, !tool.isOptional(), disposable)) instanceof TSComponent)) continue;
                    ((FlowToolstripSection)object4).add((TSComponent)object);
                }
                defaultToolstripTab.getModel().add((Client)object4);
                continue;
            }
            object4 = ToolstripSections.newSectionBuilder(section.getName(), section.getLabel(), section.getPriority());
            int n = 0;
            for (Object object2 : section.getTools()) {
                if (!((TSTabConfiguration.Tool)object2).isVisible()) continue;
                if (((TSTabConfiguration.Tool)object2).isSeparator()) {
                    object4.separator();
                    continue;
                }
                object = new TSToolPath(tSToolPath, ((TSTabConfiguration.Tool)object2).getName(), ((TSTabConfiguration.Tool)object2).getToolSetName());
                JComponent jComponent = TSFactory.createComponent((TSToolPath)object, map, tSRegistry, TSToolSet.ToolLocation.TOOLSTRIP_TAB, contextTargetingManager, bl, !((TSTabConfiguration.Tool)object2).isOptional(), disposable);
                if (jComponent == null) continue;
                jComponent.putClientProperty("horizontalAlignment", ((TSTabConfiguration.Tool)object2).getHorizontalAlignment());
                if (jComponent instanceof TSButton) {
                    ((TSButton)((Object)jComponent)).setOrientation(((TSTabConfiguration.Tool)object2).getOrientation());
                } else if (jComponent instanceof TSToggleButton) {
                    ((TSToggleButton)((Object)jComponent)).setOrientation(((TSTabConfiguration.Tool)object2).getOrientation());
                }
                object4.add(jComponent);
                ++n;
            }
            if (n <= 0) continue;
            defaultToolstripTab.getModel().add((Client)object4.build());
        }
        return defaultToolstripTab;
    }

    public static void disposeTab(ToolstripTab toolstripTab) {
        Disposable disposable = (Disposable)toolstripTab.getAttribute(DISPOSABLE_ATTRIBUTE);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void populate(ExtendedInputMap extendedInputMap, ActionMap actionMap, KeyBindingManager keyBindingManager, TSToolSet ... tSToolSetArray) {
        for (TSToolSet tSToolSet : tSToolSetArray) {
            for (Map.Entry<String, Action> entry : tSToolSet.getActions()) {
                if (!(entry.getValue() instanceof ExtendedAction)) continue;
                ExtendedAction extendedAction = (ExtendedAction)entry.getValue();
                if (keyBindingManager.containsAction(extendedAction.getActionID())) {
                    keyBindingManager.addKeyBindings(extendedAction, extendedInputMap);
                    keyBindingManager.addToActionMap(extendedAction, actionMap);
                    continue;
                }
                List list = extendedAction.getAccelerators();
                if (list == null || list.isEmpty()) continue;
                String string = tSToolSet.getName() + ":" + entry.getKey();
                actionMap.put(string, (Action)extendedAction);
                for (KeyStrokeList keyStrokeList : list) {
                    extendedInputMap.put(keyStrokeList.toKeyStrokeArray(), (Object)string);
                }
            }
        }
    }

    public static void populate(JToolBar jToolBar, QuickAccessConfiguration quickAccessConfiguration, TSRegistry tSRegistry, Toolstrip toolstrip, ContextTargetingManager contextTargetingManager) {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        boolean bl2 = false;
        if (jToolBar instanceof MJToolBar) {
            bl2 = ((MJToolBar)jToolBar).isMorePopupEnabled();
            ((MJToolBar)jToolBar).setMorePopupEnabled(false);
        }
        HashMap<Object, JComponent> hashMap = new HashMap<Object, JComponent>();
        for (Component component : jToolBar.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            object3 = (JComponent)component;
            bl = true;
            if (object3 instanceof AbstractButton && (object2 = ((AbstractButton)object3).getAction()) != null && (object = object2.getValue(CACHE_COMPONENT_KEY)) != null && object instanceof Boolean && !((Boolean)object).booleanValue()) {
                bl = false;
            }
            if ((object2 = (TSToolPath)((JComponent)object3).getClientProperty(TOOL_PATH_PROPERTY_KEY)) != null && bl) {
                hashMap.put(object2, (JComponent)object3);
                continue;
            }
            TSFactory.dispose((JComponent)object3);
        }
        jToolBar.removeAll();
        for (QuickAccessConfiguration.Tool tool : quickAccessConfiguration.getTools()) {
            Component component;
            TSToolPath tSToolPath = tool.getPath();
            component = toolstrip == null ? null : (ToolstripTab)toolstrip.getModel().get(tSToolPath.getTabName());
            object3 = null;
            if (component != null) {
                TSToolSet[] tSToolSetArray = (TSToolSet[])component.getAttribute(TOOL_SETS_ATTRIBUTE);
                if (tSToolSetArray != null) {
                    object3 = TSFactory.createToolSetMap(tSToolSetArray);
                }
                if (tSToolSetArray == null || !object3.containsKey(tSToolPath.getToolSetName())) {
                    component = null;
                }
            }
            if (!(bl = tool.getDisplayCondition() == QuickAccessConfiguration.DisplayCondition.ALWAYS || component != null && (tool.getDisplayCondition() == QuickAccessConfiguration.DisplayCondition.WHEN_TAB_PRESENT || tool.getDisplayCondition() == QuickAccessConfiguration.DisplayCondition.WHEN_TOOLSTRIP_MINIMIZED && toolstrip != null && toolstrip.getAttribute((Attribute)Toolstrip.STATE) == Toolstrip.State.COLLAPSED))) continue;
            object2 = (JComponent)hashMap.remove(tool.getPath());
            if (object2 != null && ((JComponent)object2).getClientProperty(ORIGINAL_TAB_PROPERTY_KEY) != component) {
                TSFactory.dispose((JComponent)object2);
                object2 = null;
            }
            if (object2 == null) {
                if (component != null) {
                    object2 = TSFactory.createComponent(tSToolPath, (Map<String, TSToolSet>)object3, tSRegistry, TSToolSet.ToolLocation.QUICK_ACCESS_BAR, contextTargetingManager, true, false, null);
                    TSFactory.addQuickAccessConfigUpdater(tSToolPath, (Map<String, TSToolSet>)object3, quickAccessConfiguration);
                } else {
                    object2 = TSFactory.createComponent(tSToolPath, tSRegistry.getToolSetMap(), tSRegistry, TSToolSet.ToolLocation.QUICK_ACCESS_BAR, contextTargetingManager, true, false, null);
                    TSFactory.addQuickAccessConfigUpdater(tSToolPath, tSRegistry.getToolSetMap(), quickAccessConfiguration);
                    if (object2 == null && (object = tSRegistry.getToolSetContents(tSToolPath.getToolSetName())) != null && (object2 = TSFactory.createPlaceHolder(tSToolPath.getToolName(), (TSToolSetContents)object, tSToolPath, TSToolSet.ToolLocation.QUICK_ACCESS_BAR, contextTargetingManager)) != null) {
                        ((Component)object2).setName("QuickAccess:" + ((Component)object2).getName());
                    }
                }
            }
            if (object2 == null) continue;
            ((JComponent)object2).putClientProperty(ORIGINAL_TAB_PROPERTY_KEY, component);
            if (object2 instanceof TSDropDownButton) {
                ((JComponent)object2).putClientProperty("MoreMenuIneligible", true);
            }
            if (object2 instanceof MJButton) {
                object = (MJButton)object2;
                object.setText(MJUtilities.exciseMnemonic((String)MJUtilities.exciseBracketMnemonic((String)object.getText())));
                object.setAutoMnemonicEnabled(false);
                MJToolBar.configureButton((MJButton)object);
                object.setBorder(BorderFactory.createEmptyBorder());
                if (tool.isLabelVisible()) {
                    object.unHideText();
                }
            } else if (object2 instanceof MJToggleButton) {
                object = (MJToggleButton)object2;
                object.setText(MJUtilities.exciseMnemonic((String)MJUtilities.exciseBracketMnemonic((String)object.getText())));
                object.setAutoMnemonicEnabled(false);
                MJToolBar.configureButton((MJToggleButton)object);
                object.setBorder(BorderFactory.createEmptyBorder());
                if (tool.isLabelVisible()) {
                    object.unHideText();
                }
            }
            jToolBar.add((Component)object2);
        }
        for (JComponent jComponent : hashMap.values()) {
            TSFactory.dispose(jComponent);
        }
        if (bl2) {
            ((MJToolBar)jToolBar).setMorePopupEnabled(true);
        }
    }

    private static void dispose(JComponent jComponent) {
        Disposable disposable = TSFactory.getDisposable(jComponent);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static void addQuickAccessConfigUpdater(final TSToolPath tSToolPath, Map<String, TSToolSet> map, final QuickAccessConfiguration quickAccessConfiguration) {
        String string = tSToolPath.getToolName();
        String string2 = tSToolPath.getToolSetName();
        TSToolSet tSToolSet = map.get(string2);
        if (tSToolSet != null && tSToolSet.getAction(string) != null) {
            tSToolSet.addListener(new TSToolSet.Listener(){

                @Override
                public void actionAdded(TSToolSet tSToolSet, String string) {
                }

                @Override
                public void actionRemoved(TSToolSet tSToolSet, String string) {
                    quickAccessConfiguration.removeTool(tSToolPath);
                }
            }, string);
        }
    }

    public static void addToPopupList(PopupList popupList, List<Action> list) {
        TSFactory.addToPopupList(popupList, list, null);
    }

    public static void addToPopupList(PopupList popupList, List<Action> list, ListStyle listStyle) {
        assert (popupList.getModel() instanceof DefaultListModel);
        DefaultListModel defaultListModel = (DefaultListModel)popupList.getModel();
        for (Action action : list) {
            defaultListModel.addElement(TSFactory.createListItemFromAction(action, listStyle));
        }
    }

    public static ListItem createListItemFromAction(Action action, ListStyle listStyle) {
        String string = (String)action.getValue("shortcut-free-description");
        if (string == null) {
            string = (String)action.getValue("ShortDescription");
        }
        ListItem listItem = ListItem.newItem((String)action.getValue("Name"), MJUtilities.exciseMnemonic((String)((String)action.getValue("Name"))), string, (Icon)action.getValue("SmallIcon"));
        if (listStyle != null) {
            listItem.getAttributes().setAttribute(ListItem.STYLE, (Object)listStyle);
        }
        TSFactory.setItemAttributesFromAction(listItem, action);
        return listItem;
    }

    public static Collection<TSToolSet> getToolSetsFromTab(ToolstripTab toolstripTab) {
        TSToolSet[] tSToolSetArray = (TSToolSet[])toolstripTab.getAttribute(TOOL_SETS_ATTRIBUTE);
        return tSToolSetArray != null ? Arrays.asList(tSToolSetArray) : Collections.EMPTY_LIST;
    }

    private static Map<String, TSToolSet> createToolSetMap(TSToolSet ... tSToolSetArray) {
        HashMap<String, TSToolSet> hashMap = new HashMap<String, TSToolSet>();
        for (TSToolSet tSToolSet : tSToolSetArray) {
            if (tSToolSet == null) continue;
            hashMap.put(tSToolSet.getName(), tSToolSet);
        }
        return hashMap;
    }

    private static JComponent createComponent(TSToolPath tSToolPath, Map<String, TSToolSet> map, TSRegistry tSRegistry, TSToolSet.ToolLocation toolLocation, ContextTargetingManager contextTargetingManager, boolean bl, boolean bl2, Disposable disposable) {
        Object object2;
        String string = tSToolPath.getToolName();
        String string2 = tSToolPath.getToolSetName();
        TSToolSet tSToolSet = map.get(string2);
        if (tSToolSet == null) {
            if (bl2) {
                Log.log((String)("Warning: Unable to find tool set " + string2 + " for " + tSToolPath + "\n"));
            }
            return null;
        }
        TSToolSetContents.Tool tool = tSToolSet.getContents().getTool(string);
        if (tool == null) {
            if (bl2) {
                Log.log((String)("Warning: Unable to find " + string + " in " + string2 + "\n"));
            }
            return null;
        }
        Object object3 = tSToolSet.getComponent(string, toolLocation);
        if (!tSToolPath.isToolOnPath(string, tSToolSet.getName())) {
            tSToolPath = new TSToolPath(tSToolPath, string, tSToolSet.getName(), tool.isCommon());
        } else if (tool.isCommon()) {
            tSToolPath = new TSToolPath(tSToolPath, true);
        }
        if (object3 == null) {
            object2 = tool.getType();
            if ((object2 == TSToolSetContents.ToolType.CHECK_BOX || object2 == TSToolSetContents.ToolType.RADIO_BUTTON) && toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR) {
                object2 = TSToolSetContents.ToolType.TOGGLE_BUTTON;
            }
            switch (object2) {
                case BUTTON: 
                case TOGGLE_BUTTON: 
                case RADIO_BUTTON: 
                case CHECK_BOX: {
                    Action object5 = TSFactory.getAction(tool, tSToolSet, bl);
                    if (object5 == null) {
                        Log.log((String)("Warning: Unable to find action for " + tool.getName() + " in " + tSToolSet.getName() + "\n"));
                        break;
                    }
                    if (object2 == TSToolSetContents.ToolType.BUTTON) {
                        object3 = new TSButton(object5);
                    } else if (object2 == TSToolSetContents.ToolType.TOGGLE_BUTTON) {
                        object3 = new TSToggleButton(object5);
                    } else if (object2 == TSToolSetContents.ToolType.RADIO_BUTTON) {
                        object3 = new TSRadioButton(object5);
                    } else if (object2 == TSToolSetContents.ToolType.CHECK_BOX) {
                        object3 = new TSCheckBox(object5);
                    }
                    Object object = object5.getValue("toolstrip-context-menu-contributor");
                    if (object == null) break;
                    ((JComponent)object3).putClientProperty("toolstrip-context-menu-contributor", object);
                    break;
                }
                case DROP_DOWN: 
                case SPLIT_BUTTON: {
                    Object object;
                    if (tool.getStyle() == null && !tool.hasChildren()) {
                        object = tool.getType() == TSToolSetContents.ToolType.DROP_DOWN ? new TSDropDownButton(tool.getLabel(), tool.getIcon()) : new TSSplitButton(tool.getLabel(), tool.getIcon());
                        Action action = TSFactory.getAction(tool, map, bl);
                        if (action != null) {
                            ((TSDropDownButton)object).setAction(action);
                        } else {
                            object.setToolTipText(tool.getDescription());
                        }
                        if (!tool.hasChildren()) {
                            if (action == null) {
                                Log.log((String)("Warning: No children found for " + tool.getName() + "\n"));
                            }
                        } else {
                            ((TSDropDownButton)object).setPopupListener(new MenuPopupListener(tool, tSToolPath, map, contextTargetingManager, bl, (JComponent)object, toolLocation));
                        }
                        object3 = object;
                        break;
                    }
                    if (tool.getType() == TSToolSetContents.ToolType.DROP_DOWN) {
                        object = new TSDropDownButton(tool.getLabel(), tool.getIcon());
                        object.setToolTipText(tool.getDescription());
                    } else {
                        object = new TSSplitButton(tool.getLabel(), tool.getIcon());
                        Action action = TSFactory.getAction(tool, map, bl);
                        if (action != null) {
                            ((TSDropDownButton)object).setAction(action);
                        } else {
                            object.setToolTipText(tool.getDescription());
                        }
                    }
                    ((TSDropDownButton)object).setPopupListener(new ListPopupListener(tool, tSToolPath, map, tSRegistry, contextTargetingManager, bl));
                    object3 = object;
                    break;
                }
                case LABEL: {
                    object3 = new TSLabel(tool.getLabel(), tool.getIcon(), 10);
                    break;
                }
                case GROUP: {
                    object3 = TSFactory.createGroup(tool, tSToolPath, map, tSRegistry, toolLocation, contextTargetingManager, bl, bl2, disposable);
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case GALLERY: {
                    Object object = new GalleryView(TSFactory.createGalleryModel(tool, tSToolPath, map, tSRegistry, bl), tool.getGalleryOptions());
                    char c = MJUtilities.findMnemonic((String)tool.getLabel());
                    if (c != '\u0000') {
                        ((GalleryView)object).setMoreButtonMnemonic("" + c);
                    }
                    TSFactory.addGalleryMenuContributor((GalleryView)object);
                    object3 = object;
                    ((JComponent)object3).putClientProperty("disposable", new GalleryDisposer((GalleryView)object3));
                    break;
                }
                default: {
                    Log.log((String)("Warning: Can't find ToolSupplier for " + tool.getName() + "\n"));
                    if (!bl) break;
                    object3 = new TSLabel(tool.getLabel(), tool.getIcon(), 10);
                }
            }
            if (object3 instanceof AbstractButton) {
                ButtonDisposer buttonDisposer = new ButtonDisposer((AbstractButton)object3);
                if (contextTargetingManager != null && tool.isCommon()) {
                    contextTargetingManager.register(string, (AbstractButton)object3);
                    buttonDisposer.saveTargetingData(string, contextTargetingManager);
                }
                ((JComponent)object3).putClientProperty("disposable", buttonDisposer);
            }
        }
        if (object3 != null) {
            Disposable disposable2;
            for (TSToolSet.ToolDecorator toolDecorator : tSToolSet.getDecorators(string)) {
                toolDecorator.decorateTool((JComponent)object3, toolLocation);
            }
            object2 = TSFactory.componentNameFor(tool);
            if (toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR) {
                object2 = "QuickAccess:" + (String)object2;
            }
            ((Component)object3).setName((String)object2);
            ((JComponent)object3).putClientProperty(TOOL_COMPONENT_PROPERTY_KEY, true);
            if (tool.isQuickAccessEligible() || tool.getType() == TSToolSetContents.ToolType.GALLERY) {
                ((JComponent)object3).putClientProperty(TOOL_PATH_PROPERTY_KEY, tSToolPath);
            }
            if (disposable != null && (disposable2 = TSFactory.getDisposable((JComponent)object3)) != null) {
                Disposer.register((Disposable)disposable2, (Disposable)disposable);
            }
        }
        return object3;
    }

    private static String componentNameFor(TSToolSetContents.Tool tool) {
        return tool.getToolSetName() + ":" + tool.getName();
    }

    private static Disposable getDisposable(JComponent jComponent) {
        return jComponent instanceof Disposable ? (Disposable)jComponent : (Disposable)jComponent.getClientProperty("disposable");
    }

    private static JComponent createPlaceHolder(String string, TSToolSetContents tSToolSetContents, TSToolPath tSToolPath, TSToolSet.ToolLocation toolLocation, ContextTargetingManager contextTargetingManager) {
        Object object;
        TSToolSetContents.Tool tool = tSToolSetContents.getTool(string);
        Object object2 = null;
        if (tool != null) {
            object = tool.getType();
            if ((object == TSToolSetContents.ToolType.CHECK_BOX || object == TSToolSetContents.ToolType.RADIO_BUTTON) && toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR) {
                object = TSToolSetContents.ToolType.TOGGLE_BUTTON;
            }
            if (object == TSToolSetContents.ToolType.BUTTON || object == TSToolSetContents.ToolType.TOGGLE_BUTTON || object == TSToolSetContents.ToolType.RADIO_BUTTON || object == TSToolSetContents.ToolType.CHECK_BOX || object == TSToolSetContents.ToolType.DROP_DOWN || object == TSToolSetContents.ToolType.SPLIT_BUTTON) {
                Action action = TSFactory.createPlaceHolderAction(tool);
                object2 = object == TSToolSetContents.ToolType.BUTTON ? new TSButton(action) : (object == TSToolSetContents.ToolType.TOGGLE_BUTTON ? new TSToggleButton(action) : (object == TSToolSetContents.ToolType.RADIO_BUTTON ? new TSRadioButton(action) : (object == TSToolSetContents.ToolType.CHECK_BOX ? new TSCheckBox(action) : (object == TSToolSetContents.ToolType.DROP_DOWN ? new TSDropDownButton(action) : new TSSplitButton(action)))));
            } else if (object == TSToolSetContents.ToolType.COMBO_BOX) {
                object2 = new TSComboBox(new String[]{tool.getLabel()});
            } else if (object == TSToolSetContents.ToolType.TEXT_FIELD) {
                object2 = new TSTextField(tool.getLabel());
            } else if (object == TSToolSetContents.ToolType.LABEL || object == TSToolSetContents.ToolType.CUSTOM) {
                object2 = new TSLabel(tool.getLabel(), tool.getIcon(), 2);
            }
        }
        if (object2 != null) {
            ((JComponent)object2).setEnabled(false);
            ((Component)object2).setName(TSFactory.componentNameFor(tool));
            ((JComponent)object2).putClientProperty(TOOL_COMPONENT_PROPERTY_KEY, true);
            if (tool.isQuickAccessEligible() || toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR) {
                ((JComponent)object2).putClientProperty(TOOL_PATH_PROPERTY_KEY, tSToolPath);
            }
            if (object2 instanceof AbstractButton) {
                object = new ButtonDisposer((AbstractButton)object2);
                if (contextTargetingManager != null && tool.isCommon()) {
                    contextTargetingManager.register(string, (AbstractButton)object2);
                    ((TriggerDisposer)object).saveTargetingData(string, contextTargetingManager);
                }
                ((JComponent)object2).putClientProperty("disposable", object);
            }
        }
        return object2;
    }

    private static Action createPlaceHolderAction(TSToolSetContents.Tool tool) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        tool.configure((Action)mJAbstractAction);
        mJAbstractAction.setEnabled(false);
        return mJAbstractAction;
    }

    private static Action getAction(TSToolSetContents.Tool tool, Map<String, TSToolSet> map, boolean bl) {
        TSToolSet tSToolSet = map.get(tool.getToolSetName());
        if (tSToolSet == null) {
            if (bl) {
                return TSFactory.createPlaceHolderAction(tool);
            }
            Log.log((String)("Warning: Unable to find tool set " + tool.getToolSetName() + " for " + tool.getName() + "\n"));
            return null;
        }
        return TSFactory.getAction(tool, tSToolSet, bl);
    }

    private static Action getAction(TSToolSetContents.Tool tool, TSToolSet tSToolSet, boolean bl) {
        Action action = tSToolSet.getAction(tool.getName());
        if (action == null && tool.getType() != TSToolSetContents.ToolType.DROP_DOWN) {
            if (bl) {
                action = TSFactory.createPlaceHolderAction(tool);
            } else {
                Log.log((String)("Warning: Unable to find action for " + tool.getName() + " in " + tSToolSet.getName() + "\n"));
            }
        }
        return action;
    }

    private static List<TSToolSet.ToolDecorator> getDecorators(TSToolSetContents.Tool tool, Map<String, TSToolSet> map) {
        TSToolSet tSToolSet = map.get(tool.getToolSetName());
        return tSToolSet.getDecorators(tool.getName());
    }

    private static MJMenu createMenu(TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, boolean bl, ContextTargetingManager contextTargetingManager, JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
        MJMenu mJMenu = new MJMenu(tool.getLabel());
        mJMenu.setName(TSFactory.componentNameFor(tool));
        if (contextTargetingManager != null && tool.hasContextContributors()) {
            Iterator<TSToolSetContents.Tool> iterator = contextTargetingManager.contributeTo(tool, map);
            tool = (TSToolSetContents.Tool)iterator.getFirst();
            map = (Map)iterator.getSecond();
        }
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            Object object;
            if (tool2.getType() == TSToolSetContents.ToolType.SEPARATOR) {
                mJMenu.addSeparator();
                continue;
            }
            TSToolPath tSToolPath2 = new TSToolPath(tSToolPath, tool2.getName(), tool2.getToolSetName(), tool2.isCommon());
            if (tool2.getType() == TSToolSetContents.ToolType.DROP_DOWN) {
                object = TSFactory.createMenu(tool2, tSToolPath2, map, bl, contextTargetingManager, jComponent, toolLocation);
                ((JComponent)object).putClientProperty(TOOL_PATH_PROPERTY_KEY, tSToolPath);
                ((JComponent)object).putClientProperty(INVOKER_PROPERTY_KEY, jComponent);
                mJMenu.add((JMenuItem)object);
                for (TSToolSet.ToolDecorator toolDecorator : TSFactory.getDecorators(tool2, map)) {
                    toolDecorator.decorateTool((JComponent)object, toolLocation);
                }
                continue;
            }
            if (tool2.getType() == TSToolSetContents.ToolType.BUTTON || tool2.getType() == TSToolSetContents.ToolType.RADIO_BUTTON || tool2.getType() == TSToolSetContents.ToolType.CHECK_BOX) {
                object = TSFactory.getAction(tool2, map, bl);
                if (object == null) {
                    Log.log((String)("Warning: No behavior found for " + TSFactory.componentNameFor(tool2) + " on " + mJMenu.getName() + "\n"));
                    continue;
                }
                if (contextTargetingManager != null && tool2.isCommon()) {
                    object = contextTargetingManager.getContextualAction(tool2.getName(), (Action)object);
                }
                Object object3 = null;
                if (tool2.getType() == TSToolSetContents.ToolType.BUTTON) {
                    object3 = mJMenu.add((Action)object);
                } else if (tool2.getType() == TSToolSetContents.ToolType.RADIO_BUTTON) {
                    object3 = mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)object));
                } else if (tool2.getType() == TSToolSetContents.ToolType.CHECK_BOX) {
                    object3 = mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)object));
                }
                if (object3 == null) continue;
                ((Component)object3).setName(TSFactory.componentNameFor(tool2));
                ((JComponent)object3).putClientProperty(TOOL_PATH_PROPERTY_KEY, tSToolPath2);
                ((JComponent)object3).putClientProperty(INVOKER_PROPERTY_KEY, jComponent);
                for (TSToolSet.ToolDecorator toolDecorator : TSFactory.getDecorators(tool2, map)) {
                    toolDecorator.decorateTool((JComponent)object3, toolLocation);
                }
                continue;
            }
            Log.log((String)("Warning: Can't add " + (Object)((Object)tool2.getType()) + " to menu\n"));
        }
        return mJMenu;
    }

    private static ListItem[] createListItems(TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, boolean bl, ContextTargetingManager contextTargetingManager) {
        ArrayList arrayList;
        if (contextTargetingManager != null && tool.hasContextContributors()) {
            arrayList = contextTargetingManager.contributeTo(tool, map);
            tool = (TSToolSetContents.Tool)arrayList.getFirst();
            map = (Map)arrayList.getSecond();
        }
        arrayList = new ArrayList();
        Object object = null;
        ListStyle listStyle = tool.getStyle();
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            Object object2;
            if (tool2.getType() == TSToolSetContents.ToolType.SEPARATOR) {
                if (object == null) continue;
                object.getAttributes().setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
                continue;
            }
            TSToolPath tSToolPath2 = new TSToolPath(tSToolPath, tool2.getName(), tool2.getToolSetName(), tool2.isCommon());
            if (tool2.getType() == TSToolSetContents.ToolType.DROP_DOWN) {
                object2 = ListItem.newSubList(TSFactory.componentNameFor(tool2), tool2.getLabel(), tool2.getIcon(), new ListPopupListener(tool2, tSToolPath2, map, null, contextTargetingManager, bl));
                arrayList.add(object2);
                object = object2;
                continue;
            }
            if (tool2.getType() == TSToolSetContents.ToolType.BUTTON || tool2.getType() == TSToolSetContents.ToolType.CHECK_BOX) {
                ListStyle listStyle2;
                object2 = TSFactory.getAction(tool2, map, bl);
                if (object2 == null) {
                    Log.log((String)("Warning: No behavior found for " + TSFactory.componentNameFor(tool2) + " on " + tool.getName() + " list\n"));
                    continue;
                }
                String string = MJUtilities.exciseMnemonic((String)((String)object2.getValue("Name")));
                if (contextTargetingManager != null && tool2.isCommon()) {
                    object2 = contextTargetingManager.getContextualAction(tool2.getName(), (Action)object2);
                }
                ListItem listItem = ListItem.newItem(tool2.getName(), string, tool2.getDescription(), tool2.getIcon());
                if (tool2.getType() == TSToolSetContents.ToolType.CHECK_BOX) {
                    listItem.getAttributes().setAttribute((Attribute)ListItem.HAS_CHECKBOX, (Object)true);
                }
                if ((listStyle2 = tool2.getStyle()) == null) {
                    listStyle2 = listStyle;
                }
                if (listStyle2 != null) {
                    listItem.getAttributes().setAttribute(ListItem.STYLE, (Object)listStyle2);
                }
                TSFactory.setItemAttributesFromAction(listItem, (Action)object2);
                if (tool2.isQuickAccessEligible()) {
                    listItem.getAttributes().setAttribute(TOOL_PATH_ATTRIBUTE, (Object)tSToolPath2);
                }
                arrayList.add(listItem);
                object = listItem;
                continue;
            }
            if (tool2.getType() == TSToolSetContents.ToolType.GROUP) {
                object2 = TSFactory.createListItems(tool2, tSToolPath2, map, bl, contextTargetingManager);
                if (((ListItem[])object2).length > 0) {
                    if (tool2.getHeaderType() == TSToolSetContents.HeaderType.TITLE) {
                        arrayList.add(ListItem.newHeader(tool2.getName(), tool2.getLabel(), tool2.getStyle()));
                    } else if (tool2.getHeaderType() == TSToolSetContents.HeaderType.SEPARATOR && object != null) {
                        object.getAttributes().setAttribute((Attribute)ListItem.HAS_SEPARATOR, (Object)true);
                    }
                    arrayList.addAll(Arrays.asList(object2));
                    object = object2[0];
                    continue;
                }
                object = null;
                continue;
            }
            Log.log((String)("Warning: Can't add " + (Object)((Object)tool2.getType()) + " to list\n"));
        }
        return arrayList.toArray(new ListItem[arrayList.size()]);
    }

    private static void setItemAttributesFromAction(ListItem listItem, Action action) {
        Attributes attributes = listItem.getAttributes();
        attributes.setAttribute(ACTION_ATTRIBUTE, (Object)action);
        if (!action.isEnabled()) {
            attributes.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)false);
        }
        if (action instanceof MJAbstractAction) {
            MJAbstractAction mJAbstractAction = (MJAbstractAction)action;
            KeyStroke keyStroke = mJAbstractAction.getAccelerator();
            if (keyStroke != null) {
                String string = "";
                int n = keyStroke.getModifiers();
                if (n != 0) {
                    string = KeyEvent.getModifiersExText(n) + "+";
                }
                string = string + KeyEvent.getKeyText(keyStroke.getKeyCode());
                attributes.setAttribute((Attribute)ListItem.SHORTCUT_KEY, (Object)string);
            }
            if (((Boolean)attributes.getAttribute((Attribute)ListItem.HAS_CHECKBOX)).booleanValue()) {
                attributes.setAttribute((Attribute)ListItem.CHECKVALUE_STATE, (Object)mJAbstractAction.isSelected());
            }
        }
    }

    private static JComponent createGroup(TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, TSRegistry tSRegistry, TSToolSet.ToolLocation toolLocation, ContextTargetingManager contextTargetingManager, boolean bl, boolean bl2, Disposable disposable) {
        Box box = Box.createHorizontalBox();
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            TSToolPath tSToolPath2 = new TSToolPath(tSToolPath, tool2.getName(), tool2.getToolSetName(), tool2.isCommon());
            JComponent jComponent = TSFactory.createComponent(tSToolPath2, map, tSRegistry, toolLocation, contextTargetingManager, bl, bl2, disposable);
            if (jComponent instanceof MJButton) {
                ((MJButton)jComponent).hideText();
            } else if (jComponent instanceof MJToggleButton) {
                ((MJToggleButton)jComponent).hideText();
            }
            box.add(jComponent);
        }
        return box;
    }

    public static Item createGalleryItemFromAction(GalleryView galleryView, Action action, String string, String string2, String string3, String string4) {
        TSToolPath tSToolPath = (TSToolPath)galleryView.getClientProperty(TOOL_PATH_PROPERTY_KEY);
        if (tSToolPath != null && string != null && string2 != null && string3 != null && string4 != null) {
            TSToolPath tSToolPath2 = tSToolPath.appendTool(string3, string4).appendTool(string, string2);
            action.putValue(TOOL_PATH_PROPERTY_KEY, tSToolPath2);
            string = string2 + ":" + string;
        }
        return new Item(string, action, null);
    }

    public static GalleryModel createGalleryModel(final TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, TSRegistry tSRegistry, boolean bl) {
        GalleryModel galleryModel;
        boolean bl2 = tool.getGalleryOptions().shareModel();
        boolean bl3 = bl;
        Map<String, TSToolSet> map2 = map;
        if (bl2) {
            galleryModel = fSharedGalleryModelMap.get(TSFactory.componentNameFor(tool));
            if (galleryModel != null) {
                return new TargetedGalleryModel(galleryModel, map);
            }
            bl3 = true;
            map2 = Collections.emptyMap();
        }
        galleryModel = new DefaultGalleryModel();
        String string = tSToolPath.getToolSetName();
        String string2 = tSToolPath.getToolName();
        TSToolSetContents tSToolSetContents = TSToolSetContents.createTemplate(tool);
        ((DefaultGalleryModel)galleryModel).setFactoryData(new GalleryRestoreData(tSRegistry, tSToolPath, tSToolSetContents, map));
        boolean bl4 = false;
        Object object = tool.getChildren().iterator();
        while (object.hasNext()) {
            TSToolSetContents.Tool tool2 = object.next();
            if (!tool2.hasChildren()) continue;
            bl4 = true;
            break;
        }
        if (bl4 && (object = TSFactory.recallGalleryContents(string2, string)) != null) {
            tool.matchTemplate((TSToolSetContents)object, TSFactory.createContentsMap(map));
        }
        TSFactory.populateGalleryModel(galleryModel, tool, tSToolPath, map2, bl3);
        ((DefaultGalleryModel)galleryModel).addPropertyChangeListener(new PropertyChangeListener((DefaultGalleryModel)galleryModel, string2, string, tSRegistry){
            final /* synthetic */ DefaultGalleryModel val$model;
            final /* synthetic */ String val$galleryName;
            final /* synthetic */ String val$galleryToolSetName;
            final /* synthetic */ TSRegistry val$registry;
            {
                this.val$model = defaultGalleryModel;
                this.val$galleryName = string;
                this.val$galleryToolSetName = string2;
                this.val$registry = tSRegistry;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!"filtered-results".equals(propertyChangeEvent.getPropertyName())) {
                    TSToolSetContents tSToolSetContents = TSFactory.getGalleryContents(tool, this.val$model, this.val$galleryName, this.val$galleryToolSetName);
                    TSFactory.saveGalleryContents(tSToolSetContents, this.val$galleryName, this.val$galleryToolSetName);
                    if (this.val$registry != null) {
                        this.val$registry.replaceToolSetContents(tSToolSetContents);
                    }
                }
            }
        });
        if (bl2) {
            fSharedGalleryModelMap.put(TSFactory.componentNameFor(tool), galleryModel);
            return TSFactory.createGalleryModel(tool, tSToolPath, map, tSRegistry, bl);
        }
        return galleryModel;
    }

    private static Map<String, TSToolSetContents> createContentsMap(Map<String, TSToolSet> map) {
        HashMap<String, TSToolSetContents> hashMap = new HashMap<String, TSToolSetContents>();
        for (TSToolSet tSToolSet : map.values()) {
            hashMap.put(tSToolSet.getName(), tSToolSet.getContents());
        }
        return hashMap;
    }

    private static void populateGalleryModel(GalleryModel galleryModel, TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, boolean bl) {
        Category category = null;
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            Object object;
            if (tool2.getType() == TSToolSetContents.ToolType.GROUP) {
                object = Category.FAVORITES.getName().equals(tool2.getName()) ? Category.FAVORITES.getName() : TSFactory.componentNameFor(tool2);
                Category category2 = new Category((String)object, tool2.getLabel());
                TSToolPath tSToolPath2 = new TSToolPath(tSToolPath, tool2.getName(), tool2.getToolSetName(), tool2.isCommon());
                for (TSToolSetContents.Tool tool3 : tool2.getChildren()) {
                    Item item = TSFactory.createGalleryItem(tool3, tSToolPath2, tool2.getLabel(), map, bl);
                    if (item == null) continue;
                    galleryModel.addItem(category2, item);
                }
                continue;
            }
            if (tool2.getType() == TSToolSetContents.ToolType.BUTTON) {
                object = TSFactory.createGalleryItem(tool2, tSToolPath, null, map, bl);
                if (object == null) continue;
                if (category == null) {
                    category = new Category("default", "");
                }
                galleryModel.addItem(category, (Item)object);
                continue;
            }
            Log.log((String)("Warning: Can't include " + tool.getName() + ", type =  " + (Object)((Object)tool2.getType()) + "in gallery\n"));
        }
    }

    private static Item createGalleryItem(TSToolSetContents.Tool tool, TSToolPath tSToolPath, String string, Map<String, TSToolSet> map, boolean bl) {
        TSToolPath tSToolPath2 = new TSToolPath(tSToolPath, tool.getName(), tool.getToolSetName(), tool.isCommon());
        Action action = TSFactory.getAction(tool, map, bl);
        if (action == null) {
            Log.log((String)("Warning: Unable to find action for " + tool.getName() + " in " + tool.getToolSetName() + "\n"));
            return null;
        }
        if (tool.isQuickAccessEligible()) {
            action.putValue(TOOL_PATH_PROPERTY_KEY, tSToolPath2);
        }
        List<String> list = tool.getKeywords();
        if (string != null) {
            list = new ArrayList<String>(list);
            list.add(string);
        }
        return new Item(TSFactory.componentNameFor(tool), action, list);
    }

    private static void addGalleryMenuContributor(GalleryView galleryView) {
        galleryView.addPopupListener(new GalleryView.PopupListener(){

            @Override
            public void galleryPopupShown(GalleryView galleryView) {
                final GalleryModel galleryModel = galleryView.getModel();
                galleryView.getPopupView().getComponent().putClientProperty("toolstrip-context-menu-contributor", new TSContextMenuContributor(){

                    @Override
                    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
                        if (jPopupMenu.getComponentCount() > 0) {
                            jPopupMenu.addSeparator();
                        }
                        jPopupMenu.add((Action)((Object)new RestoreGalleryLayoutAction(galleryModel)));
                        jPopupMenu.putClientProperty("retain-overlays", true);
                    }
                });
            }

            @Override
            public void galleryPopupHidden(GalleryView galleryView) {
            }
        });
    }

    private static TSToolSetContents getGalleryContents(TSToolSetContents.Tool tool, GalleryModel galleryModel, String string, String string2) {
        TSToolSetContents tSToolSetContents = new TSToolSetContents(string2, true);
        tSToolSetContents.addDescendants(tool);
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string).setToolSetName(string2).setType(TSToolSetContents.ToolType.GALLERY).setLabel(tool.getLabel()), new TSToolSetContents.Dependency[0]);
        if (galleryModel instanceof WrappedGalleryModel) {
            galleryModel = ((WrappedGalleryModel)galleryModel).getRootModel();
        }
        for (Category category : galleryModel.getCategories()) {
            int n;
            String string3 = category.getName();
            String string4 = string2;
            if (!Category.FAVORITES.getName().equals(string3) && (n = category.getName().indexOf(58)) > 0 && n < category.getName().length()) {
                string4 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
            }
            tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(string3).setToolSetName(string4).setType(TSToolSetContents.ToolType.GROUP).setLabel(category.getLabel()), new TSToolSetContents.Dependency(string, string2));
            for (Item item : galleryModel.getItems(category)) {
                Action action = item.getAction();
                TSToolPath tSToolPath = (TSToolPath)action.getValue(TOOL_PATH_PROPERTY_KEY);
                tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(tSToolPath.getToolName()).setToolSetName(tSToolPath.getToolSetName()).setLabel(item.getLabel()).setIcon(item.getIcon()).setDescription(item.getDescription()), new TSToolSetContents.Dependency(string3, string4));
            }
        }
        return tSToolSetContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveGalleryContents(TSToolSetContents tSToolSetContents, String string, String string2) {
        File file = TSFactory.getGalleryContentFile(string, string2);
        FileOutputStream fileOutputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = tSToolSetContents.toXML(document);
            document.appendChild(element);
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.logException((Exception)parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Log.logException((Exception)transformerConfigurationException);
        }
        catch (Exception exception) {
            Log.log((String)("Error saving " + string + ":" + string2 + " to " + file.getPath()));
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static TSToolSetContents recallGalleryContents(String string, String string2) {
        File file = TSFactory.getGalleryContentFile(string, string2);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                TSToolSetContents tSToolSetContents = new TSToolSetContents(SimpleDOMUtils.read((InputStream)fileInputStream));
                fileInputStream.close();
                return tSToolSetContents;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.logException((Exception)fileNotFoundException);
                return null;
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
                return null;
            }
            catch (DataFormatException dataFormatException) {
                Log.logException((Exception)dataFormatException);
                return null;
            }
        }
        return null;
    }

    private static File getGalleryContentFile(String string, String string2) {
        return new File(FileUtils.getPreferencesDirectory(), string2 + "_" + string + ".xml");
    }

    private static class GalleryDisposer
    implements Disposable {
        private GalleryView fGalleryView;

        private GalleryDisposer(GalleryView galleryView) {
            this.fGalleryView = galleryView;
        }

        public void dispose() {
            GalleryModel galleryModel = this.fGalleryView.getModel();
            if (galleryModel instanceof WrappedGalleryModel) {
                ((WrappedGalleryModel)galleryModel).dispose();
            }
        }
    }

    private static class ButtonDisposer
    extends TriggerDisposer {
        private final AbstractButton iButton;

        private ButtonDisposer(AbstractButton abstractButton) {
            this.iButton = abstractButton;
        }

        public void dispose() {
            if (this.iTargetingManager != null) {
                this.iTargetingManager.unregister(this.iToolName, this.iButton);
            }
            this.iButton.setAction(null);
            this.iButton.setText("disposed");
        }
    }

    private static abstract class TriggerDisposer
    implements Disposable {
        protected String iToolName;
        protected ContextTargetingManager iTargetingManager;

        private TriggerDisposer() {
        }

        protected void saveTargetingData(String string, ContextTargetingManager contextTargetingManager) {
            this.iToolName = string;
            this.iTargetingManager = contextTargetingManager;
        }
    }

    public static class ListListenerBridge
    implements ListActionListener {
        @Override
        public void listItemSelected(ListActionEvent listActionEvent) {
            ListItem listItem = listActionEvent.getListItem();
            Action action = (Action)listItem.getAttributes().getAttribute(ACTION_ATTRIBUTE);
            if (action != null) {
                if (((Boolean)listItem.getAttributes().getAttribute((Attribute)ListItem.HAS_CHECKBOX)).booleanValue() && action instanceof MJAbstractAction) {
                    MJAbstractAction mJAbstractAction;
                    mJAbstractAction.setSelected(!(mJAbstractAction = (MJAbstractAction)action).isSelected());
                }
                action.actionPerformed(listActionEvent);
            }
        }
    }

    private static class RestoreGalleryLayoutAction
    extends MJAbstractAction {
        private GalleryModel fModel;

        private RestoreGalleryLayoutAction(GalleryModel galleryModel) {
            super(Resources.getString("menuitem.RestoreFactoryLayout"));
            this.fModel = galleryModel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultGalleryModel defaultGalleryModel = (DefaultGalleryModel)(this.fModel instanceof WrappedGalleryModel ? ((WrappedGalleryModel)this.fModel).getRootModel() : this.fModel);
            GalleryRestoreData galleryRestoreData = (GalleryRestoreData)defaultGalleryModel.getFactoryData();
            if (galleryRestoreData != null) {
                TSToolSetContents tSToolSetContents = galleryRestoreData.fRegistry.getToolSetContents(galleryRestoreData.fToolPath.getToolSetName());
                TSToolSetContents.Tool tool = tSToolSetContents.getTool(galleryRestoreData.fToolPath.getToolName());
                defaultGalleryModel.startUpdateSequence();
                defaultGalleryModel.clear();
                tool.matchTemplate(galleryRestoreData.fTemplate, TSFactory.createContentsMap(galleryRestoreData.fToolSetMap));
                TSFactory.populateGalleryModel(defaultGalleryModel, tool, galleryRestoreData.fToolPath, galleryRestoreData.fToolSetMap, false);
                defaultGalleryModel.endUpdateSequence();
            }
        }
    }

    private static class GalleryRestoreData {
        final TSRegistry fRegistry;
        final TSToolPath fToolPath;
        final TSToolSetContents fTemplate;
        final Map<String, TSToolSet> fToolSetMap;

        private GalleryRestoreData(TSRegistry tSRegistry, TSToolPath tSToolPath, TSToolSetContents tSToolSetContents, Map<String, TSToolSet> map) {
            this.fRegistry = tSRegistry;
            this.fToolPath = tSToolPath;
            this.fTemplate = tSToolSetContents;
            this.fToolSetMap = map;
        }
    }

    private static class ListPopupListener
    implements PopupListener {
        private final TSToolSetContents.Tool iTool;
        private final TSToolPath iToolPath;
        private final Map<String, TSToolSet> iToolSetMap;
        private final TSRegistry iRegistry;
        private final boolean iCreatePlaceHolders;
        private final ContextTargetingManager iTargetingManager;
        private final TSToolSet.ListDecorator iDecorator;

        private ListPopupListener(TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, TSRegistry tSRegistry, ContextTargetingManager contextTargetingManager, boolean bl) {
            this.iTool = tool;
            this.iToolPath = tSToolPath;
            this.iToolSetMap = map;
            this.iRegistry = tSRegistry;
            this.iTargetingManager = contextTargetingManager;
            this.iCreatePlaceHolders = bl;
            this.iDecorator = map.get(this.iTool.getToolSetName()).getListDecorator(this.iTool.getName());
        }

        @Override
        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            PopupList popupList;
            Map<String, TSToolSet> map = this.iToolSetMap;
            if (this.iRegistry != null) {
                map = new HashMap<String, TSToolSet>(this.iToolSetMap);
                map.putAll(this.iRegistry.getToolSetMap());
            }
            ListItem[] listItemArray = TSFactory.createListItems(this.iTool, this.iToolPath, map, this.iCreatePlaceHolders, this.iTargetingManager);
            if (this.iDecorator != null) {
                DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
                for (ListItem listItem : listItemArray) {
                    defaultListModel.addElement(listItem);
                }
                popupList = new PopupList((ListModel)defaultListModel);
                this.iDecorator.decorateList(popupList);
            } else {
                popupList = new PopupList(listItemArray);
            }
            popupList.setName(TSFactory.componentNameFor(this.iTool) + "PopupList");
            popupList.setListStyle(this.iTool.getStyle() != null ? this.iTool.getStyle() : ListStyle.TEXT_ONLY);
            popupList.addListActionListener(new ListListenerBridge());
            popupList.putClientProperty(TSFactory.INVOKER_PROPERTY_KEY, jComponent);
            popupCallback.show(popupList);
        }
    }

    public static class MenuDisposer
    implements PopupMenuListener {
        private MJMenu iMenu;

        public MenuDisposer(MJMenu mJMenu) {
            this.iMenu = mJMenu;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuDisposer.this.iMenu.dispose();
                }
            });
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private static class MenuPopupListener
    implements PopupListener {
        private final TSToolSetContents.Tool iTool;
        private final TSToolPath iToolPath;
        private final Map<String, TSToolSet> iToolSetMap;
        private final boolean iCreatePlaceHolders;
        private final ContextTargetingManager iTargetingManager;
        private final JComponent iInvoker;
        private final TSToolSet.ToolLocation iLocation;

        private MenuPopupListener(TSToolSetContents.Tool tool, TSToolPath tSToolPath, Map<String, TSToolSet> map, ContextTargetingManager contextTargetingManager, boolean bl, JComponent jComponent, TSToolSet.ToolLocation toolLocation) {
            this.iTool = tool;
            this.iToolPath = tSToolPath;
            this.iToolSetMap = map;
            this.iTargetingManager = contextTargetingManager;
            this.iCreatePlaceHolders = bl;
            this.iInvoker = jComponent;
            this.iLocation = toolLocation;
        }

        @Override
        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            MJMenu mJMenu = TSFactory.createMenu(this.iTool, this.iToolPath, this.iToolSetMap, this.iCreatePlaceHolders, this.iTargetingManager, this.iInvoker, this.iLocation);
            JPopupMenu jPopupMenu = mJMenu.getPopupMenu();
            jPopupMenu.addPopupMenuListener(new MenuDisposer(mJMenu));
            popupCallback.show(jPopupMenu);
        }
    }
}

