/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripSectionLayout;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWithHeader;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWrapper;
import com.mathworks.toolstrip.impl.ToolstripTabContentPanel;
import com.mathworks.toolstrip.plaf.SectionWithHeaderUI;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.toolstrip.sections.IconifiedSectionLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ToolstripTabLayout
implements LayoutManager2 {
    public static final SectionWithHeaderUI SECTION_HEADER_UI = new ToolstripSectionComponentWithHeader(new JButton(""), null).getUI();
    private final ToolstripTabContentPanel fTabContent;
    private final List<Section> fSections = new ArrayList<Section>();

    public ToolstripTabLayout(ToolstripTabContentPanel toolstripTabContentPanel) {
        this.fTabContent = toolstripTabContentPanel;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
        for (Section section : this.fSections) {
            section.resetWidths();
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.fSections.clear();
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.fSections.clear();
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.fSections.clear();
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(3000, container.getHeight());
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return new Dimension(300, container.getHeight());
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(1, container.getHeight());
    }

    @Override
    public void layoutContainer(Container container) {
        block8: {
            boolean bl;
            ToolstripTabContentPanel toolstripTabContentPanel = (ToolstripTabContentPanel)container;
            ClientCollection<ToolstripSection> clientCollection = toolstripTabContentPanel.getTab().getModel();
            Insets insets = toolstripTabContentPanel.getInsets();
            int n = toolstripTabContentPanel.getWidth() - insets.left - insets.right;
            int n2 = toolstripTabContentPanel.getHeight() - insets.top - insets.bottom - SECTION_HEADER_UI.getSectionExtraHeight();
            if (this.fSections.size() != clientCollection.size()) {
                this.fSections.clear();
                for (Object object : clientCollection) {
                    this.fSections.add(new Section(toolstripTabContentPanel.getTab(), (ToolstripSection)object));
                }
            }
            for (Object object : this.fSections) {
                ((Section)object).reset();
            }
            ArrayList<Section> arrayList = new ArrayList<Section>(this.fSections);
            Collections.reverse(arrayList);
            Collections.sort(arrayList, new Comparator<Section>(){

                @Override
                public int compare(Section section, Section section2) {
                    return section.fPriority - section2.fPriority;
                }
            });
            block2: do {
                Section section;
                Iterator iterator2;
                int n3 = 0;
                for (Iterator iterator2 : this.fSections) {
                    n3 += ((Section)((Object)iterator2)).getTotalWidth(n2);
                }
                if (n3 <= n) {
                    ToolstripTabLayout.layout(toolstripTabContentPanel, this.fSections);
                    break block8;
                }
                bl = false;
                iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    section = (Section)iterator2.next();
                    if (!section.canShrinkWithoutIconifying()) continue;
                    bl = section.shrink();
                    break;
                }
                if (bl) continue;
                iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    section = (Section)iterator2.next();
                    if (!section.canShrink()) continue;
                    bl = section.shrink();
                    continue block2;
                }
            } while (bl);
            ToolstripTabLayout.layout(toolstripTabContentPanel, this.fSections);
        }
    }

    private static void layout(ToolstripTabContentPanel toolstripTabContentPanel, List<Section> list) {
        Insets insets = toolstripTabContentPanel.getInsets();
        int n = insets.right;
        int n2 = insets.top;
        int n3 = toolstripTabContentPanel.getHeight() - insets.top - insets.bottom;
        int n4 = n3 - SECTION_HEADER_UI.getSectionExtraHeight();
        for (int i = 0; i < list.size(); ++i) {
            Section section = list.get(i);
            ToolstripSectionComponentWrapper toolstripSectionComponentWrapper = toolstripTabContentPanel.getSectionComponent(i);
            JComponent jComponent = section.fContent;
            if (section.fCurrentStep != section.fPrevStep || jComponent == null) {
                if (section.currentStep() instanceof IconifiedSectionLayout) {
                    jComponent = section.currentStep().layout(toolstripTabContentPanel.getTab(), i, n3);
                } else {
                    jComponent = section.currentStep().layout(toolstripTabContentPanel.getTab(), i, n4);
                    jComponent = new ToolstripSectionComponentWithHeader(jComponent, section.fSection);
                }
                section.fContent = jComponent;
            }
            toolstripSectionComponentWrapper.setContent(jComponent);
            int n5 = section.getTotalWidth(n4);
            toolstripSectionComponentWrapper.setBounds(n, n2, n5, n3);
            n += n5;
        }
    }

    public static class Section {
        ToolstripSection fSection;
        ToolstripTab fTab;
        int fSectionIndex;
        int fPriority;
        Iterator<ToolstripSectionLayout> fStepsIterator;
        List<Integer> fWidths = Lists.newArrayList();
        List<ToolstripSectionLayout> fSteps = Lists.newArrayList();
        int fCurrentStep;
        int fPrevStep;
        JComponent fContent;
        int textWidth;

        public Section(ToolstripTab toolstripTab, ToolstripSection toolstripSection) {
            this.fTab = toolstripTab;
            this.fSection = toolstripSection;
            this.fSectionIndex = toolstripTab.getModel().indexOf((Client)toolstripSection);
            this.fPriority = (Integer)toolstripSection.getAttribute(ToolstripSection.PRIORITY);
            this.fStepsIterator = toolstripSection.getLayoutPolicy().iterator();
            Preconditions.checkArgument((boolean)this.fStepsIterator.hasNext(), (String)"Section layout policy should have at least one layout (section \"%s\"", (Object[])new Object[]{toolstripSection.getName()});
            this.advance();
        }

        void reset() {
            this.fPrevStep = this.fCurrentStep;
            this.fCurrentStep = 0;
        }

        boolean canShrink() {
            return this.fCurrentStep + 1 < this.fSteps.size() || this.fStepsIterator.hasNext();
        }

        boolean canShrinkWithoutIconifying() {
            int n;
            for (n = this.fSteps.size() - this.fCurrentStep - 1; n < 2 && this.fStepsIterator.hasNext(); ++n) {
                this.advance();
            }
            return n > 1;
        }

        boolean shrink() {
            if (this.fCurrentStep + 1 >= this.fSteps.size()) {
                if (!this.fStepsIterator.hasNext()) {
                    return false;
                }
                this.advance();
            }
            ++this.fCurrentStep;
            return true;
        }

        private void advance() {
            this.fSteps.add(this.fStepsIterator.next());
            this.fWidths.add(-1);
        }

        ToolstripSectionLayout currentStep() {
            return this.fSteps.get(this.fCurrentStep);
        }

        int getCurrentWidth(int n) {
            return this.getWidth(this.fCurrentStep, n);
        }

        private int getWidth(int n, int n2) {
            if (this.fWidths.get(n) == -1) {
                this.fWidths.set(n, this.fSteps.get(n).getPreferredWidth(this.fTab, this.fSectionIndex, n2));
            }
            return this.fWidths.get(n);
        }

        public int sectionHeaderWidth() {
            int n;
            String string = ((String)this.fSection.getAttribute(Client.TITLE)).trim().toUpperCase(Locale.getDefault());
            Font font = ToolstripTheme.getInstance().getSectionTitleFont();
            FontMetrics fontMetrics = new FontMetrics(font){};
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, null);
            this.textWidth = n = (int)rectangle2D.getWidth();
            return this.textWidth;
        }

        int getTotalWidth(int n) {
            int n2 = this.getCurrentWidth(n);
            int n3 = this.sectionHeaderWidth();
            if (!(this.currentStep() instanceof IconifiedSectionLayout)) {
                n2 = n3 > n2 ? SECTION_HEADER_UI.getTotalSectionWidth(n3) : SECTION_HEADER_UI.getTotalSectionWidth(n2);
            }
            return n2;
        }

        public void resetWidths() {
            for (int i = 0; i < this.fWidths.size(); ++i) {
                this.fWidths.set(i, -1);
            }
        }
    }
}

