/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.TSComponentUI;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;
import sun.swing.DefaultLookup;

public class ToolstripTextFieldUI
extends BasicTextFieldUI
implements TSComponentUI {
    private static final String ACTIVE_TEXT_FIELD = "activeTextField";
    private static final String BORDER_TOP1 = "borderTop1";
    private static final String BORDER_TOP2 = "borderTop2";
    private static final String BORDER_BOTTOM = "borderBottom";
    private final TSTextFieldMouseListener fEventListener;
    private boolean fHasFocus;

    public static ToolstripTextFieldUI createUI(JComponent jComponent) {
        return new ToolstripTextFieldUI();
    }

    public ToolstripTextFieldUI() {
        this.copy("font", "foreground", "caretForeground", "selectionForeground", "inactiveForeground", "margin", "keyBindings", "focusInputMap", "actionMap", "keyBindings");
        this.put("border", new TSTextFieldBorder());
        this.put("selectionBackground", new ColorUIResource(11194851));
        this.put("disabledBackground", new ColorUIResource(0xE0E0E0));
        this.put("background", new ColorUIResource(0xF8F8F8));
        this.put("inactiveBackground", new ColorUIResource(0xF8F8F8));
        this.put("activeBackground", new ColorUIResource(0xFFFFFF));
        this.put("borderTop1.active", new ColorUIResource(0x666666));
        this.put("borderTop2.active", new ColorUIResource(0xD8D8D8));
        this.put("borderBottom.active", new ColorUIResource(0xE6E6E6));
        this.put("borderTop1.inactive", new ColorUIResource(0x999999));
        this.put("borderTop2.inactive", new ColorUIResource(0xE5E5E5));
        this.put("borderBottom.inactive", new ColorUIResource(0xE6E6E6));
        this.fEventListener = new TSTextFieldMouseListener();
    }

    private void put(String string, Object object) {
        UIManager.getDefaults().put(this.getPropertyPrefix() + "." + string, object);
    }

    private void copy(String ... stringArray) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        for (String string : stringArray) {
            uIDefaults.put(this.getPropertyPrefix() + "." + string, uIDefaults.get("TextField." + string));
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        TSTextField tSTextField = (TSTextField)((Object)this.getComponent());
        tSTextField.setFont(ToolstripTheme.getInstance().getTSTextFieldFont());
        tSTextField.setSelectedTextColor(Color.BLACK);
        tSTextField.setOpaque(true);
        tSTextField.putClientProperty("canManageOpacity", true);
        tSTextField.addMouseListener(this.fEventListener);
        tSTextField.addMouseMotionListener(this.fEventListener);
        tSTextField.addFocusListener(this.fEventListener);
        tSTextField.addActionListener(this.fEventListener);
        this.updateBackground(tSTextField);
    }

    @Override
    protected void uninstallDefaults() {
        TSTextField tSTextField = (TSTextField)((Object)this.getComponent());
        tSTextField.removeFocusListener(this.fEventListener);
        tSTextField.removeMouseListener(this.fEventListener);
        tSTextField.removeMouseMotionListener(this.fEventListener);
        tSTextField.removeActionListener(this.fEventListener);
        super.uninstallDefaults();
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled") || propertyChangeEvent.getPropertyName().equals(ACTIVE_TEXT_FIELD)) {
            this.updateBackground((TSTextField)propertyChangeEvent.getSource());
        }
    }

    private void updateBackground(TSTextField tSTextField) {
        String string;
        Color color;
        Color color2 = tSTextField.getBackground();
        String string2 = this.getPropertyPrefix();
        Color color3 = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + ".disabledBackground", null);
        Color color4 = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + ".inactiveBackground", null);
        Color color5 = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + ".activeBackground", null);
        if (this.isEditable()) {
            if (this.isActive()) {
                color = color5;
                string = ".active";
            } else {
                color = color4;
                string = ".inactive";
            }
        } else {
            color = color3;
            string = ".inactive";
        }
        tSTextField.setBackground(color);
        Border border = tSTextField.getBorder();
        if (border instanceof TSTextFieldBorder) {
            TSTextFieldBorder tSTextFieldBorder = (TSTextFieldBorder)border;
            tSTextFieldBorder.fBorderTop1 = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + "." + BORDER_TOP1 + string, null);
            tSTextFieldBorder.fBorderTop2 = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + "." + BORDER_TOP2 + string, null);
            tSTextFieldBorder.fBorderBottom = DefaultLookup.getColor((JComponent)((Object)tSTextField), this, string2 + "." + BORDER_BOTTOM + string, null);
        }
        tSTextField.repaint();
    }

    private boolean isActive() {
        JTextComponent jTextComponent = this.getComponent();
        Boolean bl = (Boolean)jTextComponent.getClientProperty(ACTIVE_TEXT_FIELD);
        boolean bl2 = bl != null && bl != false;
        return jTextComponent.isEnabled() && jTextComponent.isEditable() && (bl2 || this.fHasFocus);
    }

    private boolean isEditable() {
        JTextComponent jTextComponent = this.getComponent();
        return jTextComponent.isEnabled() && jTextComponent.isEditable();
    }

    @Override
    public int getPreferredWidth(TSComponent tSComponent, LayoutMode layoutMode) {
        return this.getPreferredSize((JComponent)((JComponent)((Object)tSComponent))).width;
    }

    @Override
    protected String getPropertyPrefix() {
        return "TSTextField";
    }

    private static class TSTextFieldBorder
    extends AbstractBorder {
        private Color fBorderTop1;
        private Color fBorderTop2;
        private Color fBorderBottom;

        TSTextFieldBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(this.fBorderTop1);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(1, 0, n3 - 1, 0);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.setColor(this.fBorderBottom);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 1;
            insets.left = 4;
            insets.right = 2;
            insets.bottom = 1;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class TSTextFieldMouseListener
    implements MouseListener,
    MouseMotionListener,
    FocusListener,
    ActionListener {
        private TSTextFieldMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ToolstripTextFieldUI.this.updateBackground((TSTextField)mouseEvent.getSource());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TSTextField tSTextField = (TSTextField)mouseEvent.getSource();
            tSTextField.putClientProperty(ToolstripTextFieldUI.ACTIVE_TEXT_FIELD, true);
            ToolstripTextFieldUI.this.updateBackground(tSTextField);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TSTextField tSTextField = (TSTextField)mouseEvent.getSource();
            tSTextField.putClientProperty(ToolstripTextFieldUI.ACTIVE_TEXT_FIELD, false);
            ToolstripTextFieldUI.this.updateBackground(tSTextField);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ToolstripTextFieldUI.this.fHasFocus = true;
            TSTextField tSTextField = (TSTextField)((Object)focusEvent.getComponent());
            tSTextField.selectAll();
            ToolstripTextFieldUI.this.updateBackground(tSTextField);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ToolstripTextFieldUI.this.fHasFocus = false;
            ToolstripTextFieldUI.this.updateBackground((TSTextField)((Object)focusEvent.getComponent()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TSUtil.toolstripActionProcessed(ToolstripTextFieldUI.this.getComponent());
        }
    }
}

