/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.UrlFilterRequestHandler;
import com.mathworks.html.UrlResolver;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;

public class FileExtensionHandler
extends UrlFilterRequestHandler {
    public FileExtensionHandler(String ... stringArray) {
        super(FileExtensionHandler.buildExtensionRegexp(stringArray));
    }

    private static Pattern buildExtensionRegexp(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(".*\\.(");
        for (String string : stringArray) {
            if (string.charAt(0) == '.') {
                string = string.substring(1);
            }
            stringBuilder.append(Pattern.quote(string)).append('|');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")$");
        return Pattern.compile(stringBuilder.toString(), 2);
    }

    @Override
    protected void handleMatchedUrl(String string) {
        new FileResolver().acceptUrl(string);
    }

    private static class FileResolver
    extends UrlResolver {
        private FileResolver() {
        }

        @Override
        protected void handleFileLocation(File file) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        protected void handleUrlLocation(URL uRL) {
            try {
                Desktop.getDesktop().browse(uRL.toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

