/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AggregateWebPolicyDelegate
implements WebPolicyDelegate {
    private final WebPolicyDelegate fOriginalDelegate;
    private final Map<Browser, List<WebPolicyDelegate>> fDelegates = new WeakHashMap<Browser, List<WebPolicyDelegate>>();

    public AggregateWebPolicyDelegate(WebPolicyDelegate webPolicyDelegate) {
        this.fOriginalDelegate = webPolicyDelegate;
    }

    public void addDelegate(Browser browser, WebPolicyDelegate webPolicyDelegate) {
        List<WebPolicyDelegate> list = this.fDelegates.get(browser);
        if (list == null) {
            list = new LinkedList<WebPolicyDelegate>();
            this.fDelegates.put(browser, list);
        }
        list.add(webPolicyDelegate);
    }

    public void removeDelegate(Browser browser, WebPolicyDelegate webPolicyDelegate) {
        List<WebPolicyDelegate> list = this.fDelegates.get(browser);
        if (list != null) {
            list.remove(webPolicyDelegate);
        }
    }

    public void clearBrowserDelegates(Browser browser) {
        this.fDelegates.remove(browser);
    }

    public List<WebPolicyDelegate> getBrowserDelegates(Browser browser) {
        List<WebPolicyDelegate> list = this.fDelegates.get(browser);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public boolean allowNavigation(NavigationEvent navigationEvent) {
        List<WebPolicyDelegate> list = this.getBrowserDelegates(navigationEvent.getBrowser());
        for (WebPolicyDelegate webPolicyDelegate : list) {
            if (webPolicyDelegate.allowNavigation(navigationEvent)) continue;
            return false;
        }
        return this.fOriginalDelegate == null ? true : this.fOriginalDelegate.allowNavigation(navigationEvent);
    }

    public boolean allowMimeType(String string, NavigationEvent navigationEvent) {
        List<WebPolicyDelegate> list = this.getBrowserDelegates(navigationEvent.getBrowser());
        for (WebPolicyDelegate webPolicyDelegate : list) {
            if (webPolicyDelegate.allowMimeType(string, navigationEvent)) continue;
            return false;
        }
        return this.fOriginalDelegate == null ? true : this.fOriginalDelegate.allowMimeType(string, navigationEvent);
    }
}

