/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.jxbrowser.JxBrowserFactory;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.NewWindowContainer;
import com.teamdev.jxbrowser.NewWindowManager;
import com.teamdev.jxbrowser.NewWindowParams;
import com.teamdev.jxbrowser.VisualWindowContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class JxBrowserPopupHandler<T extends HtmlActions>
implements NewWindowManager {
    private final PopupWindowListener<T> fPopupListener;

    JxBrowserPopupHandler(PopupWindowListener<T> popupWindowListener) {
        this.fPopupListener = popupWindowListener;
    }

    public NewWindowContainer evaluateWindow(NewWindowParams newWindowParams) {
        String string = newWindowParams.getUrl();
        Rectangle rectangle = newWindowParams.getBounds();
        return new JxBrowserPanelWindowContainer(string, rectangle);
    }

    private class JxBrowserPanelWindowContainer
    extends VisualWindowContainer {
        private Component iPopupComponent;
        private final Rectangle iBounds;
        private final String iUrl;

        private JxBrowserPanelWindowContainer(String string, Rectangle rectangle) {
            this.iBounds = rectangle;
            this.iUrl = string;
        }

        public void insertBrowser(final Browser browser) {
            if (browser == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JxBrowserFactory jxBrowserFactory = new JxBrowserFactory(browser);
                    HtmlPanel htmlPanel = new HtmlPanel(jxBrowserFactory);
                    JxBrowserPanelWindowContainer.this.iPopupComponent = JxBrowserPopupHandler.this.fPopupListener.createPopupComponent(htmlPanel);
                    JxBrowserPanelWindowContainer.this.iPopupComponent.setBounds(JxBrowserPanelWindowContainer.this.iBounds);
                    htmlPanel.setCurrentLocation(JxBrowserPanelWindowContainer.this.iUrl);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void setVisible(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JxBrowserPanelWindowContainer.this.iPopupComponent != null) {
                        JxBrowserPanelWindowContainer.this.iPopupComponent.setVisible(bl);
                    }
                }
            });
        }

        public void setLocation(final Point point) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JxBrowserPanelWindowContainer.this.iPopupComponent != null) {
                        JxBrowserPanelWindowContainer.this.iPopupComponent.setLocation(point);
                    }
                }
            });
        }

        public void setSize(final Dimension dimension) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JxBrowserPanelWindowContainer.this.iPopupComponent != null) {
                        JxBrowserPanelWindowContainer.this.iPopupComponent.setSize(dimension);
                    }
                }
            });
        }
    }
}

