/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.ole.types.OleCmdExecOpt;
import com.jniwrapper.win32.ole.types.OleCmdID;
import com.jniwrapper.win32.shdocvw.IWebBrowser2;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser1.mozilla.MozillaWebBrowser;
import com.teamdev.xpcom.Xpcom;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.mozilla.interfaces.nsIContentViewer;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIMarkupDocumentViewer;
import org.mozilla.interfaces.nsIWebBrowser;

class JxBrowserZoomHandler
extends KeyAdapter {
    private final Browser fBrowser;
    private int fZoomValue = 100;

    JxBrowserZoomHandler(Browser browser) {
        this.fBrowser = browser;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isControlDown(keyEvent)) {
            int n = keyEvent.getKeyCode();
            if (n == 107 || n == 61) {
                this.zoomIn();
            } else if (n == 109 || n == 45) {
                this.zoomOut();
            }
        }
    }

    private boolean isControlDown(KeyEvent keyEvent) {
        return this.fBrowser.getType() == BrowserType.Safari ? keyEvent.isMetaDown() : keyEvent.isControlDown();
    }

    private void zoomIn() {
        if (this.fBrowser.getType() == BrowserType.Safari) {
            this.zoomMac(true);
        } else if (this.fZoomValue <= 2000) {
            this.zoom(this.fZoomValue += 10);
        }
    }

    private void zoomOut() {
        if (this.fBrowser.getType() == BrowserType.Safari) {
            this.zoomMac(false);
        } else if (this.fZoomValue >= 10) {
            this.zoom(this.fZoomValue -= 10);
        }
    }

    public void zoom(int n) {
        switch (this.fBrowser.getType()) {
            case IE: {
                this.zoomIE(n);
                break;
            }
            case Mozilla: {
                this.zoomMozilla(n);
            }
        }
    }

    private void zoomIE(final int n) {
        final IEBrowser iEBrowser = (IEBrowser)this.fBrowser;
        iEBrowser.getPeer().getOleMessageLoop().doInvokeLater(new Runnable(){

            @Override
            public void run() {
                IWebBrowser2 iWebBrowser2 = (IWebBrowser2)iEBrowser.getPeer().getBrowserPeer();
                iWebBrowser2.execWB(new OleCmdID(63L), new OleCmdExecOpt(2L), new Variant(n), Variant.createUnspecifiedParameter());
            }
        });
    }

    private void zoomMozilla(final int n) {
        Xpcom.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                MozillaBrowser mozillaBrowser = (MozillaBrowser)JxBrowserZoomHandler.this.fBrowser;
                nsIWebBrowser nsIWebBrowser2 = ((MozillaWebBrowser)mozillaBrowser.getPeer()).getWebBrowser();
                nsIInterfaceRequestor nsIInterfaceRequestor2 = (nsIInterfaceRequestor)nsIWebBrowser2.queryInterface("{033a1470-8b2a-11d3-af88-00a024ffc08c}");
                nsIDocShell nsIDocShell2 = (nsIDocShell)nsIInterfaceRequestor2.getInterface("{8adfb831-1053-4a19-884d-bcdad7277b4b}");
                nsIContentViewer nsIContentViewer2 = nsIDocShell2.getContentViewer();
                nsIMarkupDocumentViewer nsIMarkupDocumentViewer2 = (nsIMarkupDocumentViewer)nsIContentViewer2.queryInterface("{40b2282a-a882-4483-a634-dec468d88377}");
                float f = (float)n / 100.0f;
                nsIMarkupDocumentViewer2.setFullZoom(f);
            }
        });
    }

    private void zoomMac(boolean bl) {
        int n;
        Font font = this.fBrowser.getConfigurable().getDefaultFont();
        int n2 = font.getSize();
        int n3 = n = bl ? n2 + 1 : n2 - 1;
        if (n >= 10 && n <= 72) {
            Font font2 = new Font(font.getName(), 0, n);
            this.fBrowser.getConfigurable().setDefaultFont(font2);
        }
    }
}

