/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.RequestHandler;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import java.util.LinkedList;
import java.util.List;

public class RequestHandlerPolicyDelegate
implements WebPolicyDelegate,
NavigationListener {
    private final List<RequestHandler> fRequestHandlers = new LinkedList<RequestHandler>();
    private String fPendingUrl;
    private BrowserRequest.Origin fPendingOrigin;
    private String fLastUrl;

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fRequestHandlers.add(requestHandler);
    }

    public boolean containsHandler(RequestHandler requestHandler) {
        return this.fRequestHandlers.contains(requestHandler);
    }

    public void setPendingRequest(String string, BrowserRequest.Origin origin) {
        this.fPendingUrl = string;
        this.fPendingOrigin = origin;
    }

    public boolean allowNavigation(NavigationEvent navigationEvent) {
        String string = navigationEvent.getUrl();
        if (RequestHandlerPolicyDelegate.shouldBypassHandlers(string)) {
            return true;
        }
        BrowserRequest browserRequest = this.getRequestForUrl(string);
        for (RequestHandler requestHandler : this.fRequestHandlers) {
            boolean bl = requestHandler.handleRequest(browserRequest);
            if (!bl) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldBypassHandlers(String string) {
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        return string.matches("^(file:/+)?about:blank|^http:/+$") || string.startsWith("javascript:");
    }

    private BrowserRequest getRequestForUrl(String string) {
        boolean bl = this.fLastUrl != null && HtmlUtils.areUrlsOnSamePage(string, this.fLastUrl);
        BrowserRequest browserRequest = this.isPendingRequest(string) ? new BrowserRequest(string, this.fPendingOrigin, bl) : new BrowserRequest(string, BrowserRequest.Origin.USER_INTERACTION, bl);
        this.fPendingOrigin = null;
        this.fPendingUrl = null;
        return browserRequest;
    }

    private boolean isPendingRequest(String string) {
        if (this.fPendingOrigin == null) {
            return false;
        }
        switch (this.fPendingOrigin) {
            case GO_BACK: 
            case GO_FORWARD: 
            case REFRESH: {
                return true;
            }
        }
        return this.fPendingUrl != null && HtmlUtils.areUrlsOnSamePage(this.fPendingUrl, string);
    }

    public boolean allowMimeType(String string, NavigationEvent navigationEvent) {
        return true;
    }

    public void navigationStarted(NavigationEvent navigationEvent) {
    }

    public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
        String string;
        this.fLastUrl = string = navigationFinishedEvent.getUrl();
        if (!RequestHandlerPolicyDelegate.shouldBypassHandlers(string)) {
            this.fPendingUrl = null;
            this.fPendingOrigin = null;
        }
    }
}

