/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private LinkedList<String> endings = new LinkedList();

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExtensionFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExtensionFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.match(f)) {
                return true;
            }
        }
        return false;
    }

    protected boolean match(File f) {
        return this.getExtension(f) != null;
    }

    public String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            for (String end : this.endings) {
                if (!filename.endsWith(end)) continue;
                return end;
            }
        }
        return null;
    }

    public void addExtension(String extension) {
        this.endings.add(extension.startsWith(".") ? extension : "." + extension);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator i = this.endings.iterator();
                while (i.hasNext()) {
                    this.fullDescription = this.fullDescription + (String)i.next();
                    if (!i.hasNext()) continue;
                    this.fullDescription = this.fullDescription + ", ";
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

