/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.gui;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.gui.MouseKeyboardSortingStrategy;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableComparatorChooser<E> {
    public static final Object SINGLE_COLUMN = new MouseOnlySortingStrategy(false);
    public static final Object MULTIPLE_COLUMN_MOUSE = new MouseOnlySortingStrategy(true);
    public static final Object MULTIPLE_COLUMN_KEYBOARD = new MouseKeyboardSortingStrategy();
    protected SortedList<E> sortedList;
    private TableFormat<? super E> tableFormat;
    protected Comparator<? super E> sortedListComparator = null;
    protected final SortingState sortingState = new SortingState(this);

    protected AbstractTableComparatorChooser(SortedList<E> sortedList, TableFormat<? super E> tableFormat) {
        this.sortedList = sortedList;
        this.setTableFormat(tableFormat);
        this.sortingState.addPropertyChangeListener(new SortingStateListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildComparator() {
        Comparator rebuiltComparator = this.sortingState.buildComparator();
        this.sortedList.getReadWriteLock().writeLock().lock();
        try {
            this.sortedListComparator = rebuiltComparator;
            this.sortedList.setComparator(rebuiltComparator);
        }
        finally {
            this.sortedList.getReadWriteLock().writeLock().unlock();
        }
    }

    protected void setTableFormat(TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.sortingState.rebuildColumns(tableFormat);
    }

    public List getComparatorsForColumn(int column) {
        return this.sortingState.getColumns().get(column).getComparators();
    }

    public List<Integer> getSortingColumns() {
        return this.sortingState.getSortingColumnIndexes();
    }

    public int getColumnComparatorIndex(int column) {
        return this.sortingState.getColumns().get(column).getComparatorIndex();
    }

    public boolean isColumnReverse(int column) {
        return this.sortingState.getColumns().get(column).isReverse();
    }

    public void appendComparator(int column, int comparatorIndex, boolean reverse) {
        this.sortingState.appendComparator(column, comparatorIndex, reverse);
        this.sortingState.fireSortingChanged();
    }

    public void clearComparator() {
        this.sortingState.clearComparators();
        this.sortingState.fireSortingChanged();
    }

    protected void redetectComparator(Comparator<? super E> currentComparator) {
        this.sortedListComparator = currentComparator;
        this.sortingState.detectStateFromComparator(currentComparator);
    }

    protected int getSortingStyle(int column) {
        return this.sortingState.getColumns().get(column).getSortingStyle();
    }

    public Comparator createComparatorForElement(Comparator<E> comparatorForColumn, int column) {
        return new TableColumnComparator<E>(this.tableFormat, column, comparatorForColumn);
    }

    public String toString() {
        return this.sortingState.toString();
    }

    public void fromString(String stringEncoded) {
        this.sortingState.fromString(stringEncoded);
        this.sortingState.fireSortingChanged();
    }

    public void dispose() {
        this.sortedList = null;
        this.tableFormat = null;
        this.sortedListComparator = null;
    }

    private class SortingStateListener
    implements PropertyChangeListener {
        private SortingStateListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractTableComparatorChooser.this.rebuildComparator();
        }
    }
}

