/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices.segv.V1.ws;

import com.mathworks.mlwebservices.DefaultService;
import com.mathworks.mlwebservices.WSSwingWorker;
import com.mathworks.mlwebservices.segv.V1.ws.gen.Segv;
import com.mathworks.mlwebservices.segv.V1.ws.gen.SegvStub;
import com.mathworks.mlwebservices.segv.V1.ws.gen.SendRequest;
import com.mathworks.mlwebservices.segv.V1.ws.gen.SendReturn;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class SegvWebService
extends DefaultService
implements Segv {
    private static final Logger LOG = Logger.getLogger(SegvWebService.class.getName());
    private String ServiceNameForConnection = null;
    private Segv serviceConnection = null;
    private boolean bindingFinished = false;

    @Override
    public String getDefaultEndpointKey() {
        return "segv";
    }

    @Override
    public WSSwingWorker getBindingThread(String string) {
        return new BindingThread();
    }

    @Override
    public void disconnect() {
        this.serviceConnection = null;
    }

    public void configure(Segv segv) {
        this.serviceConnection = segv;
    }

    @Override
    public boolean isConnected() {
        return this.serviceConnection != null;
    }

    public boolean isFinished() {
        return this.bindingFinished;
    }

    public String getServiceToUse() {
        return this.ServiceNameForConnection;
    }

    public static SegvWebService bindToWebServiceNow(String string) {
        return new SegvWebService(true, string);
    }

    public static SegvWebService bindToWebServiceInBackground(String string) {
        return new SegvWebService(false, string);
    }

    @Override
    public SendReturn send(SendRequest sendRequest) {
        SendReturn sendReturn = null;
        if (this.isConnected()) {
            try {
                sendReturn = this.serviceConnection.send(sendRequest);
            }
            catch (RemoteException remoteException) {
                LOG.fine(remoteException.getMessage());
            }
        }
        return sendReturn;
    }

    private SegvWebService(boolean bl, String string) {
        this.ServiceNameForConnection = string;
        if (string != null && !"".equalsIgnoreCase(string)) {
            this.setEndpointURL(string);
        }
        BindingThread bindingThread = new BindingThread();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> future = executorService.submit(bindingThread);
        if (bl) {
            try {
                future.get(20000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (TimeoutException timeoutException) {
                this.serviceConnection = null;
            }
        }
    }

    private final class BindingThread
    extends WSSwingWorker {
        private BindingThread() {
        }

        @Override
        public void run() {
            SegvStub segvStub;
            try {
                String string = SegvWebService.this.getEndpointURL();
                segvStub = new SegvStub(string);
                SegvWebService.this.configureOptions(segvStub);
            }
            catch (Throwable throwable) {
                segvStub = null;
            }
            if (!this.isCancelled()) {
                SegvWebService.this.serviceConnection = segvStub;
            }
            SegvWebService.this.bindingFinished = true;
        }
    }
}

