/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingLevelRuntimeException;
import com.mathworks.services.settings.SettingValidity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SettingTransaction {
    private final Map<Setting, Object> fTransaction = new LinkedHashMap<Setting, Object>();
    private static ThreadLocal<SettingTransaction> sTransaction = new ThreadLocal();
    private TransactionState fState = TransactionState.CREATED;
    private SettingLevel fLevel = null;
    private Setting<?> fFirstSetting;

    <T> void add(Setting<T> setting, T t, SettingLevel settingLevel) throws SettingLevelRuntimeException {
        assert (this.fState == TransactionState.STARTED);
        if (settingLevel != null && this.fLevel != null && settingLevel != this.fLevel) {
            throw new SettingLevelRuntimeException("Inconsistent levels used in transaction; was " + (Object)((Object)this.fLevel) + "; now " + (Object)((Object)settingLevel));
        }
        if (this.fTransaction.isEmpty()) {
            this.fFirstSetting = setting;
        } else if (!setting.getPath().isSameTree(this.fFirstSetting.getPath())) {
            throw new IllegalStateException("Tree was changed in transaction");
        }
        if (settingLevel != null) {
            this.fLevel = settingLevel;
        }
        this.fTransaction.put(setting, t);
    }

    public <T> boolean contains(Setting<T> setting) {
        return this.fTransaction.containsKey(setting);
    }

    <T> T get(Setting<T> setting) {
        Object object = this.fTransaction.get(setting);
        return (T)object;
    }

    public static SettingTransaction getTransaction() {
        SettingTransaction settingTransaction = sTransaction.get();
        assert (settingTransaction == null || settingTransaction.getState() == TransactionState.STARTED);
        return settingTransaction;
    }

    private TransactionState getState() {
        return this.fState;
    }

    public void start() {
        if (SettingTransaction.getTransaction() != null) {
            throw new IllegalStateException("Attempt to start another transaction in thread already in transaction");
        }
        if (this.fState == TransactionState.STARTED) {
            throw new IllegalStateException("Attempt to start transaction already active in another thread");
        }
        this.fState = TransactionState.STARTED;
        sTransaction.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SettingValidity> commit() throws SettingException {
        if (this.fState == TransactionState.CREATED) {
            throw new IllegalStateException("Attempt to commit transaction that was never started");
        }
        if (sTransaction.get() != this) {
            throw new IllegalStateException("Attempt to commit transaction not associated with current thread");
        }
        this.cancel();
        long l = SettingTransaction.nativeCreateTransactionContext();
        try {
            for (Map.Entry<Setting, Object> entry : this.fTransaction.entrySet()) {
                Setting setting = entry.getKey();
                setting.set(l, entry.getValue(), null);
            }
            List<SettingValidity> list = SettingTransaction.nativeCommitTransaction(l, this.fLevel.value());
            return list;
        }
        finally {
            SettingTransaction.nativeDeleteTransactionContext(l);
        }
    }

    public void cancel() throws IllegalStateException {
        if (this.fState == TransactionState.CREATED) {
            throw new IllegalStateException("Attempt to cancel transaction not started.");
        }
        if (sTransaction.get() != this) {
            throw new IllegalStateException("Attempt to cancel transaction not associated with current thread");
        }
        sTransaction.remove();
        this.fState = TransactionState.FINISHED;
    }

    public void clear() {
        this.fTransaction.clear();
        this.fState = null;
        this.fLevel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SettingValidity> validate() {
        long l = SettingTransaction.nativeCreateTransactionContext();
        try {
            ArrayList<SettingValidity> arrayList = null;
            for (Map.Entry<Setting, Object> object2 : this.fTransaction.entrySet()) {
                Setting setting = object2.getKey();
                try {
                    setting.set(l, object2.getValue(), null);
                }
                catch (SettingException settingException) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<SettingValidity>();
                    }
                    arrayList.add(new SettingValidity(setting.fullPath(), settingException));
                }
            }
            List<SettingValidity> list = SettingTransaction.nativeValidateTransaction(l, this.fLevel.value());
            if (list == null) {
                ArrayList<SettingValidity> arrayList2 = arrayList;
                return arrayList2;
            }
            list.addAll(arrayList);
            List<SettingValidity> list2 = list;
            return list2;
        }
        finally {
            SettingTransaction.nativeDeleteTransactionContext(l);
        }
    }

    private static native void nativeDeleteTransactionContext(long var0);

    private static native long nativeCreateTransactionContext();

    private static native List<SettingValidity> nativeCommitTransaction(long var0, String var2);

    private static native List<SettingValidity> nativeValidateTransaction(long var0, String var2);

    private static enum TransactionState {
        CREATED,
        STARTED,
        FINISHED;

    }
}

