/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class SettingTypeException
extends SettingException {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.mathworks.services.settings.resources.RES_Settings");
    private final Class<?> fActualType;
    private final Class<?> fExpectedType;

    public SettingTypeException(String string) {
        super(string);
        this.fActualType = null;
        this.fExpectedType = null;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, Class<?> clazz2) {
        super(MessageFormat.format(RESOURCE.getString("SettingTypeError"), setting.fullPath(), SettingTypeException.getTypeName(clazz2), SettingTypeException.getTypeName(clazz)));
        this.fActualType = clazz;
        this.fExpectedType = clazz2;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        super(MessageFormat.format(RESOURCE.getString("SettingCompositeTypeError"), setting.fullPath(), SettingTypeException.getTypeName(clazz), SettingTypeException.getTypeName(clazz3), SettingTypeException.getTypeName(clazz2)));
        this.fActualType = clazz2;
        this.fExpectedType = clazz3;
    }

    public SettingTypeException(Setting<?> setting) {
        super(MessageFormat.format(RESOURCE.getString("SettingNodeTypeError"), setting.fullPath(), setting.isNodeExpected() ? "node" : "key", setting.isNodeExpected() ? "key" : "node"));
        this.fActualType = null;
        this.fExpectedType = null;
    }

    public SettingTypeException(Setting<?> setting, Class<?> clazz, String string) {
        super(MessageFormat.format(RESOURCE.getString("SettingKeyValueError"), setting.fullPath(), SettingTypeException.getTypeName(clazz), string));
        this.fActualType = setting.getType();
        this.fExpectedType = setting.getType();
    }

    public Class<?> getActualType() {
        return this.fActualType;
    }

    public Class<?> getExpectedType() {
        return this.fExpectedType;
    }

    private static String getTypeName(Class<?> clazz) {
        if (clazz == null) {
            return "unknown";
        }
        String string = clazz.getName();
        if (clazz.isArray()) {
            int n = string.indexOf("[L") + 1;
            assert (n > 0);
            assert (string.length() > n + 2);
            StringBuilder stringBuilder = new StringBuilder(string.substring(n + 1, string.length() - 1));
            while (n-- > 0) {
                stringBuilder.append("[]");
            }
            string = stringBuilder.toString();
        }
        if (string.startsWith("java.lang.")) {
            string = string.substring("java.lang.".length());
        } else if (string.startsWith("com.mathworks.util.types.")) {
            string = string.substring("com.mathworks.util.types.".length());
        }
        return string;
    }
}

