/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import javax.swing.JComponent;
import org.openide.ErrorManager;

public final class HelpCtx {
    private static final ErrorManager err;
    public static final HelpCtx DEFAULT_HELP;
    private final URL helpCtx;
    private final String helpID;

    public HelpCtx(URL uRL) {
        this.helpCtx = uRL;
        this.helpID = null;
    }

    public HelpCtx(String string) {
        this.helpID = string;
        this.helpCtx = null;
    }

    public HelpCtx(Class clazz) {
        this(clazz.getName());
    }

    public URL getHelp() {
        return this.helpCtx;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public int hashCode() {
        int n = HelpCtx.class.hashCode();
        if (this.helpCtx != null) {
            n ^= this.helpCtx.hashCode();
        }
        if (this.helpID != null) {
            n ^= this.helpID.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof HelpCtx)) {
            return false;
        }
        HelpCtx helpCtx = (HelpCtx)object;
        return (this.helpCtx == helpCtx.helpCtx || this.helpCtx != null && this.helpCtx.equals(helpCtx.helpCtx)) && (this.helpID == helpCtx.helpID || this.helpID != null && this.helpID.equals(helpCtx.helpID));
    }

    public String toString() {
        if (this.helpID != null) {
            return "HelpCtx[" + this.helpID + "]";
        }
        return "HelpCtx[" + this.helpCtx + "]";
    }

    public static void setHelpIDString(JComponent jComponent, String string) {
        if (err != null) {
            err.log("setHelpIDString: " + string + " on " + jComponent);
        }
        jComponent.putClientProperty("HelpID", string);
    }

    public static HelpCtx findHelp(Component component) {
        if (err != null) {
            err.log("findHelp on " + component);
        }
        while (component != null) {
            String string;
            Object object;
            if (component instanceof Provider) {
                object = ((Provider)((Object)component)).getHelpCtx();
                if (err != null) {
                    err.log("found help " + object + " through HelpCtx.Provider interface");
                }
                return object;
            }
            if (component instanceof JComponent && (string = (String)((JComponent)(object = (JComponent)component)).getClientProperty("HelpID")) != null) {
                if (err != null) {
                    err.log("found help " + string + " by client property");
                }
                return new HelpCtx(string);
            }
            component = component.getParent();
            if (err == null) continue;
            err.log("no luck, trying parent " + component);
        }
        if (err != null) {
            err.log("nothing found");
        }
        return DEFAULT_HELP;
    }

    public static HelpCtx findHelp(Object object) {
        if (object instanceof Component) {
            return HelpCtx.findHelp((Component)object);
        }
        if (object instanceof Provider) {
            return ((Provider)object).getHelpCtx();
        }
        try {
            BeanDescriptor beanDescriptor = Introspector.getBeanInfo(object.getClass()).getBeanDescriptor();
            String string = (String)beanDescriptor.getValue("helpID");
            if (string != null) {
                return new HelpCtx(string);
            }
        }
        catch (IntrospectionException introspectionException) {
            err.log("findHelp on " + object + ": " + introspectionException);
        }
        return DEFAULT_HELP;
    }

    static {
        ErrorManager errorManager = ErrorManager.getDefault();
        ErrorManager errorManager2 = errorManager.getInstance("org.openide.util.HelpCtx");
        err = errorManager2.isLoggable(1) ? errorManager2 : null;
        DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");
    }

    public static interface Provider {
        public HelpCtx getHelpCtx();
    }
}

