/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.InheritanceTree;

final class DelegatingStorage
implements Serializable,
AbstractLookup.Storage {
    private AbstractLookup.Storage delegate;
    private Thread owner;

    public DelegatingStorage(AbstractLookup.Storage storage) {
        this.delegate = storage;
        this.owner = Thread.currentThread();
    }

    public Object writeReplace() {
        return this.delegate;
    }

    public void checkForTreeModification() {
        if (Thread.currentThread() == this.owner) {
            throw new AbstractLookup.ISE("You are trying to modify lookup from lookup query!");
        }
    }

    public static boolean isSimple(AbstractLookup.Storage storage) {
        if (storage instanceof DelegatingStorage) {
            return ((DelegatingStorage)storage).delegate instanceof ArrayStorage;
        }
        return storage instanceof ArrayStorage;
    }

    public AbstractLookup.Storage exitDelegate() {
        if (Thread.currentThread() != this.owner) {
            throw new IllegalStateException("Onwer: " + this.owner + " caller: " + Thread.currentThread());
        }
        AbstractLookup.Storage storage = this.delegate;
        this.delegate = null;
        return storage;
    }

    @Override
    public boolean add(AbstractLookup.Pair pair, Object object) {
        return this.delegate.add(pair, object);
    }

    @Override
    public void remove(AbstractLookup.Pair pair, Object object) {
        this.delegate.remove(pair, object);
    }

    @Override
    public void retainAll(Map map, Object object) {
        this.delegate.retainAll(map, object);
    }

    @Override
    public Object beginTransaction(int n) {
        try {
            return this.delegate.beginTransaction(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ArrayStorage arrayStorage = (ArrayStorage)this.delegate;
            this.delegate = new InheritanceTree();
            Enumeration enumeration = arrayStorage.lookup(Object.class);
            while (enumeration.hasMoreElements()) {
                if (this.delegate.add((AbstractLookup.Pair)enumeration.nextElement(), new ArrayList())) continue;
                throw new IllegalStateException("All objects have to be accepted");
            }
            AbstractLookup.ReferenceToResult referenceToResult = arrayStorage.cleanUpResult(null);
            if (referenceToResult != null) {
                referenceToResult.cloneList(this.delegate);
            }
            return this.delegate.beginTransaction(n);
        }
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template template) {
        return this.delegate.cleanUpResult(template);
    }

    @Override
    public void endTransaction(Object object, Set set) {
        this.delegate.endTransaction(object, set);
    }

    @Override
    public Enumeration lookup(Class clazz) {
        return this.delegate.lookup(clazz);
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult referenceToResult) {
        return this.delegate.registerReferenceToResult(referenceToResult);
    }
}

